/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taMsg.c  Messages file

 All TrxAVR messages are stored here

*/

#include "taGlobal.h"

// Messages from TrxAVR.c
const char TrxAVR_version[] = "1.83";  // Version must be 4 characters for transmission to Hobcat
//const char TrxAVR_VersionComment[] = "24.01.2018";


// Messages from ta24LC512.c


// Messages from taADC.c


// Messages from taButtons.c
const char pmdNotAllowed[21] PROGMEM = {"--Not Allowed--"};
const char s_on[] PROGMEM = "on";
const char s_off[] PROGMEM = "off";
// Button task names in full
// separately applied to receive and transmit
const char pmdTaskNameList[nooftasks][21] PROGMEM = {  // [number][length]
		" -no task assigned-",		//    0 buNotAssigned
		"Copy current VFO",			//    1 buCopyVfo
		"VFO A / B switch",			//    2 buVfoAB
		"Split R/T frequency",		//    3 buSplit
		"RIT",						//    4 buRIT
		"SSB mode",					//    5 buSSB
		"CW mode",					//    6 buCW
		"Step through modes",		//    7 buModeStep
		"Toggle side band",			//    8 buSsbLsb
		"Togl RF attenuator",		//    9 buAtten
		"Scan current bank",		//   10 buScanBank
		"Scan VfoA & VfoB",			//   11 buScanAB
		"Green params",				//   12 buGreen
		"Yellow params",			//   13 buYellow
		"Red params",				//   14 buRed
		"Default params",			//   15 buDefaultParams    
		"NR on/off",				//   16 buDenoise
		"Mute&suspend VOX",			//   17 buMute
		"Togl noise blanker",		//   18 buNoiseBlank
		"AutoNotch on/off",			//   19 nbuAutoNotch
		"Togl manual notch",		//   20 buManNotch
		"Rx Filter wide/nar",		//   21 buWideNarrow
		"Vox on/off",				//   22 buVox
		"Compression on/off",		//   23 buComp
		"Fwd power meter",			//   24 buForward
		"Refl power meter",			//   25 buReflected
		"SWR meter toggle",			//   26 buSWR
 		"Togl Fwd/Refl/SWR",		//   27 buSWRtoggle
		"Best IP3 or NF",			//   28 buIP3
		"Togl soft flywheel",		//   29 buSoftFlywheel
		"DDS 23 on/off",			//   30 buDDS23
		"DDS 43 on/off",			//   31 buDDS43
		"Param stepping",			//   32 buParamStep
		"Next band UP",				//   33 buBandUp
		"Next band DOWN",			//   34 buBandDown
		"XIT",						//   35 buXIT
		"RIT",						//   36 buRIT
		"Display sleep",			//   37 buSleep
		"Display dim on/off",		//   38 buDim
		"Wobbulator",				//   39 buWobbulator
		"Rate tuning mode",			//   40 buRateTune
		"Sig.generator mode",		//   41 buSigGen
		"Montr guard chan",			//   42 buGuardChannel
		"Scan cur. memstack",		//   43 buMemStackScan
		"VFO stack tune",			//   44 buVfoStackTune
		"VFO A-B scanning",			//   45 buVfoABscan
		"DDS79 Toggle PG2",			//   46 buDDS79
		"DDS75 Wide+PG2",			//   47 buWideBandRx
		"Encoder assign",			//   48 buEncAssign
		"Memory stack 67",			//	 49 buMemStack67
		"Memory stack 68",			//	 50 buMemStack68
		"Memory stack 69",			//	 51 buMemStack69
		"Memory stack 60",			// 	 52 buMemStack60
		"Memory slot 61",			//	 53 buMemSlot61
		"Memory slot 62",			//	 54 buMemSlot62
		"Memory slot 63",			// 	 55 buMemSlot63
		"Memory slot 64",			//	 56 buMemSlot64
		"Memory slot 65",			//	 57 buMemSlot65
		"Memory slot 66",			//	 58 buMemSlot66
		"Mem stack 67 tune",		//	 59 buMemStack67Tune
		"Mem stack 68 tune",		//	 60 buMemStack68Tune
		"Mem stack 69 tune",		//	 61 buMemStack69Tune
		"Mem stack 60 tune",		// 	 62 buMemStack60Tune
		"DSP/DDS keys disp",		//   63 buDSPDDSKeys
		"Toggle auto dim",			//   64 buAutoDim
		"I2C1",                 	//   65 I2C PAC9555 task 1  
		"I2C2",                 	//   66 I2C PAC9555 task 2  
		"I2C3",                 	//   67 I2C PAC9555 task 3  
		"I2C4",                 	//   68 I2C PAC9555 task 4  
		"I2C5",                 	//   69 I2C PAC9555 task 5  
		"I2C6",                 	//   70 I2C PAC9555 task 6  
		"I2C7",                 	//   71 I2C PAC9555 task 7  
		"I2C8",                 	//   72 I2C PAC9555 task 8
		"PA3AKE roofer sw.",		//   73 buPA3AKE_Roofer
		"PA3AKE atten +", 	 		//   74 buPA3AKE_AttenIncrease 
		"PA3AKE atten -", 	 		//   75 buPA3AKE_AttenDecrease 
		"Toggle tuning lock",		//   76 buTuneLock
		"CW QRO",								//   77 buCWQRO
		"CW QRP",								//   78 buCWQRP
		"Toggle CW QRO/QRP",		//   79 buCWQROQRP
		
};

// Button task names shortened to 20chars for LCD display
// separately applied to receive and transmit
const char pmdTaskLabelList[nooftasks][2][10] PROGMEM = {  // [number][string1/2][length]
		{"Not","set"},				//    0 buNotAssigned
		{"Copy","VFO"},				//    1 buCopyVfo
		{"VFO","A/B"},				//    2 buVfoAB
		{"R/T","split"},			//    3 buSplit
		{"RIT","mode"},				//    4 buRIT
		{"SSB","mode"},				//    5 buSSB
		{"CW","mode"},				//    6 buCW
		{"Mode","step"},			//    7 buModeStep
		{"LSB","/USB"},				//    8 buSsbLsb
		{"Atten",""},				//    9 buAtten
		{"Scan","bank"},			//   10 buScanBank
		{"Scan","A&B"},				//   11 buScanAB
		{"Green","params"},			//   12 buGreen
		{"Yellow","params"},		//   13 buYellow
		{"Red","params"},			//   14 buRed
		{"default","params"},		//   15 buDefaultParams 
		{"NR","+TK"},					//   16 buDenoise
		{"Audio","mute"},			//   17 buMute
		{"Noise","blank"},			//   18 buNoiseBlank
		{"Auto","notch"},			//   19 nbuAutoNotch
		{"Man.","notch"},			//   20 buManNotch
		{"6.2","6.1"},			//   21 buWideNarrow
		{"Vox",""},					//   22 buVox
		{"Comp.",""},				//   23 buComp
		{"Fwd.","power"},			//   24 buForward
		{"Refl.","power"},			//   25 buReflected
		{"SWR","meter"},			//   26 buSWR
		{"SWR","toggle"},			//   27 buSWRtoggle
		{"IP3","NF"},				//   28 buIP3
		{"Flywheel","tune"},		//   29 buSoftFlywheel
		{"DDS23","on/off"},			//   30 buDDS23
		{"DDS43","on/off"},			//   31 buDDS43
		{"Param","step"},			//   32 buParamStep
		{"Band","up"},				//   33 buBandUp
		{"Band","down"},			//   34 buBandDown
		{"XIT","mode"},				//   35 buXIT
		{"RIT","mode"},				//   36 buRIT
		{"Sleep",""},				//   37 buSleep
		{"Disp dim","on/off"},		//   38 buDim
		{"Wobbu",""},				//   39 buWobbulator
		{"Rate","tune"},			//   40 buRateTune
		{"Sig","gen"},				//   41 buSigGen
		{"Guard","chan."},			//   42 buGuardChannel
		{"Mstack","scan"},			//   43 buMemStackScan
		{"Vstack","tune"},			//   44 buVfoStackTune
		{"VfoAB","scan"},			//   45 buVfoABscan
		{"DDS79","PG2"},			//   46 buDDS79
		{"DDS75","Wide"},			//   47 buWideBandRx
		{"Enc","assign"},			//   48 buEncAssign
		{"Mstack","67"},			//	 49 buMemStack67
		{"Mstack","68"},			//	 50 buMemStack68
		{"Mstack","69"},			//	 51 buMemStack69
		{"Mstack","60"},			// 	 52 buMemStack60
		{"Mslot","61"},				//	 53 buMemSlot61
		{"Mslot","62"},				//	 54 buMemSlot62
		{"Mslot","63"},				// 	 55 buMemSlot63
		{"Mslot","64"},				//	 56 buMemSlot64
		{"Mslot","65"},				//	 57 buMemSlot65
		{"Mslot","66"},				//	 58 buMemSlot66
		{"Mstack","67tune"},		//	 59 buMemStack67Tune
		{"Mstack","68tune"},		//	 60 buMemStack68Tune
		{"Mstack","69tune"},		//	 61 buMemStack69Tune
		{"Mstack","60tune"},		// 	 62 buMemStack60Tune
		{"DSP/DDS","key disp"},		//   63 buDSPDDSKeys
		{"AutoDim","on/off"},		//   64 buAutoDim
		{"I2C","1"},				//   65 I2C task 1
		{"I2C","2"},				//   66 I2C task 2
		{"I2C","3"},				//   67 I2C task 3
		{"I2C","4"},				//   68 I2C task 4
		{"I2C","5"},				//   69 I2C task 5
		{"I2C","6"},				//   70 I2C task 6
		{"I2C","7"},				//   71 I2C task 7
		{"I2C","8"},			  	//   72 I2C task 8
		{"roofer",""},				//   73 buPA3AKE_Roofer 
		{"atten+",""},				//   74 buPA3AKE_Atten_Increase
		{"atten-",""},		      	//   75 buPA3AKE_Atten_Decrease
		{"Tun lock","on/off"},		//   76 buTuneLock
		{"CW","QRO"},							//   77 buCWQRO	
		{"CW","QRP"},							//   78 buCWQRO			
		{"cwQRO","cwQRP"},					//   79 buCWQRO				
};

// Task labels for CW modal DSP switches
//const char pmdTaskLabel19[2][10] PROGMEM = {"QRP","QRO"};   // removed IJS Star6a9
//const char pmdTaskLabel21[2][10] PROGMEM = {"Depth","Width"};    // removed IJS Star6a9
const char pmdTaskLabel22[2][10] PROGMEM = {"QSK",""};
const char pmdTaskLabel23[2][10] PROGMEM = {"Spot",""};


// Messages from taCAT.c


// Messages from taCharLCD.c


// Messages from taConfig.c


// Messages from taDDS.c


// Messages from taDDScommands.c
// The following are fleeting conformation messages for DDS commands
// 20 chars max  - same message for graphics and charlcd
const char s_Green[] PROGMEM = "Green";
const char s_Yellow[] PROGMEM = "Yellow";
const char s_Red[] PROGMEM = "Red";
const char s_Default[] PROGMEM = "Default";
const char s__params[] PROGMEM = " params";
const char s_Best_IP3_set[] PROGMEM = "Best IP3 set";
const char s_Best_NF_set[] PROGMEM = "Best NF set";
const char s_All_params_default[] PROGMEM = "All params default";
const char s_RF_atten__on[] PROGMEM = "RF atten on";
const char s_RF_atten__off[] PROGMEM = "RF atten off";
const char s_DDS43_switch_off[] PROGMEM = "DDS43 switch off";
const char s_DDS43_switch_on[] PROGMEM = "DDS43 switch on";
const char s_DDS23_switch_off[] PROGMEM = "DDS23 switch off";
const char s_DDS23_switch_on[] PROGMEM = "DDS23 switch on";
const char s_Flywheel_on[] PROGMEM = "Flywheel on";
const char s_Flywheel_off[] PROGMEM = "Flywheel off";
const char s_Auto_dim_on[] PROGMEM = "Auto-dim on";
const char s_Auto_dim_off[] PROGMEM = "Auto-dim off";
const char s_Tune_lock_on[] PROGMEM = "Tuning lock on";
const char s_Tune_lock_off[] PROGMEM = "Tuning lock off";
const char s_Dim_on[] PROGMEM = "Perm dim on";
const char s_Dim_off[] PROGMEM = "Perm dim off";
const char s_Rate_tuning_on[] PROGMEM = "Rate_tuning_on";
const char s_Toggle_to_USB[] PROGMEM = "Toggle to USB";
const char s_Toggle_to_LSB[] PROGMEM = "Toggle to LSB";
const char s_Low_side_injection[] PROGMEM = "Low side injection";
const char s_High_side_injection[] PROGMEM = "High side injection";
const char s_PowerOn_restore[] PROGMEM = "PowerOn restore";
const char s_No_PowerOn_restore[] PROGMEM = "No PowerOn restore";
const char s_Default_CW_mode[] PROGMEM = "Default CW mode=";
const char s_PowerOn_slot_t_VFO_N[] PROGMEM = "PowerOn slot > VFO N";
const char s_VFO_N_t_PowerOn_slot[] PROGMEM = "VFO N > PowerOn";
const char s_volatile_slot[] PROGMEM = "volatile slot";
const char s_Saved_to_sticky_slot[] PROGMEM = "Save to sticky slot";
const char s_Sig_gen_mode_on[] PROGMEM = "Sig gen mode on";
const char s_Sig_gen_mode_off[] PROGMEM = "Sig gen mode off";
const char s_PortG_bit_2_off[] PROGMEM = "PortG bit 2 off";
const char s_PortG_bit_2_on[] PROGMEM = "PortG bit 2 on";
const char s_PG2_and_wide_Rx_off[] PROGMEM = "P2G & wide Rx off";
const char s_PG2_and_wide_Rx_on[] PROGMEM = "P2G & wide Rx on";
const char s_DSPKeys_off[] PROGMEM = "DSP/DDS disp off";
const char s_DSPKeys_DDS_on[] PROGMEM = "DDS key disp on";
const char s_DSPKeys_DSP_on[] PROGMEM = "DSP key disp on";
const char s_DSPKeys_Both_on[] PROGMEM = "DSP/DDS disp on";
const char s_SwitchCode_off[] PROGMEM = "Switch disp off";
const char s_SwitchCode_on[] PROGMEM = "Switch disp on";
const char s_RawSwitchCode_on[] PROGMEM = "Raw switch disp on";


// Messages from taDebug.c
const char s_PORTA[] PROGMEM = "PORTA";
const char s_PORTB[] PROGMEM = "PORTB";
const char s_PORTC[] PROGMEM = "PORTC";
const char s_PORTD[] PROGMEM = "PORTD";
const char s_PORTE[] PROGMEM = "PORTE";
const char s_PORTF[] PROGMEM = "PORTF";
const char s_PORTG[] PROGMEM = "PORTG";
const char s_PORTH[] PROGMEM = "PORTH";
const char s_PORTJ[] PROGMEM = "PORTJ";
const char s_PORTK[] PROGMEM = "PORTK";
const char s_PORTL[] PROGMEM = "PORTL";

const char s_DDRA[] PROGMEM = "DDRA";
const char s_DDRB[] PROGMEM = "DDRB";
const char s_DDRC[] PROGMEM = "DDRC";
const char s_DDRD[] PROGMEM = "DDRD";
const char s_DDRE[] PROGMEM = "DDRE";
const char s_DDRF[] PROGMEM = "DDRF";
const char s_DDRG[] PROGMEM = "DDRG";
const char s_DDRH[] PROGMEM = "DDRH";
const char s_DDRJ[] PROGMEM = "DDRJ";
const char s_DDRK[] PROGMEM = "DDRK";
const char s_DDRL[] PROGMEM = "DDRL";

const char s_PINA[] PROGMEM = "PINA";
const char s_PINB[] PROGMEM = "PINB";
const char s_PINC[] PROGMEM = "PINC";
const char s_PIND[] PROGMEM = "PIND";
const char s_PINE[] PROGMEM = "PINE";
const char s_PINF[] PROGMEM = "PINF";
const char s_PING[] PROGMEM = "PING";
const char s_PINH[] PROGMEM = "PINH";
const char s_PINJ[] PROGMEM = "PINJ";
const char s_PINK[] PROGMEM = "PINK";
const char s_PINL[] PROGMEM = "PINL";

const char s_MonitorA[] PROGMEM = "MonitorA";
const char s_MonitorB[] PROGMEM = "MonitorB";
const char s_MonitorC[] PROGMEM = "MonitorC";
const char s_MonitorH[] PROGMEM = "MonitorH";

const char s_Debug_Mode[] PROGMEM = "Mode";
const char s_Debug_Colour[] PROGMEM = "Param Colour";
const char s_Debug_DeNoise[] PROGMEM = "NR+TK";
const char s_Debug_NoiseBlank[] PROGMEM = "Noise Blank";
const char s_Debug_AutoNotch[] PROGMEM = "Auto Notch";
const char s_Debug_QRO[] PROGMEM = "QRO";
const char s_Debug_ManualNotch[] PROGMEM = "Manual Notch";
const char s_Debug_Filter[] PROGMEM = "Filter";
const char s_Debug_Vox[] PROGMEM = "Vox";
const char s_Debug_QSK[] PROGMEM = "QSK";
const char s_Debug_Comp[] PROGMEM = "Compressor";
const char s_Debug_Spot[] PROGMEM = "Spot";
const char s_Debug_Starno[] PROGMEM = "StarNo_";


// Messages from taDiagnostic.c


// Messages from taEA320TouchPanel.c
const char s_Touch_panel_calibration[] PROGMEM = "Touch panel calibration";
const char s_Tap_screen_to_begin_[] PROGMEM = "Tap screen to begin";
const char s_Tap_cross[] PROGMEM = "Tap cross";
const char s__Key_ESC_or___to_exit_[] PROGMEM = "(Key ESC or # to exit)";
const char s_use_stylus_A[] PROGMEM = "For better accuracy use a non-scratching";
const char s_use_stylus_B[] PROGMEM = "stylus or similar pointing device.";


// Messages from taEATFT.c
const char s_SNRD[] PROGMEM = "SNRD";
const char s__split[] PROGMEM = "|split";
const char s_Narrow[] PROGMEM = "F(6.1)";
const char s_Wide[] PROGMEM = "F(6.2)";
const char s_6162[] PROGMEM = "6.1/6.2";
const char s_Context[] PROGMEM = "Context";
const char s_mem1_[] PROGMEM = "mem ";
const char s_Sticky_[] PROGMEM = "Sticky  ";
const char s_Volatile_[] PROGMEM = "Volatile ";
const char s_VFO_stack[] PROGMEM = "VFO Stack";
const char s_wobbulator[] PROGMEM = "wobbulator";
const char s_Mem_scan[] PROGMEM = "Mem scan";
const char s_AB_scan[] PROGMEM = "AB scan";
const char s_Rate_tune[] PROGMEM = "Rate tune";
const char s_guard_chan_every_20s[] PROGMEM = "guard chan|every 20s";
const char s_Signal1_generator[] PROGMEM = "Signal|generator";
const char pmdSwitchLogo[8][2][6] PROGMEM = {
	{""},
	{"AMn","AMn"},
	{"NB", "NB"},
	{"NR+TK","NR+TK"},
	{"", ""},     //not used in STAR4 GW2HFR
	{"Vox","QSK"},
	{"Cmp","Spo"},
	{"Att","Att"}
};


// Messages from taEATFTcommands.c


// Messages from taEATFTdriver.c


// Messages from taEATFTmenus.c
const char se_Encoder__[] PROGMEM = "Encoder  ";
const char se_Potentiometer__[] PROGMEM = "Potentiometer  ";
const char se_Enc____set_param[] PROGMEM = "Enc    set param";
const char se_Pot____set_param[] PROGMEM = "Pot    set param";
const char se_Receive_[] PROGMEM = "Receive ";
const char se_Transmit_[] PROGMEM = "Transmit ";
const char se_button__[] PROGMEM = "button  ";
const char se_button___task[] PROGMEM = "button   task";
const char se_touchpad____task[] PROGMEM = "touchpad    task";
const char se_Rx_[] PROGMEM = "Rx ";
const char se_Tx_[] PROGMEM = "Tx ";
const char se_Set_dimmed_display[] PROGMEM = "Set dimmed display  ";
const char se_Set_bright_display[] PROGMEM = "Set bright display  ";
const char se_Auto_dim_seconds[] PROGMEM = "Auto-Dim seconds    ";
const char se_Menu_timeout[] PROGMEM = "Menu timeout    ";
const char se_MOX_timeout[] PROGMEM = "MOX timeout    ";
const char se_Set_DDS_clock_freq_[] PROGMEM = "Set DDS clock freq.";
const char se_Edit_local_time_offset[] PROGMEM = "Edit local time offset";
const char se_Set_LSB_offset[] PROGMEM = "Set LSB offset";
const char se_Set_USB_offset[] PROGMEM = "Set USB offset";

// graphics only
const char se_Encoder___set_parameter[] PROGMEM = "Encoder   set parameter";
const char se_Pot___set_parameter[] PROGMEM = "Pot   set parameter";
const char se___Select_encoder[] PROGMEM = "  Select encoder";
const char se___Select_encoder_or_pot[] PROGMEM = "  Select encoder or pot";
const char se__Select_Rx_[] PROGMEM = "  Select Rx ";
const char se__Select_Tx_[] PROGMEM = "  Select Tx ";
const char se_task_button[] PROGMEM = "task button";
const char se_task_touchpad[] PROGMEM = "task touchpad";
const char se_Menu_to_accept__ESC_to_abort_[] PROGMEM = "Menu to accept|ESC to abort:";
const char se_Set_the_brightness_with_[] PROGMEM = "Set the brightness with|";
const char se_the_tuning_encoder_[] PROGMEM = "the tuning encoder.";
const char se_This_operates_as_DDS37_[] PROGMEM = "This operates as DDS37|";
const char se_in_signal_generator_mode__[] PROGMEM = "in signal generator mode.|";
const char se_Refer_to_Picastar_manual_[] PROGMEM = "Refer to Picastar manual.";
const char se_This_operates_as_DDS31_[] PROGMEM = "This operates as DDS31|";
const char se_Unlike_DDS_33__this_does_[] PROGMEM = "Unlike DDS33, this does|";
const char se_not_use_sig_gen_mode__[] PROGMEM = "not use sig. gen. mode.|";
const char se_Calibrate_by_tuning_to_an_[] PROGMEM = "Calibrate by tuning to an|";
const char se_accurate_known_signal_[] PROGMEM = "accurate known signal.";
const char se____no_param_assigned[] PROGMEM = "       no param assigned";
const char se_DSP_parameter_setting[] PROGMEM = "DSP parameter setting";
const char se_pom_hours_x_10_displayed_[] PROGMEM = "+/- hoursx10 displayed.|";
const char se_Set_with_tuning_encoder__[] PROGMEM = "Set with tuning encoder.|";
const char se_pom_hours_x_10_displayed[] PROGMEM = "+/- hoursx10 displayed.";
const char se_Set_with_tuning_encoder[] PROGMEM = "Set with tuning encoder.";
const char se_Range_is__120_to__120_[] PROGMEM = "Range is -120 to +120.";
const char se_UTC____[] PROGMEM = "UTC:   ";
const char se_Local__[] PROGMEM = "Local: ";
const char AutoN_Delta[] PROGMEM = "Notching BIN :";

// slot stuff
const char se__Last_[] PROGMEM = " Last ";
const char se__SSB__[] PROGMEM = " SSB  ";
const char se__CW___[] PROGMEM = " CW   ";
const char se_Poweron__[] PROGMEM = "Poweron  ";
const char se_Volat_____[] PROGMEM = "Volat     ";
const char se_Sticky____[] PROGMEM = "Sticky    ";
const char se_Slot_not_defined[] PROGMEM = "Slot not defined";
const char se_10_hyphens[] PROGMEM = "       ----------";
const char se_Stacks_and_Slots_menu[] PROGMEM = "Stacks and slots display";
const char se_Press_Stacks_to_select_stack_type__[] PROGMEM = "Press Stacks to select stack type,|";
const char se_Then_press_Stacks_again_to_go_to_slot_[] PROGMEM = " Then press Stacks againto go to slot.";
const char se___No_VFO_slot_access_here_[] PROGMEM = " (No VFO slot access here)";
const char se_6x_6x__[] PROGMEM = "6x:6x  ";
const char se__Memory_slots[] PROGMEM = "   Memory slots";
const char se__VFO_slots[] PROGMEM = "   VFO slots";
const char se__Band_slots[] PROGMEM = "   Band slots";
const char se_Red___[] PROGMEM = "Red   ";
const char se_Yellow[] PROGMEM = "Yellow";
const char se_Green_[] PROGMEM = "Green ";
const char se_narrow[] PROGMEM = "narrow";
const char se_wide[] PROGMEM = "wide";
const char se_6162[] PROGMEM = "6.1/6.2";
const char se_context[] PROGMEM = "context";
const char se_IP3[] PROGMEM = "IP3";
const char se_NF[] PROGMEM = "NF";

const char epmdSlotMenuList[3][17] PROGMEM = {
		"  Memory stacks",		//  0
		"  VFO stacks",	      //  1
		"  Band stacks",	  	//  2
};



// Messages from taEEPROM.c


// Messages from taEncoder.c
const char s_Encoder__[] PROGMEM = "Encoder  ";
const char s_Potentiometer__[] PROGMEM = "Potentiometer  ";
const char s_TxDrv___[] PROGMEM = "TrDrv = ";


// Messages from taFont8.c


// Messages from taFont16.c


// Messages from taFontFreqA.c


// Messages from taFontFreqAx.c


// Messages from taFontFreqB.c


// Messages from taFontFreqBx.c


// Messages from taFT245R.c


// Messages from taGraphicsControl.c


// Messages from taGraphicsDriverEA320.c


// Messages from taGraphicsEA320.c
const char s_Test_point[] PROGMEM = "Test point";
const char s_Max[] PROGMEM = "Max";
const char s_Min[] PROGMEM = "Min";

// DSP parameter names in full
const char pmdRxBarList[8][13] PROGMEM = {
		"Rx input",					//  0  
		"Noise blank",	    //  1  
		"After filter",			//  2  
		"After AGC",			  //  3  
		"A.notch out",			//  4  
		"SNR out ",			//  5  
		"Pre AF gain",			//  6  
		"Rx Af out",			  //  7
};
const char pmdTxBarList[8][13] PROGMEM = {
		"Mic input",					//  0  
		"After decim",	      //  1  
		"After N-gate",			  //  2  
		"After filter",			  //  3  
		"After VOGAD",			  //  4  
		"After comp.",			  //  5  
		"Tx monitor",			    //  6  
		"Tx IF out",			    //  7
};


// Messages from taI2C.c
const char s_CW[] PROGMEM = "CW";
const char s_SSB[] PROGMEM = "SSB";


// Messages from taIntEeprom.c


// Messages from taKeys.c


// Messages from taKeysUser.c


// Messages from taKS0108.c
const char s_Wobltr[] PROGMEM = "Wobltr";
const char s_VFOstk[] PROGMEM = "VFOstk";
const char s_ABscan[] PROGMEM = "ABscan";
const char s_RteTun[] PROGMEM = "RteTun";
const char s_Mscan[] PROGMEM = "Mscan";
const char s_Nar_[] PROGMEM = "Nar.";


// Messages from taKS0108Driver.c


// Messages from taKS0108Menus.c
const char s_Select_Rx_[] PROGMEM = "  Select Rx ";
const char s_Select_Tx_[] PROGMEM = "  Select Tx ";
const char s_button[] PROGMEM = "button";
const char s__no_param_assigned[] PROGMEM = "  no param assigned";
const char s_Select_encoder[] PROGMEM = "Select encoder";
const char s_Select_encoder_or_pot[] PROGMEM = "Select encoder or pot";
const char s_Pot___set_parameter[] PROGMEM = "Pot   set parameter";
const char s_Enc___set_parameter[] PROGMEM = "Enc   set parameter";
const char s_Enc[] PROGMEM = "Enc";
const char s_Pot[] PROGMEM = "Pot";
const char s_Set_auto_dim_seconds[] PROGMEM = "Set auto-dim seconds";
const char s_Set_menu_timeout[] PROGMEM = "Set menu timeout";
const char s_Set_MOX_timeout[] PROGMEM = "Set MOX timeout";
const char s_Stacks_and_slots[] PROGMEM = "Stacks and slots";
const char s_Last_[] PROGMEM = "Last ";
const char s_SSB__[] PROGMEM = "SSB  ";
const char s_CW___[] PROGMEM = "CW   ";
const char s_Pwron_[] PROGMEM = "Pwron ";
const char s_Vol___[] PROGMEM = "Vol   ";
const char s_Stky__[] PROGMEM = "Stky   ";
const char s_6x_6x_[] PROGMEM = "6x:6x "; 
const char s_Sig__gen__mode_used_[] PROGMEM = "Sig.gen. mode used.";
const char s_Sig__gen__mode_not_used_[] PROGMEM = "Sig.gen. mode not used.";
const char s_Encoder___set_param[] PROGMEM = "Encoder   set param";
const char s_Units___hours_x_10[] PROGMEM = "Units:  hours x 10";

const char kpmdSlotMenuList[3][16] PROGMEM = {
		"  Memory stacks",		//  0
		"  VFO stacks",	      //  1
		"  Band stacks",	  	//  2
};


// Messages from taMenus.c
const char s_Enc____set_param[] PROGMEM = "Enc    set param";
const char s_Pot____set_param[] PROGMEM = "Pot    set param";
const char s_Receive_[] PROGMEM = "Receive ";
const char s_Transmit_[] PROGMEM = "Transmit ";
const char s_button__[] PROGMEM = "button  ";
const char s_touchpad___[] PROGMEM = "touchpad   ";
const char s_button___task[] PROGMEM = "button   task";
const char s_touchpad____task[] PROGMEM = "touchpad    task";
const char s_Rx_[] PROGMEM = "Rx ";
const char s_Tx_[] PROGMEM = "Tx ";
const char s_Set_dimmed_display[] PROGMEM = "Set dimmed display  ";
const char s_Set_bright_display[] PROGMEM = "Set bright display  ";
const char s_Auto_dim_seconds[] PROGMEM = "Auto-Dim seconds    ";
const char s_Menu_timeout[] PROGMEM = "Menu timeout    ";
const char s_MOX_timeout[] PROGMEM = "MOX timeout    ";
const char s_Set_DDS_clock_freq_[] PROGMEM = "Set DDS clock freq.";
// graphics only
const char s___Encoder___set_parameter[] PROGMEM = "  Encoder   set parameter";
const char s___Potentiometer___set_parameter[] PROGMEM = "  Potentiometer   set parameter";
const char s___Select_encoder[] PROGMEM = "  Select encoder";
const char s___Select_encoder_or_pot[] PROGMEM = "  Select encoder or pot";
const char s___Select_receive_[] PROGMEM = "  Select receive ";
const char s___Select_transmit_[] PROGMEM = "  Select transmit ";
const char s_task_button[] PROGMEM = "task button";
const char s_task_touchpad[] PROGMEM = "task touchpad";
const char s_Menu_to_accept_____ESC_to_abort[] PROGMEM = "Menu to accept     ESC to abort";
const char s_With_LED_set_the_brightness_[] PROGMEM = "With LED set the brightness.";
const char s_With_CFL__bright_is_full_on[] PROGMEM = "With CFL, bright is full on";
const char s_and_dimmed_is_set_by_R13_[] PROGMEM = "and dimmed is set by R13.";
const char s_Set_bright_255__Set_dim_below[] PROGMEM = "Set bright=255. Set dim below";
const char s_the_bright_dim_switching_point_[] PROGMEM = "the bright/dim switching point.";
const char s_This_LSB_offset_setup_operates[] PROGMEM = "This LSB offset setup operates";
const char s_the_same_as_DDS_37_[] PROGMEM = "the same as DDS 37.";
const char s_ie__in_signal_generator_mode_[] PROGMEM = "ie: in signal generator mode.";
const char s_Refer_to_Picastar_manual_[] PROGMEM = "Refer to Picastar manual.";
const char s_This_USB_offset_setup_operates[] PROGMEM = "This USB offset setup operates";
const char s_the_same_as_DDS_31_[] PROGMEM = "the same as DDS 31.";
const char s_This_is_different_to_DDS_33_[] PROGMEM = "This is different to DDS 33.";
const char s_It_does_not_use_sig__gen__mode_[] PROGMEM = "It does not use sig. gen. mode.";
const char s_It_allows_you_to_calibrate_the[] PROGMEM = "It allows you to calibrate the";		  
const char s_DDS_clock_by_tuning_the_receiver[] PROGMEM = "DDS clock by tuning the receiver";		  
const char s_to_an_accurate_known_signal_[] PROGMEM = "to an accurate known signal."; 		  
const char s____no_param_assigned[] PROGMEM = "    no param assigned";

// Main menu options 
const char pmdMainMenuList[15][25] PROGMEM = {
		"Assign encoders and pots",		//  0
		"Assign Rx buttons",			//  1
		"Assign Tx buttons",			//  2
		"Set bright display level",		//  3
		"Set dimmed display level",		//  4
		"Set auto-dim seconds",			//  5
		"Set menu timeout",				//  6
		"Set MOX timeout",				//  7
		"Edit DDS clock",				//  8
		"Edit USB offset",				//  9
		"Edit LSB offset",				//  10
		"Edit local time offset",     	// 11
		"Assign Rx touchpads",			//  12
		"Assign Tx touchpads",			//  13
		"Touch panel calibration"		//  14
};
const char pmdMenuList[15][21] PROGMEM = {
		"Encoders & Pots",		//  0
		"Assign Rx buttons",	//  1
		"Assign Tx buttons",	//  2
		"Display bright level",	//  3
		"Display dimmed level",	//  4    
		"Auto-dim seconds",		//  5
		"Menu timeout",			//  6
		"MOX timeout",			//  7
		"DDS clock frequency",	//  8
		"USB offset",			//  9
		"LSB offset",			//  10
		"Local time offset",   	// 11
		"Assign Rx touchpads",	//  12
		"Assign Tx touchpads",	//  13
		"Touch panel setup"		//  14
};


// Messages from taProgmem.c
// Band names
const char pmdBandNameList[10][4] PROGMEM = {
		"160",	// 0
		"80m",	// 1
		"60m",	// 2
		"40m",	// 3
		"30m", 	// 4
		"20m",	// 5
		"17m",	// 6
		"15m",	// 7
		"12m",	// 8
		"10m",	// 9
};

// Switch button labels  - 4 char
const char pmdButtonCapList[10][6] PROGMEM = {
		"",		// 0
		"NR",	// 1
		"mode",	// 2
		"NB",	// 3
		"Anot", // 4
		"Mnot",	// 5
		"Filt",	// 6
		"Vox",	// 7
		"",		// 8
		"Comp",	// 9
};

// Mode names
const char pmdModeNameList[4][4] PROGMEM = {
		"LSB",	// 0
		"USB",	// 1
		"CWL",	// 2
		"CWU", 	// 3
};

// DSP parameter units
const char pmdUnitsList[66][6] PROGMEM = {
		"",			//  0  11
		"dB",	  	//  1  12
		"dB",		//  2  13
		"dB",		//  3  14
		"",			//  4  15
		"",			//  5  16
		"",			//  6  17
		"",			//  7  18
		"",			//  8  19
		"dB",		//  9  21
		"",		// 10  22
		"dB",		// 11  23
		"",			// 12  24 
		"dB",		// 13  25 
		"",			// 14  26 
		"",			// 15  27 
		"",			// 16  28 
		"",			// 17  29 
		"",			// 18  31
		"dB",		// 19  32
		"",			// 20  33
		"WPM",		// 21  41
		"Hz",		// 22  42
		"",			// 23  43
		"",			// 24  44
		"",			// 25  45
		"",			// 26  46
		"",			// 27  47
		"kHz",		// 28  51
		"",			// 29  52
		"",			// 30  53
		"dB",		// 31  54
		"",			// 32  55
		"dB",		// 33  56
		"dB",		// 34  57
		"dB",		// 35  58
		"dB",		// 36  61
		"kHz",		// 37  62
		"kHz",		// 38  63
		"kHz",		// 39  64
		"kHz",		// 40  65
		"Hz",		// 41  66
		"",			// 42  67
		"",			// 43  68
		"",			// 44  69
		"x10mS",	// 45  71
		"dB",		// 46  72
		"",			// 47  73
		"x5mS",		// 48  74
		"mS",		// 49  75
		"",			// 50  76
		"dB",		// 51  77
		"",			// 52  78
		"",			// 53  79
		"dB",		// 54  81
		"dB",		// 55  82
		"kHz",		// 56  83
		"kHz",		// 57  84
		"dB",		// 58  85
		"",			// 59  86
		"dB",		// 60  91
		"",			// 61  92
		"dB",		// 62  93
		"",			// 63  94
		"", 		// 64  95
		"",			// 65  99
};

// DSP parameter names in full
const char pmdParamNameList[66][22] PROGMEM = {
		"Ultimate Noise Floor",		//  0  11
		"Wide GMS threshold",	    	//  1  12
		"Nar. GMS threshold",		//  2  13
		"GMS spike threshold",		//  3  14
		"x Wide GMS attack",		//  4  15
		"x Nar. GMS attack",		//  5  16
		"x While Hang decay",		//  6  17
		"x Not Hang decay",		//  7  18
		"x Post-spike decay",		//  8  19
		"AF gain",			//  9  21
		"CW QRO on/off",		// 10  22
		"CW sidetone level",		// 11  23
		"Rx EQ switch on/off",		// 12  24
		"SSB monitor level",		// 13  25
		"x NB pulse width",		// 14  26
		"x NB pulse delay time",	// 15  27
		"Not used",			// 16  28
		"Not used",			// 17  29
		"Noise blanc level",		// 18  31
		"NR sensitivity",			// 19  32
		"Not Used",			// 20  33
		"Keyer speed",			// 21  41
		"Sidetone pitch",		// 22  42
		"Auto QSK mode",		// 23  43
		"CW tones",			// 24  44
		"Key/PTT definition",		// 25  45
		"Keyer memory",			// 26  46
		"CW auto letter space",		// 27  47
		"Manual notch",			// 28  51
		"DSP monitor options",		// 29  52
		"Stereo effect",		// 30  53
		"Stereo balance",		// 31  54
		"Rx gain switch",		// 32  55
		"Manual AD603 gain",		// 33  56
		"Manual Pre-ADC gain",		// 34  57
		"Manual AGC gain",		// 35  58
		"CW filter pitch focus",		// 36  61
		"SSB Rx width 1",		// 37  62
		"SSB Rx width 2",		// 38  63
		"CW filter width",		// 39  64
		"Rx filter centre",		// 40  65
		"CW pitch",			// 41  66
		"S meter calibration",		// 42  67
		"S meter zero",			// 43  68
		"S meter update rate",		// 44  69
		"GMS hang time",		// 45  71
		"Vox gain",			// 46  72
		"CW GMS auto hang",		// 47  73
		"Tx hang time",			// 48  74
		"R > T pre delay",		// 49  75
		"T > R blanking",		// 50  76
		"Anti-vox gain",		// 51  77
		"x VOGAD lower cutoff",		// 52  78
		"x VOGAD attack rate",		// 53  79
		"Tx drive",			// 54  81
		"Cw drive decrement",		// 55  82
		"Tx bandwidth",			// 56  83
		"Tx filter centre",		// 57  84
		"Tx noise gate thresh",		// 58  85
		"x Comp aggression",		// 59  86
		"Speech compression",		// 60  91
		"Inhibit level (dB)",		// 61  92
		"Cw spot level",		// 62  93
		"Spot varies with sig",		// 63  94
		"Tx EQ switch on/off",		// 64  95
		"No param. assigned",		// 65  99
};

// DSP parameter names abbreviated
const char pmdParamShortNameList[66][15]PROGMEM = {
		"UNF",		//  0  11
		"Wide GMS thr",		//  1  12
		"Nar.GMS thr",		//  2  13
		"GMS spike thr",	//  3  14
		"x Wide GMS atk",	//  4  15
		"x Nar. GMS atk",	//  5  16
		"x W-Hang decay",	//  6  17
		"x N-Hang decay",	//  7  18
		"x P-Spk decay",	//  8  19
		"AF gain",		//  9  21
		"CW QRO on/off", 	// 10  22
		"CWsidton level",	// 11  23
		"Rx EQ",		// 12  24 
		"SSB mon.level", 	// 13  25 
		"x NB width",		// 14  26
		"x NB delay",		// 15  27
		"x CW Focus",		// 16  28
		"x AN decay",		// 17  29
		"Condx senstvty",	// 18  31
		"NR sensitivity",		// 19  32
		"Noise flr sup.",	// 20  33
		"Keyer speed",		// 21  41
		"Sidetone pitch",	// 22  42
		"AutoQSK mode",		// 23  43
		"CW tones",		// 24  44
		"Key/PTT defn.",	// 25  45
		"Keyer memory",		// 26  46
		"CW autospace", 	// 27  47
		"Manual notch",		// 28  51
		"DSP mon.option",	// 29  52
		"Stereo depth", 	// 30  53
		"Stereo balance",	// 31  54
		"Rx gain switch",	// 32  55
		"Man AD603 gn.",	// 33  56
		"Man PreADC gn.",	// 34  57
		"Man AGC gain",		// 35  58
		"CW pitch focus",	// 36  61
		"SSB narrow",		// 37  62
		"SSB wide",		// 38  63
		"CWfilter width",	// 39  64
		"Rx filt centre",	// 40  65
		"CW pitch",		// 41  66
		"S meter cal.",		// 42  67
		"S meter zero",		// 43  68
		"S meter update",	// 44  69
		"GMS hang", 	   	// 45  71
		"Vox gain",		// 46  72
		"CW autohang",		// 47  73
		"Tx hang time",		// 48  74
		"R>T predelay",		// 49  75
		"T>R blanking",		// 50  76
		"Antivox gain", 	// 51  77
		"x VOGAD lowcut",	// 52  78
		"x VOGAD attack",	// 53  79
		"Tx drive",		// 54  81
		"Cw drive decr", 	// 55  82
		"Tx bandwidth",		// 56  83
		"Tx filt.centre",	// 57  84
		"Tx Noisegt thr",	// 58  85
		"x Comp aggr.",		// 59  79
		"Speech comp.",		// 60  91
		"CW QRO.",		// 61  92  //STAR4
		"Cw spot level",	// 62  93
		"SpotSig vary",		// 63  94
		"Tx EQ switch",		// 64  95
		"Not assigned",		// 65  99
};


// Messages from taScroll.c


// Messages from taSlots.c
const char s__Last_[] PROGMEM = " Last ";
const char s__SSB__[] PROGMEM = " SSB  ";
const char s__CW___[] PROGMEM = " CW   ";
const char s_Poweron__[] PROGMEM = "Poweron  ";
const char s_Volat_____[] PROGMEM = "Volat     ";
const char s_Sticky____[] PROGMEM = "Sticky    ";
const char s_Slot_not_defined[] PROGMEM = "Slot not defined";
const char s_10_hyphens[] PROGMEM = "----------";
const char s_Stacks_and_slots_display[] PROGMEM = "Stacks and slots display";
const char s_Press_Menu_to_select_stack_type[] PROGMEM = "Press Stacks to go to stack type";
const char s__then_Menu_to_go_to_slot[] PROGMEM = " then Stacks to go to slot";
const char s___No_VFO_slot_access_here_[] PROGMEM = " (No VFO slot access here)";
const char s_6x_6x__[] PROGMEM = "6x:6x  ";

const char pmdSlotMenuList[3][15] PROGMEM = {
		"Memory stacks",	//  0
		"VFO stacks",	    //  1
		"Band stacks",		//  2
};


// Messages from taSmeter.c


// Messages from taStarControl.c
const char s_DDS_command_[] PROGMEM = "DDS command:";
const char s_No_param_restore[] PROGMEM = "No param restore";



// Messages from taStarDSP.c
const char s_Params_not_restored[] PROGMEM = "Params not restored";
const char s_AD603[] PROGMEM = "AD603";
const char s_ADC[] PROGMEM = "ADC";
const char s_AGC[] PROGMEM = "AGC";
const char s_Gain[] PROGMEM = "Gain";
const char s_dB[] PROGMEM = "dB";
const char s_dB__[] PROGMEM = "dB  ";
const char s_Hang[] PROGMEM = "Hang";
const char s_Spike[] PROGMEM = "Spike";
const char s_DAC[] PROGMEM = "DAC";
const char s_VOGAD_gain_[] PROGMEM = "VOGAD gain=";
const char s_dac__[] PROGMEM = "dac  ";


// Messages from taSWR.c
const char s_SWRADC[] PROGMEM = "SWRADC";


// Messages from taTWI.c


// Messages from taUsart.c


// Messages from taZ_DDS.c
const char s_r_e_t[] PROGMEM = "r = t";


// Messages from taZ_DDScommands.c
const char s_DDS_command__[] PROGMEM = "DDS command  ";
const char s_XIT[] PROGMEM = "XIT";
const char s_RIT[] PROGMEM = "RIT";
const char s_Sgen_[] PROGMEM = "Sgen.";
const char s_Guard[] PROGMEM = "Guard ";
const char s_VFOstack[] PROGMEM = "VFOstack";
const char s_DDS_command__9[] PROGMEM = "DDS command  9";
const char s_DDS_clock_frequency[] PROGMEM = "DDS clock frequency";
const char s_DDS_clock_freq_[] PROGMEM = "DDS clock freq.";
const char s_Set_USB_offset[] PROGMEM = "Set USB offset";
const char s_Set_LSB_offset[] PROGMEM = "Set LSB offset";
const char s_ClkCal[] PROGMEM = "ClkCal";
const char s_Move_kHz_up[] PROGMEM = "Up 1-10kHz: ";
const char s_Move_kHz_down[] PROGMEM = "Down 1-10kHz: ";
const char s_Guard_channel_check[] PROGMEM = "Guard channel check";
const char s_every_20_seconds_[] PROGMEM = "every 20 seconds.";
const char s_Signal_generator[] PROGMEM = "Signal generator";
const char s____mode_[] PROGMEM = "            mode.";
const char s_DDS_931_to_save_[] PROGMEM = "DDS 931 to save.";
const char s_DDS_937_to_save_[] PROGMEM = "DDS 937 to save.";
const char s_DDS_933_to_save_[] PROGMEM = "DDS 933 to save.";
const char s_Uses_signal_generator_mode[] PROGMEM = "Uses signal generator mode";
const char s_Uses_sig__gen__mode[] PROGMEM = "Uses sig. gen. mode";
const char s_as_Picastar_manual_[] PROGMEM = "as Picastar manual";
const char s_XIT__split_[] PROGMEM = "XIT [split ";
const char s_RIT__split_[] PROGMEM = "RIT [split ";
const char s_on__[] PROGMEM = "on] ";
const char s_off_[] PROGMEM = "off]";
const char s_s[] PROGMEM = "s";
const char s_Leading_zero_if_under_10MHz[] PROGMEM = "Leading zero if under 10Mhz";
const char s_Enter_frequency[] PROGMEM = "Enter frequency";
const char s_newline[] PROGMEM = "|";
const char s_1[] PROGMEM = "1";
const char s_3[] PROGMEM = "3";
const char s_7[] PROGMEM = "7";
const char s_T_20s[] PROGMEM = "T=20s";
const char s_DDS_info_[] PROGMEM = "* = saved to EEPROM  [9] = save";
const char s_DDS_1[DDS_1_Cnt][34] PROGMEM =
{
	"*[9]10 Select 10M band",
	"    11 Select SSB Mode",
	"*[9]12 Select 12M band",
	"*[9]13 Current band SSB dflts",
	"*[9]15 Select 15M band",
	"*[9]16 Select 160M band",
	"*[9]17 Select 17M band",
	"*[9]19 Current band CW dflts"
};
const char s_DDS_2[DDS_2_Cnt][34] PROGMEM =
{
	"*[9]20 Select 20M band",
	"    22 Rate tuning mode",
	"    23 Toggle DDS23 switch",
	"*   26 Toggle software flywheel",
	"    27 VFO stack tuning mode",
	"    29 Invoke cmDoDDS29"
};
const char s_DDS_3[DDS_3_Cnt][34] PROGMEM =
{
	"*[9]30 Select 30M band",
	"*[9]31 Calibrate USB offset",
	"*[9]33 Calibrate Ref clock",
	"*[9]37 Calibrate LSB offset",
	"*   39 Toggle param reset mode"
};
const char s_DDS_4[DDS_4_Cnt][34] PROGMEM =
{
	"*[9]40 Select 40M band",
	"    41x Freq up by x kHz",
	"    43 Toggle DDS43 switch",
	"    44 Select CW mode",
	"    47x Freq down by x kHz",
	"    48 Toggle IP3/NF",
	"*   49 Set default CW mode",
	"    4* Save F&M to volatile stack"
};
const char s_DDS_5[DDS_5_Cnt][34] PROGMEM =
{
	"*[9]50 Select power on F&M",
	"    51 NOT USED star6",
	"    52 NOT USED star6",
	"    53 NOT USED star6",
	"    54 Set curr params to dflts",
	"    55 Monitor guard channel",
	"    56 Scan freqs in mem bank",
	"    58 Scan freq range",
	"    59 Set all params to dflts",
	"    5* Scan both VFOA & VFOB"
};
const char s_DDS_6[DDS_6_Cnt][34] PROGMEM =
{
	"*   60 Select memory bank 60",
	"*[9]61 Select slot 1 in mem bank",
	"*[9]62 Select slot 2 in mem bank",
	"*[9]63 Select slot 3 in mem bank",
	"*[9]64 Select slot 4 in mem bank",
	"*[9]65 Select slot 5 in mem bank",
	"*[9]66 Select slot 6 in mem bank",
	"*   67 Select memory bank 67",
	"*   68 Select memory bank 68",
	"*   69 Select memory bank 69",
	"*   6* Save F&M to sticky stack"
};
const char s_DDS_7[DDS_7_Cnt][34] PROGMEM =
{
	"    71 Toggle permanent dim",
	"    72 Toggle attenuator",
	"    73 Sleep",
	"*   74 Toggle auto-dim",
	"    75 Toggle wideRx & PG2",
	"*   76 Toggle DSP/DDS key desc",
	"    77 Toggle sideband",
	"    78 Toggle switch display",
	"    79 Toggle DDS79 (PG2)"
};
const char s_DDS_8[DDS_8_Cnt][34] PROGMEM =
{
	"*[9]80 Select 80M band",
	"    81 High side LO injection",
	"    83 Signal generator mode",
	"    87 Low side LO injection",
	"    88 Direct freq entry",
	"    89 Send F&M to slave STAR"
};
const char s_DDS_9[DDS_9_Cnt][34] PROGMEM =
{
	"  Leading 9 SAVE current F&M to",
	"      Band        eg 980",
	"      Memory      eg 964",
	"      SSB default    913",
	"      CW default     919",
	"      Power-up slot  950",
	"      Calibration eg 931",
	"  998 Repaint display",
	"  999 Reboots TrxAVR"
};


// Messages from taZ_Smeter.c


// Messages from taZ_StarControl.c
const char s_TrxAVR_PicaStar_[] PROGMEM = "Picastar - Software transmitter and receiver";
const char s_Loading_DSP[] PROGMEM = "Loading DSP";

const char s_IP[] PROGMEM = "IP";
const char s_NF[] PROGMEM = "NF";
const char s_grn[] PROGMEM = "Grn";
const char s_yel[] PROGMEM = "Ylw";
const char s_red[] PROGMEM = "Red";
const char s_kps[] PROGMEM = "k/s";
const char s_Mps[] PROGMEM = "M/s";
const char s_p4kps[] PROGMEM = ".4k/s";
const char s_p8kps[] PROGMEM = ".8k/s";
const char s_0p8kps[] PROGMEM = "0.8k/s";
const char s__te[] PROGMEM = " t=";
const char s_wobb_[] PROGMEM = "wobb:";
const char s__rate_[] PROGMEM = " rate ";
const char s_nbamvc[] PROGMEM = "nbamvc";

const char s_Vo_[] PROGMEM = "Vo ";
const char s_St_[] PROGMEM = "St ";
const char s_Saved_stack6x_sloty[] PROGMEM = "Saved stack6x sloty";
const char s_MemStack[] PROGMEM = "MemStack";
const char s_WWW[] PROGMEM = "<W>";
const char s_NNN[] PROGMEM = ">N<";
const char s_DEP[] PROGMEM = "_D_";
const char s_CTX[] PROGMEM = "=C=";

const char s_IP3[] PROGMEM = "IP3";
const char s_NF_[] PROGMEM = "NF ";
const char s_Green_[] PROGMEM = "Green ";
const char s_Red___[] PROGMEM = "Red   ";
const char s_kHz[] PROGMEM = "kHz";
const char s_mem_[] PROGMEM = "mem.";

const char s_Denoiser[] PROGMEM = "NR+TK";
const char s_Noise_blank[] PROGMEM = "Noise blank";
const char s_Auto_notch[] PROGMEM = "Auto notch";
const char s_QRO[] PROGMEM = "QRO";
const char s_Man_notch[] PROGMEM = "Man notch";
const char s_Vox[] PROGMEM = "Vox";
const char s_QSK[] PROGMEM = "QSK";
const char s_CW_spot[] PROGMEM = "CW spot";
const char s_RF_clip[] PROGMEM = "RF clip";
const char s_RF_attenuator[] PROGMEM = "RF attenuator";
const char s_RF_atten[] PROGMEM = "RF atten";
const char s_spacebracket[] PROGMEM = " [";
const char s_dB_[] PROGMEM = "dB]";
const char s_RightSquareBracket[] PROGMEM = "]";
const char s_kHzbr[] PROGMEM = "kHz]";
const char s_Memory_stack[] PROGMEM = "Memory stack";
const char s_tuning_mode_[] PROGMEM = "tuning mode.";
const char s_Scan_delay___[] PROGMEM = "Scan delay = ";
const char s_Scan_VFOs_A_and_B[] PROGMEM = "Scan VFOs A and B";
const char s_s__[] PROGMEM = "s  ";
const char s_Scan_memory_stack_[] PROGMEM = "Scan memory stack.";
const char s_kHzps[] PROGMEM = "kHz/s";
const char s_MHzps[] PROGMEM = "MHz/s";
const char s_0p4kHzps[] PROGMEM = "0.4kHz/s";
const char s_0p8kHzps[] PROGMEM = "0.8kHz/s";
const char s_Rate___[] PROGMEM = "Rate = ";
const char s_Rate_tuning_mode[] PROGMEM = "Rate tuning mode";
const char s_Wobbulator_mode[] PROGMEM = "Wobbulator mode";
const char s_VFO_Stack_mode[] PROGMEM = "VFO Stack mode";
const char s_Sticky_slot_no_[] PROGMEM = "Sticky slot no ";
const char s_Volatile_slot_no_[] PROGMEM = "Volatile slot no ";
const char s_version_[] PROGMEM = "Version STAR6xx - ";
const char s_A_B[] PROGMEM = "A=B";
const char s_B_A[] PROGMEM = "B=A";
const char s_VFO_A___VFO_B[] PROGMEM = "VFO A = VFO B";
const char s_VFO_B___VFO_A[] PROGMEM = "VFO B = VFO A";
const char s_att[] PROGMEM = "att";
const char s_pipe[] PROGMEM = "|";
const char s_Mem_stack[] PROGMEM = "Mem.stack";
const char s_tuning_[] PROGMEM = "tuning.";
const char s_delay_[] PROGMEM = "delay=";
const char s_VFO_Ap__VFO_B[] PROGMEM = "VFO A|   = VFO B";
const char s_VFO_Bp__VFO_A[] PROGMEM = "VFO B|   = VFO A";
const char s_3hyphens[] PROGMEM  = "---";
const char s_2hyphens[] PROGMEM  = "--";
const char s_M[] PROGMEM  = "M";
const char s_colon[] PROGMEM  = ":";
const char s_Vola_[] PROGMEM  = "Vola ";
const char s_Stky_[] PROGMEM  = "Stky ";
const char s_MemStk[] PROGMEM  = "MemStk";
const char s_tune_[] PROGMEM = "tune.";

const char s_DSPKey_1[] PROGMEM  = "(1) Toggle NR+TK";
const char s_DSPKey_2[] PROGMEM  = "(2) Toggle Colour Down";
const char s_DSPKey_3[] PROGMEM  = "(3) Toggle Noise Blanker";
const char s_DSPKey_4_SSB[] PROGMEM  = "(4) Toggle Auto/Man Notch";
const char s_DSPKey_4_CW[] PROGMEM  = "(4) Toggle Auto/Man Notch";
const char s_DSPKey_5[] PROGMEM  = "(5) Toggle Colour Up";
const char s_DSPKey_6_SSB[] PROGMEM  = "(6) 6.1/6.2 Filter";
const char s_DSPKey_6_CW[] PROGMEM  = "(6) Toggle Context/Depth";
const char s_DSPKey_7_SSB[] PROGMEM  = "(7) Toggle VOX";
const char s_DSPKey_7_CW[] PROGMEM  = "(7) Toggle QSK";
const char s_DSPKey_8[] PROGMEM  = "(8) Adjust DSP Parameters";
const char s_DSPKey_9_SSB[] PROGMEM  = "(9) Toggle Compression";
const char s_DSPKey_9_CW[] PROGMEM  = "(9) Toggle CW Spot";
const char s_DDSKey_0[] PROGMEM  = "(0) VFOA = VFOB   [0] Freq Diff";
const char s_DDSKey_asterix[] PROGMEM  = "(*) Toggle VFOA/B";
const char s_DDSKey_hash[] PROGMEM  = "(#) Toggle RIT      [#] XIT On";
const char s_DDSKey_hash_TFT[] PROGMEM  = "(#) Toggle RIT        [#] XIT On";


// Messages from taZ_StarDSP.c


// Messages from taZ_SWR.c
const char s_Fwd[] PROGMEM = "Fwd";
const char s_Ref[] PROGMEM = "Ref";
const char s_SWR[] PROGMEM = "SWR";

