/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taMenus.c       Menu code module

*/

#include "taGlobal.h"
#include "taKeys.h"
#include "taCharLCD.h"
#include "ta24LC512.h"
#include "taDDS.h"
#include "taConfig.h"
#include "taStarControl.h"
#include "taEncoder.h"
#include "taMenus.h"
#include "taStarControl.h"
#include "taStarDSP.h"
#include "taUsart.h"
#include "taADC.h"
#include "taButtons.h"
#include "taZ_StarControl.h"
#include "taGraphicsEA320.h"
#include "taEA320TouchPanel.h"
#include "taScroll.h"
#include "taGraphicsDriverEA320.h"
#include "taGraphicsEA320.h"
#include "taZ_StarControl.h"
#include "taFT245R.h"
#include "taCAT.h"
#include "taEATFTcommands.h"
#include "taEATFTmenus.h"
#include "taRTC.h"
#include "taEEPROM.h"
#include "taIntEeprom.h"



uint8_t ParamGroup;
uint8_t ParamGroupItem[10]; //   1 to 9 used

char* meTaskString(uint8_t task);
char* meMainMenuString(uint8_t Index);
char* meEncoderAssignString(uint8_t index);
char* meButtonAssignString(uint8_t b);
char* meTouchpadAssignString(uint8_t b);
char* meEncoderParamString(uint8_t i);
void meButtonAssign(char rt);
void meTouchpadAssign(char rt);
void meAdjustDisplayBrightness(uint32_t v);
void meEditDisplayBright();
void meEditDisplayDimmed();
void meAdjustNothing(uint32_t v);
void meEditAutodimSeconds();
void meEditMenuTimeout();
void meEditMoxTimeout();
void meAdjustDDSclock(uint32_t f);
void meAdjustLSBoffset(uint32_t f);
void meEditLSBoffset();
void meAdjustUSBoffset(uint32_t f);
void meEditUSBoffset();
void meEditLocalTimeOffset();
void meEditNumber(uint32_t* val, char* label, uint32_t min, uint32_t max, 
                           uint8_t step, char msg, void (*pAdjust)(uint32_t n));
void meEditNumberDef(int32_t* val, char* label, int32_t min, int32_t max,  int32_t def,
                           int8_t step, int8_t inc, char msg, void (*pAdjust)(uint32_t n));
void meEditNumeric(uint32_t* val);
void meDisplayParamNameAndVal(uint8_t ParamNo, uint8_t doname, uint8_t* pcolour);
uint8_t meCheckForEncodersPots();
void meWriteEditNumberDirections(char wot);


void meMenusInit() __attribute__((section(".highmem")));
void meMenusInit()
{
	uint8_t i;
	LastEncoderSetting = 0;
	ParamGroup = 8;  // as in Picastar  Press 8 and 8.1 appears
	for (i = 1; i <= 9; i++) {ParamGroupItem[i] = 10 * i + 1;} // start each group at 11 21 31 etc
}


// get menu name for graphics
char* meMainMenuString(uint8_t Index) // FUNCTION POINTER TARGET - must be < 128k
{
	strcpy_P(pmStrBuf,(PGM_P)&pmdMainMenuList[Index]);
  return &pmStrBuf[0];
} 


//  Get menu name for charlcd
char* pmMenuName(uint8_t n) __attribute__((section(".highmem")));
char* pmMenuName(uint8_t n)
{
	strcpy_P(pmStrBuf,(PGM_P)&pmdMenuList[n]);
  return &pmStrBuf[0];
}  




// 'E' key is abort/ESC   (used as copy in main-loop mode)

void meDoMenus() __attribute__((section(".highmem")));
void meDoMenus()
{
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 1;
	uint8_t restart = 1;
	char kc; 
	int encCount7;
	int m = 0;
	
	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	zscClearDSPKeys(0);	
	do {
		ScrollItemCount = 15;
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) break;
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1) {
			/////  Graphics menu initialise ///////////
			if (zg)	{
				zscDeleteMsgFrame(0);  // clears a hole in DSP display mode
				zscDrawMsgFrame();
				X1scroll = MsgX + 2;
				Y1scroll = MsgY + 4;
				XXscroll = MsgWidth - 2;
				YYscroll = MsgHeight - 5;
				pGetItemString = meMainMenuString;
				srInitScrollMenu();
			}
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1) {
			if (zc) {
				cdSetPos(2,0); 
				cdDisplayString(pmdSpaces(20));
				cdSetPos(2,0);
				cdDisplayString(pmMenuName(m));
			}
			if (zg) srDrawList(m);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0) {
			MenuTimer = 0;
			m += encCount7;
			if (m < 0) m = (m%ScrollItemCount) ? (m%ScrollItemCount)+ScrollItemCount : 0;
			if (m >= ScrollItemCount) m = m%ScrollItemCount;
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'M') {  // M is menu key
			if (zc) {
				cdClearLeft();
				cdSetPos(1,0);
			}
			zscClearMsgFrame();
			switch (m) {
				case 0: meEncoderAssign(0);		break;
				case 1: meButtonAssign('R');	break;
				case 2: meButtonAssign('T'); 	break;
				case 3: meEditDisplayBright();	break;
				case 4: meEditDisplayDimmed();	break;
				case 5: meEditAutodimSeconds();	break;
				case 6: meEditMenuTimeout();	break;
				case 7: meEditMoxTimeout();		break;
				case 8: meEditDDSclock();		break;
				case 9: meEditUSBoffset();		break;
				case 10: meEditLSBoffset();		break;
				case 11: meEditLocalTimeOffset(); break;
				case 12: meTouchpadAssign('R');	break;
				case 13: meTouchpadAssign('T'); break;
				case 14: tpCalibration();		break;
			}
			kc = 'X';
			zscRestoreLeftDisplay();
			refresh = 1;
			restart = 1;
		}
	} while((kc != 'E') && (kc != '#'));  // 'E' is ESC key
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	if((XRIT()==0) && (SigGenMode==0)) geClearParamBox();
	zscRestoreLeftDisplay();
	if (DisplaySwitch == 2) {
		if (zg) geStartDSPdisplay();
	} else {
		zscDeleteMsgFrame(1);
		zscShowDSPKeys(1);
	}
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
	return;
}


/////////////////////////////////////////////

char* meTaskString(uint8_t task) // FUNCTION POINTER TARGET - must be < 128k
{
  return buTaskName(task);
}


char* meButtonAssignString(uint8_t button) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t task;
	if (ButtonRT == 'R')
	{
		strcpy(StrA, PMS(s_Rx_));
		task = RxButtonAssignments[button];
	}
	else
	{
		strcpy(StrA, PMS(s_Tx_));
		task = TxButtonAssignments[button];
	}
	StrA[3] = 0x41 + button;
	StrA[4] = 0x20;
	StrA[5] = 0x20;
	StrA[6] = 0;
	strcat(StrA, buTaskName(task));
	return StrA;
}


void meButtonAssign(char rt) __attribute__((section(".highmem")));
void meButtonAssign(char rt)
{	
	uint8_t refresh = 1;
	uint8_t restart = 1;
	uint8_t nt = buGetNoofTasks();
	char kc;
	int encCount7;
	int button = 0;  //  0 to 25  (= 'a' to 'z')
	int task = 0;
	ButtonRT = rt;
	
	if (rt == 'R') ButtonMode = 0;
	else ButtonMode = 1;
	
/////  Graphics menu initialise ///////////
	if (zg)
	{
		// Frame paras already set up as follows:
		// zscDrawMsgFrame();
		// X1scroll = MsgX + 2;
		// Y1scroll = MsgY + 4;
		// XXscroll = MsgWidth - 2;
		// YYscroll = MsgHeight - 5;
		// now make space for top line title
		Y1scroll = MsgY + 21;
		YYscroll = MsgHeight - 22;
	}
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			if (zg)
			{
				zscClearMsgFrame();
				if (rt == 'R') strcpy(StrA, PMS(s___Select_receive_));
				else strcpy(StrA, PMS(s___Select_transmit_));
				strcat(StrA, PMS(s_task_button));
				gedF8WriteString(StrA, MsgX+3, MsgY+4);
				pGetItemString = meButtonAssignString;
				ScrollItemCount = noofButtons;
				srInitScrollMenu();
			}
			restart = 0;
			enGetEncoder7delta();
		}
		if (refresh == 1)
		{
			if (rt == 'R') task = RxButtonAssignments[button];
			else task = TxButtonAssignments[button];
			if (zc)
			{
				if (rt == 'R') strcpy(StrA, PMS(s_Receive_));
				else strcpy(StrA, PMS(s_Transmit_));
				strcat(StrA, PMS(s_button__));
				StrA[strlen(StrA)-1] = button + 0x41;  //convert numeric to ascii (0-25 to 'a' to 'z')
				cdSetPos(1, 0);
				cdDisplayString(pmdSpaces(20));
				cdSetPos(1, 0);
				cdDisplayString(StrA);
				strcpy(StrA, buTaskName(task));
				cdSetPos(2, 0);
				cdDisplayString(pmdSpaces(20));
				cdSetPos(2, 0);
				cdDisplayString(StrA);
			}
			if (zg)
			{
				srDrawList(button);
			}
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			button += encCount7;
			if (button < 0) button = (button%noofButtons) ? (button%noofButtons)+noofButtons : 0;
			if (button >= noofButtons) button = button%noofButtons;
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'M')
		{
			if (zc)
			{
				cdClearLeft();
				if (rt == 'R') strcpy(StrA, PMS(s_Rx_));
				else strcpy(StrA, PMS(s_Tx_));
				strcat(StrA, PMS(s_button___task));
				StrA[10] = button + 0x41;  //convert numeric to ascii (0-25 to 'a' to 'z')
				cdSetPos(1,0);
				cdDisplayString(StrA);
			}
			if (zg)
			{
				zscClearMsgFrame();
				pGetItemString = meTaskString;
				ScrollItemCount = nt;
				srInitScrollMenu();
				if (rt == 'R') strcpy(StrA, PMS(s___Select_receive_));
				else strcpy(StrA, PMS(s___Select_transmit_));
				strcat(StrA, PMS(s_button___task));
				if (rt == 'R') StrA[24] = button + 0x41;
				else StrA[25] = button + 0x41;
				gedF8WriteString(StrA, MsgX+3, MsgY+4);
			}
			enGetEncoder7delta();
			refresh = 1;
			do
			{
				scReadTR();
				if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
				if (DoMeterCode) scMeterLoopCode();
				usbCheckPC();
				ctDoCat();
				scCheckFlags();
				if (refresh == 1)
				{
					if (zc)
					{
						strcpy(StrA, buTaskName(task));
						cdSetPos(2, 0);
						cdDisplayString(pmdSpaces(20));
						cdSetPos(2, 0);
						cdDisplayString(StrA);
					}
					if (zg) srDrawList(task);
					refresh = 0;
				}
				encCount7 = enGetEncoder7delta();
				if (encCount7 != 0)
				{
					MenuTimer = 0;
					task += encCount7;
					if (task < 0) task = (task%nt) ? (task%nt)+nt : 0;
					if (task >= nt) task = task%nt;
					refresh = 1;
					if (WakeupDisplay) scWakeupDisplay();
				}
				kc = tpGetTouchChar();
				if (kc != 'E') kc = scDoMenuKeyPad();
			} while (kc == 'X');
			MenuTimer = 0;
			if (kc == 'M')
			{
				if (rt == 'R')
				{
					if (buGetTaskAllowed(task, ButtonMode)) RxButtonAssignments[button] = task;
					else RxButtonAssignments[button] = 0;
					scEEwriteRxButtonAssignments();
					if (button >= 18) geButtonLabelsZtoSRx(0,0);
					else if (button >= 11) geButtonLabelsLtoRRx(0,0);
				}
				else
				{
					if (buGetTaskAllowed(task, ButtonMode)) TxButtonAssignments[button] = task;
					else TxButtonAssignments[button] = 0;
					scEEwriteTxButtonAssignments();
					if (button >= 18) geButtonLabelsZtoSTx(0,0);
					else if (button >= 11) geButtonLabelsLtoRTx(0,0);
				}
			}
			kc = 'X';  // if kc = 'E' only drop back one menu level
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
	return;
}


char* meTouchpadAssignString(uint8_t button) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t task;
	if (ButtonRT == 'R')
	{
		strcpy(StrA, PMS(s_Rx_));
		task = RxTouchpadAssignments[button];
	}
	else
	{
		strcpy(StrA, PMS(s_Tx_));
		task = TxTouchpadAssignments[button];
	}
	if (button < 9) {
		StrA[3] = 0x31 + button;
		StrA[4] = 0x20;
	} else {
		StrA[3] = '1';
		StrA[4] = 0x30 + button - 9;
	}
	StrA[5] = 0x20;
	StrA[6] = 0;
	strcat(StrA, buTaskName(task));
	return StrA;
}


void meTouchpadAssign(char rt) __attribute__((section(".highmem")));
void meTouchpadAssign(char rt)
{	
	uint8_t refresh = 1;
	uint8_t restart = 1;
	uint8_t nt = buGetNoofTasks();
	char kc;
	int encCount7;
	int button = 0;  //  0 to 14  (= '1' to '15')
	int task = 0;
	ButtonRT = rt;
	
	if (rt == 'R') ButtonMode = 0;
	else ButtonMode = 1;
	
/////  Graphics menu initialise ///////////
	if (zg)
	{
		// Frame paras already set up as follows:
		// zscDrawMsgFrame();
		// X1scroll = MsgX + 2;
		// Y1scroll = MsgY + 4;
		// XXscroll = MsgWidth - 2;
		// YYscroll = MsgHeight - 5;
		// now make space for top line title
		Y1scroll = MsgY + 21;
		YYscroll = MsgHeight - 22;
	}
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			if (zg)
			{
				zscClearMsgFrame();
				if (rt == 'R') strcpy(StrA, PMS(s___Select_receive_));
				else strcpy(StrA, PMS(s___Select_transmit_));
				strcat(StrA, PMS(s_task_touchpad));
				gedF8WriteString(StrA, MsgX+3, MsgY+4);
				pGetItemString = meTouchpadAssignString;
				ScrollItemCount = noofTPButtons;
				srInitScrollMenu();
			}
			restart = 0;
			enGetEncoder7delta();
		}
		if (refresh == 1)
		{
			if (rt == 'R') task = RxTouchpadAssignments[button];
			else task = TxTouchpadAssignments[button];
			if (zc)
			{
				if (rt == 'R') strcpy(StrA, PMS(s_Receive_));
				else strcpy(StrA, PMS(s_Transmit_));
				strcat(StrA, PMS(s_touchpad___));
				if (button < 9) {  //convert numeric to ascii (0-14 to '1' to '15')
					StrA[strlen(StrA)-2] = 0x31 + button;
				} else {
					StrA[strlen(StrA)-2] = '1';
					StrA[strlen(StrA)-1] = 0x30 + button - 9;
				}
				cdSetPos(1, 0);
				cdDisplayString(pmdSpaces(20));
				cdSetPos(1, 0);
				cdDisplayString(StrA);
				strcpy(StrA, buTaskName(task));
				cdSetPos(2, 0);
				cdDisplayString(pmdSpaces(20));
				cdSetPos(2, 0);
				cdDisplayString(StrA);
			}
			if (zg)
			{
				srDrawList(button);
			}
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			button += encCount7;
			if (button < 0) button = (button%noofTPButtons) ? (button%noofTPButtons)+noofTPButtons : 0;
			if (button >= noofTPButtons) button = button%noofTPButtons;
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'M')
		{
			if (zc)
			{
				cdClearLeft();
				if (rt == 'R') strcpy(StrA, PMS(s_Rx_));
				else strcpy(StrA, PMS(s_Tx_));
				strcat(StrA, PMS(s_touchpad____task));
				if (button < 9) {  //convert numeric to ascii (0-14 to '1' to '15')
					StrA[12] = 0x31 + button;
					memcpy(&StrA[14], &StrA[15], 4);
					StrA[18] = 0;
				} else {
					StrA[12] = '1';
					StrA[13] = 0x30 + button - 9;
				}
				cdSetPos(1,0);
				cdDisplayString(StrA);
			}
			if (zg)
			{
				uint8_t i;
				zscClearMsgFrame();
				pGetItemString = meTaskString;
				ScrollItemCount = nt;
				srInitScrollMenu();
				if (rt == 'R') {
					strcpy(StrA, PMS(s___Select_receive_));
					i = 0;
				} else {
					strcpy(StrA, PMS(s___Select_transmit_));
					i = 1;
				}
				strcat(StrA, PMS(s_touchpad____task));
				if (button < 9) {  //convert numeric to ascii (0-14 to '1' to '15')
					StrA[26+i] = 0x31 + button;
					memcpy(&StrA[28+i], &StrA[29+i], 4);
					StrA[32+i] = 0;
				} else {
					StrA[26+i] = '1';
					StrA[27+i] = 0x30 + button - 9;
				}
				gedF8WriteString(StrA, MsgX+3, MsgY+4);
			}
			enGetEncoder7delta();
			refresh = 1;
			do
			{
				scReadTR();
				if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
				if (DoMeterCode) scMeterLoopCode();
				usbCheckPC();
				ctDoCat();
				scCheckFlags();
				if (refresh == 1)
				{
					if (zc)
					{
						strcpy(StrA, buTaskName(task));
						cdSetPos(2, 0);
						cdDisplayString(pmdSpaces(20));
						cdSetPos(2, 0);
						cdDisplayString(StrA);
					}
					if (zg) srDrawList(task);
					refresh = 0;
				}
				encCount7 = enGetEncoder7delta();
				if (encCount7 != 0)
				{
					MenuTimer = 0;
					task += encCount7;
					if (task < 0) task = (task%nt) ? (task%nt)+nt : 0;
					if (task >= nt) task = task%nt;
					refresh = 1;
					if (WakeupDisplay) scWakeupDisplay();
				}
				kc = tpGetTouchChar();
				if (kc != 'E') kc = scDoMenuKeyPad();
			} while (kc == 'X');
			MenuTimer = 0;
			if (kc == 'M')
			{
				if (rt == 'R')
				{
					if (buGetTaskAllowed(task, ButtonMode)) RxTouchpadAssignments[button] = task;
					else RxTouchpadAssignments[button] = 0;
					scEEwriteRxTouchpadAssignments();
					if (button <= 7) geButtonLabelsZtoSRx(0,0);
					else geButtonLabelsLtoRRx(0,0);
				}
				else
				{
					if (buGetTaskAllowed(task, ButtonMode)) TxTouchpadAssignments[button] = task;
					else TxTouchpadAssignments[button] = 0;
					scEEwriteTxTouchpadAssignments();
					if (button <= 7) geButtonLabelsZtoSTx(0,0);
					else geButtonLabelsLtoRTx(0,0);
				}
			}
			kc = 'X';  // if kc = 'E' only drop back one menu level
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
	return;
}


void meEditNumber(uint32_t* val, char* label, uint32_t min, uint32_t max,
                  uint8_t step, char msg, void (*pAdjust)(uint32_t n)) __attribute__((section(".highmem")));

void meEditNumber(uint32_t* val, char* label, uint32_t min, uint32_t max,
                  uint8_t step, char msg, void (*pAdjust)(uint32_t n))
{
	uint8_t refresh = 1;
	uint8_t k;
	int enc4;
	int encval = 0;
	int32_t v = *val;
	int32_t PreviousVal = *val;
	TuningMode = 'X';
	if (zc) {
		cdSetPos(1,0);
		cdDisplayString(label);
		cdSetPos(2,0);
		cdDisplayString(pmdSpaces(20));
	}
	if (zg) {
		geDrawMsgFrame();
		gedF16WriteString(label,MsgX+6,MsgY1);
		meWriteEditNumberDirections(msg);
	}
	do {
		if (refresh == 1) {
			ltoa(v,StrA,10);
			if (zc) {
				cdSetPos(2,1);
				cdDisplayString(gbTrailingSpaces(StrA,12));
			}
			if (zg) gedF16WriteString(gbTrailingSpaces(StrA,12), MsgX+14, MsgY2);
			refresh = 0;
			(*pAdjust)(v);
		}
		enc4 = enGetEncoder4delta();  // clears encoder4 count
		if (enc4 != 0) MenuTimer = 0;
		encval += enc4;
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) >= step) {
			v += encval / step;
			if (v > (int32_t)max) v = max;
			if (v < (int32_t)min) v = min;
			encval = 0;
			refresh = 1;
		}
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		k = kyGetKeyChar();
		if (k != 'X') MenuTimer = 0;
	} while ( (k != 'E') && (k != '#') && (k != 'M') );
	if (k == 'M') *val = v; else (*pAdjust)(PreviousVal);  // else put it back !!
	zscRestoreLeftDisplay();
	if (zg) zscDeleteMsgFrame(1);
	TuningMode = 'N';  // Encoder 4 can tune trx again
}



void meEditNumberDef(int32_t* val, char* label, int32_t min, int32_t max, int32_t def,
                  int8_t step, int8_t inc, char msg, void (*pAdjust)(uint32_t n)) __attribute__((section(".highmem")));

void meEditNumberDef(int32_t* val, char* label, int32_t min, int32_t max, int32_t def,
                  int8_t step, int8_t inc, char msg, void (*pAdjust)(uint32_t n))
{
	uint8_t refresh = 1;
	uint8_t k;
	int enc4;
	int encval = 0;
	int32_t v = *val;
	int32_t prevv = *val;
	int32_t PreviousVal = *val;
	TuningMode = 'X';
	if (zc) {
		cdSetPos(1,0);
		cdDisplayString(label);
		cdSetPos(2,0);
		cdDisplayString(pmdSpaces(20));
	}
	if (zg) {
		geDrawMsgFrame();
		gedF16WriteString(label,MsgX+6,MsgY1);
		meWriteEditNumberDirections(msg);
	}
	do {
		if (refresh == 1) {
			ltoa(v,StrA,10);
			if (zc) {
				cdSetPos(2,1);
				cdDisplayString(gbTrailingSpaces(StrA,12));
			}
			if (zg) gedF16WriteString(gbTrailingSpaces(StrA,12), MsgX+14, MsgY2);
			refresh = 0;
			(*pAdjust)(v);
		}
		enc4 = enGetEncoder4delta();  // clears encoder4 count
		if (enc4 != 0) MenuTimer = 0;
		encval += enc4;
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) >= step) {
			v += inc*(encval / step);
			if ( (prevv == (int32_t)def) && (v > (int32_t)def) && (v < (int32_t)min) ) v = min;
			if (v > (int32_t)max) v = max;
			if (v < (int32_t)min) v = min;
			prevv = v;
			encval = 0;
			refresh = 1;
		}
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		k = kyGetKeyChar();
		if (k != 'X') MenuTimer = 0;
	} while ( (k != 'E') && (k != '#') && (k != 'M') );
	if (k == 'M') *val = v; else (*pAdjust)(PreviousVal);  // else put it back !!
	zscRestoreLeftDisplay();
	if (zg) zscDeleteMsgFrame(1);
	TuningMode = 'N';  // Encoder 4 can tune trx again
}


void meAdjustDisplayBrightness(uint32_t v) // FUNCTION POINTER TARGET - must be < 128k
{
  scSetDisplayLEDPWM((uint8_t)v);
}


void meEditDisplayBright() __attribute__((section(".highmem")));
void meEditDisplayBright()
{
	if (Transmit == 1) return;
	uint32_t v = DDSparams.dpDisplayBright;
	strcpy(StrA, PMS(s_Set_bright_display));
	meEditNumber(&v, StrA, 0,255, 20, 'B', meAdjustDisplayBrightness);
	if (v != DDSparams.dpDisplayBright)
	{
		DDSparams.dpDisplayBright = v;
		scEEwriteDDSparams();
	}
	scSetDisplayLevel();
}


void meEditDisplayDimmed() __attribute__((section(".highmem")));
void meEditDisplayDimmed()
{
	if (Transmit == 1) {return;}
	uint32_t v = DDSparams.dpDisplayDimmed;
	strcpy(StrA, PMS(s_Set_dimmed_display));
	meEditNumber(&v, StrA, 0,255, 20, 'B', meAdjustDisplayBrightness);
	if (v != DDSparams.dpDisplayDimmed)
	{
		DDSparams.dpDisplayDimmed = v;
		scEEwriteDDSparams();
	}
	scSetDisplayLevel();
}


void meAdjustNothing(uint32_t v) // FUNCTION POINTER TARGET - must be < 128k
{
}


void meEditAutodimSeconds() __attribute__((section(".highmem")));
void meEditAutodimSeconds()
{
	if (Transmit == 1) {return;}
	int32_t v = DDSparams.dpAutoDimSeconds;
	strcpy(StrA, PMS(s_Auto_dim_seconds));
	meEditNumberDef(&v, StrA, 10, 255, 0, 20, 1, 'S', meAdjustNothing);
	if (v != DDSparams.dpAutoDimSeconds)
	{
		DDSparams.dpAutoDimSeconds = v;
		scEEwriteDDSparams();
		AutoDimmed = 0;
		AutoDimTimer = 254;
	}
}


void meEditMenuTimeout() __attribute__((section(".highmem")));
void meEditMenuTimeout()
{
	if (Transmit == 1) {return;}
	int32_t v = DDSparams.dpMenuTimeout;
	strcpy(StrA, PMS(s_Menu_timeout));
	meEditNumberDef(&v, StrA, 5, 60, 0, 20, 1, 'S', meAdjustNothing);
	if (v != DDSparams.dpMenuTimeout)
	{
		DDSparams.dpMenuTimeout = v;
		scEEwriteDDSparams();
		MenuTimer = 0;
	    if (DDSparams.dpMenuTimeout > 4) MenuFlag = 1; else MenuFlag = 0;
	}
}

void meEditMoxTimeout() __attribute__((section(".highmem")));
void meEditMoxTimeout()
{
	if (Transmit == 1) {return;}
	int32_t v = DDSparams.dpMoxTimeout;
	strcpy(StrA, PMS(s_MOX_timeout));
	meEditNumberDef(&v, StrA, 5, 600, 0, 20, 1, 'S', meAdjustNothing);
	if (v != DDSparams.dpMoxTimeout)
	{
		DDSparams.dpMoxTimeout = v;
		scEEwriteDDSparams();
		MoxTimer = 0;
	}
}



void meAdjustDDSclock(uint32_t f) // FUNCTION POINTER TARGET - must be < 128k
{
  fDDSclock = f;
  ddsUpdateDDSclock(0); // 0  = dont save 
}



void meEditDDSclock() __attribute__((section(".highmem")));
void meEditDDSclock()
{
	if (Transmit==1){return;};
	uint32_t fDDSclockPrevious = fDDSclock;
	uint32_t fc = fDDSclock;
	strcpy(StrA, PMS(s_Set_DDS_clock_freq_));
  meEditNumber(&fc, StrA, 1000000,800000000, 1, 'D', meAdjustDDSclock);
  if (fDDSclockPrevious!=fc)
	{
      fDDSclock = fc;
			ddsUpdateDDSclock(1);   //   1  =  save it
	}	    
}


void meAdjustLSBoffset(uint32_t f) // FUNCTION POINTER TARGET - must be < 128k
{
  Freq = f;
  ddsSetFreq(); 
}


void meEditLSBoffset() __attribute__((section(".highmem")));
void meEditLSBoffset()
{
	if (Transmit==1){return;};
	Mode = 0;   // LSB
	scChangeMode();
	SigGenMode = 1;
	uint32_t OldFreq = Freq;
	uint32_t LSBoffsetPrevious = LSBoffset;
	uint32_t fof = LSBoffset;
	strcpy(StrA, PMS(s_Set_LSB_offset));
  meEditNumber(&fof, StrA, 1000000,800000000, 1, 'L', meAdjustLSBoffset);
  Freq = OldFreq;
	if (LSBoffsetPrevious!=fof)
	{
      LSBoffset = fof;
			ddsUpdateLSBoffset(1);   //   1  =  save it
	}	    
	SigGenMode = 0;
}



void meAdjustUSBoffset(uint32_t f) // FUNCTION POINTER TARGET - must be < 128k
{
  Freq = f;
  ddsSetFreq(); // 0  = dont save 
}


void meEditUSBoffset() __attribute__((section(".highmem")));
void meEditUSBoffset()
{
	if (Transmit==1){return;};
	Mode = 1;   // USB
	scChangeMode();
	SigGenMode = 1;
	uint32_t OldFreq = Freq;
	uint32_t USBoffsetPrevious = USBoffset;
	uint32_t fof = USBoffset;
	strcpy(StrA, PMS(s_Set_USB_offset));
  meEditNumber(&fof, StrA, 1000000,800000000, 1, 'U', meAdjustUSBoffset);
  Freq = OldFreq;
	if (USBoffsetPrevious!=fof)
	{
    USBoffset = fof;
		ddsUpdateUSBoffset(1);   //   1  =  save it
	}	    
  SigGenMode = 0;
}

void meEditLocalTimeOffset() __attribute__((section(".highmem")));
void meEditLocalTimeOffset()
{
	if (Transmit == 1) {return;}
	int32_t v = 5*(int8_t)LocalTimeOffset;
	strcpy(StrA, PMS(se_Edit_local_time_offset));
	meEditNumberDef(&v, StrA, -120, +120, 0, 20, 5, 'F', meAdjustNothing);
	if (v != LocalTimeOffset)
	{
	  LocalTimeOffset = v/5;
		ie_eeprom_write_block(&LocalTimeOffset, &ee.EE_LocalTimeOffset, 1);
		rtcDoDateTime();
	}	    
}



char* meEncoderAssignString(uint8_t index) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t e = index;

	if (e >= 8)
	{
		e -= 8;
		strcpy(StrA, "Pot ");
		StrA[4] = 0x41 + e;
	}
	else
	{
		strcpy(StrA, "Enc ");
		StrA[4] = 0x31 + index;
	}
	StrA[5] = 0;
	uint8_t userno = EncodersPotsParams[index];
	uint8_t starno = dspUserToStar(userno);
	if (userno == 99)
	{
		strcpy(StrB,pmdSpaces(7));
	}
	else
	{
	//	ltoa(userno, StrB, 10);
		uint8_t d = userno % 10;
		uint8_t n = userno / 10;
		StrB[0] = 0x20;  //space
		StrB[1] = 0x20;  //space
		StrB[2] = 0x20;  //space
		StrB[3] = n + 0x30;
		StrB[4] = '.';
		StrB[5] = d + 0x30;
		StrB[6] = 0x20;  // space
		StrB[7] = 0;
	}
	strcat(StrA, StrB);
	strcat(StrA, pmParamNameNL(starno));
	return StrA;
}


char* meEncoderParamString(uint8_t i) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t userno = pmSeqToUserNo(i);
	if (userno == 99)
	{
		strcpy(StrA, PMS(s____no_param_assigned));
	}
	else
	{
		uint8_t starno = dspUserToStar(userno);
		uint8_t d = userno % 10;
		uint8_t n = userno / 10;
		StrA[0] = n + 0x30;
		StrA[1] = '.';
		StrA[2] = d + 0x30;
		StrA[3] = 0x20;  // space
		StrA[4] = 0;
		strcat(StrA, pmParamNameNL(starno));
	}
	return StrA;
}


void meEncoderAssign(uint8_t ch) __attribute__((section(".highmem")));
void meEncoderAssign(uint8_t ch)
{
	int de;
	int e = LastEncoderSetting;
	int encCount7;
	char kc;
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 1;
	uint8_t restart = 1;
	uint8_t EncNo = 0;
	uint8_t starno = 0;
	uint8_t userno = 0;
	uint8_t noofmenus;
	
	if (ch != 0) noofmenus = 8; else noofmenus = 10;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
/////  Graphics menu initialise ///////////
	if (zg)	
	{
		Y1scroll = MsgY + 21;
		YYscroll = MsgHeight - 22;
	}
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			if (zg)
			{
				zscClearMsgFrame();
				if (ch != 0) gedF8WriteString(PMS(s___Select_encoder), MsgX+3, MsgY+4);
				else gedF8WriteString(PMS(s___Select_encoder_or_pot), MsgX+3, MsgY+4);
				pGetItemString = meEncoderAssignString;
				ScrollItemCount = noofmenus;
				srInitScrollMenu();
			}
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1)
		{
			if (zc)
			{
				if (e < 8)
				{
					strcpy(StrA, PMS(s_Encoder__));
					StrA[8] = e + 0x31;  //convert numeric to ascii (0-7 to 1-8)
				}
				else
				{
					strcpy(StrA, PMS(s_Potentiometer__));
					StrA[14] = e + 0x39;  //convert numeric to ascii (0-1 to A to B
				}
				cdSetPos(1, 0);
				cdDisplayString(pmdSpaces(20));
				cdSetPos(1, 0);
				cdDisplayString(StrA);
			}
			if (zg)
			{
				srDrawList(e);
			}
			EncNo = e;
			userno = EncodersPotsParams[EncNo];
			starno = dspUserToStar(userno);
			if (zc)
			{
				if (starno == 99)
				{
					strcpy(StrA, pmdSpaces(3));
				}
				else
				{
					ltoa(userno, StrA, 10);
					strcat(StrA, " ");
				}
				strcat(StrA, pmParamNameShortNL(starno));
				cdSetPos(2, 0);
				cdDisplayString(pmdSpaces(20));
				cdSetPos(2, 0);
				cdDisplayString(StrA);
			}
			refresh = 0;
		}
		if (uaCheckEncoders8(&nenc, &delta, &updown, 0) != 0)
		{
			encCount7 = enGetEncoder7delta();
			if (encCount7 != 0)
			{
				MenuTimer = 0;
				e += encCount7;
				if (e < 0) e = (e%noofmenus) ? (e%noofmenus)+noofmenus: 0;
				if (e >= noofmenus) e = e%noofmenus;
				refresh = 1;
				if (WakeupDisplay) scWakeupDisplay();
			}
			kc = tpGetTouchChar();
			if ((kc != 'E') && (kc != ch)) kc = scDoMenuKeyPad();
			if (kc != 'X') MenuTimer = 0;
		}
		else
		{
			MenuTimer = 0;
			e = nenc;
			EncNo = e;
			userno = EncodersPotsParams[EncNo];
			starno = dspUserToStar(userno);
			kc = 'M';
		}
		if ((kc == 'M') || (kc == ch))
		{
			if (zc)
			{
				cdClearLeft();
				if (e < 8)
				{
					strcpy(StrA, PMS(s_Enc____set_param));
					StrA[4] = e + 0x31;  //convert numeric to ascii (0-7 to 1-8)
				}
				else
				{
					strcpy(StrA, PMS(s_Pot____set_param));
					StrA[4] = e + 0x39;  //convert numeric to ascii (0-3 to A to D)
				}
				cdSetPos(1, 0);
				cdDisplayString(StrA);
			}
			if (zg)
			{
				zscClearMsgFrame();
				pGetItemString = meEncoderParamString;
				ScrollItemCount = 48;
				srInitScrollMenu();
				if (e < 8)
				{
					strcpy(StrA, PMS(s___Encoder___set_parameter));
					StrA[10] = e + 0x31;
				}
				else
				{
					strcpy(StrA, PMS(s___Potentiometer___set_parameter));
					StrA[16] = e + 0x39;
				}
				gedF8WriteString(StrA, MsgX+3, MsgY+4);
			}
			enGetEncoder7delta();
			refresh = 1;
			do
			{
				scReadTR();
				if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
				if (DoMeterCode) scMeterLoopCode();
				usbCheckPC();
				ctDoCat();
				scCheckFlags();
				if (refresh == 1)
				{
					starno = dspUserToStar(userno);
					if (zc)
					{
						if (starno == 99)
						{
							strcpy(StrA, pmdSpaces(3));
						}
						else
						{
							ltoa(userno, StrA, 10);
							strcat(StrA, pmdSpaces(1));
						}
						strcat(StrA, pmParamNameShortLN(pmListIndexFromParamNo(starno)));
						cdSetPos(2, 0);
						cdDisplayString(pmdSpaces(20));
						cdSetPos(2, 0);
						cdDisplayString(StrA);
					}
					if (zg)
					{
						srDrawList(pmUsernoToSeq(userno));
					}
					refresh = 0;
				}
				de = 0;
				if (uaCheckEncoders8(&nenc, &delta, &updown, 0) != 0) {
					encCount7 = enGetEncoder7delta();
					if (encCount7 != 0) de = encCount7;
				} else {
					if (e == nenc) {
						if (!zg) {
							if (updown == 1) {
								if (HardwareSettings.hsMenuEncoder == 0) de = delta; else de = -delta;
							} else {
								if (HardwareSettings.hsMenuEncoder == 0) de = -delta; else de = delta;
							}
						} else {
							if (updown == 1) {
								if (HardwareSettings.hsMenuEncoder == 0) de = -delta; else de = delta;
							} else {
								if (HardwareSettings.hsMenuEncoder == 0) de = delta; else de = -delta;
							}
						}
					}
				}
				if (de != 0) {
					MenuTimer = 0;
					userno = pmUserNoListShift(userno, de, 1);   // 1 = Allow unassigned
					if (userno == 0) starno = 0;
					else starno = dspUserToStar(userno);
					refresh = 1;
					if (WakeupDisplay) scWakeupDisplay();
				}
				kc = tpGetTouchChar();
				if ((kc != 'E') && (kc != ch)) kc = scDoMenuKeyPad();
			} while (kc == 'X');
			MenuTimer = 0;
			if ((kc == 'M') || (kc == ch))
			{
				EncodersPotsParams[EncNo] = userno;
				scEEwriteEncodersPotsParams();
				enSetEncodersMaxMin();
				if (EncNo < 8) LastEncoderSetting = EncNo;
			}
			kc = 'X';  // if kc = 'E' only drop back one menu level
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
}


void meLastEncoderAssign() __attribute__((section(".highmem")));
void meLastEncoderAssign()
{
	int de;
	int encCount7;
	char kc;
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 1;
	uint8_t starno = 0;
	uint8_t userno = 0;
	
	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	zscClearDSPKeys(0);
	if (zc)
	{
		cdClearLeft();
		strcpy(StrA, PMS(s_Enc____set_param));
		StrA[4] = LastEncoderSetting + 0x31;  //convert numeric to ascii (0-7 to 1-8)
		cdSetPos(1,0);
		cdDisplayString(StrA);
	}
	if (zg)
	{
		zscDeleteMsgFrame(0);  // clears a hole in DSP display mode
		zscDrawMsgFrame();
		X1scroll = MsgX + 2;
		XXscroll = MsgWidth - 2;
		Y1scroll = MsgY + 21;
		YYscroll = MsgHeight - 22;
		pGetItemString = meEncoderParamString;
		ScrollItemCount = 48;
		srInitScrollMenu();
		strcpy(StrA, PMS(s___Encoder___set_parameter));
		StrA[10] = LastEncoderSetting + 0x31;
		gedF8WriteString(StrA, MsgX + 3, MsgY + 4);
	}
	userno = EncodersPotsParams[LastEncoderSetting];
	enGetEncoder7delta();
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2))
		{
			DisplayingMenu = 0;
			MenuFlag = 0;
			MenuTimer = 0;
			MenuExit = 1;
			geClearParamBox();
			zscRestoreLeftDisplay();
			if (DisplaySwitch == 2)
			{
				if (zg) geStartDSPdisplay();
			}
			else
			{
				zscDeleteMsgFrame(1);
				zscShowDSPKeys();
				zscShowFilter();
			}
			Encoder4count = 0;
			do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
			return;   //  exit all meus on TR switched
		}
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (refresh == 1)
		{
			starno = dspUserToStar(userno);
			if (zc)
			{
				if (starno == 99)
				{
					strcpy(StrA, pmdSpaces(3));
				}
				else
				{
					ltoa(userno, StrA, 10);
					strcat(StrA, pmdSpaces(1));
				}
				strcat(StrA, pmParamNameShortLN(pmListIndexFromParamNo(starno)));
				cdSetPos(2, 0);
				cdDisplayString(pmdSpaces(20));
				cdSetPos(2, 0);
				cdDisplayString(StrA);
				}
			if (zg) srDrawList(pmUsernoToSeq(userno));
			refresh = 0;
		}
		de = 0;
		do
		{
			n = uaCheckEncoders8(&nenc, &delta, &updown, 0);
			if ( (n == 0) && (nenc == LastEncoderSetting) ) {
				if (!zg) {
					if (updown == 1) {
						if (HardwareSettings.hsMenuEncoder == 0) de += delta; else de -= delta;
					} else {
						if (HardwareSettings.hsMenuEncoder == 0) de -= delta; else de += delta;
					}
				} else {
					if (updown == 1) {
						if (HardwareSettings.hsMenuEncoder == 0) de -= delta; else de += delta;
					} else {
						if (HardwareSettings.hsMenuEncoder == 0) de += delta; else de -= delta;
					}
				}
			}
		} while ( (n == 0) || (n == 3) );
		if ( (de == 0) && ((encCount7 = enGetEncoder7delta()) != 0) ) de = encCount7;
		if (de != 0)
		{
			MenuTimer = 0;
			userno = pmUserNoListShift(userno, de, 1);   // 1 = Allow unassigned
			if (userno == 0) starno = 0;
			else starno = dspUserToStar(userno);
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc=scDoMenuKeyPad();
	} while (kc == 'X');
	MenuTimer = 0;
	if (kc == 'M')
	{
		EncodersPotsParams[LastEncoderSetting] = userno;
		scEEwriteEncodersPotsParams();
		enSetEncodersMaxMin(); 
	}
	kc = 'X';
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	zscRestoreLeftDisplay();
	if (DisplaySwitch == 2)
	{
		if (zg) geStartDSPdisplay();
	}
	else
	{
		zscDeleteMsgFrame(1);
		zscShowDSPKeys();
		zscShowFilter();
	}
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
	return;
}


// called by moving menu encoder oy keying 8 as Picastar
void meParamSettings() __attribute__((section(".highmem")));  
void meParamSettings()  
{
	int ec;
	//int previousval = 0;
	int enc4;
	int encval = 0;
	int paramval = 0;
	char kc; 
	uint8_t doname;
	uint8_t max;
	uint8_t colour;
	uint8_t min;
	uint8_t starno = 0;
	uint8_t n = 8;  // unneceassary initialisation
	uint8_t refresh = 1;
	uint8_t userno = ParamGroupItem[ParamGroup];
	
	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
/////  Graphics menu initialise ///////////
	if (zg) {
		if (DisplaySwitch == 2) HaltDSPdisplay=1;
		zscClearDSPKeys(0);
		zscDeleteMsgFrame(0);  // clears a hole in DSP display mode
		zscDrawMsgFrame();
		X1scroll = MsgX + 2;
		Y1scroll = MsgY + 4;
		XXscroll = MsgWidth - 2;
		YYscroll = MsgHeight - 3;
		pGetItemString = meParamMenuString;
		ScrollItemCount = 47;
		srInitScrollMenu();
	}
//////////////////////////////////////
	cdClearLeft();
	cdSetPos(1, 0); 
	TuningMode = 'X'; // stop Encoder4 tuning
	doname = 1;
	do {
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) break;   //  exit all menus on TR switched
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (refresh == 1) {
			colour = ParamColour; // current colour - may be changes by dspGetParamValue();
			if (254 == dspGetParam254Value(dspUserToStar(userno))) colour = pgreen;  // set to green if 254
			meDisplayParamNameAndVal(userno, doname, &colour);
			starno = dspUserToStar(userno);
			dspSetLed(colour);
			refresh = 0;
			doname = 0;
		}
		if (meCheckForEncodersPots()) break;  // check if pots or encoders8 twiddled
		ec = enGetEncoder7delta();
		if (WakeupDisplay) scWakeupDisplay();
		if (ec != 0) {
			MenuTimer = 0;
			userno = pmUserNoListShift(userno, ec, 0);  // 0 = do not allow unassigned
			starno = dspUserToStar(userno);
			ParamGroup = userno / 10;
			ParamGroupItem[ParamGroup] = userno;
			encval = 0;
			refresh = 1;
			doname = 1;
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == '*') {
			if (ParamColour != pgreen) {  // green set not involved
				if (colour == pgreen) {   // value taken from green set - so doesn't have a value of its own
					paramval = dspGetGreenParamValue(starno);
					dspSetParam(starno, paramval);
					dspSetLed(ParamColour);  // save the current value to the param set
				} else {
					dspSetParam(starno, 254);  // has its own value - overwrite with 254
					dspSetLed(pgreen);         //                   - so will report green value
				}
			}
			if (starno == 21) Muted = 0;
			if ((starno >= 61) && (starno <= 66)) zscShowFilter();
			encval = 0;
			refresh = 1;
		}
		if ((kc >= '0') && (kc <= '9')) {
			if (kc != '0') {
				n = kc - 0x30;  /// group number   eg: 2 for 2.1 = AF gain
				userno = ParamGroupItem[n];
				if (n == ParamGroup) {
					userno++;
					starno = dspUserToStar(userno);
					// use list to check for passing top of group
					if (pmListIndexFromParamNo(starno) == 255) userno--;
				}
			} else {
				userno = ParamGroupItem[ParamGroup];
				if ((userno % 10) > 1) userno--;
			}
			starno = dspUserToStar(userno);
			ParamGroup = n;
			ParamGroupItem[ParamGroup] = userno;
			encval = 0;
			refresh = 1;
			doname = 1;
		}
		enc4 = enGetEncoder4delta();  // clears encoder4 count
		if (enc4 != 0) MenuTimer = 0;
		encval += enc4;
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) > 29)
		{
			colour = ParamColour; // current colour - may be changes by dspGetParamValue();
			max = dspGetMax(starno);
			min = dspGetMin(starno);
			paramval = dspGetParamValue(starno);
			dspSetLed(colour);
			//previousval = paramval;
			paramval += encval / 30;   // about 7 increments per rev as in Picastar
			if (paramval > max) paramval = max;
			if (paramval < min) paramval = min;
			if (starno == 81) dspStoreTxDrive(paramval); else dspSetParam(starno, paramval);
			if (starno == 21) Muted = 0;
			if ((starno >= 61) && (starno <= 66)) zscShowFilter();
			switch (starno) {
				case 11:
				case 32:
				case 51:
				case 43:
				case 91:
				case 93: zscShowSwitches();
			}
			encval = 0;
			refresh = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	TuningMode = 'N';  // Encoder 4 can tune trx again
	dspSetLed(ParamColour);
	zscShowFilter();
	zscRestoreLeftDisplay();
	if(SigGenMode==0) geClearParamBox();
	if (DisplaySwitch == 2) {
		if (zg) {
			geStartDSPdisplay();
		}
	} else {
		zscDeleteMsgFrame(1);
		zscShowDSPKeys();
	}
	Encoder4count = 0;
	return;
}


uint8_t meCheckForEncodersPots() __attribute__((section(".highmem")));
uint8_t meCheckForEncodersPots()
{
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t enc8, pots;
	
	enc8 = uaCheckEncoders8(&nenc, &delta, &updown, 1);
	if ((pots = adCheckPots(&nenc, &delta, &updown)) == 0) PotsFlag = 1;
	if ((enc8 == 0) || (pots == 0)) return 1; else return 0;
}


void meDisplayParamNameAndVal(uint8_t userno, uint8_t doname, uint8_t* pcolour) __attribute__((section(".highmem")));
void meDisplayParamNameAndVal(uint8_t userno, uint8_t doname, uint8_t* pcolour)
{
	uint8_t d;
	uint8_t n; 
	uint8_t starno = dspUserToStar(userno);
 	if (zc)   // charlcd
	{ 	 
		if (doname!=0)
		{
	    	cdSetPos(2,0);
			cdDisplayString(pmdSpaces(20));
		 	d = userno%10;
			n = userno/10;
			StrA[0]=n+0x30;
			StrA[1]='.';
			StrA[2]=d+0x30;
			StrA[3]=0;
			strcat(StrA,pmdSpaces(1));
			strcat(StrA,pmParamNameShortNL(starno));
			cdSetPos(1,0);
			cdDisplayString(pmdSpaces(20));
			cdSetPos(1,0);
			cdDisplayString(StrA);
		}			
		cdSetPos(2,1);
		strcpy(StrA,dspParamValString(starno,1));
		strcat(StrA,pmdSpaces(5));
		cdDisplayString(StrA);
	}
	if (zg)   // graphics
	{
		uint8_t MenuIndex = pmUsernoToSeq(userno);
		if (doname!=0)
		{srDrawList(MenuIndex);}
		else
		{srDrawHighlightedItem(MenuIndex);};	
		if(SigGenMode==0)
		{
  		if (doname!=0)
  		{
  			geClearParamBox();
  			strcpy(StrA,pmParamNameNL(starno));
  			gedF8WriteString(StrA,3,42);
  		}
  		else
  		{geClearParamBoxLower();};
  		d = userno%10;
  		n = userno/10;
  		StrA[0]=n+0x30;
  		StrA[1]='.';
  		StrA[2]=d+0x30;
  		StrA[3]=0;
  		strcat(StrA,pmdSpaces(2));
  		strcat(StrA,dspParamValString(starno, 1));
  		strcat(StrA,pmdSpaces(1));
  		strcat(StrA,pmUnitsFromListIndex(pmParamNameIndexNL(starno)));
  		gedF16WriteString(StrA,3,51);					
	  }
	}
}


char* meParamMenuString(uint8_t i) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t userno = pmSeqToUserNo(i);
	uint8_t starno = dspUserToStar(userno);
	uint8_t d = userno%10;
	uint8_t n = userno/10;
	StrA[0]=n+0x30;
	StrA[1]='.';
	StrA[2]=d+0x30;
	StrA[3]=0;
	strcat(StrA,pmdSpaces(1));
	strcat(StrA,pmParamNameNL(starno));
	uint8_t w = gedF8StringWidth(StrA);
	strcpy(StrB,dspParamValString(starno,1));
	strcat(StrB,pmUnitsFromListIndex(pmParamNameIndexNL(starno)));
	w += gedF8StringWidth(StrB);
	strcat(StrA,pmdSpaces((MsgWidth-w-8)/4));
	strcat(StrA,StrB);
	return StrA;
}


void meWriteEditNumberDirections(char wot) __attribute__((section(".highmem")));
void meWriteEditNumberDirections(char wot)
{
	switch(wot)
	{
		case 'F':
		{
		  gedF8WriteString(PMS(se_pom_hours_x_10_displayed),MsgX+4,MsgY3+9);
		  gedF8WriteString(PMS(se_Set_with_tuning_encoder),MsgX+4,MsgY3+18);
			gedF8WriteString(PMS(se_Range_is__120_to__120_),MsgX+4,MsgY3+27);
			break;
		}
		case 'L':
		{
		  gedF8WriteString(PMS(s_This_LSB_offset_setup_operates),MsgX+4,MsgY3);
		  gedF8WriteString(PMS(s_the_same_as_DDS_37_),MsgX+4,MsgY3+9);
			gedF8WriteString(PMS(s_ie__in_signal_generator_mode_),MsgX+4,MsgY3+18);
			gedF8WriteString(PMS(s_Refer_to_Picastar_manual_),MsgX+4,MsgY3+27);
			break;
		}
		case 'U':
		{
		  gedF8WriteString(PMS(s_This_USB_offset_setup_operates),MsgX+4,MsgY3);
		  gedF8WriteString(PMS(s_the_same_as_DDS_31_),MsgX+4,MsgY3+9);
			gedF8WriteString(PMS(s_ie__in_signal_generator_mode_),MsgX+4,MsgY3+18);
			gedF8WriteString(PMS(s_Refer_to_Picastar_manual_),MsgX+4,MsgY3+27);
			break;
		}
		case 'D':
		{
			gedF8WriteString(PMS(s_This_is_different_to_DDS_33_),MsgX+4,MsgY3);
			gedF8WriteString(PMS(s_It_does_not_use_sig__gen__mode_),MsgX+4,MsgY3+10);		  
			gedF8WriteString(PMS(s_It_allows_you_to_calibrate_the),MsgX+4,MsgY3+19);		  
			gedF8WriteString(PMS(s_DDS_clock_by_tuning_the_receiver),MsgX+4,MsgY3+28);		  
			gedF8WriteString(PMS(s_to_an_accurate_known_signal_),MsgX+4,MsgY3+37);		  					  
		  break;
		}
		case 'B':
		{
			gedF8WriteString(PMS(s_With_LED_set_the_brightness_),MsgX+4,MsgY3);		  
			gedF8WriteString(PMS(s_With_CFL__bright_is_full_on),MsgX+4,MsgY3+10);		  
			gedF8WriteString(PMS(s_and_dimmed_is_set_by_R13_),MsgX+4,MsgY3+19);		  
			gedF8WriteString(PMS(s_Set_bright_255__Set_dim_below),MsgX+4,MsgY3+28);		  
			gedF8WriteString(PMS(s_the_bright_dim_switching_point_),MsgX+4,MsgY3+37);		  
			break;
		}
		case 'S':
		{
		  break;
		}
	}
	gedF8WriteString(PMS(s_Menu_to_accept_____ESC_to_abort),MsgX+8,MsgY3+48);
}
