/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taKS0108Menus.c    128x64 mono graphics menus program file

*/


#include "taGlobal.h"
#include "taKS0108Driver.h"
#include "taKS0108.h"
#include "taFT245R.h"
#include "taFont8.h"
#include "taFont16.h"
#include "taStarControl.h"
#include "taZ_StarControl.h"
#include "taSWR.h"
#include "taZ_SWR.h"
#include "taEncoder.h"
#include "taDDS.h"
#include "taStarDSP.h"
#include "taMenus.h"
#include "taCAT.h"
#include "taEA320TouchPanel.h"
#include "taADC.h"
#include "taUsart.h"
#include "taKS0108Menus.h"
#include "taButtons.h"
#include "taKeys.h"
#include "taRTC.h"
#include "taEEPROM.h"
#include "taIntEeprom.h"

#define ksmScrollSpacing 9
#define ksmTop 27
#define ksmBottom 62
#define ksmLeft 1 
#define ksmRight 125
#define ksmVisCount 4

#define InfoRight 36	// was 37
#define InfoBottom 25	// was 26

#define MsgTop 25
#define MsgBottom 54
#define MsgLeft 0
#define MsgRight 99

#define pgreen 1


static uint8_t VisCount;
static uint8_t ksmScrollItemCount;
static uint8_t ScrollY;

uint8_t ksmAllowDisplayRTC();
uint16_t ksmLineY(uint8_t n);
void ksmDisplayParamNoAndName(uint8_t userno, uint8_t dolist, uint8_t* pcolour);
void ksmEditNumber(uint32_t* val, char* label, uint32_t min, uint32_t max,
                  uint8_t step, char msg, void (*pAdjust)(uint32_t n));
void ksmEditNumberDef(int32_t* val, char* label, int32_t min, int32_t max, int32_t def,
                  int8_t step, uint8_t inc, char msg, void (*pAdjust)(uint32_t n));
void ksmWriteEditNumberDirections(char wot);
char* ksdParamMenuString(uint8_t i); // FUNCTION POINTER TARGET - must be < 128k
char* ksmMainMenuString(uint8_t Index); // FUNCTION POINTER TARGET - must be < 128k
char* ksmTaskString(uint8_t task); // FUNCTION POINTER TARGET - must be < 128k
char* ksmButtonAssignString(uint8_t button); // FUNCTION POINTER TARGET - must be < 128k
char* ksmEncoderAssignString(uint8_t index); // FUNCTION POINTER TARGET - must be < 128k
char* ksmEncoderParamString(uint8_t i); // FUNCTION POINTER TARGET - must be < 128k
void ksmAdjustDisplayBrightness(uint32_t v); // FUNCTION POINTER TARGET - must be < 128k
void ksmAdjustNothing(uint32_t v); // FUNCTION POINTER TARGET - must be < 128k
void ksmAdjustDDSclock(uint32_t f); // FUNCTION POINTER TARGET - must be < 128k
void ksmAdjustLSBoffset(uint32_t f); // FUNCTION POINTER TARGET - must be < 128k
void ksmEditUSBoffset();   // FUNCTION POINTER TARGET - must be < 128k
void ksmEditLocalTimeOffset();   // FUNCTION POINTER TARGET - must be < 128k
char* ksmSlotMenuString(uint8_t Index);  // FUNCTION POINTER TARGET - must be < 128k
void ksmButtonAssign(char rt);
void ksmEditDisplayBright();
void ksmEditDisplayDimmed();
void ksmEditAutodimSeconds();
void ksmEditMenuTimeout();
void ksmEditMoxTimeout();
void ksmEditDDSclock();
void ksmEditLSBoffset();
void ksmEditUSBoffset();
uint8_t ksmCheckForEncodersPots();
char ksmSlotListMenu(uint8_t slotkind);
void ksmGotoSlot(uint8_t slotkind, uint8_t m);
char* ksmBandSlotMenuString(uint8_t i); // FUNCTION POINTER TARGET - must be < 128k
char* ksmVfoSlotMenuString(uint8_t i); // FUNCTION POINTER TARGET - must be < 128k
char* ksmMemSlotMenuString(uint8_t i); // FUNCTION POINTER TARGET - must be < 128k
char* ksmSlotInfo(char slotkind);
char* (*pGetItemString)(uint8_t n);

uint16_t ksmLineY(uint8_t n) __attribute__((section(".highmem")));
uint16_t ksmLineY(uint8_t n)
{
  return ScrollY + n*ksmScrollSpacing;
}

void ksmMsgBox() __attribute__((section(".highmem")));
void ksmMsgBox()
{
	ksdClearRect(MsgLeft,MsgTop,MsgRight,MsgBottom);
  ksdLine(MsgLeft,MsgTop,MsgRight,MsgTop);
	ksdLine(MsgLeft,MsgTop,MsgLeft,MsgBottom);
	ksdLine(MsgLeft,MsgBottom,MsgRight,MsgBottom);
	ksdLine(MsgRight,MsgTop,MsgRight,MsgBottom);
}


void ksmMsgLine(char* s, uint8_t n) __attribute__((section(".highmem")));
void ksmMsgLine(char* s, uint8_t n)
{
	ksdClearRect(MsgLeft+1,MsgTop+3+8*(n-1),MsgRight-1,MsgTop+1+9*n);
	ksdF8WriteString(s,MsgLeft+3,MsgTop+2+9*(n-1),0);
}

void ksmDeleteMenuBox(uint8_t DoSwitchArea) __attribute__((section(".highmem")));
void ksmDeleteMenuBox(uint8_t DoSwitchArea)
{
	ksdClearRect(0,ksmTop-2,127,63 - 8*(DoSwitchArea==0));
	if(ksFreqInfoShowing) ksWriteFreqInfoData(ksFreqInfoText);
}

void ksmClearMenuBox() __attribute__((section(".highmem")));
void ksmClearMenuBox()
{
	ksdClearRect(1,ksmTop-1,126,62);
}


void ksmClearScrollArea() __attribute__((section(".highmem")));
void ksmClearScrollArea()
{
	ksdClearRect(1,ScrollY,126,62);
}



void ksmDrawList(int Index) __attribute__((section(".highmem")));
void ksmDrawList(int Index)
{
	uint8_t y, inverted;
	char u[40];
	int pos,i;
	for(pos=0;pos<VisCount;pos++)
	{  
		y = ScrollY+pos*ksmScrollSpacing;
		ksdClearRect(ksmLeft,y-1,ksmRight+1,y+8);
		
		i = pos + Index - HighlightedPos;
		if(i<0){i+=ksmScrollItemCount;};
		if(i>=ksmScrollItemCount){i-=ksmScrollItemCount;}
		strcpy(u," ");
		strcat(u,pGetItemString(i));
		if(pos==HighlightedPos) inverted = 1; else inverted = 0;
		ksdF8WriteString(u,ksmLeft,y,inverted);
	}
}


void ksmInitMenu() __attribute__((section(".highmem")));
void ksmInitMenu()
{
	VisCount = (ksmBottom-ScrollY+1)/ksmScrollSpacing;
	if(VisCount>ksmScrollItemCount){VisCount=ksmScrollItemCount;};
  HighlightedPos = (VisCount+1)/2 - 1;
	SpaceWidth = pgm_read_byte(&lentbl_S[0]);   // ascii 32 width
	ksdClearRect(ksmLeft,ksmTop,ksmRight,ksmBottom);
}


void ksmDrawMenuFrame() __attribute__((section(".highmem")));
void ksmDrawMenuFrame()
{
	ksdLine(0,ksmTop-2,127,ksmTop-2);
	ksdLine(0,63,127,63);
	ksdLine(0,ksmTop-2,0,63);
	ksdLine(127,ksmTop-2,127,63);
}

void ksmDrawInfoFrame() __attribute__((section(".highmem")));
void ksmDrawInfoFrame()
{
	ksmDeleteInfoBox();
	ksdLine(0,0,InfoRight,0);
	ksdLine(0,InfoBottom,InfoRight,InfoBottom);
	ksdLine(0,0,0,InfoBottom);
	ksdLine(InfoRight,0,InfoRight,InfoBottom);
}

void ksmDeleteInfoBox() __attribute__((section(".highmem")));
void ksmDeleteInfoBox()
{
	ksdClearRect(0,0,InfoRight,InfoBottom);
	ksFreqInfoShowing = 0;
	ksmDrawDateTime();
}

void ksmClearInfoBox() __attribute__((section(".highmem")));
void ksmClearInfoBox()
{
	ksdClearRect(1,1,InfoRight-1,InfoBottom-1);	
}


 /////////////////////////////////////////////////////////////////////////////

void ksmRestoreMenuArea(uint8_t DoSwitches) __attribute__((section(".highmem")));
void ksmRestoreMenuArea(uint8_t DoSwitches)
{
	ksmDeleteMenuBox(DoSwitches);
	if(DoSwitches) zscShowSwitches();
	if(Transmit) ksSwrInit(); else ksSmeterInit(); 		
	zscShowFilter();
	zscDisplayIP3NF();
	zscDisplayParamColour(ParamColour);
	ksmDrawDateTime();
	zscShowMode();
}

void ksmRestoreInfoArea() __attribute__((section(".highmem")));
void ksmRestoreInfoArea()
{
	ksmDeleteInfoBox();
	zscShowMemStackSlotNo();
	ksmDrawDateTime();
}


///////////////////   RTC   /////////////////////////

uint8_t ksmAllowDisplayRTC() __attribute__((section(".highmem")));
uint8_t ksmAllowDisplayRTC()
{
	if ((RtcActive==0)
	|| NoClockDraw || Guarding || (TuningMode=='V') 
	|| (TuningMode=='R') || (TuningMode=='S')
	|| (TuningMode=='M') || SigGenMode) return 0;
	return 1;
}


void ksmDrawTime() __attribute__((section(".highmem")));
void ksmDrawTime()
{
	if(!ksmAllowDisplayRTC()) return; 
	strcpy(StrB,StrTimeL);
	ksdWrite5x3String(StrB,2,12);
}
   


void ksmDrawDateTime() __attribute__((section(".highmem")));
void ksmDrawDateTime()
{
	if(!ksmAllowDisplayRTC()) return; 
	ksmClearDateTime();
	strcpy(StrB,StrTimeL);
	ksdWrite5x3String(StrB,2,12);
	strcpy(StrB,StrDateL);
	ksdWrite5x3String(StrB,2,20);
  ksdRectangle(0,10,37,17);
}

void ksmClearDateTime() __attribute__((section(".highmem")));
void ksmClearDateTime()
{
	ksdClearRect(0,12,36,25);
}  


// called by moving menu encoder oy keying 8 as Picastar
void ksmParamSettings() __attribute__((section(".highmem")));
void ksmParamSettings()
{
	int ec;
	//int previousval = 0;
	int enc4;
	int encval = 0;
	int paramval = 0;
	char kc; 
	uint8_t dolist;
	uint8_t max;
	uint8_t colour;
	uint8_t min;
	uint8_t starno = 0;
	uint8_t n = 8;  // unneceassary initialisation
	uint8_t refresh = 1;
	uint8_t userno = ParamGroupItem[ParamGroup];
	
	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
/////  Graphics menu initialise ///////////
	ksmDeleteMenuBox(1);
	ksmDrawMenuFrame();
	ksmDrawInfoFrame();
	pGetItemString = ksdParamMenuString;
	ksmScrollItemCount = 47;
	ScrollY = ksmTop;
	ksmInitMenu();
	
//////////////////////////////////////
	TuningMode = 'X'; // stop Encoder4 tuning
	dolist = 1;
	do {
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) break;   //  exit all menus on TR switched
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (refresh == 1) {
			colour = ParamColour; // current colour - may be changes by dspGetParamValue();
			if (254 == dspGetParam254Value(dspUserToStar(userno))) colour = pgreen;  // set to green if 254
			ksmDisplayParamNoAndName(userno, dolist, &colour);
			starno = dspUserToStar(userno);
			dspSetLed(colour);
			refresh = 0;
			dolist = 0;
		}
		if (ksmCheckForEncodersPots()) break;  // check if pots or encoders8 twiddled
		ec = enGetEncoder7delta();
		if (WakeupDisplay) scWakeupDisplay();
		if (ec != 0) {
			MenuTimer = 0;
			userno = pmUserNoListShift(userno, ec, 0);  // 0 = do not allow unassigned
			starno = dspUserToStar(userno);
			ParamGroup = userno / 10;
			ParamGroupItem[ParamGroup] = userno;
			encval = 0;
			refresh = 1;
			dolist = 1;
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == '*') {
			if (ParamColour != pgreen) {  // green set not involved
				if (colour == pgreen) {   // value taken from green set - so doesn't have a value of its own
					paramval = dspGetGreenParamValue(starno);
					dspSetParam(starno, paramval);
					dspSetLed(ParamColour);  // save the current value to the param set
				} else {
					dspSetParam(starno, 254);  // has its own value - overwrite with 254
					dspSetLed(pgreen);         //                   - so will report green value
				}
			}
			if (starno == 21) Muted = 0;
			encval = 0;
			refresh = 1;
		}
		if ((kc >= '0') && (kc <= '9')) {
			if (kc != '0') {
				n = kc - 0x30;  // group number   eg: 2 for 2.1 = AF gain
				userno = ParamGroupItem[n];
				if (n == ParamGroup) {
					userno++;
					starno = dspUserToStar(userno);
					// use list to check for passing top of group
					if (pmListIndexFromParamNo(starno) == 255) userno--;
				}
			} else {
				userno = ParamGroupItem[ParamGroup];
				if ((userno % 10) > 1) userno--;
			}
			starno = dspUserToStar(userno);
			ParamGroup = n;
			ParamGroupItem[ParamGroup] = userno;
			encval = 0;
			refresh = 1;
			dolist = 1;
		}
		enc4 = enGetEncoder4delta();  // clears encoder4 count
		if (enc4 != 0) MenuTimer = 0;
		encval += enc4;
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) > 29) {
			colour = ParamColour; // current colour - may be changes by dspGetParamValue();
			max = dspGetMax(starno);
			min = dspGetMin(starno);
			paramval = dspGetParamValue(starno);
			dspSetLed(colour);
			//previousval = paramval;
			paramval += encval / 30;   // about 7 increments per rev as in Picastar
			if (paramval > max) paramval = max;
			if (paramval < min) paramval = min;
			if (starno == 81) dspStoreTxDrive(paramval); else dspSetParam(starno, paramval);
			if (starno == 21) Muted = 0;
			encval = 0;
			refresh = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	TuningMode = 'N';  // Encoder 4 can tune trx again
	dspSetLed(ParamColour);
	ksmRestoreMenuArea(1);
	ksmRestoreInfoArea();
	Encoder4count = 0;
	return;
}


uint8_t ksmCheckForEncodersPots() __attribute__((section(".highmem")));
uint8_t ksmCheckForEncodersPots()
{
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t enc8, pots;
	
	enc8 = uaCheckEncoders8(&nenc, &delta, &updown, 1);
	if ((pots = adCheckPots(&nenc, &delta, &updown)) == 0) PotsFlag = 1;
	if ((enc8 == 0) || (pots == 0)) return 1; else return 0;
}


void ksmDisplayParamNoAndName(uint8_t userno, uint8_t dolist, uint8_t* pcolour) __attribute__((section(".highmem")));
void ksmDisplayParamNoAndName(uint8_t userno, uint8_t dolist, uint8_t* pcolour)
{
	uint8_t starno = dspUserToStar(userno);
	uint8_t MenuIndex = pmUsernoToSeq(userno);
	if (dolist) ksmDrawList(MenuIndex);
	ksmClearInfoBox();
	strcpy(StrA,dspParamValString(starno,1));
	strcpy(StrB,pmUnitsFromListIndex(pmParamNameIndexNL(starno)));
	strcpy(StrC,StrA);
	strcat(StrC,pmdSpaces(1));
	strcat(StrC,StrB);
	uint8_t c = ksdF8StringWidth(StrC);
	if(c > (InfoRight-3))
	{
		ksdF8CentreWriteString(StrA,InfoRight/2,4,0);
		ksdF8CentreWriteString(StrB,InfoRight/2,13,0);
	}
	else
	ksdF8CentreWriteString(StrC,InfoRight/2,8,0);
}


char* ksdParamMenuString(uint8_t i) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t userno = pmSeqToUserNo(i);
	uint8_t starno = dspUserToStar(userno);
	uint8_t d = userno%10;
	uint8_t n = userno/10;
	StrA[0]=n+0x30;
	StrA[1]='.';
	StrA[2]=d+0x30;
	StrA[3]=0;
	strcat(StrA,pmdSpaces(1));
	strcat(StrA,pmParamNameNL(starno));
	return StrA;
}


/////////////////////////////////////////////////////////////////////////





// get menu name for 128x64graphics
char* ksmMainMenuString(uint8_t Index) // FUNCTION POINTER TARGET - must be < 128k
{
  return pmMenuName(Index);
} 




// 'E' key is abort/ESC   (used as copy in main-loop mode)

void ksmDoMenus() __attribute__((section(".highmem")));
void ksmDoMenus()
{
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 1;
	uint8_t restart = 1;
	char kc; 
	int encCount7;
	int m = 0;
	
	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	do {
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) break;
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1) {
			ksmDeleteMenuBox(1);
			ksmDrawMenuFrame();
			ksmScrollItemCount = 12;
			ScrollY = ksmTop;
			ksmInitMenu();
			pGetItemString = ksmMainMenuString;
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1) {
			ksmDrawList(m);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0) {
			MenuTimer = 0;
			m += encCount7;
			if (m < 0) m = (m%ksmScrollItemCount) ? (m%ksmScrollItemCount)+ksmScrollItemCount : 0;
			if (m >= ksmScrollItemCount) m = m%ksmScrollItemCount;
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'M') {  // M is menu key
			zscClearMsgFrame();
			switch (m) {
				case 0: ksmEncoderAssign(0);		break;
				case 1: ksmButtonAssign('R');		break;
				case 2: ksmButtonAssign('T');		break;
				case 3: ksmEditDisplayBright();		break;
				case 4: ksmEditDisplayDimmed();		break;
				case 5: ksmEditAutodimSeconds();	break;
				case 6: ksmEditMenuTimeout();		break;
				case 7: ksmEditMoxTimeout();		break;
				case 8: ksmEditDDSclock();			break;
				case 9: ksmEditUSBoffset();			break;
				case 10: ksmEditLSBoffset();		break;
				case 11: ksmEditLocalTimeOffset();		break;
			}
			kc = 'X';
			ksmDeleteMenuBox(1);
			refresh = 1;
			restart = 1;
		}
	} while((kc != 'E') && (kc != '#'));  // 'E' is ESC key
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	ksmRestoreMenuArea(1);
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
	return;
}

//////////////////////////////////////////////////////////////////

char* ksmTaskString(uint8_t task) // FUNCTION POINTER TARGET - must be < 128k
{
  return buTaskName(task);
}


char* ksmButtonAssignString(uint8_t button) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t task;
	if (ButtonRT == 'R')
	{
		strcpy(StrA, PMS(s_Rx_));
		task = RxButtonAssignments[button];
	}
	else
	{
		strcpy(StrA, PMS(s_Tx_));
		task = TxButtonAssignments[button];
	}
	StrA[3] = 0x41 + button;
	StrA[4] = 0x20;
	StrA[5] = 0x20;
	StrA[6] = 0;
	strcat(StrA, buTaskName(task));
	return StrA;
}


void ksmButtonAssign(char rt) __attribute__((section(".highmem")));
void ksmButtonAssign(char rt)
{	
	uint8_t refresh = 1;
	uint8_t restart = 1;
	uint8_t nt = buGetNoofTasks();
	char kc;
	int encCount7;
	int button = 0;  //  0 to 25  (= 'a' to 'z')
	int task = 0;
	ButtonRT = rt;
	
	if (rt == 'R') ButtonMode = 0;
	else ButtonMode = 1;
	// now make space for top line title
	ScrollY = ksmTop + 9;
	
/////  Graphics menu initialise ///////////
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			ksmClearMenuBox();
			ksmScrollItemCount = noofButtons;
			ksmInitMenu();
			if (rt == 'R') strcpy(StrA, PMS(s_Select_Rx_));
			else strcpy(StrA, PMS(s_Select_Tx_));
			strcat(StrA, PMS(s_button));
			ksdF8WriteString(StrA, 3, ksmTop,0);
			pGetItemString = ksmButtonAssignString;
			restart = 0;
			enGetEncoder7delta();
		}
		if (refresh == 1)
		{
			if (rt == 'R') task = RxButtonAssignments[button];
			else task = TxButtonAssignments[button];
			ksmDrawList(button);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			button += encCount7;
			if (button < 0) button = (button%noofButtons) ? (button%noofButtons)+noofButtons : 0;
			if (button >= noofButtons) button = button%noofButtons;
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = scDoMenuKeyPad();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'M')
		{
			ksmClearMenuBox();
			pGetItemString = ksmTaskString;
			ksmScrollItemCount = nt;
			ksmInitMenu();
			if (rt == 'R') strcpy(StrA, PMS(s_Select_Rx_));
			else strcpy(StrA, PMS(s_Select_Tx_));
			strcat(StrA, PMS(s_button___task));
			if (rt == 'R') StrA[19] = button + 0x41;
			else StrA[19] = button + 0x41;
			ksdF8WriteString(StrA, 3, ksmTop, 0);
			enGetEncoder7delta();
			refresh = 1;
			do
			{
				scReadTR();
				if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
				if (DoMeterCode) scMeterLoopCode();
				usbCheckPC();
				ctDoCat();
				scCheckFlags();
				if (refresh == 1)
				{

					ksmDrawList(task);
					refresh = 0;
				}
				encCount7 = enGetEncoder7delta();
				if (encCount7 != 0)
				{
					MenuTimer = 0;
					task += encCount7;
					if (task < 0) task = (task%nt) ? (task%nt)+nt : 0;
					if (task >= nt) task = task%nt;
					refresh = 1;
					if (WakeupDisplay) scWakeupDisplay();
				}
				kc = tpGetTouchChar();
				if (kc != 'E') kc = scDoMenuKeyPad();
			} while (kc == 'X');
			MenuTimer = 0;
			if (kc == 'M')
			{
				if (rt == 'R')
				{
					if (buGetTaskAllowed(task, ButtonMode)) RxButtonAssignments[button] = task;
					else RxButtonAssignments[button] = 0;
					scEEwriteRxButtonAssignments();
				}
				else
				{
					if (buGetTaskAllowed(task, ButtonMode)) TxButtonAssignments[button] = task;
					else TxButtonAssignments[button] = 0;
					scEEwriteTxButtonAssignments();
				}
			}
			kc = 'X';  // if kc = 'E' only drop back one menu level
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
	return;
}




////////////////////////////////////////////////////////////////////////////

char* ksmEncoderAssignString(uint8_t index) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t e = index;

	if (e >= 8)
	{
		e -= 8;
		strcpy(StrA, PMS(s_Pot));
		StrA[3] = 0x41 + e;
	}
	else
	{
		strcpy(StrA, PMS(s_Enc));
		StrA[3] = 0x31 + index;
	}
	StrA[4] = 0;
	uint8_t userno = EncodersPotsParams[index];
	uint8_t starno = dspUserToStar(userno);
	if (userno == 99)
	{
		strcpy(StrB,pmdSpaces(6));
	}
	else
	{
		uint8_t d = userno % 10;
		uint8_t n = userno / 10;
		StrB[0] = 0x20;  //space
		StrB[1] = 0x20;  //space
		StrB[2] = n + 0x30;
		StrB[3] = '.';
		StrB[4] = d + 0x30;
		StrB[5] = 0x20;  // space
		StrB[6] = 0;
	}
	strcat(StrA, StrB);
	strcat(StrA, pmParamNameShortNL(starno));
	return StrA;
}


char* ksmEncoderParamString(uint8_t i) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t userno = pmSeqToUserNo(i);
	if (userno == 99)
	{
		strcpy(StrA, PMS(s__no_param_assigned));
	}
	else
	{
		uint8_t starno = dspUserToStar(userno);
		uint8_t d = userno % 10;
		uint8_t n = userno / 10;
		StrA[0] = n + 0x30;
		StrA[1] = '.';
		StrA[2] = d + 0x30;
		StrA[3] = 0x20;  // space
		StrA[4] = 0;
		strcat(StrA, pmParamNameShortNL(starno));
	}
	return StrA;
}



void ksmEncoderAssign(uint8_t ch) __attribute__((section(".highmem")));
void ksmEncoderAssign(uint8_t ch)
{
	int de;
	int e = LastEncoderSetting;
	int encCount7;
	char kc;
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 1;
	uint8_t restart = 1;
	uint8_t EncNo = 0;
	//uint8_t starno = 0;
	uint8_t userno = 0;
	uint8_t noofmenus;
	
	if (ch != 0) noofmenus = 8; else noofmenus = 10;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
/////  Graphics menu initialise ///////////
		ScrollY = ksmTop + 9;
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			ksmClearMenuBox();
			ksmScrollItemCount = noofmenus;
			ksmInitMenu();
			if (ch != 0) ksdF8WriteString(PMS(s_Select_encoder), 10, ksmTop,0);
			else ksdF8WriteString(PMS(s_Select_encoder_or_pot), 10, ksmTop,0);
			pGetItemString = ksmEncoderAssignString;
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1)
		{
			ksmDrawList(e);
			EncNo = e;
			userno = EncodersPotsParams[EncNo];
			//starno = dspUserToStar(userno);
			refresh = 0;
		}
		if (uaCheckEncoders8(&nenc, &delta, &updown, 0) != 0)
		{
			encCount7 = enGetEncoder7delta();
			if (encCount7 != 0)
			{
				MenuTimer = 0;
				e += encCount7;
				if (e < 0) e = (e%noofmenus) ? (e%noofmenus)+noofmenus: 0;
				if (e >= noofmenus) e = e%noofmenus;
				refresh = 1;
				if (WakeupDisplay) scWakeupDisplay();
			}
			kc = tpGetTouchChar();
			if ((kc != 'E') && (kc != ch)) kc = scDoMenuKeyPad();
			if (kc != 'X') MenuTimer = 0;
		}
		else
		{
			MenuTimer = 0;
			e = nenc;
			EncNo = e;
			userno = EncodersPotsParams[EncNo];
			//starno = dspUserToStar(userno);
			kc = 'M';
		}
		if ((kc == 'M') || (kc == ch))
		{
			ksmClearMenuBox();
			pGetItemString = ksmEncoderParamString;
			ksmScrollItemCount = 48;
			ksmInitMenu();
			if (e < 8)
			{
				strcpy(StrA, PMS(s_Enc___set_parameter));
				StrA[4] = e + 0x31;
			}
			else
			{
				strcpy(StrA, PMS(s_Pot___set_parameter));
				StrA[4] = e + 0x39;
			}
			ksdF8WriteString(StrA, 10, ksmTop,0);
			enGetEncoder7delta();
			refresh = 1;
			do
			{
				scReadTR();
				if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) return;   //  exit all menus on TR switched
				if (DoMeterCode) scMeterLoopCode();
				usbCheckPC();
				ctDoCat();
				scCheckFlags();
				if (refresh == 1)
				{
					//starno = dspUserToStar(userno);
					ksmDrawList(pmUsernoToSeq(userno));
					refresh = 0;
				}
				de = 0;
				if (uaCheckEncoders8(&nenc, &delta, &updown, 0) != 0)
				{
					encCount7 = enGetEncoder7delta();
					if (encCount7 != 0) de = encCount7;
				} 
				else
				{
					if (e == nenc)
					{
						 if (updown == 1)
						{
							if (HardwareSettings.hsMenuEncoder == 0) de = -delta; else de = delta;
						} else
						{
							if (HardwareSettings.hsMenuEncoder == 0) de = delta; else de = -delta;
						}
					}
				}
				if (de != 0)
				{
					MenuTimer = 0;
					userno = pmUserNoListShift(userno, de, 1);   // 1 = Allow unassigned
					//if (userno == 0) starno = 0;
					//else starno = dspUserToStar(userno);
					refresh = 1;
					if (WakeupDisplay) scWakeupDisplay();
				}
				kc = tpGetTouchChar();
				if ((kc != 'E') && (kc != ch)) kc = scDoMenuKeyPad();
			} while (kc == 'X');
			MenuTimer = 0;
			if ((kc == 'M') || (kc == ch))
			{
				EncodersPotsParams[EncNo] = userno;
				scEEwriteEncodersPotsParams();
				enSetEncodersMaxMin();
				if (EncNo < 8) LastEncoderSetting = EncNo;
			}
			kc = 'X';  // if kc = 'E' only drop back one menu level
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));
}

////////////////////////////////////////////////////////////////////////////////////

void ksmEditNumber(uint32_t* val, char* label, uint32_t min, uint32_t max,
                  uint8_t step, char msg, void (*pAdjust)(uint32_t n)) __attribute__((section(".highmem")));
void ksmEditNumber(uint32_t* val, char* label, uint32_t min, uint32_t max,
                  uint8_t step, char msg, void (*pAdjust)(uint32_t n))
{
	uint8_t refresh = 1;
	uint8_t k;
	int enc4;
	int encval = 0;
	int32_t v = *val;
	int32_t PreviousVal = *val;
	TuningMode = 'X';
	ksmClearMenuBox();
	ksmDrawMenuFrame();
	ksdF8WriteString(label, 3, ksmTop, 0);
	ksmWriteEditNumberDirections(msg);
	do {
		if (refresh == 1) {
			ltoa(v, StrA, 10);
			ksdF8WriteString(gbTrailingSpaces(StrA,12), 3, ksmTop+12, 0);
			refresh = 0;
			(*pAdjust)(v);
		}
		enc4 = enGetEncoder4delta();  // clears encoder4 count
		if (enc4 != 0) MenuTimer = 0;
		encval += enc4;
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) >= step) {
			v += encval / step;
			if (v > (int32_t)max) v = max;
			if (v < (int32_t)min) v = min;
			encval = 0;
			refresh = 1;
		}
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		k = kyGetKeyChar();
		if (k != 'X') MenuTimer = 0;
	} while ( (k != 'E') && (k != '#') && (k != 'M') );
	if (k == 'M') *val = v; else (*pAdjust)(PreviousVal);  // else put it back !!
	// ksmRestoreMenuArea(1);
	TuningMode = 'N';  // Encoder 4 can tune trx again
}



void ksmEditNumberDef(int32_t* val, char* label, int32_t min, int32_t max, int32_t def,
                  int8_t step, uint8_t inc, char msg, void (*pAdjust)(uint32_t n)) __attribute__((section(".highmem")));
void ksmEditNumberDef(int32_t* val, char* label, int32_t min, int32_t max, int32_t def,
                  int8_t step, uint8_t inc, char msg, void (*pAdjust)(uint32_t n))
{
	uint8_t refresh = 1;
	uint8_t k;
	int enc4;
	int encval = 0;
	int32_t v = *val;
	int32_t prevv = *val;
	int32_t PreviousVal = *val;
	TuningMode = 'X';
	ksmClearMenuBox();
	ksmDrawMenuFrame();
	ksdF8WriteString(label, 3, ksmTop, 0);
	ksmWriteEditNumberDirections(msg);
	do {
		if (refresh == 1) {
			ltoa(v, StrA, 10);
			ksdF8WriteString(gbTrailingSpaces(StrA,12), 3, ksmTop+12, 0);
			refresh = 0;
			(*pAdjust)(v);
		}
		enc4 = enGetEncoder4delta();  // clears encoder4 count
		if (enc4 != 0) MenuTimer = 0;
		encval += enc4;
		if (WakeupDisplay) scWakeupDisplay();
		if (abs(encval) >= step) {
			v += inc*(encval / step);
			if ( (prevv == (int32_t)def) && (v > (int32_t)def) && (v < (int32_t)min) ) v = min;
			if (v > (int32_t)max) v = max;
			if (v < (int32_t)min) v = min;
			prevv = v;
			encval = 0;
			refresh = 1;
		}
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		k = kyGetKeyChar();
		if (k != 'X') MenuTimer = 0;
	} while ( (k != 'E') && (k != '#') && (k != 'M') );
	if (k == 'M') *val = v; else (*pAdjust)(PreviousVal);  // else put it back !!
	// ksmRestoreMenuArea(1);
	TuningMode = 'N';  // Encoder 4 can tune trx again
}


void ksmAdjustDisplayBrightness(uint32_t v) // FUNCTION POINTER TARGET - must be < 128k
{
  scSetDisplayLEDPWM((uint8_t)v);
}


void ksmEditDisplayBright() __attribute__((section(".highmem")));
void ksmEditDisplayBright()
{
	if (Transmit == 1) return;
	uint32_t v = DDSparams.dpDisplayBright;
	strcpy(StrA, PMS(s_Set_bright_display));
	ksmEditNumber(&v, StrA, 0,255, 20, 'B', ksmAdjustDisplayBrightness);
	if (v != DDSparams.dpDisplayBright)
	{
		DDSparams.dpDisplayBright = v;
		scEEwriteDDSparams();
	}
	scSetDisplayLevel();

}


void ksmEditDisplayDimmed() __attribute__((section(".highmem")));
void ksmEditDisplayDimmed()
{

	if (Transmit == 1) {return;}
	uint32_t v = DDSparams.dpDisplayDimmed;
	strcpy(StrA, PMS(s_Set_dimmed_display));
	ksmEditNumber(&v, StrA, 0,255, 20, 'B', ksmAdjustDisplayBrightness);
	if (v != DDSparams.dpDisplayDimmed)
	{
		DDSparams.dpDisplayDimmed = v;
		scEEwriteDDSparams();
	}
	scSetDisplayLevel();

}


void ksmAdjustNothing(uint32_t v) // FUNCTION POINTER TARGET - must be < 128k
{
}


void ksmEditAutodimSeconds() __attribute__((section(".highmem")));
void ksmEditAutodimSeconds()
{
	if (Transmit == 1) {return;}
	int32_t v = DDSparams.dpAutoDimSeconds;
	strcpy(StrA, PMS(s_Set_auto_dim_seconds));
	ksmEditNumberDef(&v, StrA, 10, 255, 0, 20, 1, 'S', ksmAdjustNothing);
	if (v != DDSparams.dpAutoDimSeconds)
	{
		DDSparams.dpAutoDimSeconds = v;
		scEEwriteDDSparams();
		AutoDimmed = 0;
		AutoDimTimer = 254;
	}
}


void ksmEditMenuTimeout() __attribute__((section(".highmem")));
void ksmEditMenuTimeout()
{
	if (Transmit == 1) {return;}
	int32_t v = DDSparams.dpMenuTimeout;
	strcpy(StrA, PMS(s_Set_menu_timeout));
	ksmEditNumberDef(&v, StrA, 5, 60, 0, 20, 1, 'S', ksmAdjustNothing);
	if (v != DDSparams.dpMenuTimeout)
	{
		DDSparams.dpMenuTimeout = v;
		scEEwriteDDSparams();
		MenuTimer = 0;
	    if (DDSparams.dpMenuTimeout > 4) MenuFlag = 1; else MenuFlag = 0;
	}
}


void ksmEditMoxTimeout() __attribute__((section(".highmem")));
void ksmEditMoxTimeout()
{
	if (Transmit == 1) {return;}
	int32_t v = DDSparams.dpMoxTimeout;
	strcpy(StrA, PMS(s_Set_MOX_timeout));
	ksmEditNumberDef(&v, StrA, 5, 600, 0, 20, 1, 'S', ksmAdjustNothing);
	if (v != DDSparams.dpMoxTimeout)
	{
		DDSparams.dpMoxTimeout = v;
		scEEwriteDDSparams();
		MoxTimer = 0;
	}
}




void ksmAdjustDDSclock(uint32_t f) // FUNCTION POINTER TARGET - must be < 128k
{
  fDDSclock = f;
  ddsUpdateDDSclock(0); // 0  = dont save 
}



void ksmEditDDSclock() __attribute__((section(".highmem")));
void ksmEditDDSclock()
{

	if (Transmit==1){return;};
	uint32_t fDDSclockPrevious = fDDSclock;
	uint32_t fc = fDDSclock;
	strcpy(StrA, PMS(s_Set_DDS_clock_freq_));
  ksmEditNumber(&fc, StrA, 1000000,800000000, 1, 'D', ksmAdjustDDSclock);
  if (fDDSclockPrevious!=fc)
	{
      fDDSclock = fc;
			ddsUpdateDDSclock(1);   //   1  =  save it
	}	    
}


void ksmAdjustLSBoffset(uint32_t f) // FUNCTION POINTER TARGET - must be < 128k
{
  Freq = f;
  ddsSetFreq(); 
}


void ksmEditLSBoffset() __attribute__((section(".highmem")));
void ksmEditLSBoffset()
{
	if (Transmit==1){return;};
	Mode = 0;   // LSB
	scChangeMode();
	SigGenMode = 1;
	uint32_t OldFreq = Freq;
	uint32_t LSBoffsetPrevious = LSBoffset;
	uint32_t fof = LSBoffset;
	strcpy(StrA, PMS(s_Set_LSB_offset));
  ksmEditNumber(&fof, StrA, 1000000,800000000, 1, 'L', ksmAdjustLSBoffset);
  Freq = OldFreq;
	if (LSBoffsetPrevious!=fof)
	{
      LSBoffset = fof;
			ddsUpdateLSBoffset(1);   //   1  =  save it
	}	    
	SigGenMode = 0;
}




void ksmEditLocalTimeOffset() __attribute__((section(".highmem")));
void ksmEditLocalTimeOffset()
{
	if (Transmit == 1) {return;}
	int32_t v = 5*(int8_t)LocalTimeOffset;
	strcpy(StrA, PMS(se_Edit_local_time_offset));
	ksmEditNumberDef(&v, StrA, -120, +120, 0, 20, 5, 'F', ksmAdjustNothing);
	if (v != LocalTimeOffset)
	{
	  LocalTimeOffset = v/5;
		ie_eeprom_write_block(&LocalTimeOffset, &ee.EE_LocalTimeOffset, 1);
		rtcDoDateTime();
	}	    
}



void ksmAdjustUSBoffset(uint32_t f) // FUNCTION POINTER TARGET - must be < 128k
{
  Freq = f;
  ddsSetFreq(); // 0  = dont save 
}


void ksmEditUSBoffset() __attribute__((section(".highmem")));
void ksmEditUSBoffset()
{
	if (Transmit==1){return;};
	Mode = 1;   // USB
	scChangeMode();
	SigGenMode = 1;
	uint32_t OldFreq = Freq;
	uint32_t USBoffsetPrevious = USBoffset;
	uint32_t fof = USBoffset;
	strcpy(StrA, PMS(s_Set_USB_offset));
  ksmEditNumber(&fof, StrA, 1000000,800000000, 1, 'U', ksmAdjustUSBoffset);
  Freq = OldFreq;
	if (USBoffsetPrevious!=fof)
	{
    USBoffset = fof;
		ddsUpdateUSBoffset(1);   //   1  =  save it
	}	    
  SigGenMode = 0;
}

void ksmWriteEditNumberDirections(char wot) __attribute__((section(".highmem")));
void ksmWriteEditNumberDirections(char wot)
{
	switch(wot)
	{
		case 'L':
		case 'U': ksdF8WriteString(PMS(s_Sig__gen__mode_used_),10,ksmTop+26,0); break;
		case 'D': ksdF8WriteString(PMS(s_Sig__gen__mode_not_used_),10,ksmTop+26,0); break;	
		case 'F': ksdF8WriteString(PMS(s_Units___hours_x_10),10,ksmTop+26,0); break;	  
	}
}

//////////////////////////////////////////////////////////////////////////////////
//////////////////  Stacks and slots ////////////////////

char* ksmSlotMenuString(uint8_t Index)  // FUNCTION POINTER TARGET - must be < 128k
{
	strcpy_P(pmStrBuf,(PGM_P)&kpmdSlotMenuList[Index]);
	return &pmStrBuf[0];
} 


void ksmSlotMenu() __attribute__((section(".highmem")));
void ksmSlotMenu()
{
	int m = 0;
	int encCount7;
	char kc;
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t noofslots = 3;
	uint8_t refresh = 1;
	uint8_t restart = 1;

	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2)) break;   //  exit all menus on TR switched
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			ksmDeleteMenuBox(1);
			ksmDrawMenuFrame();
			ksmScrollItemCount = noofslots;
			ScrollY = ksmTop + 9;
			ksmInitMenu();
			ksdF8WriteString(PMS(s_Stacks_and_slots), 3, ksmTop,0);
			pGetItemString = ksmSlotMenuString;
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1)
		{
			ksmDrawList(m);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			m += encCount7;
			if(m<0){m=(m%noofslots)?(m%noofslots)+noofslots:0;}
			if(m>=noofslots){m=m%noofslots;}
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc = kyGetKeyChar();
		if (kc != 'X') MenuTimer = 0;
		if (kc == 'S')   /// S is stacks key
		{
			ksmClearMenuBox();
			kc = ksmSlotListMenu(m);  //  0 = mem,  1 = vfo,   2 = band
			ksmDeleteMenuBox(1);
			refresh = 1;
			restart = 1;
		}
	} while ((kc != 'E') && (kc != '#'));  // 'E' is ESC key
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	ksmRestoreMenuArea(1);
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
}


char* ksmSlotInfo(char slotkind) __attribute__((section(".highmem")));
char* ksmSlotInfo(char slotkind)
{
	uint8_t e,i;
	ltoa(RamSlot.stFreq,StrB,10);
	if(strlen(StrB)<8){e=0;}else{e=1;}
	for(i=0;i<=2;i++)
	{
	  StrB[9-i] = StrB[6-i+e];
	}
	StrB[6] = '.';
	for(i=3;i<=5;i++)
	{
	  StrB[8-i] = StrB[6-i+e];
	}
	StrB[2] = '.';
	if(e==0)
	{
		StrB[1]= StrB[0];
		StrB[0] = ' ';
	};
	StrB[10]=' ';
	StrB[11]=0;
	if(e==0)
	{
		for(i=0;i<=11;i++){StrB[12-i]=StrB[11-i];};
		StrB[0]=' ';   // leading zero
	}
	switch(RamSlot.stMode)
	{
		case 0: StrC[0] = 'L'; break;
		case 1: StrC[0] = 'U'; break;
		case 2:
		case 3: StrC[0] = 'C'; break;
	}
	StrC[1] = ' ';

	if(RamSlot.stIP3==1){StrC[2]='I';}else{StrC[2]='N';};
	switch(RamSlot.stParamColour)
	{
		case 1: StrC[3]='G'; break;
		case 2: StrC[3]='Y'; break;
		case 3: StrC[3]='R'; break;
	}
	if(RamSlot.stFilterNarrow==1)
	{
		if(RamSlot.stMode < 2){StrC[3]='N';} else {StrC[3]='D';};
	}
	else
	{
		if(RamSlot.stMode < 2){StrC[4]='W';} else {StrC[4]='C';};
	};
	StrC[5] = 0;
	strcat(StrB,StrC);
	return StrB;
}



char* ksmMemSlotMenuString(uint8_t i) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t stack;
	uint8_t slot;
	if(i<24)
	{
		stack = i/6;
		slot =  i%6;
		ddsLoadMemSlotToRamSlot(stack,slot);		
		stack += 7;
		if(stack==10){stack=0;};
		strcpy(StrA,PMS(s_6x_6x_));
		StrA[1] = 0x30+stack;
		StrA[4] = 0x31+slot;
		strcat(StrA,ksmSlotInfo('M'));
	}	
	return StrA;			  
}



char* ksmVfoSlotMenuString(uint8_t i) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t n = i;
	if(n==0)
	{
		ddsLoadStickyVfoSlotToRamSlot(0);
		strcpy(StrA,PMS(s_Pwron_));
		strcat(StrA,ksmSlotInfo('V'));
	}
	if((n>=1)&&(n<=7))
	{
		ddsLoadStickyVfoSlotToRamSlot(n);
		strcpy(StrA,PMS(s_Stky__));
		StrA[4] = 0x30+n;
		strcat(StrA,ksmSlotInfo('V'));
	}
	if((i>=8)&&(i<=30))
	{
		n -=8;
		if(n<VolatileCount)
		{
			ddsLoadVolatileVfoSlotToRamSlot(n);
		}
		n += 1;  //  slots 0-22 shown as 1-23
		strcpy(StrA,PMS(s_Vol___));
		StrA[3] = 0x30 + n/10;
		StrA[4] = 0x30 + n%10;
		if(n<VolatileCount)
		{
			strcat(StrA,ksmSlotInfo('V'));		
		}
		else
		{
			strcat(StrA,PMS(s_Slot_not_defined));
		}
	}
	return StrA;
}



char* ksmBandSlotMenuString(uint8_t i) // FUNCTION POINTER TARGET - must be < 128k
{
	uint8_t band, t;
	char LSC = 'X';
	band = i%10;
	t = i/10;
	switch(t)
	{
	  case 0: LSC = 'L'; break;
		case 1: LSC = 'S'; break;
		case 2: LSC = 'C'; break;
	}
	StrB[0] = LSC;
	StrB[1] = ' ';
	StrB[2] = 0;
	ddsLoadBandSlotToRamSlot(LSC,band);
	strcpy(StrA,pmBandName(band));
	strcat(StrA,StrB);
	if(band==2)
	{strcat(StrA,PMS(s_10_hyphens));}
	else
	{strcat(StrA,ksmSlotInfo('B'));};		
	return StrA;
}



void ksmGotoSlot(uint8_t slotkind, uint8_t m) __attribute__((section(".highmem")));
void ksmGotoSlot(uint8_t slotkind, uint8_t m)
{
	switch(slotkind)
	{
		case 0:
		{
			MemStackNo = m/6;
			MemSlotNo =  m%6;
			ddsLoadMemSlot(VFO,MemStackNo, MemSlotNo);	
			ddsApplyVfo(VFO);
			UpdateDDS = 1;
			Encoder4count = 0;		
			zscShowMemStackSlotNo();
			break;
		}
		case 1:
		{
			// no volatile access here
			break;
		}
		case 2:
		{
			uint8_t b = m%10;   // band
			uint8_t t = m/10;
			char LSC = 'L';  // dummy value
			switch(t)
			{
	  		case 0: LSC = 'L'; break;
				case 1: LSC = 'S'; break;
				case 2: LSC = 'C'; break;
			}
			ddsLoadBandSlot(VFO,LSC,b); 
			ddsApplyVfo(VFO);
		  UpdateDDS = 1;
//			ddsSaveBandSlot(VFO,'L',Band);
			break;
		}
	}
}



char ksmSlotListMenu(uint8_t slotkind) __attribute__((section(".highmem")));
char ksmSlotListMenu(uint8_t slotkind)
{
	int m = 0;
	int encCount7;
	char kc;
	uint8_t refresh = 1;
	uint8_t restart = 1;

	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2))
		{
			Encoder4count = 0;
			return 'E';   //  exit all menus on TR switched
		}
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (restart == 1)
		{
			ksmClearMenuBox();
			ScrollY = ksmTop;
			switch(slotkind)
			{
				case 0: pGetItemString = ksmMemSlotMenuString; ksmScrollItemCount = 24; break;
				case 1: pGetItemString = ksmVfoSlotMenuString; ksmScrollItemCount = 31; break;
				case 2: pGetItemString = ksmBandSlotMenuString; ksmScrollItemCount = 30; break;
			}
			ksmInitMenu();
			enGetEncoder7delta();
			restart = 0;
		}
		if (refresh == 1)
		{
			ksmDrawList(m);
			refresh = 0;
		}
		encCount7 = enGetEncoder7delta();
		if (encCount7 != 0)
		{
			MenuTimer = 0;
			m += encCount7;
			if(m<0){m=(m%ksmScrollItemCount)?(m%ksmScrollItemCount)+ksmScrollItemCount:0;}
			if(m>=ksmScrollItemCount){m=m%ksmScrollItemCount;}
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if(kc!='E'){kc=scDoMenuKeyPad();} 
		if (kc != 'X') MenuTimer = 0;
		if(kc=='S')   /// S is stacks key
		{
			if(m!=1)  // no VFO slot access
			{
				ksmGotoSlot(slotkind,m);
				return 'E';  // cause exit from  parent menu
			}
			kc = 'X';
		}
	} while((kc!='E')&&(kc!='#'));  // 'E' is ESC key
	ksmDeleteMenuBox(1);
	Encoder4count = 0;
	return 'X';
}


void ksmLastEncoderAssign() __attribute__((section(".highmem")));
void ksmLastEncoderAssign()
{
	int de;
	int encCount7;
	char kc;
	uint8_t n;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t refresh = 1;
	//uint8_t starno = 0;
	uint8_t userno = 0;
	
	if (DDSparams.dpMenuTimeout > 4) {
		MenuTimer = 0;
		MenuFlag = 1;
	}
	DisplayingMenu = 1;
	pGetItemString = ksmEncoderParamString;
	ksmScrollItemCount = 48;
	ksmDeleteMenuBox(1);
	ksmDrawMenuFrame();
	ScrollY = ksmTop + 9;
	ksmInitMenu();
	strcpy(StrA, PMS(s_Encoder___set_param));
	StrA[8] = LastEncoderSetting + 0x31;
	ksdF8WriteString(StrA, 7, ksmTop,0);
	userno = EncodersPotsParams[LastEncoderSetting];
	enGetEncoder7delta();
	do
	{
		scReadTR();
		if ((Transmit != PreviousTransmitD) || (MenuFlag == 2))
		{
			DisplayingMenu = 0;
			MenuFlag = 0;
			MenuTimer = 0;
			MenuExit = 1;
			ksmRestoreMenuArea(1);
			Encoder4count = 0;
			do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
			return;   //  exit all meus on TR switched
		}
		if (DoMeterCode) scMeterLoopCode();
		usbCheckPC();
		ctDoCat();
		scCheckFlags();
		if (refresh == 1)
		{
			//starno = dspUserToStar(userno);
			ksmDrawList(pmUsernoToSeq(userno));
			refresh = 0;
		}
		de = 0;
		do
		{
			n = uaCheckEncoders8(&nenc, &delta, &updown, 0);
			if ( (n == 0) && (nenc == LastEncoderSetting) ) {
				if (!zg) {
					if (updown == 1) {
						if (HardwareSettings.hsMenuEncoder == 0) de += delta; else de -= delta;
					} else {
						if (HardwareSettings.hsMenuEncoder == 0) de -= delta; else de += delta;
					}
				} else {
					if (updown == 1) {
						if (HardwareSettings.hsMenuEncoder == 0) de -= delta; else de += delta;
					} else {
						if (HardwareSettings.hsMenuEncoder == 0) de += delta; else de -= delta;
					}
				}
			}
		} while ( (n == 0) || (n == 3) );
		if ( (de == 0) && ((encCount7 = enGetEncoder7delta()) != 0) ) de = encCount7;
		if (de != 0)
		{
			MenuTimer = 0;
			userno = pmUserNoListShift(userno, de, 1);   // 1 = Allow unassigned
			//if (userno == 0) starno = 0;
			//else starno = dspUserToStar(userno);
			refresh = 1;
			if (WakeupDisplay) scWakeupDisplay();
		}
		kc = tpGetTouchChar();
		if (kc != 'E') kc=scDoMenuKeyPad();
	} while (kc == 'X');
	MenuTimer = 0;
	if (kc == 'M')
	{
		EncodersPotsParams[LastEncoderSetting] = userno;
		scEEwriteEncodersPotsParams();
		enSetEncodersMaxMin(); 
	}
	kc = 'X';
	DisplayingMenu = 0;
	MenuFlag = 0;
	MenuTimer = 0;
	MenuExit = 1;
	ksmRestoreMenuArea(1);
	Encoder4count = 0;
	do {n = uaCheckEncoders8(&nenc, &delta, &updown, 0);} while ( (n == 0) || (n == 3) );
	return;
}
