/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taIntEeeprom.c    program file

 WINAVR Provides eeprom routine
This modules divides 4k eeprom into 4 1k blocks
- in cae it get worn out!!

*/


#include "taGlobal.h"


static uint16_t EememStart;

void ieInit()
{
  uint8_t e = HardwareSettings.hsInternalEepromStart;
	if(e>3){e=0;};
	switch(e)
	{
	  case 0: EememStart = 0x0000; break;
	  case 1: EememStart = 0x0400; break;
	  case 2: EememStart = 0x0800; break;
	  case 3: EememStart = 0x0C00; break;
  }
}


void ie_eeprom_read_block(void *pointer_ram, const void *pointer_eeprom, size_t n)
{
  pointer_eeprom += EememStart;
	eeprom_read_block(pointer_ram,pointer_eeprom,n);
}



void ie_eeprom_write_block(const void *pointer_ram, void *pointer_eeprom, size_t n)
{
  pointer_eeprom += EememStart;
	eeprom_write_block(pointer_ram,pointer_eeprom,n);
}
