/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taGraphicsControl.c    program file
 

  Access display via taGraphics.c to 
*/

#include "taGlobal.h"
#include "taGraphicsDriverEA320.h"
#include "taGraphicsEA320.h"
#include "taGraphicsControl.h"
#include "taButtons.h"
#include "taDDS.h"


void gcGraphicsDisplayInit()
{
	if (zg)
	{
		gedInitEA320Graphics();
    }
}


void gcGraphicsDisplayRestore()
{
	if (zg)
	{
		gedSwitchLayer(1);
		gedCls(0);
		geDrawFrames();
		if (HaveBB || HaveTP)
		{
			geDrawButtonFramesLtoR();
		}
    }
	gedInitFrequencyDisplay();
}


void gcGraphicsDisplayStart()
{
	if (zg)
	{
		gedSwitchLayer(1);
		gedCls(0);
	   	geDrawFrames();
		geButtonLabelsZtoSRx(0,0);
		geButtonLabelsZtoSTx(0,0);
		if (HaveBB || HaveTP)
		{
			geDrawButtonFramesLtoR();
			geButtonLabelsLtoRRx(0,0);
			geButtonLabelsLtoRTx(0,0);
		}
	}
	gedInitFrequencyDisplay();
}
	
	      

void gcGraphicsRedrawLabels(uint8_t task, uint8_t Highlighted)
{
	geButtonLabelsZtoSRx(task,Highlighted);
	geButtonLabelsZtoSTx(task,Highlighted);
	if (HaveBB || HaveTP)
	{
		geButtonLabelsLtoRRx(task,Highlighted);
		geButtonLabelsLtoRTx(task,Highlighted);
	}
}
	



