/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taEncoder.c  Rotary encoder module program file


*/


#include "taGlobal.h"
#include "taEncoder.h"
#include "taStarDSP.h"
#include "taCharLCD.h"
#include "taUsart.h" 
#include "taStarControl.h"
#include "taButtons.h"
#include "taStarDSP.h"
#include "taSWR.h"
#include "taDDS.h"
#include "taStarDSP.h"
#include "taADC.h"
#include "taMenus.h"
#include "taDebug.h"
#include "taZ_StarControl.h"
#include "taZ_DDS.h"
#include "taGraphicsEA320.h"
#include "taGraphicsDriverEA320.h"
#include "taEATFTmenus.h"
#include "taEATFTcommands.h"
#include "taKS0108Menus.h"
#include "taKS0108.h"
#include "taKS0108Driver.h"
#include "taRTC.h"

#define pinQuad4 PINE      // an alias for PINE
#define Quad4  3   // bit 3  -  a constant set equal to 3 

#define pinQuad7 PINE      // an alias for PINE
#define Quad7  6   // bit 6 - a constant set equal to 6 
#define Phase7 7   // bit 7 of PORTE ... is also INT7 input

//define four constants
#define INT4sense 3   // Rising edge  - using to set INT4 bits in EICRB
#define INT7sense 2   // Falling edge  - using to set INT7 bits in EICRB
#define INT4enabled 1 //  - this constant is used to set INT4 mask to 1
#define INT7enabled 1 //  - this constant is used to clear INT7 mask to 0

#define Arial20 11
#define Arial18 12
#define Arial16 13
#define ArialBold18 9
#define ArialBold16 10

uint8_t DisplayEnc;
uint16_t TuningTimer; // stepping and XIT Tx tune persistence
int Encoder4count;  // global
int Encoder7count;  // global
char TuningMode;   //  'N' = normal  'V'= VFO stack  'R' = rate
uint8_t PotsFlag;
uint8_t Param81PotVal;
uint8_t Flywheeling;
char LatestTuningDir;  // used by flywheel
char TuningDir;
int RateTuningIndex;
uint8_t SweepDir;   // 0 = no sweep, 'D' = down, 'U' = up
uint8_t KillRateTuning;
uint8_t EncodersPotsParams[12];  // user nos
uint8_t EncodersPotsParamMax[12];   // param max values
uint8_t EncodersPotsParamMin[12];   // param max values
uint8_t BlockEncoderTuning;
uint8_t LockTuning;
uint8_t TxXITtune;
uint8_t DisplayEncTimer;

static uint8_t TestNenc;
static uint8_t TestUpDown;
static uint8_t TestDelta;
static uint8_t EncoderParamNameLength;
static uint8_t quad;
static uint8_t EncStartCount;
static int step;


// ISR for rotary encoder interrupt on INT4 
// - high resolution tuning encoder
// Encoder has phase and quadrature logic outputs
// phase signal interrupts on rising edge of INT4 (PE4)
// ISR reads quad signal on PORTE bit 3
// If quad is low - decrement Encoder4count
// If quad is high - increment Encoder4count
   
ISR(INT4_vect)
{
	char ud;

	quad = (pinQuad4 & (1 << Quad4));
	if (HardwareSettings.hsTuningEncoder == 0) quad ^= (1 << Quad4);
	WakeupDisplay = 2;
	ShiftTimer = 0;
	step = 1;
	if (quad != 0) ud = 'D'; else ud = 'U';
	if (ud != LatestTuningDir) {
		Flywheeling = 0;
		KillRateTuning = 1;       // immediate stop
	}
	if (TuningMode == 'N') {
		if (TuningTimer < MiscParams.TuningThreshold1) {
			if (TuningTimer == MiscParams.TuningThreshold2) {
				step = 10; 
				if (TxXITtune == 0) Flywheeling = 1;
				else Flywheeling = 0;
			} else step = 5;
		}
	}
	if (ud == 'D') {
		step = -step; 
		LatestTuningDir = 'D';
	} else {  // Flywheel uses latest tuning step
		LatestTuningDir='U';  //down
	}
	Encoder4count += step; 
	TuningTimer = 0;
	_delay_us(10);
	if (DisplayingMenu == 0) {
		if (TxXITtune == 1) {
//			if ( (TxFreq > 10000) || (step > 0) ) TxFreq += 10 * step;  // avoid freq < 10000
			TxFreq += 10 * step;
			if (TxFreq > 99999990) TxFreq = 99999990;
			else if (TxFreq < 10000) TxFreq = 10000;
			VfoSlot[1].stFreq = TxFreq;  // IJS 11.10.2009
			if (ddsSetFreq() == 0) {     // IJS 11.10.2009
		    	UpdateDDS = 1; // if locked out then set this flag to update in main loop
    		}
			NeedShowFreq = 0;
		} else {
			if ( (TuningMode == 'N') && (BlockEncoderTuning == 0) && 
				(LockTuning == 0 || ( (RIT == 1 || XIT == 1) && Split == 1) ) ) { // freq only changed by ISR in 'N'(normal mode)
//				if ( (Freq > 10000) || (step > 0) ) Freq += 10 * step;  // avoid freq < 10000
				Freq += 10 * step;
				if (Freq > 99999990) Freq = 10000;
				else if (Freq < 10000) Freq = 99999990;
				NeedShowFreq = 1;
				if (MemSlotNo != 255) ClearSlotno = 1;  // it last freq was from selecting a slot, we are now tuning away from it
				if (ddsSetFreq() == 0) { // will set UpdateDDS = 0 if successful
		    		UpdateDDS = 1; // if locked out then set this flag to update in main loop
    			}
			}
		}
	}
	return;
}


// ISR for rotary encoder interrupt on INT7 
// - low resolustion menu selection (click stops)
// Encoder has phase and quadrature switch to ground outputs
// phase signal interrupts on falling edge of INT7 
// ISR reads quad signal on PORTE bit 6
// If quad is low - increment Encoder7count
// If quad is high - decrement Encoder7count
   
ISR(INT7_vect)
{
	enINTenable(7,0);
	int q = pinQuad7 & (1 << Quad7);
	_delay_ms(3);  // debounce
	WakeupDisplay = 1;
	ShiftTimer = 0;
	if (!zg && !zt)
	{
		if (q == 0) {
			if (HardwareSettings.hsMenuEncoder == 0) Encoder7count -= 1;
			else Encoder7count += 1;
		} else {
			if (HardwareSettings.hsMenuEncoder == 0) Encoder7count += 1;
			else Encoder7count -= 1;
		}
	}
	else
	{
		if (q == 0) {
			if (HardwareSettings.hsMenuEncoder == 0) Encoder7count += 1;
			else Encoder7count -= 1;
		} else {
			if (HardwareSettings.hsMenuEncoder == 0) Encoder7count -= 1;
			else Encoder7count += 1;
		}
	}
	enINTenable(7, 1);	
	return;
}

// Read encoder 4 count - called from elsewhere 
// - clear the count and then return delta count since last call
int enGetEncoder4delta()
{
  int c = Encoder4count;
	Encoder4count = 0;
	return c;
}


// Read encoder7 count - called from elsewhere 
// - clear the count and then return delta count since last call
int enGetEncoder7delta()
{
  int c = Encoder7count;
	Encoder7count = 0;
	return c;
}


// INTn enable (tf=1) or disable (tf=0)
void enINTenable(unsigned char n, unsigned char tf)
{
	if (tf == 0) {
	EIMSK &= ~(1 << n); // clear bit n (for INTn) in EIMSK register to disable interupt
	} else {
	EIFR |= (1 << n);  // set bit n (for INTn) in EIFR register to clear flag
	EIMSK |= (1 << n);  // set bit n (for INTn) in EIMSK register to enable interupt
	}
	return;
}


void enEncodersInit()
{
	EncStartCount = 4;  // four intial reads with no prolonged display  
	                 // - makes sure pot values stored
	Flywheeling = 0;
	BlockEncoderTuning = 0;
	LockTuning = 0;
	WakeupDisplay = 0;
	Encoder4count = 0;  //reset counters	
	Encoder7count = 0;
  DisplayEnc = 255;
	DisplayEncTimer = 0;
  EICRB &= 0x36;    // clear INT4 and INT7 sense bits
	unsigned char s4 = INT4sense;  
	unsigned char s7 = INT7sense;
	EICRB |= ((s7 << 6) | s4);  // set INT4 and INT7 sense bits
  int en; 
  en = INT4enabled;
	enINTenable(4,en);  // enabled or disabled according to value of INTnenabled
	en = INT7enabled;
	enINTenable(7,en);
}


void enSetEncodersMaxMin()
{
	uint8_t nenc;
	uint8_t userno;
	uint8_t starno;
	
	for (nenc = 0; nenc <= 9; nenc++)
	{
		userno = EncodersPotsParams[nenc];
		starno = dspUserToStar(userno);        // will change on mode change
		EncodersPotsParamMax[nenc] = dspGetMax(starno);
		if (starno == 81) EncodersPotsParamMax[nenc]=100;  // bug temporary fix
		EncodersPotsParamMin[nenc] = dspGetMin(starno);
	}
}


uint8_t enDoEncodersPots()
{
	int val;
	int change;
	uint8_t nenc;
	uint8_t delta;
	uint8_t updown;
	uint8_t NewSession;
	uint8_t min;
	uint8_t max;
	uint8_t userno;
	uint8_t starno;
	uint8_t RestoreFilterGraphic;
	uint8_t denc;

	NewSession = 0;
	denc = EncodersPotsParams[DisplayEnc];
	if (DisplayEnc != 255) ShiftTimer = 0;
	if (EncStartCount > 0) {
		EncStartCount -= 1;
		DisplayEncTimer = 0;
	}
	if ((Transmit == 1) && ((denc == 81) || (denc == 82))) swDisplaySWR();
	if ((DisplayEnc != 255) && (DisplayEncTimer == 0)) {
		DisplayEnc = 255;
		zscRestoreLeftDisplay();   // zc conditional
		RestoreFilterGraphic = 0;
		if (zt) {
			emeDeleteInfo();
			emeDrawDateTime();   //    IJS 3.1.2011
			if (DisplaySwitch == 2) dspStartDSPdisplayEATFT();
			else zscShowDSPKeys();
			RestoreFilterGraphic = 1;
		}
		if (zs) { 
			ksMsgShowing = 0;
			ksmRestoreMenuArea(0);
		}
		if (zg) {
			if (DisplaySwitch == 2) geStartDSPdisplay();
			else {
				zscDeleteMsgFrame(1);
				RestoreFilterGraphic = 1;
				zscShowDSPKeys();
			}
		}
		if (RestoreFilterGraphic) zscShowFilter();
	}
	if (uaCheckEncoders8(&nenc, &delta, &updown,0) != 0) {
		if (adCheckPots(&nenc, &delta, &updown) != 0) return 0;
	} else {
		if (ShiftTimer) {
			HaltDSPdisplay = 1;
			ShiftTimer = 0;
			LastEncoderSetting = nenc;
			if (zt) emeLastEncoderAssign();
			else if (zg) meLastEncoderAssign();
			else if (zs) ksmLastEncoderAssign();
			else meLastEncoderAssign();
			ksMsgShowing = 0;
			return 0;
		}
	}
	userno = EncodersPotsParams[nenc];
	if ((userno <= 10) || (userno >= 99)) return 0;
	SweepDir = 0;
	Guarding = 0;
	TuningMode = 'N';
	HowToShowFreq = 'V';
	zddsShowBothVfoFreqs();	// restore normal A/B frequency display
	if(((!zg) || (RTCpos<3)) && (!zs)) zscClearTuneBox();
	if(XRIT() == 0) {
		zscClearScanInfoDisplay();  // this is char display only
		if((!zg) || (RTCpos<3)) zscClearRITXITBox();
	}
	buRedrawLabel(39, 0);
	scWakeupDisplay();
	starno = dspUserToStar(userno);
	DisplayEncTimer = 3;             //  encoder display timer
	if (DisplayEnc == 255) NewSession=1;
	if ((nenc != DisplayEnc) && (EncStartCount == 0)) {
		HaltDSPdisplay = 1;
		DisplayEnc = nenc;
		if (zc) {
			cdSetPos(2, 0);
	  		cdDisplayString(pmdSpaces(20));
			cdSetPos(2, 0);
			EncoderParamNameLength = cdDisplayString(pmParamNameShortNL(starno)); 						 
		}
		if ((zt) || (zg) || (zs)) {			
			uint8_t i = nenc + 1;
			if (zg) zscClearDSPKeys(1);
			if (nenc >= 8) {
	  			i -= 8;
				strcpy(StrA, PMS(s_Potentiometer__));
				StrA[14] = 0x40 + i;
			} else {
				strcpy(StrA, PMS(s_Encoder__));
				StrA[8] = 0x30 + i;
			}
			ltoa(userno, StrB, 10);
			uint8_t d = userno % 10;
			uint8_t n = userno / 10;
			StrB[0] = n + 0x30;
			StrB[1] = '.';
			StrB[2] = d + 0x30;
			StrB[3] = 0x20;  // space
			StrB[4] = 0;
			if (zs) strcat(StrB, pmParamNameShortNL(starno));
			else strcat(StrB, pmParamNameNL(starno));
			if (zt) {
				emeClearInfo();
				if (NewSession == 1) emeInfoFrame();
				etcFont(Arial18);
				etcTextColour(6, 1);
				emeInfoString(7, 8, 'L', StrA);
				etcTextColour(4, 1);
				emeInfoString(7, 34, 'L', StrB);
			}
			if (zg) {
				zscClearMsgFrame();  // graphics only
				if (NewSession == 1) zscDrawMsgFrame();
				gedF16WriteString(StrA, MsgX+5, MsgY1);
				gedF16WriteString(StrB, MsgX+5, MsgY2);
			}	
			if (zs) {
				if((starno==81)&&(Transmit==1)) {
					strcpy(StrA,PMS(s_TxDrv___));
					ksdF8WriteString(StrA,0,47,0);
				} else {
					ksMsgShowing = 1;
					ksmMsgBox();
					ksmMsgLine(StrA,1);
					ksmMsgLine(StrB,2);
				}
			}
			NewSession = 0;
		}
		if (nenc < 8) delta = 0;	// first click activates display but no change
	}								// but not for pots 
	TestNenc = nenc;
	TestUpDown = updown;
	TestDelta = delta;
	if (updown == 1) change = delta; else change = -delta;
	val = dspGetParamValue(starno);
	max = EncodersPotsParamMax[nenc];
	min = EncodersPotsParamMin[nenc];
	val += change;
	if (val > max) val = max;
	if (val < min) val = min;
	if (starno == 81) dspStoreTxDrive(val); else dspSetParam(starno,val);
	if (starno == 21) Muted = 0;
	if (EncStartCount == 0) {
		if (zc) {
			cdSetPos(2, EncoderParamNameLength+1);
			cdDisplayString(dspParamValString(starno, 1));
		}
		if ((zt) || (zg) || (zs)) {
			strcpy(StrA, dspParamValString(starno, 1));
			strcat(StrA, pmdSpaces(1));
			strcat(StrA, pmUnitsFromListIndex(pmParamNameIndexNL(starno)));
			if (zt) {
				etcFont(Arial18);
				etcTextColour(7, 1);
				emeClearInfoRect(24, 56, 80, 76);
				emeInfoString(24, 56, 'L', StrA);
			}
			if (zs) {
				if ((starno == 81) && (Transmit == 1)) {
					strcat(StrA,pmdSpaces(1));
					ksdF8WriteString(StrA,36,47,0);
				} else ksmMsgLine(StrA,3);
			}
			if (zg) {
				Brush.Color = 0;
				gedFillRect(MsgX+20, MsgY3, MsgX+MsgWidth-24, MsgY3+16);
				gedF16WriteString(StrA, MsgX+20, MsgY3);
			}
		}
	}
	if ((starno >= 61) && (starno <= 66)) zscShowFilter();
	switch (starno) {
		case 11:
		case 32:
		case 51:
		case 43:
		case 91:
		case 93: zscShowSwitches();
	}
	return 1;
	ksMsgShowing = 0;
}
