/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taEEPROM.c    program file
 
Holds all the EEPROM data definitions for TrxAVR.
Do not change the order or else the physical allocations will affected.

*/

#include "taGlobal.h"
#include "taEEPROM.h"

struct ee_type EEMEM ee = {
	174998221,								// uint32_t EE_fDDSclock;	// DDS clock in Hz
	9012850,								// uint32_t EE_USBoffset;	// USB Offset
	9010150,								// uint32_t EE_LSBoffset;	// LSB Offset
	
	{{{0}}},								// struct Slot_type EE_BandStack[3][10];
											//		EEPROM Sticky slots x 30   (60m slots unused)
	
	{{{0}}},								// struct Slot_type EE_MemStack[4][6];
											//		EEPROM Sticky slots x 24
	
	{{0}},									// struct Slot_type EE_VfoStickyStack[8];
											//		EEPROM Sticky slots  0 = PowerOn,   1-7 = VFO slots 1-7
	
	{0},												// uint8_t EE_CalCurve[42];
	{22, 99, 99, 99, 99, 99, 99, 99, 21, 22, 99, 99},	// uint8_t EE_EncodersPotsParams[12];
	{0},												// uint8_t EE_RxButtonAssignments[32];
	{0},												// uint8_t EE_TxButtonAssignments[32];
	{2, 0, 0, 0, 160, 80, 30, 0, 1, 0, 0, 0},			// uint8_t EE_DDSparamBlock[12];
	{0},												// struct TouchCal_type EE_TouchCal;
	{0},												// uint8_t EE_RxTouchpadAssignments[32];
	{0},												// uint8_t EE_TxTouchpadAssignments[32];
	
	{0},												// uint8_t EE_I2C_ButtonOpcode[8];
	{0},												// uint8_t EE_I2C_ButtonGroup[8];
	{0},												// uint8_t EE_I2C_ButtonAddress[8];
	{0},												// uint16_t EE_I2C_ButtonDataword[8];
	{{0}},				 								// uint8_t EE_I2C_ButtonLabels[8][12];
	0,													// uint8_t EE_I2C_BpfKind;
	0,													// uint8_t EE_I2C_BpfAddress;
	0,													// uint8_t EE_PA3AKE_RooferAddress;
	0,													// uint8_t EE_PA3AKE_SquarerAddress;
	0,													// uint8_t EE_PA3AKE_MixerAddress;
	0,													// uint8_t EE_PA3AKE_MixerEnable;
	0,													// uint8_t EE_PA3AKE_RooferSwitchEnable;
	0,													// uint16_t EE_PA3AKE_MixerDAC;
	0,													// uint16_t EE_PA3AKE_SquarerDAC;
	0,													// uint8_t EE_EnablePCA9555;
	{0},												// uint8_t EE_I2C_Spare[11];
	0,													// uint8_t EE_LocalTimeOffset
	9011500,											// uint32_t EE_CWoffset;	// optional separate CWU/CWL offset in Hz
	0,													// uint8_t EE_CWoffsetEnable;
	{0, 0, 2, 0, 0, 0, 0, 0},							// uint8_t EE_TuningParamBlock[8];
};

	

