/*
 *****    homebrew-radios.net   *****

 *****     Project TrxAVR       *****


 taConfig.c    program file
 
Configuration settings, params etc 
 

*/


#include "taGlobal.h"
#include "taConfig.h"
#include "taDDS.h"
#include "taFT245R.h"
#include "taStarControl.h"
#include "taZ_StarControl.h"
#include "taZ_DDS.h"
#include "taGraphicsEA320.h"
#include "taStarDSP.h"
#include "taSmeter.h"
#include "taSWR.h"
#include "ta24LC512.h"
#include "taIntEeprom.h"
#include "taKeys.h"
#include "taCharLCD.h"
#include "taGraphicsDriverEA320.h"
#include "taButtons.h"
#include "taEncoder.h"
#include "taGraphicsControl.h"
#include "taEA320TouchPanel.h"
#include "TrxAVR.h"
#include "taEATFT.h"
#include "taKS0108Driver.h"
#include "taEEPROM.h"
#include "taRTC.h"
#include "taTWI.h"
#include "taEATFTcommands.h"

uint32_t fdw;  //  temp for diagnostics

void cfBlockTo32(uint32_t* v,uint8_t* p);
void cf32ToBlock(uint32_t* v,uint8_t* p);
void cfConfirmReady();


void cfConfigInit()
{
//  fDDSclock = 174998221;
//	USBoffset = 9012850;
//	LSBoffset = 9010150;
	return;
}


void cfSetDisplayControls()
{
	zc = 0;            // zc == 1 - means write to char lcd
	zs = 0;            // zs == 1 - means write to 128x64 graphics display
	zg = 0;            // zg == 1 - means write to 320x240 graphics display
	zt = 0;            // zt == 1 - means write to colour TFT display on I2C bus
	TwentyByFour = 0;  // 0 = 40x2    1 = 20x4    For char LCD
	EA320_6800 = 0;    // 0 = 8080    1 = 6800    For 320x240 display
	DualDisplay = 0;   // 0 = no multiple display    1 = multiple display
	HaveTP = 0;        // 1 = 320x240 touch panel installed
	HaveRB = 0;        // 1 = 320x240 8 right side buttons installed
	HaveBB = 0;        // 1 = 320x240 7 bottom buttons installed
	DoMeterCode = 0;   // 1 = display supports scMeterLoopCode()
	ksCSLOW = 0;       // 1 = CS active low for 128x64 display

	switch (TftaI2Caddress)
	{
	  case 0x00:
		case 0xFF: TFTA_I2C_ADDRESS = 0x6F; break;
		default:  TFTA_I2C_ADDRESS = TftaI2Caddress;
  }

	switch (HardwareSettings.hsDisplay)
	{
		case 0: zc = 1; break;
		case 1: zc = 1; TwentyByFour = 1; break;
		case 2: zg = 1; break;
		case 3: zg = 1; EA320_6800 = 1; break;
		case 4: zt = 1; break;
		case 5: zs = 1; break;
		case 6: zs = 1; ksCSLOW = 1; break;
	}

	switch (HardwareSettings.hsDualDisplay)
	{
		case 0: break;
		case 1: DualDisplay = 1; zc = 1; break;
		case 2: DualDisplay = 1; zc = 1; TwentyByFour = 1; break;
		case 3: DualDisplay = 1; zt = 1; break;
		case 4: DualDisplay = 1; zc = 1; zt = 1; break;
		case 5: DualDisplay = 1; zc = 1; TwentyByFour = 1; zt = 1; break;
	}

	if (zg) {
		switch (HardwareSettings.hsTouchPanel)
		{
			case 0: break;
			case 1: HaveRB = 1; break;
			case 2: HaveBB = 1; break;
			case 3: HaveRB = 1; HaveBB = 1; break;
			case 4: HaveTP = 1; break;
		}
	}

	if (zt || zg) DoMeterCode = 1;

	switch (HardwareSettings.hsKeyMatrix)
	{
		case 0:  xmax = 5; ymax = 5; break;
		case 1:  xmax = 5; ymax = 6; break;
		case 2:  xmax = 5; ymax = 7; break;
		case 3:  xmax = 6; ymax = 5; break;
		case 4:  xmax = 6; ymax = 6; break;
		case 5:  xmax = 6; ymax = 7; break;
		case 6:  xmax = 7; ymax = 5; break;
		case 7:  xmax = 7; ymax = 6; break;
		case 8:  xmax = 7; ymax = 7; break;
		case 9:  xmax = 8; ymax = 5; break;
		case 10: xmax = 8; ymax = 6; break;
		case 11: xmax = 8; ymax = 7; break;
		default: xmax = 5; ymax = 5; break;
	}

}


void cfBlockTo32(uint32_t* v,uint8_t* p)
{
  uint8_t i;
	for(i=0;i<=3;i++){*((uint8_t*)(v) + i) = *(p+i);};
}


void cf32ToBlock(uint32_t* v,uint8_t* p)
{
  uint8_t i;
	for(i=0;i<=3;i++){*(p+i) = *((uint8_t*)(v) + i);};
}


void cfConfirmReady()
{
  char buf[9];
	strcpy(buf,"$$TA");
	strcat(buf,TrxAVR_version);
	usbSendBlock((uint8_t*)buf,9,1000); 
}


void cfInitDisplay()
{
	ieInit();
	kyKeyPadInit();
	tpInitTouchPanel();
	gcGraphicsDisplayInit();
	ksdInit();
	cdInitCharLCD();
	DisplaySwitch = 0;
	zgDSPDisplay = 0;
	ztDSPDisplay = 0;
	if (zg) geSetMsgFrameDimensions(0);
	DisplayBlankFlag = 1;
	scSetDisplayLEDPWM(0);
	DisplayingMenu = 0;
	gcGraphicsDisplayStart();
	ddsApplyVfo(VFO);
	if (zc) {cdClear(); cdHome();}
	if (zt) etStartUp();
	if (zs) ksdClearScreen();
	ddsCheckFreq();
	zscShowMode();
	zscDisplayIP3NF();
	zscShowSwitches(1);
	etFilterInit();
	zscShowFilter();
	zddsShowBothVfoFreqs();
	zscDisplayParamColour(ParamColour);
	if (zt) {etMemBox(); etStackSlot(MemStackNo,255);}
	zscShowMemStackSlotNo();
	swInitSWR();
	smStartSmeter();
	rtcInit(1);
	_delay_ms(1700); // wait for seconds to move  (this delay at startup is DSP load)
	rtcClockCheck();
	scWakeupDisplay();
}








void cfUsbRequest(char cmd)
{
	uint8_t block[128];
	uint8_t i;
	uint8_t TFTA_I2C_ADDRESS_OLD, TFTA_I2C_ADDRESS_NEW;
	switch(cmd)
	{
	  case 'M': {  // Hobcat request for bytes 0 to 15 of Usrow
								for (i=0;i<=15;i++)
								{
									etcGetUserSigByte(i, &block[i]);
									//if (etcGetUserSigByte(0, &block[0]) == 0) return;
								}	 
								usbSendBlock((block),16,500);                
		            break;
							}
    case 'N': {
								if (usbReceiveBlock(block, 3, 500) == 1)
								{
									etcSetUserSigByte(block[0] + 0x100*block[1], block[2]);
								}
		            break;
              }
		
		case 'P': {   // TftA I2C address  - in taGlobal.h - read back to PC request
								usbSendBlock((&TFTA_I2C_ADDRESS),1,500);
								break;
              } 
	  case 'Q': {   //  TftA I2C address - in taGlobal.h - write from PC request
								TFTA_I2C_ADDRESS_OLD = TftaI2Caddress; 
								if (usbReceiveBlock(&TftaI2Caddress, 1, 500) == 1)
								{ 
									xeSaveTftaI2Caddress();
  								TFTA_I2C_ADDRESS_NEW = TftaI2Caddress; 
									cfSetDisplayControls();  // set zc, zg, zt etc
									if (zt) 
									{
										TFTA_I2C_ADDRESS = TFTA_I2C_ADDRESS_OLD;
										etcSetTftaI2Caddress(TFTA_I2C_ADDRESS_NEW);  // must be after cfSetDisplayControls
										TFTA_I2C_ADDRESS = TFTA_I2C_ADDRESS_NEW; 
                  }
									cfInitDisplay();
//									rtcInit(1);
								}
								break;
              }
	  case 'R': {   // hardware options  - in taGlobal.h - read back to PC request
								xeLoadHardwareSettings();
								cfSetDisplayControls();  // set zc, zg, zt etc
								memcpy(&block[0],&HardwareSettings.hsDisplay,96);
								usbSendBlock((uint8_t*)(&block),96,500);
								break;
              } 
	  case 'W': {   
								if (usbReceiveBlock((uint8_t*)(&block), 96, 500) == 1)
								{ 
									memcpy(&HardwareSettings.hsDisplay, &block[0], 96);
									xeSaveHardwareSettings();
									cfSetDisplayControls();  // set zc, zg, zt etc
									cfInitDisplay();
									rtcInit(1);
								}
								break;
              }
	  case 'D': {
		            if(usbReceiveBlock((uint8_t*)(&fDDSclock),4,500)==1)
								{ 
									ddsUpdateDDSclock(1);  // 1 = save it
								}
							  break;
              } 
		case 'L': {
		            if(usbReceiveBlock((uint8_t*)(&LSBoffset),4,500)==1)
								{ 
									ddsUpdateLSBoffset(1);
								}
							  break;
              } 

		case 'U': {
		            if(usbReceiveBlock((uint8_t*)(&USBoffset),4,500)==1)
								{ 
									ddsUpdateUSBoffset(1);
								}
							  break;
              } 

		case 'C': {
		            if(usbReceiveBlock((uint8_t*)(&block),5,500)==1) // CW offset[4] + enable byte
								{ 
									cfBlockTo32(&CWoffset,&block[0]);
									CWoffsetEnable = block[4];
									ddsUpdateCWoffset(1);
								}
							  break;
              } 

		case 'I': {
					if(usbReceiveBlock((uint8_t*)(&block),124,500)==1)
					{ 
						cfBlockTo32(&fDDSclock,&block[0]); 
						cfBlockTo32(&LSBoffset,&block[4]); 
						cfBlockTo32(&USBoffset,&block[8]);
						ddsUpdateDDSclock(1);   // 1 = save it
						ddsUpdateLSBoffset(1);
						ddsUpdateUSBoffset(1);
						for(i=0;i<10;i++){EncodersPotsParams[i] = block[12+i];};
						for(i=0;i<noofButtons;i++){RxButtonAssignments[i] = block[22+i];};
						for(i=0;i<noofButtons;i++){TxButtonAssignments[i] = block[48+i];};
						DDSparams.dp44CWmode = block[74];
						DDSparams.dpSoftwareFlywheel = block[75];
						DDSparams.dpAutoDim = block[76];
						DDSparams.dpParamResetMode = block[77];
						DDSparams.dpDisplayBright = block[78];
						DDSparams.dpDisplayDimmed = block[79];
						DDSparams.dpAutoDimSeconds = block[80];
						DDSparams.dpDisplayKeyValue = block[81];
						DDSparams.dpDSPDDSKeysDisplay = block[82];
						DDSparams.dpMenuTimeout = block[83];
						DDSparams.dpMoxTimeout = block[84] + 256*block[85];
						TouchCal.tcLeft = block[86] + 0x100*block[87];
						TouchCal.tcRight = block[88] + 0x100*block[89];
						TouchCal.tcTop= block[90] + 0x100*block[91];
						TouchCal.tcBottom = block[92] + 0x100*block[93];
						for(i=0;i<noofTPButtons;i++){RxTouchpadAssignments[i] = block[94+i];};
						for(i=0;i<noofTPButtons;i++){TxTouchpadAssignments[i] = block[109+i];};
						scEEwriteEncodersPotsParams();
						scEEwriteTxButtonAssignments();
						scEEwriteRxButtonAssignments();
						scEEwriteTxTouchpadAssignments();
						scEEwriteRxTouchpadAssignments();
						scEEwriteDDSparams();
						tpEEwriteTouchCal();
					}
					break;
		} 

		case 'J': {    // second EEMEM general purpose - not same as 'C' which is CWoffset only
		            if(usbReceiveBlock((uint8_t*)(&block),5,500)==1) // CW offset[4] + enable byte
								{ 
									cfBlockTo32(&CWoffset,&block[0]);
									CWoffsetEnable = block[4];
									// more
									ddsUpdateCWoffset(1);
								}
							  break;
              } 

		case 'S': {
						cf32ToBlock(&fDDSclock,&block[0]);
						cf32ToBlock(&LSBoffset,&block[4]);
						cf32ToBlock(&USBoffset,&block[8]);
						for(i=0;i<10;i++){block[12+i] = EncodersPotsParams[i];};
						for(i=0;i<noofButtons;i++){block[22+i] = RxButtonAssignments[i];};
						for(i=0;i<noofButtons;i++){block[48+i] = TxButtonAssignments[i];};
						block[74] = DDSparams.dp44CWmode;
						block[75] = DDSparams.dpSoftwareFlywheel;
						block[76] = DDSparams.dpAutoDim;
						block[77] = DDSparams.dpParamResetMode;
						block[78] = DDSparams.dpDisplayBright;
						block[79] = DDSparams.dpDisplayDimmed;
						block[80] = DDSparams.dpAutoDimSeconds;
						block[81] = DDSparams.dpDisplayKeyValue;
						block[82] = DDSparams.dpDSPDDSKeysDisplay;
						block[83] = DDSparams.dpMenuTimeout;
						block[84] = DDSparams.dpMoxTimeout % 256;
						block[85] = DDSparams.dpMoxTimeout / 256;
						block[86] = TouchCal.tcLeft % 0x100;
						block[87] = TouchCal.tcLeft / 0x100;
						block[88] = TouchCal.tcRight % 0x100;
						block[89] = TouchCal.tcRight / 0x100;
						block[90] = TouchCal.tcTop % 0x100;
						block[91] = TouchCal.tcTop / 0x100;
						block[92] = TouchCal.tcBottom % 0x100;
						block[93] = TouchCal.tcBottom / 0x100;
						for(i=0;i<noofTPButtons;i++){block[94+i] = RxTouchpadAssignments[i];};
						for(i=0;i<noofTPButtons;i++){block[109+i] = TxTouchpadAssignments[i];};
						usbSendBlock((uint8_t*)(&block),124,500);
						break;
						}

		case 'T': {
								cf32ToBlock(&CWoffset,&block[0]);
								block[4] = CWoffsetEnable;
								usbSendBlock((uint8_t*)(&block),5,500);
								break;
							}
						 
		case 'Z': cfConfirmReady(); break;

		case 'F': etProgramFlash(); break;
  }
}

