/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taADC.c  Analog input module program file


*/

// ADC inputs are used in single ended mode
// ref volts is ADVCC with external capacitor at AREF pin


#include "taGlobal.h"
#include "taEncoder.h"
#include "taStarDSP.h"
#include "taCharLCD.h"
#include "taUsart.h" 
#include "taStarControl.h"
#include "taStarDSP.h"
#include "taSWR.h"
#include "taDDS.h"
#include "taStarDSP.h"
#include "taADC.h"


#define ADMUX567  0x40    // used to set bits 5-7                         // ref = AVCC,   ADLAR = right adjusted result
#define ADCSRA0127 0x87;  // used to set bit 7  and 0-2
                          //  bit 7 enables ADC. 
	                        //  bits 0-2 = 7 = clock = XTAL /128  = 16000/128 -  125kHz.
        
static int PrevADO[2];

//Initialise analogue inputs
void adInit()
{
	uint8_t i;
	for (i = 0; i < 2; i++) {PrevADO[i] = 0;}
	Param81PotVal = 80;
	ADMUX = ADMUX567;
	ADCSRA = ADCSRA0127;  //  Switch on ADC at 125kHz clock rate
 	return;
}


uint16_t adReadADC(uint8_t channel)
{
	ADMUX = ADMUX567 | channel;  // select from ADC 0 to 7 single ended 
	ADCSRA |= 0x40;  // set bit 6 (ADSC) to start conversion
	while (ADCSRA & 0x40);
	uint16_t res = ADCL;
	res += (ADCH << 8);
	return res;
}


uint8_t adCheckPots(uint8_t* nenc, uint8_t* delta, uint8_t* updown)
{
	int y;
	int ADO[2];      //    adc output 0 - 1023
	uint16_t pmax;
	uint16_t x;
	uint16_t pmin;
	uint16_t newval;
	uint8_t PotNo;  // actual values 8 and 9
	uint8_t pval;
	uint8_t userno;
	uint8_t starno;
	uint8_t i;
	
	if (PotsFlag == 0) return 1;
	PotsFlag = 0;
	
	for (i = 0; i <= 1; i++) {
		ADO[i] = adReadADC(3 - i);  // 0 is adc3 = Pot 8,  1 is adc2 = Pot 9
		PotNo = 8 + i;             // EncodersPot index  ie 8 or 9 (out of 0 to 9)
		if (abs(ADO[i]-PrevADO[i]) < 12) ADO[i] = PrevADO[i]; // anti jitter		WAS 2  ijs 11.01.2010
		PrevADO[i] = ADO[i];
		y = ADO[i] / 4;
		if (y > 240) y = 240;
		if (y < 25) y = 25;   // adc control range is 100 to 960  
		*nenc = PotNo;
		userno = EncodersPotsParams[PotNo];
		if ((userno <= 10) || (userno >= 99)) continue;
		pmax = EncodersPotsParamMax[PotNo];
		pmin = EncodersPotsParamMin[PotNo];
		starno = dspUserToStar(userno); 
		pval = dspGetParamValue(starno);
		if (starno == 21) {
			x = (y - 25) * pmax;
			newval = (pmax + (x / 215)) / 2;   // from 66 to 100% of param setting
		} else {
			x = (y - 25) * (pmax - pmin);
			newval = pmin + (x / 215);
		}
		if (newval > pmax) newval = pmax;
		if (newval < pmin) newval = pmin;
		if (newval > pval) {
			if (pval < pmax) {
				*delta = (uint8_t)(newval - pval);
				*updown = 1;
				scWakeupDisplay();
				return 0;
			}
		}
		if (newval < pval) {
			if (pval > pmin) {
				*delta = (uint8_t)(pval - newval);
				*updown = 0;
				scWakeupDisplay();
				return 0;
			}
		}
	}	        // check both pots unless one found to have changed
	return 1;
}
