/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****
 
Front panel/transceiever control board using ATmega2560

TrxAVR.c  

Main module program file

AVR Studio must have:
 -  device set to atmega2560
 - frequency set to 16Mhz in configuration and debug
 

*/


#include "taGlobal.h"
#include "TrxAVR.h"
#include "taKeys.h"
#include "taCharLCD.h"
#include "taEncoder.h"
#include "taFT245R.h"
#include "ta24LC512.h"
#include "taDDS.h"
#include "taConfig.h"
#include "taADC.h"
#include "taDebug.h"
#include "taUsart.h"
#include "taStarDSP.h"
#include "taStarControl.h"
#include "taMenus.h"
#include "taSWR.h"
#include "taGraphicsDriverEA320.h"
#include "taGraphicsControl.h"
#include "taEATFT.h"
#include "taSmeter.h"
#include "taIntEeprom.h"
#include "taEA320TouchPanel.h"
#include "taScroll.h"
#include "taCAT.h"
#include "taKS0108Driver.h"
#include "taI2C.h"
#include "taRTC.h"


int main(void)
{
			
	cli(); // disable interrupts
 
	DDRG = 0x3F;	//  bits 0-1  out  LCD E (clock) and RS (data/instruction)
					//  bit  2    out  spare or WideBand BPF select
					//  bits 3-4  out  DDS clock lines
					//  bit  5   OUT  - OC0B  - PWM analogue s-meter output
					//  bits 6-7  in   dont exist !!
	ddsClearClocks();	// need to reset DDS clock lines before DDS (R/C) reset is completed
	                  // so do this early ... and before the startup delay
	                  
	PORTG &= 0x38;	// Set LCD E and RS to zero, WideBand BPF to zero

/////////////////////////////////////////////////////////////////////
	MCUSR = 0x00; // Clear all bits in Reset status register
	WDTCSR = ((1 << WDCE)|(1 <<WDE));  // Ensure watchdog is off
	WDTCSR = 0x00;  // Timed write - do not separate
//////////////////////////////////////////////////////////////
//  Set data direction registers
//  Set all spare multipurpose I/O lines to output - override elsewhare?  

  


	_delay_ms(1500); // prevents 24LC512 corruption on boot after programming


	DDRA = 0xFF;	//  relay driver output
	PORTA = 0;    // all off

 	DDRB = 0xEE;	//     bits 1-3 and 5-7  out
					//     bit 0 is keypad Y6 in
					//     bits 1, 2, 3 programming interface - could be outputs on layout revision
					//     bit 4 is DSP T/R line (low = transmit)
					//     bit 5 is Peak SWR  (high to give long time constant on SWR meter)
					//     bit 6 is PA disable. Low to disable (on prolonged mismatch)
					//     bit 7 DDS I/O update
				    
	PORTB = 0x11;   //     pull up on key pad Y6 bit 0 and T/R line bit 4

	DDRC = 0xFF;	//  bits 0-7  out  
					//      initialise to outputs for Keypad, USB and LCD write
					//      will be inputs on USB read. 
					//      USB read should reset to outputs on exit
					//      Likewise LCD read - but may never need to do this 

	DDRD = 0xB0;	//  bits 0-1  in   24LC512 EEPROM - set to input ? 
					//  bits 2-3  in   FT245RL TXE# and RXE# inputs (also may interrupt?)
					//  bits 4-5  out  FT245RL WR and RD#  - set to output
					//  bit  6    in   FT245RL PWREN#  - set to input 
					//  bit  7    out  LCD  RW or other LCD control if dont need to read it   output   

	DDRE = 0x24;	//  bits 0-1  in   actually UART0
					//  bit  2    out  IP3
					//  bits 3-4  in   rotary encoder inputs (INT 4 used)
					//  bit  5    out  spare
					//  bits 6-7  in   rotary encoder inputs (INT 7 used) - needs pullups - PORTE

	PORTE = 0xD8;	//  pull ups enabled for switching encoder on INT 7  and INT 4
	
	DDRF = 0xC0;	//  bits 0-1  Ref adn Fwd analog inputs
								//  bits 2-3  Pots 9 and 8 analog input
								//  bits 4-5  Touch panel read X and Y
								//  bits 6-7  OUtput - touch panel dirve TouchXH ad=nd TouchYH

	DDRH = 0xFC;	//  bits 0-1  set to in as UART2 used 
					//  bits 2-6  out  LED's (param red, param grn, Tx, Atten, IP3) 
					//  bit  7    out  DDS SDIO    

	PORTH = 0;
	
	DDRJ = 0x81;	//  bit  7    out  BPF out  (atten)
					//  bits 2-6  in   key pad Y0-Y4 in
					//  bit  1    in   key pad Y5 in
					//  bit  0    out  spare LCD control?

	DDRK = 0xFF;	//  bits 0-7  out  BPF out

	DDRL = 0xFF;	//  bit  0    out  Spare
					//  bits 1-2  out  Display controls
 					//  bit  3    out  CAT MOX control to NPN to pull down PPT line
					//  bits 4-7  out  Display controls

// Set pullups on input bits

	PORTJ = 0x7E;	//  bit  1     pullup  set for key pad input  Y5
					//  bits 2-6   pullups set for key pad inputs Y0 - Y4
  
	PORTD = 0xFF;
	PORTL = 0;

// Load hardware settings from 24LC512
	xeLoadHardwareSettings();
	xeLoadTftaI2Caddress();
	cfSetDisplayControls();   // set zc and zg for char and graphics display selection
// Set internal eeprom 1k block start address
	ieInit(); 
// Load internal EEMEM data
	scEEreadDDSparams();
	scEEreadMiscParams();
	scEEreadTxButtonAssignments();
	scEEreadRxButtonAssignments();
	scEEreadTxTouchpadAssignments();
	scEEreadRxTouchpadAssignments();
	scEEreadEncodersPotsParams();
// set I2C devices
	icInit(); 
// Apply configuration settings eg: DDS clock frequency, etc etc
	cfConfigInit();
// Keypad initialise - set correct decode options
	kyKeyPadInit();
// Touchpad initilaise
	tpInitTouchPanel();
// initialise DDS
	ddsInit();
// Initialise USB - must do this first because leaving RD# low will
// gate data onto portC lines and stop PORTC wrting to LCD
	usbInit();
// Initialise graphics display	 
//	geInitGraphics();  // initialise graphics display panel
// Configure graphics display
	gcGraphicsDisplayInit();
// Initialise character display	 
	cdInitCharLCD();  // initialise 16 x2 character display
	ksdInit(); // initialise 128x64 display
	// Initialise mneu scroll module
	srInitScroll(); 
	// Initialies menus
	meMenusInit();
// Initialise rotary encoder(s)
	enEncodersInit();
// Initialise Star control
	scStarInit();
// Initialise DSP module
	dspInit();
// initialise ADC 
	adInit();
// Initialise USART3 module
	uaSerialInit();
// Initialise serial CAT
	ctCatInit();
// Intialise Timer 3
	scTimersInit();
// Initilaise Debug module
	dbDebugInit();
// Initialise SWR module
	swInitSWR();	 
// Check if RTC active and initialise adn load TestSeconds
  rtcInit(1);  // must be before DSP load   1 = docheck
// Load DSP code and params
	scStarStart();
// see if RTC has moved on after DSP load	
  NoClockDraw = ParamsNotRestoredMsg;
	rtcClockCheck(); // ParamsNotResoreMsg stays on screen - so dont draw clock
// Initialise SWR module
	swInitSWR();	 
// Start S-meter
	smStartSmeter();
	
	 
// enable interrupts
	sei();         // Set interrupt enable bit in status register 
// main program loop
	while(1)
	{
		scTestLoopCode();
	}
}
