/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taStarControl.h  Central picastar control module header file


*/

#ifndef _ta_STARCONTROL_H_
#define _ta_STARCONTROL_H_ 1


#define LSB 0;
#define USB 1;
#define CWLSB 2;
#define CWUSB 3;


struct MiscParams_type {
	uint8_t FlywheelVal;
	uint8_t TuningThreshold2;
	uint8_t TuningThreshold1;
	uint8_t XParamShow;
	uint8_t s5;
	uint8_t s6;
	uint8_t s7;
	uint8_t s8;
};

extern struct MiscParams_type MiscParams;

extern uint8_t WobMode;
extern uint8_t Mode;
extern uint8_t PreviousMode;
extern uint8_t RFatten;
extern uint8_t DDS43;
extern uint8_t DDS23;
extern uint8_t GuardChannel;
extern uint8_t MainChannel;
extern uint8_t Guarding;
extern uint8_t ClearSlotno;
extern uint8_t SWdenoise;
extern uint8_t SWnoiseblank;
extern uint8_t SWautonotch;
extern uint8_t SWmanualnotch;
extern uint8_t SWfilter;
extern uint8_t CW_SWfilter;
extern uint8_t SSB_SWfilter;
extern uint8_t SWvox;
extern uint8_t SWspeechcomp;
extern uint8_t SWqro;
extern uint8_t SWqsk;
extern uint8_t SWspot;
extern uint8_t SWmonitor52;
extern uint8_t BufFlag;
extern uint8_t ShiftKeyFlag;
extern uint8_t ShiftTimer;
extern uint8_t ShowSwitchValueTimer;
extern uint8_t ShowSwitchValueFlag;
extern uint16_t RawKeycode;
extern uint8_t zgDSPDisplay;
extern uint8_t ztDSPDisplay;
extern uint8_t WakeupDisplay;
extern uint8_t Sleeping;
extern uint8_t Dimm;
extern uint8_t DisplayOff;
extern uint8_t AutoDimmed;
extern uint16_t AutoDimTimer;
extern uint8_t MenuTimer;
extern uint16_t MoxTimer;
extern uint8_t MenuFlag;
extern uint8_t ScanDelayIndex;
extern uint8_t ScanDelay;
extern uint16_t ScanTimer;
extern uint16_t GuardTimer;
extern char StickyVolatile;
extern uint32_t fA;
extern uint32_t fB;
extern uint8_t SweepStepIndex;
extern uint32_t SweepStep;
extern uint8_t XIT;
extern uint8_t RIT;
extern uint8_t ABdiff;
extern uint8_t DisplaySwitch;
extern uint8_t DisplayBlankFlag;
extern uint16_t DisplayBlankTimer;
extern uint8_t DisplayingMenu;
extern uint8_t ParamSetting;
extern uint8_t DDS79;
extern uint8_t WideBand;
extern uint8_t Transmit;
extern uint8_t PreviousTransmitF;
extern uint8_t PreviousTransmitD;
extern uint8_t LastEncoderSetting;
extern char ScanMode;


////////////////////////////////////////////////////////////////////

uint8_t XRIT();
void scUsbRequest(char cmd);
void scTx(uint8_t tr);
void scBandChanged();
void scReadTR();
void scTrChangeDisplays();
void scEEreadDDSparams();
void scEEwriteDDSparams();
void scEEreadMiscParams();
void scEEwriteMiscParams();
void scEEwriteEncodersPotsParams();
void scEEreadEncodersPotsParams();
void scEEwriteRxButtonAssignments();
void scEEreadRxButtonAssignments();
void scEEwriteTxButtonAssignments();
void scEEreadTxButtonAssignments();
void scEEwriteRxTouchpadAssignments();
void scEEreadRxTouchpadAssignments();
void scEEwriteTxTouchpadAssignments();
void scEEreadTxTouchpadAssignments();
void scChangeMode();
void scSetDisplayLEDPWM(uint8_t n);
void scSetSWRdamping(uint8_t d);
void scMeterLoopCode();
void scTestLoopCode();
void scStarStart();
void scTimersInit();
void scStarInit();
void scSetBand();
void scPaBias(uint8_t n);
void scSetMeterPWM(uint8_t n);
void scCheckFlags();
void scSetIP3(uint8_t n);
void scSetAtten(uint8_t n);
char scDoMenuKeyPad();
void scDoKeyPad();
void scDoDisplayKeyEATFT();
void scSetDisplayLevel();
void scWakeupDisplay();
void scSwitchToMemStacks();
void scPushToVolatileStack();
void scDoMemSlotSave();
void scWobbulator();
void scABscan();
void scScanMemStack();
void scShowSplitMode();
void scSetDDS23(uint8_t n);
void scSetDDS43(uint8_t n);
void scDenoise();
void scNoiseBlank();
void scAutoNotch();
void scManualNotch();
void scWideNarrow();
void scVoxQsk();
void scModeStep();
void scMute();
void scComp();
void scSetWideNarrow();
void scSetDDS79(uint8_t n);
void scColourshiftup();
void scColourshiftdwn();

#endif	/* !_ta_STARCONTROL_H_ */
