/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****

 taGraphicsDriverEA320.h    header file
 
Graphics display driver   320x240   
Epson S1D13700 driver chip
 
*/

#ifndef _ta_GRAPHICSDRIVEREA320_H_
#define _ta_GRAPHICSDRIVEREA320_H_ 1


struct TPen
{
	uint8_t Color;
	uint8_t Mode;
};

struct TPositionS1D13700
{
	uint16_t x;
	uint16_t y;
};

struct TBrush
{
  uint8_t Color;
  uint8_t Width;
};

extern struct TBrush Brush;
extern uint8_t InvertPixels;
extern uint16_t gedNextCharX;

void gedInitEA320Graphics();
void gedSwitchLayer(uint8_t n);
void gedShowLayer(uint8_t n, uint8_t on);
void gedFlashLayer(uint8_t n, uint8_t flash);
void gedSetPixel(uint16_t pX, uint16_t pY);
uint8_t geReadByte();
void gedWriteByte(uint8_t pValue);
void gedCls(uint8_t pColor);
void gedFillRect(uint16_t pX1, uint16_t pY1, uint16_t pX2, uint16_t pY2);
void gedRect(uint16_t pX1, uint16_t pY1, uint16_t pX2, uint16_t pY2, uint8_t width);
void gedHorizLine(uint16_t pX1, uint16_t pX2, uint8_t pY, uint8_t width);
void gedVertLine(uint8_t pY1, uint8_t pY2, uint16_t pX, uint8_t width);
void gedPosWriteChar(uint8_t pX, uint8_t pY, char ch);
void gedSetCharPos(uint8_t pX, uint8_t pY);
void gedDisplayFrequency(uint32_t f, uint8_t Vfo, uint8_t ActiveVfo);
void gedInitFrequencyDisplay();
void gedClearFrequencyDisplay(uint8_t vfo, uint8_t decpoints);
void gedFreqDecPoints(uint8_t vfo);
void gedF16WriteChar(uint8_t ch, uint16_t* ppX, uint16_t* ppY);
void gedF16WriteString(char* s, uint16_t X, uint16_t Y);
void gedF8WriteChar(uint8_t ch, uint16_t* ppX, uint16_t* ppY);
void gedF8WriteString(char* s, uint16_t X, uint16_t Y);
void ged5x3WriteString(char* s, uint16_t X, uint16_t Y);
void gedDrawFrames();
void gedWriteDigit(uint8_t value, uint8_t n, uint8_t Vfo, uint8_t ActiveVfo);
void gedF8CentreWriteString(char* s,uint8_t X,uint8_t Y, uint8_t width);
uint16_t gedF8StringWidth(char* s);
uint16_t gedF16StringWidth(char* s);
void gedDisplayDifference(int32_t df, uint8_t Vfo, uint8_t ActiveVfo);

#endif	/* !_ta_GRAPHICSDRIVEREA320_H_ */
