/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 taFT245R.h    header file
 
Support for FTDI FT245RL USB chip 
 
*/

#ifndef _ta_FT245R_H_
#define _ta_FT245R_H_ 1


extern unsigned char RxIntEnabled;
extern char ReqString[16];
extern char StrUsbA[80];   
extern char StrUsbB[80];   
extern char StrUsbC[8];   

void usbInit();
void usbINTenable(unsigned char n, unsigned char tf);
int usbGetByte(unsigned char* b);
int usbPutByte(unsigned char b);
uint8_t usbReceiveString(char *s, uint16_t timelimit);
uint8_t usbSendString(char *s, uint16_t timelimit, uint8_t terminator);
uint8_t usbSendBlock(uint8_t *start, uint16_t noofbytes, uint16_t timelimit);
uint8_t usbReceiveBlock(uint8_t *start, uint16_t noofbytes, uint16_t timelimit);
void usbResetRx();
void usbCheckPC();

#endif	/* !_ta_FT245R_H_ */
