/*
 *****    homebrew-radios.net   *****

 *****     Project TxrAVR       *****


 ta24LC512.h   header file
 
Functions using the 24LC512 64kbyte EEPROM chip on two wire interface (TWI) 
 
*/

#ifndef _ta_24LC512_H_
#define _ta_24LC512_H_ 1


// SWR calibration variables - loaded from external EEPROM

struct CalDataStruct_type
{
	uint16_t cdsFwdCalLevel[32];    // 32 forward power levels for ADC output = 32, 64 ... 992   centiwatts
	uint16_t cdsRefCalLevel[32];    // 32 reflected power levels for ADC output = 32, 64 ... 992  centiwatts
	uint16_t cdsFwdFsWatts;         // Forward analogue meter output full scale watts
	uint16_t cdsRefFsWatts;         // Reflected analogue meter output full scale watts
	uint16_t cdsMismatchDeciWatts;
	uint16_t cdsMismatchSeconds;
};

extern struct CalDataStruct_type CalDataStruct;
extern uint8_t xeebuf[132];

void xeLoadSwrCalData();   // SWR cal data from external EEPROM to RAM varaibles above
void xeSaveSwrCalData();   // SWr cal data from RAM varaibles above to external EEPROM
uint16_t xeGetDspParamsAddress(uint8_t n);
uint16_t xeGetDspMaxAddr();
uint16_t xeGetDspMinAddr();
uint16_t xeGetDspMultAddr();
uint16_t xeGetTxDriveSSBaddr();
uint16_t xeGetTxDriveCWaddr();
uint16_t xeGetParamterColourAddr();
uint16_t xeGetOldestStickyVfoSlotNoAddr();
uint16_t xeGetDspCodeByteCount();
void xeSetTxDriveToDefault();
int xeWrite32bit(uint16_t eeaddr, uint32_t n);
int xeRead32bit(uint16_t eeaddr, uint32_t *n);
int xeReadByte(uint16_t eeaddr, uint8_t *n);
int xeWriteByte(uint16_t eeaddr, uint8_t n);
void xeWriteDrive(uint8_t d, uint8_t band, uint8_t mode, uint8_t pcolour);
uint8_t xeReadDrive(uint8_t band, uint8_t mode, uint8_t pcolour);
void xeLoadHardwareSettings();
void xeSaveHardwareSettings();
void xeLoadTftaI2Caddress();
void xeSaveTftaI2Caddress();

#endif	/* _ta_24LC512_H_ */
