//===============================================================
// vnotice.cpp - vNoticeDialog class functions - Windows
//
// Copyright (C) 1995-2003  Bruce E. Wampler
// date: 15 Apr 2003 10:33:32
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#include <v/vwin32.h>		// for Win 32 stuff
#include <v/vnotice.h>		// our header
#include <v/vicon.h>
#include <v/vapp.h>		// for calc. of dialog position -  TEH Dec97

// Define static data of the class

//vbm8
#define bang_depth 8
#define bang_width 40
#define bang_height 32
static unsigned char bang_bits[] = {
3,
0,0,0,
255,255,255,
255,255,0,
255,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,0,0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,2,2,2,2,0,0,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,0,0,
0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
0,2,2,0,0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,0,0,2,2,0,3,0,0,2,2,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,0,3,3,3,0,0,2,0,0,0,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,0,3,3,3,0,0,2,
2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,
2,0,3,3,3,0,0,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,0,0,0,2,2,2,0,3,3,3,0,0,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,0,0,2,2,2,2,0,3,3,3,0,0,2,2,2,2,0,0,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,0,3,3,3,0,0,2,
2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,
2,0,3,3,3,0,0,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,0,0,2,2,2,2,2,2,0,3,3,3,0,0,2,2,2,2,2,2,0,0,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,0,3,3,3,0,0,2,2,2,2,2,2,0,0,0,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,2,0,3,3,3,0,0,2,
2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,
2,0,3,3,3,0,0,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,
0,2,2,2,2,2,2,2,2,0,3,3,3,0,0,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,
1,1,1,1,1,1,0,0,2,2,2,2,2,2,2,2,2,0,3,3,3,0,0,2,2,2,2,2,2,2,2,2,
0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,0,3,0,0,2,2,
2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,
2,2,2,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,1,1,1,1,0,0,0,2,
2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,
1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,
2,2,0,0,0,1,1,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,3,0,0,0,2,
2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,
2,0,3,3,3,0,0,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,1,1,0,0,0,2,2,2,2,
2,2,2,2,2,2,2,2,2,0,0,3,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,1,
1,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,0,0,0,1,1,0,0,0,0,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1
};
    static vIcon bang((unsigned char*)&bang_bits[0], bang_height, bang_width,
	bang_depth,Transparent);

    // Modified: TEH Jan98
    // Put icon + text in a frame so button is below frame.
    // With many-line text displays, the button will always be below text.
    static CommandObject NoticeDialog[] =
      {
	{C_Frame, 93, 0, "",
		NoList, CA_NoSpace | CA_NoBorder, isSens, NoFrame, 0, 0},
	{C_Icon, 91, 0, "Notice", (void*)&bang, CA_None,isSens,93, 0, 0},
	{C_Text, 92, 0, "",
		 NoList, CA_MainMsg | CA_NoBorder, isSens, 93, 91, 0},
	{C_Button, M_OK, M_OK, " OK ", NoList, CA_DefaultButton, isSens,
		NoFrame, 0, 93},
	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };

//======================>>> vNoticeDialog::Notice <<<=======================
  void vNoticeDialog::Notice(const char* msg)
  {
    //	Show a message, and OK
    //	no important return

    int dummy;

    // TEH jan98; move before "if" as it is in vYNReplyDialog
//@@@@ fix const evendually
    NoticeDialog[2].title = (char*)msg;		// BEW: V:1.13
    if (!_cmdsAdded)				// Only once
      {
	AddDialogCmds(NoticeDialog);		// Set up standard dialog
	_cmdsAdded = 1;
      }
    (void) ShowModalDialog(msg,dummy);		// show and wait
  }

//====================>>> vNoticeDialog::DialogCommand <<<=======================
  void vNoticeDialog::DialogCommand(ItemVal id, ItemVal val, CmdType ctype)
  {
    vModalDialog::DialogCommand(id,val,ctype);
  }

// TEH Dec97
// Added DialogDisplayed to handle the centering of the dialog in the app.
//==================>>> vNoticeDialog::DialogDisplayed <<<=====================
  void vNoticeDialog::DialogDisplayed()
  {
    // center the dialog in the app window
    RECT rctApp, rctDlg;			// app and dialog corners
    ::GetWindowRect(theApp->winHwnd(), &rctApp);
    ::GetWindowRect(_wDialog, &rctDlg);
    int widApp, htApp, widDlg, htDlg;		// app and dialog dimensions
    widApp = rctApp.right - rctApp.left;
    htApp = rctApp.bottom - rctApp.top;
    widDlg = rctDlg.right - rctDlg.left;
    htDlg = rctDlg.bottom - rctDlg.top;
    int left, top;				// new dialog upper-left corner
    if ( widApp > widDlg )
	left = (widApp - widDlg)/2; // don't add to left - SetDialogPosition does
    else
	left = rctApp.left;
    if ( htApp > htDlg )
	top = (htApp - htDlg)/2;
    else
	top = rctApp.top;
    SetDialogPosition (left , top);	      // set the position, in V coords
  }

// ---------------------------------------------------------------------
