unit UfrmWeb;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, SHDocVw, ExtCtrls, RzPanel, StdCtrls, RzLabel, Mask,
  RzEdit, RzButton, ActiveX;

type
  TfrmWeb = class(TForm)
    RzPanel1: TRzPanel;
    RzPanel2: TRzPanel;
    WB: TWebBrowser;
    RzBitBtn_Back: TRzBitBtn;
    RzBitBtn_Forward: TRzBitBtn;
    RzBitBtn_TrxAVRhome: TRzBitBtn;
    RzPanel3: TRzPanel;
    RzEdit_URL: TRzEdit;
    RzLabel2: TRzLabel;
    RzBitBtn_URLexec: TRzBitBtn;
    RzBitBtn_Close: TRzBitBtn;
    RzBitBtn1: TRzBitBtn;
    RzBitBtn2: TRzBitBtn;
    RzBitBtn_Refresh: TRzBitBtn;
    RzBitBtn_Stop: TRzBitBtn;
    RzBitBtn3: TRzBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure RzBitBtn_BackClick(Sender: TObject);
    procedure RzBitBtn_ForwardClick(Sender: TObject);
    procedure RzBitBtn_TrxAVRhomeClick(Sender: TObject);
    procedure WBNavigateComplete2(Sender: TObject; const pDisp: IDispatch;
      var URL: OleVariant);
    procedure RzBitBtn_URLexecClick(Sender: TObject);
    procedure RzBitBtn_CloseClick(Sender: TObject);
    procedure RzBitBtn1Click(Sender: TObject);
    procedure RzBitBtn2Click(Sender: TObject);
    procedure RzBitBtn_StopClick(Sender: TObject);
    procedure RzBitBtn_RefreshClick(Sender: TObject);
    procedure RzBitBtn3Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    NavFlags: olevariant;
    procedure WBPrintNoDialog;
    procedure WBPrintWithDialog;
    procedure WBPrintPreview;
    procedure WBPrintPageSetup;
    procedure SetWidths;
  public
    procedure Initialise(url: string);
  end;

var
  frmWeb: TfrmWeb;

implementation

{$R *.dfm}

uses UInidata;

procedure TfrmWeb.Initialise(url: string);
var
  flags: olevariant;
begin
  Show;
  LoadWebBrowserCoordinates;
  with g_regInidata do
  begin
    Left := IniWebFormLeft;
    Top := IniWebFormTop;
    Width := IniWebFormWidth;
    Height := IniWebFormHeight;
  end;
  SetWidths;
  NavFlags := $1C;
  WB.RegisterAsBrowser := true;
  Wb.RegisterAsDropTarget := true;
  WB.Navigate(url,NavFlags);
end;


procedure TfrmWeb.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 with g_RegIniData do
 begin
   IniWebFormLeft := left;
   IniWebFormTop := top;
   IniWebFormHeight := height;
   IniWebFormWidth := width;
 end;
 SaveWebBrowserCoordinates;
 Application.ProcessMessages;
 // WB.Free;
 //Free;
 frmWeb := nil;
end;


procedure TfrmWeb.SetWidths;
begin
  RzEdit_URL.Width := Width - 110;
  RzBitBtn_URLexec.Left := RzEdit_URL.Width + 47;
  RzBitBtn_Close.left := Width - 59;
end;

procedure TfrmWeb.RzBitBtn_BackClick(Sender: TObject);
begin
  try
    WB.GoBack;
  except
  end;
end;

procedure TfrmWeb.RzBitBtn_ForwardClick(Sender: TObject);
begin
  try
    WB.GoForward;
  except
  end;
end;

procedure TfrmWeb.RzBitBtn_TrxAVRhomeClick(Sender: TObject);
begin
  try
    WB.Navigate('www.homebrew-radios.net/trxavr_picastar/trxavr_picastar.htm',NavFlags);
  except
  end;
end;

procedure TfrmWeb.WBNavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  RzEdit_URL.Text := URL;
end;

procedure TfrmWeb.RzBitBtn_URLexecClick(Sender: TObject);
begin
  WB.Navigate(RzEdit_URL.Text, NavFlags);
end;

procedure TfrmWeb.RzBitBtn_CloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmWeb.RzBitBtn1Click(Sender: TObject);
begin
  WB.GoSearch;
end;

procedure TfrmWeb.RzBitBtn2Click(Sender: TObject);
begin
  WB.GoHome;
end;

procedure TfrmWeb.RzBitBtn_StopClick(Sender: TObject);
begin
  WB.Stop;
end;

procedure TfrmWeb.RzBitBtn_RefreshClick(Sender: TObject);
begin
  WB.Refresh;
end;



// print directly without printer dialog
procedure TfrmWeb.WBPrintNoDialog;
var
   vIn, vOut: OleVariant;
begin
   WB.ControlInterface.ExecWB(OLECMDID_PRINT, OLECMDEXECOPT_DONTPROMPTUSER, vIn, vOut) ;
end;

//call the printer dialog
procedure TfrmWeb.WBPrintWithDialog;
var
   vIn, vOut: OleVariant;
begin
   WB.ControlInterface.ExecWB(OLECMDID_PRINT, OLECMDEXECOPT_PROMPTUSER, vIn, vOut) ;
end;

// Print Preview
procedure TfrmWeb.WBPrintPreview;
var
   vIn, vOut: OleVariant;
begin
   WB.ControlInterface.ExecWB(OLECMDID_PRINTPREVIEW, OLECMDEXECOPT_DONTPROMPTUSER, vIn, vOut) ;
end;

//Call page setup dialog
procedure TfrmWeb.WBPrintPageSetup;
var
   vIn, vOut: OleVariant;
begin
   WB.ControlInterface.ExecWB(OLECMDID_PAGESETUP, OLECMDEXECOPT_PROMPTUSER, vIn, vOut) ;
end;

procedure TfrmWeb.RzBitBtn3Click(Sender: TObject);
begin
  WBPrintWithDialog;
end;


procedure TfrmWeb.FormResize(Sender: TObject);
begin
  Setwidths;
end;

initialization
  OleInitialize(nil);

finalization
  OleUninitialize;
end.


end.
