unit UfrmUpdate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzButton, Psock, NMHttp, Registry, IniFiles, StdCtrls, RzLabel,
  ExtCtrls, RzPrgres, RzPanel, RzLaunch, NMFtp, HHComp, DateUtils,
  IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient, IdFTP;

type

  TRegUpdate
  = record
      ruFtpHost: string;
      ruFtpLogin: string;
      ruFtpDir: string;
      ruUpdateInfo: string;
      ruLocalVersion: string;
      ruLocalDescription: string;
      ruInstallerName: string;
    end;


  TUpdateInfo
   = record
      uiLocalVersion: string;
      uiLocalDescription: string;
      uiScriptName: string;
      uiNewVersion: string;
      uiNewDescription: string;
      uiMsgU: string;
      uiMsgV: string;
      uiMsga: string;
      uiMsgb: string;
      uiMsgc: string;
      uiMsgd: string;
      uiMsge: string;
      uiMsgf: string;
      uiActionMsg: string;
      uiScriptUrl: string;
      uiCancelled: boolean;
      uiUpdateAvailable: boolean;
    end;

  TfrmUpdate = class(TForm)
    RzPanel1: TRzPanel;
    RzPanel2: TRzPanel;
    RzBitBtn_LookForUpdate: TRzBitBtn;
    RzBitBtn1: TRzBitBtn;
    RzPanel3: TRzPanel;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel_AppReport1: TRzLabel;
    RzLabel_AppActionMsg: TRzLabel;
    RzBitBtn_CancelApp: TRzBitBtn;
    RzBitBtn_GetUpdateApp: TRzBitBtn;
    RzLabel_AppLocalVersion: TRzLabel;
    RzBitBtn_CancelQaof: TRzBitBtn;
    RzPB_App: TRzProgressBar;
    RzLabel_AppNewVersion: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    RzLabel6: TRzLabel;
    RzLabel_BytesApp: TRzLabel;
    RzLauncher1: TRzLauncher;
    RzBitBtn_Help: TRzBitBtn;
    Timer_Terminate: TTimer;
    RzLabel_Looking: TRzLabel;
    HtmlHelp: TEmbeddedHtmlHelp;
    RzLabel_AppReport2: TRzLabel;
    RzLabel_AppReport3: TRzLabel;
    RzURLLabel2: TRzURLLabel;
    RzBitBtn2: TRzBitBtn;
    IdFTP_Update: TIdFTP;
    procedure RzBitBtn_LookForUpdateClick(Sender: TObject);
    procedure RzBitBtn_GetUpdateAppClick(Sender: TObject);
    procedure RzBitBtn_CancelAppClick(Sender: TObject);
    procedure RzBitBtn1Click(Sender: TObject);
    procedure RzBitBtn_HelpClick(Sender: TObject);
    procedure RzLauncher1Timeout(Sender: TObject);
    procedure Timer_TerminateTimer(Sender: TObject);
    procedure IdFTP_UpdateWork(Sender: TObject; AWorkMode: TWorkMode;
      const AWorkCount: Integer);
    procedure RzBitBtn2Click(Sender: TObject);
  private
    HobcatSetupSize: longint;
    RegIniFile: TRegIniFile;
    RegUpdate: TRegUpdate;
    LastCheckDate: TDateTime;
    AppUpdate: boolean;
    UseProgress: boolean;
    ftpHost: string;
    ftpDir: string;
    UpdateInf: string;
    ftpLogin: string;
    ftpPassword: string;
    UpdateInfPath: string;
    RemoteUpdateFile: string;
    UpdateInfo: TUpdateInfo;
    InstallerFilePath: string;
    InstallerFileName: string;
    procedure ClearUpdateInfo;
    procedure SetLabels;
    procedure GetAppUpdate;
  public
    HobcatSetupTimedout: boolean;
    AutoCheck: boolean;
    CheckSuccess: boolean;
    function RegIniOpen: boolean;
    function LoadRegIniFile: boolean;
    procedure LookForUpdate;
    procedure Initialise(Auto: boolean);
  end;

const
 KeyName: string = 'Software\hbradios\hobcat';


var
  frmUpdate: TfrmUpdate;

implementation

uses UGlobals, About, UfrmMain;

{$R *.dfm}



function TfrmUpdate.RegIniOpen: boolean;
begin
  result := true;
  try
    RegIniFile := TRegIniFile.Create;
    RegIniFile.RootKey := HKEY_LOCAL_MACHINE; // Section to look for within the registry
    RegIniFile.OpenKey(KeyName,true);
  except
    result := false;
    RegIniFile.Free;
  end;
end;


function TfrmUpdate.LoadRegIniFile: boolean;
var
  s: string;
begin
  result := true;
  s := ExtractFilePath(Application.ExeName);
  if not RegIniOpen then
  begin
    s := 'Unable to find registry section: HKLM\hbradios\hobcat' + #13#10
        + 'Do you want to proceed with built in default update parameters?';
    result := (mrYes = MessageDlg(s,mtWarning,[mbYes,mbNo],0));
    RegIniFile.Free;
    exit;
  end;
  with RegUpdate, RegIniFile do begin
    ruLocalVersion := ReadString('ftpupdate','localversion','0,0,0,0');
    ruLocalDescription := ReadString('ftpupdate','localdescription','Local version desciption missing');
  end;
  RegIniFile.Free;
end;





procedure TfrmUpdate.Initialise(Auto: boolean);
var
  RegIniFile: TRegInifile;
  IniFile: TIniFile;
  s: string;
begin
  AutoCheck := false;
  UseProgress := false;
  RzLabel_Looking.Hide;
  RzPB_App.Hide;
  RzBitBtn_GetUpdateApp.Hide;
  RzBitBtn_CancelApp.Hide;
  RzLabel_BytesApp.Caption := '';
  ClearUpdateInfo;
  SetLabels;
  UpdateInfPath := g_TempPath + '\hobcat_update.inf';
  LoadRegIniFile;

  with RegUpdate do
  begin
    UpdateInfo.uiLocalVersion := ruLocalVersion;
    UpdateInfo.uiLocalDescription := ruLocalDescription;
    UpdateInfo.uiScriptName := ruInstallerName;
  end;
  FtpHost := 'ftp.owdill.co.uk';
  FtpLogin := 'hobcatupdate@owdill.co.uk';
  FtpDir := '';
  InstallerFileName := 'hobcatsetup.exe';
  InstallerFilepath := g_TempPath + '\' + InstallerFileName;
  UpdateInf := 'hobcat_update.inf';
  ftpPassword := 'scarista5678';
  SetLabels;
  IdFTP_Update.User := ftpLogin;
  IdFTP_Update.Password := 'scarista5678';  //ftpPassword;
  IdFTP_Update.Host := ftpHost;
  IdFTP_Update.Port := 21;
end;


procedure TfrmUpdate.ClearUpdateInfo;
begin
  with UpdateInfo do
  begin
    uiLocalVersion := '';;
    uiLocalDescription := '';
    uiScriptName := '';
    uiNewVersion := '';
    uiNewDescription := '';
    uiMsgU := '';
    uiMsgV := '';
    uiMsga := '';
    uiMsgb := '';
    uiMsgc := '';
    uiMsgd := '';
    uiMsge := '';
    uiMsgf := '';
    uiActionMsg := '';
    uiScriptUrl := '';
    uiCancelled := false;
    uiUpdateAvailable := false;
  end;
end;


procedure TfrmUpdate.SetLabels;
var
  s1,s2,s3: string;
begin
  RzLabel_AppLocalVersion.Caption := UpdateInfo.uiLocalDescription;
  RzLabel_AppNewVersion.Caption := UpdateInfo.uiNewDescription;
  RzLabel_AppActionMsg.Caption := UpdateInfo.uiActionMsg;

  with UpdateInfo do
  begin
    s1 := uiMsgU;
    if uiMsgV <> '' then s1 := s1 + #10#13 + uiMsgV;
    s2 := uiMsga;
    if uiMsgb <> '' then s2 := s2 + #10#13 + uiMsgb;
    if uiMsgc <> '' then s2 := s2 + #10#13 + uiMsgc;
    s3 := uiMsgd;
    if uiMsge <> '' then s3 := s3 + #10#13 + uiMsge;
    if uiMsgf <> '' then s3 := s3 + #10#13 + uiMsgf;
  end;
  RzLabel_AppReport1.Caption := s1;
  RzLabel_AppReport2.Caption := s2;
  RzLabel_AppReport3.Caption := s3;
end;




procedure TfrmUpdate.LookforUpdate;
var
  IniFile: TIniFile;
  i: integer;
  u,v: longint;
  Section: string;
  s: string;
begin
  AppUpdate := false;
  CheckSuccess := false;
  RzLabel_Looking.Show;
  RzBitBtn_LookForUpdate.Enabled := false;
  DeleteFile(UpdateInfPath);
  try
    IdFTP_Update.Connect(true);
  except
    s := 'Failed to connect to ftpupdate folder at homebrew-radios.net';
    MessageDlg(s,mtWarning,[mbOK],0);
    RzLabel_Looking.Hide;
    RzBitBtn_LookForUpdate.Enabled := true;
    exit;
  end;

//  NMFTP_Update.ChangeDir('/' + ftpDir);
  try
    IdFTP_Update.Get(UpdateInf,UpdateInfPath,true);
    IdFTP_Update.Quit;
  except
    s := 'Failed to find update control file' + #10#13 + '(' + UpdateInfPath + ')'
    + #10#13#10#13 + 'You need to run Hobcat as administrator.';
    MessageDlg(s,mtWarning,[mbOK],0);
    IdFTP_Update.Quit;
    RzLabel_Looking.Hide;
    RzBitBtn_LookForUpdate.Enabled := true;
    exit;
  end;
  CheckSuccess := true;
  RzLabel_Looking.Hide;
  IniFile := TIniFile.Create(UpdateInfPath);
  with IniFile do
  begin
    Section := 'AppUpdate';
    with UpdateInfo do
    begin
      uiUpdateAvailable := true;
      uiNewVersion := ReadString(Section,'newversion','');
      uiNewDescription := ReadString(Section,'description','');
      uiMsga := ReadString(Section,'msga','');
      uiMsgb := ReadString(Section,'msgb','');
      uiMsgc := ReadString(Section,'msgc','');
      uiMsgd := ReadString(Section,'msgd','');
      uiMsge := ReadString(Section,'msge','');
      uiMsgf := ReadString(Section,'msgf','');
      uiActionMsg := ReadString(Section,'actionmsg','');
      uiScriptUrl := ReadString(Section,'scripturl','');
      if uiNewVersion <= uiLocalVersion then
      begin
        uiMsgU := 'You already have the latest version installed.';
        uiMsgV := 'But the ''Get update'' button is enabled for test purposes!!';
        uiUpdateAvailable := false;
      end;
    end;
    Free;
    DeleteFile(UpdateInfPath);
  end;
  SetLabels;
//if UpdateInfo.uiUpdateAvailable then RzBitBtn_GetUpdateApp.Show;
  RzBitBtn_GetUpdateApp.Show;
  RzBitBtn_LookForUpdate.Enabled := true;
end;


procedure TfrmUpdate.GetAppUpdate;
var
  s: string;
begin
  RzLabel_AppReport1.Caption := '';
  RzLabel_AppReport2.Caption := '';
  RzLabel_AppReport3.Caption := '';
  AppUpdate := true;
  DeleteFile(g_TempPath + '\' + UpdateInfo.uiScriptName);
  RzLabel_AppActionMsg.Caption := '';
  RzBitBtn_GetUpdateApp.Hide;
  RzBitBtn_CancelApp.Show;
  RzBitBtn_CancelApp.Enabled := true;
  RzBitBtn_LookForUpdate.Enabled := false;
  RzPB_App.Percent := 0;
  RzPB_App.Show;
  UseProgress := true;
  RzLabel_BytesApp.Font.Style := [fsBold];
  RzLabel_BytesApp.Caption := 'Connecting...';
  UpdateInfo.uiCancelled := false;
  try
    IdFTP_Update.Connect(true);
  except
    s := 'Failed to connect to ftpupdate folder at homebrew-radios.net';
    MessageDlg(s,mtWarning,[mbOK],0);
    UseProgress := false;
    RzBitBtn_LookForUpdate.Enabled := true;
    exit;
  end;
  try
    HobcatSetupSize := IdFTP_Update.Size(InstallerFileName);
    IdFTP_Update.Get(InstallerFileName, InstallerFilePath,true);
    IdFTP_Update.Quit;
  except
    RzPB_App.Hide;
    if UpdateInfo.uiCancelled
    then RzLabel_AppReport1.Caption := 'Download cancelled'
    else begin
      s := 'Failed to find Install/Update file' + #10#13 + '(' + InstallerFileName + ')';
      MessageDlg(s,mtWarning,[mbOK],0);
    end;
    IdFTP_Update.Quit;
    RzBitBtn_CancelApp.Hide;
    UseProgress := false;
    RzBitBtn_CancelApp.Enabled := false;
    RzBitBtn_CancelApp.Hide;
    RzLabel_BytesApp.Caption := '';
    RzBitBtn_LookForUpdate.Enabled := true;
    exit;
  end;
//  NMFTP_Update.TimeOut := 30000;
  RzPB_App.Hide;
  UseProgress := false;
  RzBitBtn_CancelApp.Hide;
  RzLabel_BytesApp.Caption := '';
  Application.ProcessMessages;
//  if NMFTP_Update.BytesRecvd > 4 then
  if true then
  begin
    RzLabel_AppReport1.Caption := UpdateInfo.uiScriptName + '  update program loaded into Temp folder';
    s := UpdateInfo.uiScriptName + '  update program loaded'
        + #10#13 + 'Do you wish to process with the update ?'
        + ' (HOBCAT will terminate)';
    if mrYes = MessageDlg(s,mtConfirmation,[mbYes,mbNo],0) then
    begin
      RzLauncher1.FileName := InstallerFilePath;
      RzLauncher1.StartDir := g_TempPath;
      RzLauncher1.Launch;
      HobcatSetupTimedout := false;
      Timer_Terminate.Enabled := true;
      repeat
        Application.ProcessMessages;
        if HobcatSetupTimedout then break;
      until RzLauncher1.HProcess <> 0;
      if not HobcatSetupTimedout
      then Application.Terminate
      else begin
        s := 'HobcatSetup failure to launch timeout.' +#10#13 + 'Press any key';
        MessageDlg(s,mtWarning,[mbOk],0);
        Close;
      end;
    end
    else begin
      RzBitBtn_GetUpdateApp.Show;
      SetLabels;
    end;
  end
    else begin
    RzBitBtn_GetUpdateApp.Show;
    s := 'Update file download incomplete ?';
    MessageDlg(s,mtWarning,[mbOk],0);
  end;
  RzBitBtn_LookForUpdate.Enabled := true;
end;



procedure TfrmUpdate.RzBitBtn_LookForUpdateClick(Sender: TObject);
begin
  Initialise(false);
  LookForUpdate;
end;



procedure TfrmUpdate.RzBitBtn_GetUpdateAppClick(Sender: TObject);
begin
  GetAppUpdate;
end;

procedure TfrmUpdate.RzBitBtn_CancelAppClick(Sender: TObject);
begin
  try
    UpdateInfo.uiCancelled := true;
    IdFTP_Update.Abort;
    IdFTP_Update.Quit;
  except
  end;
  MessageDlg('Download aborted.'
                       ,mtInformation,[mbOk],0);
//  Application.Terminate;
end;

procedure TfrmUpdate.RzBitBtn1Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmUpdate.RzBitBtn_HelpClick(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/hobcat/hobcat_updates.htm');
//  HtmlHelp.ChmFile := ExtractFilePath(Application.EXEName) + 'Hobcat.chm';
//  HtmlHelp.DisplayContext(4000);
end;

procedure TfrmUpdate.RzLauncher1Timeout(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmUpdate.Timer_TerminateTimer(Sender: TObject);
begin
  Timer_Terminate.Enabled := false;
  HobcatSetupTimedout := true;
end;

procedure TfrmUpdate.IdFTP_UpdateWork(Sender: TObject;
  AWorkMode: TWorkMode; const AWorkCount: Integer);
var
  b,m: integer;
begin
  Application.ProcessMessages;
  if not AppUpdate then exit;
  if AWorkCount MOD 1000 <> 0 then exit;
  b := AWorkCount;
  m := HobcatSetupSize;
  if b > 0 then
  begin
    RzPB_App.Percent := (100*b) DIV m;
    RzLabel_BytesApp.Font.Style := [];
    RzLabel_BytesApp.Caption := IntToStr(b) + ' bytes of '
                                 + IntToStr(m) + ' bytes';
  end;
end;

procedure TfrmUpdate.RzBitBtn2Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/trxavr_versions.htm');  
end;

end.
