unit UfrmTftA_I2Caddress;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzButton, StdCtrls, Mask, RzEdit, RzSpnEdt, RzLabel,syncobjs,
  D2XXUnit, UGlobals;

type
  TfrmTftA_I2Caddress = class(TForm)
    RzLabel29: TRzLabel;
    RzLabel_TftA_HexAddress: TRzLabel;
    RzSpinEdit_TftA_Address: TRzSpinEdit;
    RzBitBtn_Save: TRzBitBtn;
    RzBitBtn_Exit: TRzBitBtn;
    RzLabel8: TRzLabel;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    RzLabel6: TRzLabel;
    RzLabel7: TRzLabel;
    RzLabel9: TRzLabel;
    procedure RzSpinEdit_TftA_AddressChange(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure RzBitBtn_SaveClick(Sender: TObject);
  private
    I2CaDelayEvent: TEvent;
    I2Caddress: byte;
  public
    procedure Initialise;
    procedure DoWriteI2Caddress;
    procedure DoReadI2Caddress;
  end;

var
  frmTftA_I2Caddress: TfrmTftA_I2Caddress;

implementation

uses UfrmMain,UUsb;

{$R *.dfm}


procedure TfrmTftA_I2Caddress.Initialise;
begin
  I2CaDelayEvent := TEvent.Create(0, true, false, 'Hobcat TftA I2C address delay event');
  I2CaDelayEvent.ResetEvent;
  I2CaDelayEvent.WaitFor(200);
  frmMain.USBstate[readtftad] := 'W';
end;

procedure TfrmTftA_I2Caddress.DoReadI2Caddress;
var
  error: boolean;
  s: string;
begin
  error := false;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_P')
  then error := true
  else begin
    I2CaDelayEvent.ResetEvent;
    I2CaDelayEvent.WaitFor(200);
    if not Usb.usReceiveBlock(@I2Caddress,1) then error := true;
  end;
  if error then
  begin
    s := 'Failed to read TftA I2C address from TrxAVR 24LC512 EEPROM';
    MessageDlg(s,mtWarning,[mbOk],0);
    exit;
  end;
  RzSpinEdit_TFTA_Address.Text := IntToStr(I2Caddress);
end;

procedure TfrmTftA_I2Caddress.DoWriteI2Caddress;
var
  error: boolean;
  s: string;
begin
  I2Caddress := trunc(RzSpinEdit_TftA_Address.Value);
  error := false;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_Q')
  then error := true
  else begin
    if not Usb.usSendBlock(@I2Caddress,1) then error := true;
  end;
  if error then
  begin
    s := 'Failed to send TftA I2C address to TrxAVR';
    MessageDlg(s,mtWarning,[mbOk],0);
    exit;
  end;
  s := 'TftA I2C address send to TrxAVR / TftA'
           + #13#10 + ' Please reboot TrxAVR';
  MessageDlg(s,mtInformation,[mbOk],0);
end;


procedure TfrmTftA_I2Caddress.RzSpinEdit_TftA_AddressChange(
  Sender: TObject);
var
  b: byte;
begin
  b := trunc(RzSpinEdit_TftA_Address.Value);
  RzLabel_TftA_HexAddress.Caption := IntToHex(b,2);
end;

procedure TfrmTftA_I2Caddress.RzBitBtn_ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmTftA_I2Caddress.RzBitBtn_SaveClick(Sender: TObject);
begin
  frmMain.USBstate[writetftad] := 'W';
end;

end.
