unit UfrmTFTflash;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzButton, StdCtrls, FileCtrl, ComCtrls, RzTreeVw, RzFilSys,
  RzLabel, Mask, RzEdit, syncobjs;

type
  TfrmTFTflash = class(TForm)
    RzBitBtn_Exit: TRzBitBtn;
    RzBitBtn_program: TRzBitBtn;
    RzBitBtn_Help: TRzBitBtn;
    RzLabel_Filename: TRzLabel;
    RzDirectoryTree1: TRzDirectoryTree;
    RzFileListBox1: TRzFileListBox;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel_Report: TRzLabel;
    RzLabel_checksum: TRzLabel;
    RzLabel_RecChecksum: TRzLabel;
    RzLabel4: TRzLabel;
    procedure RzFileListBox1Change(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure RzBitBtn_programClick(Sender: TObject);
  private
    FlashDelayEvent: TEvent;
    FlashFile: file;
    FlashFileName: string;
    buf: array[0..2000000] of byte;
    FlashSize: longint;
    procedure SendFile;
  public
    procedure Initialise;
    procedure SendBytes;
  end;

var
  frmTFTflash: TfrmTFTflash;

implementation
uses UIniData, UfrmMain, UUsb,D2XXunit;

{$R *.dfm}


procedure TfrmTFTflash.Initialise;
begin
  RzLabel_Checksum.caption := '';
  RzLabel_RecChecksum.caption := '';
  Rzlabel_report.Caption := '';
  RzDirectoryTree1.Directory := g_RegIniData.IniTFTflashFile;
  Rzlabel_Filename.Caption := RzFileListBox1.LongFilename;
  FlashDelayEvent := TEvent.Create(0, true, false, 'Hobcat Flash programming delay event');
end;


procedure TfrmTFTflash.RzFileListBox1Change(Sender: TObject);
begin
  Rzlabel_Filename.Caption := RzFileListBox1.LongFilename;
end;

procedure TfrmTFTflash.RzBitBtn_ExitClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TfrmTFTflash.RzBitBtn_programClick(Sender: TObject);

begin
  FlashFilename := RzFileListBox1.LongFilename;
  if FlashFilename = '' then
  begin
    MessageDlg('No file selected !',mtWarning,[mbOk],0);
    exit;
  end;
  g_RegIniData.IniTFTflashFile := FlashFilename;
  SaveRegIniFile;
  SendFile;
end;



procedure TfrmTFTflash.SendFile;
var
  BytesLoaded: longint;
  s: string;
begin
  AssignFile(FlashFile,FlashFileName);
  Reset(FlashFile,1);
  FlashSize := FileSize(FlashFile);
  BlockRead(FlashFile,buf,FlashSize,BytesLoaded);
  CloseFile(FlashFile);
  if FlashSize <> BytesLoaded then
  begin
    s := 'Flash file size = ' + IntToStr(FlashSize) + ' bytes, but '
                                 + IntToStr(BytesLoaded) + ' bytes loaded.';
    MessageDlg(s,mtWarning,[mbOk],0);
    exit;
  end;
  frmMain.USBstate[tftflash] := 'W';
end;


procedure TfrmTFTflash.SendBytes;
var
  i,bk,remaining: longint;
  Checksum: longint;
  RecChecksum: word;
  bksz: integer;
  block: array[0..255] of byte;
  bytesdone: boolean;
begin
  RzLabel_Checksum.caption := '';
  RzLabel_RecChecksum.caption := '';
  Checksum := 0;
  for i := 0 to FlashSize-1 do Checksum := (Checksum + buf[i]) MOD $10000;
  Checksum := (Checksum + FlashSize) MOD $10000;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_F') then
  begin
    MessageDlg('Failed to send USB header',mtWarning,[mbOk],0);
    exit;
  end;
  FlashDelayEvent.ResetEvent;
  FlashDelayEvent.WaitFor(1);
  if not Usb.usSendBlock(@FlashSize,4) then
  begin
    MessageDlg('Failed to send byte count',mtWarning,[mbOk],0);
    exit;     //  sent byte count
  end;
  FlashDelayEvent.ResetEvent;
  FlashDelayEvent.WaitFor(10);
  bk := 0;
  bytesdone := false;
  Purge_USB_device_in;
  repeat
    remaining := FlashSize - bk;
    if remaining >= 128 then
    begin
      for i := 0 to 127 do block[i] := buf[bk+i];
      bk := bk + 128;
      bksz := 128;
      if remaining = 128 then bytesdone := true;
    end
    else begin
      for i := 0 to remaining - 1 do block[i] := buf[bk+i];
      for i := remaining to 127 do block[i]:= 0;
      bytesdone := true;
      bksz := remaining;
    end;
    Usb.usSendBlock(@block[0],bksz);
    RzLabel_report.Caption := 'bytes:  ' + IntToStr(bk);
    FlashDelayEvent.ResetEvent;
    FlashDelayEvent.WaitFor(40);
    Application.ProcessMessages;
  until bytesdone;
  if bytesdone
  then Rzlabel_report.Caption := 'Flash code: ' + IntToStr(FlashSize) + ' bytes sent'
  else RzLabel_report.Caption := 'Flash code transmission by USB failed';
  FlashDelayEvent.ResetEvent;
  FlashDelayEvent.WaitFor(600);
  Usb.usReadWord(RecChecksum);
  RzLabel_Checksum.Caption :=  'Checksum on send =  '
                                               + IntToStr(Checksum);
  RzLabel_RecChecksum.Caption := 'Checksum back from TrxAVR  =  '
                                               + IntToStr(RecChecksum);

end;




end.
