unit UfrmMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComPort, ComCtrls, Menus, RzButton, RzBorder, ExtCtrls,
  RzLabel, RzPanel, UIniData, HHComp, UGlobals, RzStatus, FileCtrl,syncobjs,
  RzBHints, IdBaseComponent, IdComponent, IdUDPBase, IdUDPClient, IdSNTP;

type

  TUSBjob = (status,
             setrtc,readrtc,setfout,readfout,setatr,readatr,setaging, readaging,
             setoffs,readoffs,
             hwreadrtc, readtftad, writetftad,readusrow0to15,writeusrow,
             getslots,tr,setfreq,ddsbutton,eesave,eeload,hwread,hwwrite,
             ddsclk,lsboffs,usboffs,adc,cwoffs,dds,dspgetall,dsp254,dspswrcal,
             ddsswrcal,ddsswrdata,parambk,paramstobk,debug,cal,telem,ad603,
             paramcol,oneparam,codeparams,codeonly,diagwrite,diagread,ad5321w,
             ad5321r,tftflash,paramsonly,paramsdown);

  TfrmMain = class(TForm)
    MainMenu1: TMainMenu;
    Menu_File: TMenuItem;
    Menu_Setup: TMenuItem;
    Menu_Links: TMenuItem;
    Help2: TMenuItem;
    Menu_About: TMenuItem;
    Menu_comsel: TMenuItem;
    HtmlHelp: TEmbeddedHtmlHelp;
    RzStatusBar1: TRzStatusBar;
    RzStatusPane_left: TRzStatusPane;
    RzClockStatus1: TRzClockStatus;
    Menu_Exit: TMenuItem;
    Timer_Startup: TTimer;
    Menu_Tools: TMenuItem;
    Menu_InternetUpdates: TMenuItem;
    RzToolbar1: TRzToolbar;
    Menu_Window: TMenuItem;
    RzSpacer1: TRzSpacer;
    RzBitBtn_Debug: TRzBitBtn;
    RzSpacer2: TRzSpacer;
    Timer_USBstatus: TTimer;
    RzStatusPane_COM: TRzStatusPane;
    Menu_Tile: TMenuItem;
    Menu_Cascade: TMenuItem;
    RzBitBtn_DSP: TRzBitBtn;
    RzSpacer3: TRzSpacer;
    RzBitBtn_DDS: TRzBitBtn;
    Menu_View: TMenuItem;
    Menu_DSP_EEPROM: TMenuItem;
    Menu_CodeParams: TMenuItem;
    Menu_ParamsOnly: TMenuItem;
    Menu_CodeOnly: TMenuItem;
    Menu_UploadParams: TMenuItem;
    Menu_StarFolder: TMenuItem;
    StarComPort: TComPort;
    TimerCom: TTimer;
    Menu_DSP_direct: TMenuItem;
    Menu_setupUSB: TMenuItem;
    Timer_USBqueue: TTimer;
    Menu_DDSclockOffsets: TMenuItem;
    Menu_LoadSaveEEMEM: TMenuItem;
    Menu_hardware: TMenuItem;
    AD603calibrationtoTrxAVR1: TMenuItem;
    Menu_SwrCal: TMenuItem;
    Menu_FwdCal: TMenuItem;
    Menu_RefCal: TMenuItem;
    Menu_CalSummary: TMenuItem;
    Menu_SelectParamFile: TMenuItem;
    RzStatusPane_TrxAVR: TRzStatusPane;
    rxAVRportdiagnostic1: TMenuItem;
    ProgrameTFTFlashMemory1: TMenuItem;
    I2Cbusdevices1: TMenuItem;
    GlennsTrxAVRpages1: TMenuItem;
    homebrewradiosyahoogroups1: TMenuItem;
    PeakreadingSWRmeterG3VPX1: TMenuItem;
    Versionhistory1: TMenuItem;
    Usefulfactsandhints1: TMenuItem;
    HocatandTrxAVRdownloadpage1: TMenuItem;
    Userfeedback1: TMenuItem;
    Picastarmanual1: TMenuItem;
    Introduction1: TMenuItem;
    Initialsetup1: TMenuItem;
    DDSmode1: TMenuItem;
    DSPmode1: TMenuItem;
    DSPmonitor1: TMenuItem;
    CAT1: TMenuItem;
    Sourcecode1: TMenuItem;
    X1DDSmenuSummary1: TMenuItem;
    X2DSPmenusummary1: TMenuItem;
    X3Softwareblockdiagram1: TMenuItem;
    X5colouredparameters1: TMenuItem;
    X4Stereosummary1: TMenuItem;
    X7DSPOEMcommands1: TMenuItem;
    X8parameterremovereplace1: TMenuItem;
    X9Denoisertrimuntility1: TMenuItem;
    picaprojectyahoogroupscom1: TMenuItem;
    Menu_Database: TMenuItem;
    Menu_projectDB: TMenuItem;
    homebrewradiosnet1: TMenuItem;
    RzBalloonHints1: TRzBalloonHints;
    Menu_RTC: TMenuItem;
    Menu_TftaI2Caddress: TMenuItem;
    Menu_Usrow: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Menu_AboutClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Timer_StartupTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Menu_InternetUpdatesClick(Sender: TObject);
    procedure Menu_ExitClick(Sender: TObject);
    procedure RzBitBtn_DebugClick(Sender: TObject);
    procedure Timer_USBstatusTimer(Sender: TObject);
    procedure Menu_TileClick(Sender: TObject);
    procedure Menu_CascadeClick(Sender: TObject);
    procedure Menu_ArrangeClick(Sender: TObject);
    procedure RzBitBtn_DSPClick(Sender: TObject);
    procedure RzBitBtn_DDSClick(Sender: TObject);
//    function  CheckUsb: boolean;
    procedure Menu_CodeParamsClick(Sender: TObject);
    procedure Menu_ParamsOnlyClick(Sender: TObject);
    procedure Menu_CodeOnlyClick(Sender: TObject);
    procedure Menu_UploadParamsClick(Sender: TObject);
    procedure Menu_comselClick(Sender: TObject);
    procedure Menu_StarFolderClick(Sender: TObject);
    procedure Menu_DSP_directClick(Sender: TObject);
    procedure Menu_setupUSBClick(Sender: TObject);
    procedure Timer_USBqueueTimer(Sender: TObject);
    procedure DSPUSBCOM1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Menu_DDSclockOffsetsClick(Sender: TObject);
    procedure Menu_LoadSaveEEMEMClick(Sender: TObject);
    procedure Menu_hardwareClick(Sender: TObject);
    procedure AD603calibrationtoTrxAVR1Click(Sender: TObject);
    procedure Menu_CalSummaryClick(Sender: TObject);
    procedure Menu_FwdCalClick(Sender: TObject);
    procedure Menu_RefCalClick(Sender: TObject);
    procedure Menu_SelectParamFileClick(Sender: TObject);
    procedure rxAVRportdiagnostic1Click(Sender: TObject);
    procedure ProgrameTFTFlashMemory1Click(Sender: TObject);
    procedure I2Cbusdevices1Click(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure Versionhistory1Click(Sender: TObject);
    procedure Usefulfactsandhints1Click(Sender: TObject);
    procedure HocatandTrxAVRdownloadpage1Click(Sender: TObject);
    procedure GlennsTrxAVRpages1Click(Sender: TObject);
    procedure PeakreadingSWRmeterG3VPX1Click(Sender: TObject);
    procedure homebrewradiosyahoogroups1Click(Sender: TObject);
    procedure Feedbacksuggestions1Click(Sender: TObject);
    procedure Introduction1Click(Sender: TObject);
    procedure Initialsetup1Click(Sender: TObject);
    procedure DDSmode1Click(Sender: TObject);
    procedure DSPmode1Click(Sender: TObject);
    procedure DSPmonitor1Click(Sender: TObject);
    procedure CAT1Click(Sender: TObject);
    procedure Sourcecode1Click(Sender: TObject);
    procedure X1DDSmenuSummary1Click(Sender: TObject);
    procedure X2DSPmenusummary1Click(Sender: TObject);
    procedure X3Softwareblockdiagram1Click(Sender: TObject);
    procedure X4Stereosummary1Click(Sender: TObject);
    procedure X5colouredparameters1Click(Sender: TObject);
    procedure X7DSPOEMcommands1Click(Sender: TObject);
    procedure X8parameterremovereplace1Click(Sender: TObject);
    procedure X9Denoisertrimuntility1Click(Sender: TObject);
    procedure picaprojectyahoogroupscom1Click(Sender: TObject);
    procedure Menu_projectDBClick(Sender: TObject);
    procedure Menu_DatabaseClick(Sender: TObject);
    procedure homebrewradiosnet1Click(Sender: TObject);
    procedure Menu_RTCClick(Sender: TObject);
    procedure Menu_TftaI2CaddressClick(Sender: TObject);
    procedure Menu_UsrowClick(Sender: TObject);
  private
    com: string;
    ComportOk: boolean;
    NeedToGetVersion: boolean;
    MainDelayEvent: TEvent;
    procedure SetComPort(domsg: boolean);
    procedure GetTrxAVRStatus;
    procedure CloseUsb;
    procedure SendCodeParams;
    procedure SendCodeOnly;
    procedure SendParamsOnly;
    procedure ParamsDownload;
    procedure ClearUsbQueue;
    function CheckForStarFolder: boolean;
  public
    USBjob: TUSBjob;
    USBstate: array[status..paramsdown] of char;
    Terminating: boolean;
    procedure WebBrowser(url: string);
    procedure DoPTT;

  end;



var
  frmMain: TfrmMain;
  TrxAVRconnected : Boolean;
  TrxAVR_Serial_Number : String;
  TrxsAVR_Description : String;

implementation

uses UfrmCal, UfrmComSel, About, UfrmRtf, UfrmUpdate, UfrmCalswr,
     UfrmDebug, D2XXUnit, CfgUnit, UUsb, UfrmDSP, UfrmDDS,
  UfrmLoadCodeParams, UfrmLoadParams, UfrmLoadCode,
  UfrmDownloadParams, UfrmLoading, UfrmSelectStarDir, UfrmDirectDSP, UParams,
  UfrmDSPtelem, UfrmDDSclock, UfrmEEMEM, UfrmHardware, UfrmCalCurve,
  UfrmParamFile, UfrmPortDiagnostic, UfrmTFTflash, UfrmI2C, UfrmWeb,
  UfrmDatabase, UfrmDBpassword,UfrmRTC, UfrmTftA_I2Caddress, UfrmUsrow;

{$R *.dfm}

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Terminating := false;
  Usb := TUsb.Create;
//  Usb.usBusy := false;
  USBjob := status;
  Caption := ' HOBCAT';
  HtmlHelp.ChmFile := ExtractFilePath(Application.ExeName) + 'Hobcat.chm';
  EnsureIniFileIsRegistry;
  LoadMainCoordinates;
  with g_RegIniData do
  begin
    top := IniMainFormTop;
    left := IniMainFormLeft;
    height := IniMainFormHeight;
    width := IniMainFormWidth;
  end;
  LoadSwrCoordinates;
  LoadDebugCoordinates;
  LoadRegIniFile;
//  ErrorLogInit;
  LoadDebugIniData;
  ReadXjpIniData;
  LoadEememIniFile;
  Params := TParams.Create;
  ClearUsbQueue;
  NeedToGetVersion := true;
  MainDelayEvent := TEvent.Create(0, true, false, 'Hobcat frmMain delay event');
  if g_RegIniData.IniDspTelemetry = 0 then TelemMode := 'U' else TelemMode := 'S';
  Application.ProcessMessages;
  Timer_Startup.Enabled := true;
end;




procedure TfrmMain.WebBrowser(url: string);
begin
  if frmWeb = nil then frmWeb := TfrmWeb.Create(self);
  frmWeb.Initialise(url);
 // frmWeb.Show;
end;



procedure TfrmMain.SetComPort(domsg: boolean);
var
  s, com: string;
begin
  com := g_RegIniData.IniComPort;
  if com = 'none' then
  begin
    StarComPort.Active := false;
    ComportOk := false;
    Menu_DSP_Direct.Enabled := false;
    with RzStatusPane_COM.font do
    begin
      Style := [];
      Color := clRed;
      RzStatusPane_COM.caption := 'No COM port';
      exit;
    end;
  end;
  RzStatusPane_COM.caption := com;
  try
    with StarComport do
    begin
      Active := false;
      ComportOk := false;
      DeviceName := com;
      Timeouts.ReadConstant := 200;
      Active := true;
      ComportOk := true;
      Menu_DSP_Direct.Enabled := true;
      RzStatusPane_left.Font.Color := clBlack;
      with RzStatusPane_COM.font do
      begin
        Style := [];
        Color := clBlack;
      end;
    end;
  except
    StarComPort.Active := false;
    ComportOk := false;
    Menu_DSP_Direct.Enabled := false;
    s := 'Failed to open serial port ' + com + #13#10
      + 'This port may not exist on you computer' +  #13#10
      + 'If so please select another port or select ''none'''
      + #13#10 + '    Press OK:';
    MessageDlg(s,mtError,[mbOk],0);
      with RzStatusPane_COM.font do
      begin
        Style := [fsStrikeout];
        Color := clRed;
      end;
  end;
end;



procedure TfrmMain.Menu_AboutClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TfrmMain.FormShow(Sender: TObject);
begin
  AboutBox.Label_Version.Caption := 'Version: ' + g_HobcatVersion;
end;


procedure TfrmMain.CloseUsb;
begin
  RzStatusPane_left.caption := 'USB: ' + 'Main window USB connection closed';
  Application.ProcessMessages;
  Usb.usCloseConnection;
end;




procedure TfrmMain.GetTrxAVRStatus;
var
  UsbAlive: boolean;
  TrxAVRversion: string;
begin
  with Usb do
  begin
    if usTestStatus then
    begin
      UsbAlive := true;
      RzStatusPane_left.caption := 'USB: ' + usDeviceDescription
                                             + '  s/n: ' + usDeviceSerialNo;
    end
    else begin
      UsbAlive := false;
      TrxAVRversion := '';
      NeedToGetVersion := true;
      RzStatusPane_left.caption := 'USB: ' + 'TrxAVR not detected';
    end;
    if UsbAlive then
    begin
      g_UsbReady := true;
      if NeedToGetVersion then
      begin
        TrxAVRversion := usgetTrxAVRversion;
        if TrxAVRversion <> '' then
        begin
          with RzStatusPane_TrxAVR do
          begin
            Font.Color := clBlack;
            Caption := 'TrxAVR v' + TrxAVRversion +  ' ready';
            NeedToGetVersion := false
          end;
        end;
      end;
      Menu_DSP_EEPROM.Enabled := true;
      Menu_DDSclockOffsets.Enabled := true;
      Menu_LoadSaveEEMEM.Enabled := true;
      Menu_Hardware.Enabled := true;
      Menu_RTC.Enabled := true;
      Menu_TftaI2Caddress.Enabled := true;
      Menu_Usrow.Enabled := true;
      Menu_SWrcal.Enabled := true;
    end
    else begin
      NeedToGetVersion := true;
      ClearUsbQueue;
      g_UsbReady := false;
      RzStatusPane_TrxAVR.Caption := '';
      Menu_DSP_EEPROM.Enabled := false;
      Menu_DDSclockOffsets.Enabled := false;
      Menu_LoadSaveEEMEM.Enabled := false;
      Menu_Hardware.Enabled := false;
      Menu_RTC.Enabled := false;
      Menu_TftaI2Caddress.Enabled := false;
      Menu_Usrow.Enabled := false;
      Menu_SWrcal.Enabled := false;
    end;
  end;
end;

      
{
procedure TfrmMain.GetTrxAVRStatus;
begin
  with Usb do
  begin
    if usTestStatus then
    begin
      g_UsbReady := true;
      RzStatusPane_left.caption := 'USB: ' + usDeviceDescription
                                             + '  s/n: ' + usDeviceSerialNo;
      Menu_DSP_EEPROM.Enabled := true;
      Menu_StarFolder.Enabled := true;
      Menu_SelectParamFile.Enabled := true;
      Menu_DDSclockOffsets.Enabled := true;
      Menu_LoadSaveEEMEM.Enabled := true;
      Menu_Hardware.Enabled := true;
      Menu_SWrcal.Enabled := true;
    end
    else begin
      g_UsbReady := false;
      RzStatusPane_left.caption := 'USB: ' + 'TrxAVR not detected';
      Menu_DSP_EEPROM.Enabled := false;
      Menu_StarFolder.Enabled := false;
      Menu_SelectParamFile.Enabled := false;
      Menu_DDSclockOffsets.Enabled := false;
      Menu_LoadSaveEEMEM.Enabled := false;
      Menu_Hardware.Enabled := false;
      Menu_SWrcal.Enabled := false;
    end;
  end;
end;
}
procedure TfrmMain.Timer_USBstatusTimer(Sender: TObject);
begin
  if terminating then exit;
  USBstate[status] := 'W';
end;


procedure TfrmMain.Timer_StartupTimer(Sender: TObject);
var
  TimeString: string;
begin
  FT_Enable_Error_Report := False; // Turn off error dialog
  Timer_Startup.enabled := false;
  g_TempPath := ExtractFilePath(Application.ExeName) + 'Temp';
  if not DirectoryExists(g_TempPath) then CreateDir(g_TempPath);
  {File names are made unique to terminal by using application startup time hhmmsszzz
   where zzz is milliseconds.  }
  TimeString := FormatDateTime('hhmmsszzz',Now);
  g_TextFilePath := g_TempPath + '\' + 'DATA' + '_' + TimeString + '.RTF';
  Timer_USBstatus.enabled := true;
  setComport(true);
end;

procedure TfrmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Terminating := true;
  with g_RegIniData do
  begin
    IniMainFormLeft := left;
    IniMainFormTop := top;
    IniMainFormWidth := width;
    InimainFormHeight := height;
    SaveMainCoordinates;
  end;
  if frmCalSWR <> nil then frmCalSWR.Close;
  if frmDDS <> nil then frmDDS.Close;
  if frmDSP <> nil then frmDSP.Close;
  if frmDebug <> nil then frmDebug.Close;
end;


procedure TfrmMain.Menu_InternetUpdatesClick(Sender: TObject);
begin
  Timer_USBstatus.Enabled := false;
  Timer_USBqueue.Enabled := false;
  frmUpdate := TfrmUpdate.create(self);
  frmUpdate.Initialise(false);
  frmupdate.ShowModal;
  frmUpdate.Free;
  Timer_USBqueue.Enabled := true;
  Timer_USBstatus.Enabled := true;
end;

procedure TfrmMain.Menu_ExitClick(Sender: TObject);
begin
  Close;
end;




procedure TfrmMain.Menu_TileClick(Sender: TObject);
begin
  Tile;
end;

procedure TfrmMain.Menu_CascadeClick(Sender: TObject);
begin
  Cascade;
end;

procedure TfrmMain.Menu_ArrangeClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TfrmMain.RzBitBtn_DSPClick(Sender: TObject);
begin
  if not CheckForStarFolder then exit;
  if not Params.paInputParams then
  begin
    Free;
    exit;
  end;
  if frmDSP = nil then
  begin
    frmDSP := TfrmDSP.Create(self);
    frmDSP.Initialise;
  end;
  frmDSP.Show;
end;

procedure TfrmMain.RzBitBtn_DDSClick(Sender: TObject);
begin
  if frmDDS = nil then
  begin
    frmDDS := TfrmDDS.Create(self);
    frmDDS.Initialise;
  end;
  frmDDS.Show;
end;

procedure TfrmMain.RzBitBtn_DebugClick(Sender: TObject);
begin
  if frmDebug = nil then
  begin
    frmDebug := TfrmDebug.Create(self);
    frmDebug.Initialise;
  end;
  frmDebug.Show;
end;



function TfrmMain.CheckForStarFolder: boolean;
var
  s: string;
begin
  if not DirectoryExists(g_RegIniData.IniStarFolder) then
  begin
    s := 'Cannot find your Star folder :  ' + g_RegIniData.IniStarFolder;
    MessageDlg(s,MtWarning,[mbOk],0);
    result := false;
    exit;
  end;
  result := true;
end;

procedure TfrmMain.Menu_CodeParamsClick(Sender: TObject);
begin
  if not CheckForStarFolder then exit;
  frmMain.USBstate[codeparams] := 'W';
end;

procedure TfrmMain.SendCodeParams;
var
  mr: TModalResult;
begin
  frmLoadCodeParams := TfrmLoadCodeParams.create(self);
  frmLoadCodeParams.Initialise;
  mr := frmLoadCodeParams.ShowModal;
  frmLoadCodeParams.Free;
  if mr <> mrOk then exit;
  if frmLoading = nil then frmLoading := TfrmLoading.Create(self);
  frmLoading.Initialise(ToAVR,3);
  frmLoading.ShowModal;
  Application.ProcessMessages;
  frmLoading.Free;
  frmLoading := nil;
end;




procedure TfrmMain.Menu_ParamsOnlyClick(Sender: TObject);
begin
  if not CheckForStarFolder then exit;
  frmMain.USBstate[paramsonly] := 'W';
end;

procedure TfrmMain.SendParamsOnly;
var
  mr: TModalResult;
begin
  frmLoadParams := TfrmLoadParams.create(self);
  frmLoadParams.Initialise;
  mr := frmLoadParams.ShowModal;
  frmLoadParams.Free;
  if mr <> mrOk then exit;
  frmLoading := TfrmLoading.Create(self);
  frmLoading.Initialise(ToAVR,2);
  frmLoading.Showmodal;
  frmLoading.Free;
  frmLoading := nil;
end;



procedure TfrmMain.Menu_CodeOnlyClick(Sender: TObject);
begin
  if not CheckForStarFolder then exit;
  frmMain.USBstate[codeonly] := 'W';
end;


procedure TfrmMain.SendCodeOnly;
var
  mr: TModalResult;
begin
  frmLoadCode := TfrmLoadCode.create(self);
  frmLoadCode.Initialise;
  mr := frmLoadCode.ShowModal;
  frmLoadCode.Free;
  if mr <> mrOk then exit;
  frmLoading := TfrmLoading.Create(self);
  frmLoading.Initialise(ToAVR,1);
  frmLoading.Showmodal;
  frmLoading.Free;
  frmLoading := nil;
end;


procedure TfrmMain.Menu_UploadParamsClick(Sender: TObject);
begin
  if not CheckForStarFolder then exit;
  frmMain.USBstate[paramsdown] := 'W';
end;

procedure TfrmMain.ParamsDownload;
var
  mr: TModalResult;
begin
  frmDownloadParams := TfrmDownloadParams.create(self);
  frmDownLoadParams.Initialise;
  mr := frmDownLoadParams.ShowModal;
  frmDownLoadParams.Free;
  if mr <> mrOk then exit;
  frmLoading := TfrmLoading.Create(self);
  frmLoading.Initialise(ToAVR,4);
  frmLoading.Showmodal;
  frmLoading.Free;
end;

procedure TfrmMain.Menu_comselClick(Sender: TObject);
begin
  frmComSel := TfrmComSel.Create(self);
  frmComSel.Initialise;
  frmComSel.ShowModal;
  frmComSel.Free;
  SetComPort(true);
end;

procedure TfrmMain.Menu_StarFolderClick(Sender: TObject);
begin
  frmSelectStarDir := TfrmSelectStarDir.Create(self);
  frmSelectStarDir.Initialise;
  frmSelectStarDir.ShowModal;
  frmSelectStarDir.Free;
end;

procedure TfrmMain.Menu_DSP_directClick(Sender: TObject);
var
  mr: TModalResult;
begin
  if ComportOk = false then exit;
  frmDirectDSP := TfrmDirectDSP.create(self);
  frmDirectDSP.Initialise;
  mr := frmDirectDSP.ShowModal;
  frmDirectDSP.Free;
  if mr <> mrOk then exit;
  frmLoading := TfrmLoading.Create(self);
  frmLoading.Initialise(ToDSP,3);   // 3 = code and params
  frmLoading.Showmodal;
  frmLoading.Free;
end;

procedure TfrmMain.Menu_setupUSBClick(Sender: TObject);
begin
  SetupForm := TSetupForm.Create(self);
  SetupForm.ShowModal;
  SetupForm.Free;
end;

procedure TfrmMain.ClearUsbQueue;
var
  job: TUSBjob;
begin
  for job := status to paramsdown do USBstate[job] := 'X';
end;



procedure TfrmMain.DoPTT;
var
  Tx: boolean;
  buf: array[0..24] of byte;
begin
  Application.ProcessMessages;
  if TelemMode <> 'U' then exit;
  with Usb do
  begin
    Purge_USB_Device_In;
    usSendString('$$$DSP_T');   // T = telemetry
    MainDelayEvent.ResetEvent;
    MainDelayEvent.WaitFor(50);
    Application.ProcessMessages;
    Usb.usReceiveBlock(@buf[0],24);
  end;
  Tx := ((buf[4] AND $80)>0);
  Purge_USB_Device_In;
  if Tx                //  toggle MOX  so it transmitting swith to Rx
  then Usb.usSendString('$$$CTL_R')
  else Usb.usSendString('$$$CTL_T');
end;


procedure TfrmMain.Timer_USBqueueTimer(Sender: TObject);
var
  FirstJob: TUSBjob;
  js: char;
  done: boolean;
begin
  if not Usb.usDeviceOpenAndOk then USBjob := status;
  Timer_USBqueue.enabled := false;
  FirstJob := USBjob;
  done := false;
  repeat
    js := USBstate[USBjob];
    if js = 'W' then
    begin
      USBstate[USBjob] := 'X';
      done := true;
      case USBjob of
        status:       GetTrxAVRStatus;
        readrtc:        if frmRTC <> nil then frmRTC.DoReadRTC;
        readtftad:      if frmTftA_I2Caddress <> nil then frmTftA_I2Caddress.DoReadI2Caddress;
        writetftad:     if frmTftA_I2Caddress <> nil then frmTftA_I2Caddress.DoWriteI2Caddress;
        readusrow0to15: if frmUsrow <> nil then frmUsrow.DoReadUsrowBytes0to15;
        writeusrow:     if frmUsrow <> nil then frmUsrow.DoWriteUsrowByte;
        setrtc:         if frmRTC <> nil then frmRTC.DoSetRTC;
        getslots:       if frmDDS <> nil then frmDDS.GetSlotsUpdate;
        tr:             if frmDDS <> nil then DoPTT;
        setfreq:        if frmDDS <> nil then frmDDS.SendFreq;
        ddsbutton:      if frmDDS <> nil then frmDDS.SendButtonChange;
        eesave:         if frmEEMEM <> nil then frmEEMEM.SaveEEMEM;
        eeload:         if frmEEMEM <> nil then frmEEMEM.LoadEEMEM;
        ddsclk:         if frmDDSclock <> nil then frmDDSclock.SendDDSclock;
        lsboffs:        if frmDDSclock <> nil then frmDDSclock.SendUSBoffset;
        usboffs:        if frmDDSclock <> nil then frmDDSclock.SendLSBoffset;
        cwoffs:         if frmDDSclock <> nil then frmDDSclock.SendCWoffset;
        adc:            if frmCalswr <> nil then frmCalswr.GetADC;
        debug:          if frmDebug <> nil then frmDebug.RequestDebugData;
        cal:            if frmCal <> nil then frmCal.SendCal;
        telem:          if frmDSP <> nil then frmDSP.ReceiveTelemetry;
        ad603:          if frmCalCurve <> nil then frmCalCurve.SendCalCurve;
        ad5321w:        frmI2C.PA3AKE_SendDAC;
        ad5321r:        frmI2C.PA3AKE_ReadDACs;
        paramcol:       if frmDSP <> nil then frmDSP.SendParamColour;
        oneparam:       if frmDSP <> nil then frmDSP.SendOneTrxAVRParam;
        diagwrite:      if frmPortDiagnostic <> nil then frmPortDiagnostic.WritePorts;
        diagread:       if frmPortDiagnostic <> nil then frmPortDiagnostic.ReadPorts;
        codeonly:       SendCodeOnly;
        tftflash:       if frmTFTflash <> nil then frmTFTFlash.SendBytes;
        paramsonly:     SendParamsOnly;
        codeparams:     SendCodeParams;
        paramsdown:     ParamsDownload;
        hwread:         if frmHardware <> nil then frmHardware.ReadHardware;
        hwwrite:        if frmHardware <> nil then frmHardware.WriteHardware;
        dspgetall:      if frmDSP <> nil then frmDSP.ReadTrxavrParams;
        dsp254:         if frmDSP <> nil then frmDSP.Read254;
        dspswrcal:      if frmDSP <> nil then frmDSP.GetSwrCalFromUSB;
        ddsswrcal:      if frmDDS <> nil then frmDDS.GetSwrCalFromUSB;
        ddsswrdata:     if frmDDS <> nil then frmDDS.ReceiveSwrDataFromUSB;
        setfout:        if frmRTC <> nil then frmRTC.DoSetFout;
        readfout:       if frmRTC <> nil then frmRTC.DoReadFout;
        setatr:         if frmRTC <> nil then frmRTC.DoSetATR;
        readatr:        if frmRTC <> nil then frmRTC.DoReadATR;
        setaging:       if frmRTC <> nil then frmRTC.DoSetAging;
        readaging:      if frmRTC <> nil then frmRTC.DoReadAging;
        setoffs:        if frmRTC <> nil then frmRTC.DoSetOffset;
        readoffs:       if frmRTC <> nil then frmRTC.DoReadOffset;
        hwreadrtc:      if frmRTC <> nil then frmRTC.DoReadHardware;
        parambk:        if frmDSP <> nil then frmDSP.SetParamToBackup;
        paramstobk:     if frmDSP <> nil then frmDSP.CopyParamsToBackup;
      end; { case }
    end;
    inc(USBjob);
    if USBjob > paramsdown then USBjob := status;
  until done OR (USBjob = FirstJob);
  Timer_USBqueue.enabled := true;
end;

procedure TfrmMain.DSPUSBCOM1Click(Sender: TObject);
begin
  frmDSPtelem := TfrmDSPtelem.Create(self);
  frmDSPtelem.Initialise;
  frmDSPtelem.ShowModal;
  frmDSPtelem.Free;
end;

procedure TfrmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if frmDSP <> nil then frmDSP.Close;
end;

procedure TfrmMain.Menu_DDSclockOffsetsClick(Sender: TObject);
begin
  frmDDSclock := TfrmDDSclock.Create(self);
  frmDDSclock.Initialise;
  frmDDSClock.Show;
//  frmDDSclock.Free;
end;

procedure TfrmMain.Menu_LoadSaveEEMEMClick(Sender: TObject);
var
  path: string;
  nc: byte;
begin
  if not CheckForStarFolder then exit;
  path := g_RegIniData.IniStarFolder;
  nc := Length(path);
  if path[nc] <> '\' then path := Path + '\';
  path := path + 'TrxAvrEEMEM.ini';
//  if not FileExists(path) then
//  begin
//    MessageDlg('Cannot find:   ' + path,mtWarning,[mbOk],0);
//    exit;
//  end;
  frmEEMEM := TfrmEEMEM.Create(self);
  frmEEMEM.Initialise;
  frmEEMEM.Show;
//  frmEEMEM.Free;
end;

procedure TfrmMain.Menu_hardwareClick(Sender: TObject);
begin
  frmHardware := TfrmHardware.Create(self);
  frmHardware.Initialise;
  frmHardware.ShowModal;
  frmHardware.Free;
end;

procedure TfrmMain.AD603calibrationtoTrxAVR1Click(Sender: TObject);
begin
  if not CheckForStarFolder then exit;
  frmCalCurve := TfrmCalCurve.Create(self);
  frmCalCurve.Initialise;
  frmCalCurve.ShowModal;
  frmCalCurve.Free;
end;

procedure TfrmMain.Menu_CalSummaryClick(Sender: TObject);
begin
  frmRtf := TfrmRtf.Create(self);
  frmRtf.Initialise;
  frmRtf.ShowModal;
  frmRtf.Free;
end;

procedure TfrmMain.Menu_FwdCalClick(Sender: TObject);
begin
  frmCal := TfrmCal.Create(self);
  frmCal.CalKind := fwd;
  frmCal.Initialise;
  frmCal.ShowModal;
  frmCal.Free;
end;

procedure TfrmMain.Menu_RefCalClick(Sender: TObject);
begin
  frmCal := TfrmCal.Create(self);
  frmCal.CalKind := ref;
  frmCal.Initialise;
  frmCal.ShowModal;
  frmCal.Free;
end;

procedure TfrmMain.Menu_SelectParamFileClick(Sender: TObject);
var
  mr: TModalResult;
begin
  frmParamFile := TfrmParamFile.Create(self);
  frmParamFile.Initialise;
  mr := frmParamFile.ShowModal;
  frmParamFile.Free;
end;  

procedure TfrmMain.rxAVRportdiagnostic1Click(Sender: TObject);
begin
  frmPortDiagnostic := TfrmPortDiagnostic.Create(self);
  frmPortDiagnostic.Initialise;
  frmPortDiagnostic.ShowModal;
  frmPortDiagnostic.Free;
end;

procedure TfrmMain.ProgrameTFTFlashMemory1Click(Sender: TObject);
begin
   frmTFTflash := TfrmTFTflash.Create(self);
  frmTFTflash.initialise;
  frmTFTflash.ShowModal;
  frmTFTflash.Free;
end;

procedure TfrmMain.I2Cbusdevices1Click(Sender: TObject);
begin
  frmI2C := TfrmI2C.Create(self);
  frmI2C.Initialise;
  frmI2C.ShowModal;
  frmI2C.Free;
end;

procedure TfrmMain.Help2Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/trxavr_picastar.htm');
end;

procedure TfrmMain.Versionhistory1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/trxavr_versions.htm');
end;

procedure TfrmMain.Usefulfactsandhints1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/Useful.htm');
end;

procedure TfrmMain.HocatandTrxAVRdownloadpage1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/trxavr_downloads.htm');
end;

procedure TfrmMain.GlennsTrxAVRpages1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.carnut.info/star-parts/TrxAVR_interface_pcb/Trxavrb-build_1.htm');
end;

procedure TfrmMain.PeakreadingSWRmeterG3VPX1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.g3vpx.net/peakswr/peakswr.htm');
end;

procedure TfrmMain.homebrewradiosyahoogroups1Click(Sender: TObject);
begin
  frmMain.WebBrowser('http://groups.yahoo.com/group/homebrew-radios/');
end;

procedure TfrmMain.Feedbacksuggestions1Click(Sender: TObject);
begin
  frmMain.WebBrowser('http://www.homebrew-radios.net/trxavr_picastar/feedback.php');
end;

procedure TfrmMain.Introduction1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/ch1.pdf');
end;

procedure TfrmMain.Initialsetup1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/ch2.pdf');
end;

procedure TfrmMain.DDSmode1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/ch3.pdf');
end;

procedure TfrmMain.DSPmode1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/ch4.pdf');
end;

procedure TfrmMain.DSPmonitor1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/ch5.pdf');
end;

procedure TfrmMain.CAT1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/ch6.pdf');
end;

procedure TfrmMain.Sourcecode1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/ch7.pdf');
end;

procedure TfrmMain.X1DDSmenuSummary1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/x1.pdf');
end;

procedure TfrmMain.X2DSPmenusummary1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/x2.pdf');
end;

procedure TfrmMain.X3Softwareblockdiagram1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/x3.pdf');
end;

procedure TfrmMain.X4Stereosummary1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/x4.pdf');
end;

procedure TfrmMain.X5colouredparameters1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/x6.pdf');
end;

procedure TfrmMain.X7DSPOEMcommands1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/x7.pdf');
end;

procedure TfrmMain.X8parameterremovereplace1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/x8.pdf');
end;

procedure TfrmMain.X9Denoisertrimuntility1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/trxavr_picastar/picastar_manual/x9.pdf');
end;

procedure TfrmMain.picaprojectyahoogroupscom1Click(Sender: TObject);
begin
  frmMain.WebBrowser('http://uk.groups.yahoo.com/group/picaproject/');
end;

procedure TfrmMain.Menu_projectDBClick(Sender: TObject);
var
  mr: TModalResult;
begin
  frmDBpassword := TfrmDBpassword.Create(self);
  frmDBpassword.ShowModal;
  mr := frmDBpassword.ModalResult;
  frmDBpassword.Free;
  if mr = mrOk then
  begin
    if frmDatabase = nil then frmDatabase := TfrmDatabase.Create(self);
    frmDatabase.Show;
    frmDatabase.Initialise;
  end;
end;

procedure TfrmMain.Menu_DatabaseClick(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net/database/database_login.php');
end;

procedure TfrmMain.homebrewradiosnet1Click(Sender: TObject);
begin
  frmMain.WebBrowser('www.homebrew-radios.net');
end;

procedure TfrmMain.Menu_RTCClick(Sender: TObject);
begin
  frmRTC := TfrmRTC.Create(self);
  frmRTC.Initialise;
  frmRTC.ShowModal;
  frmRTC.Free;
end;

procedure TfrmMain.Menu_TftaI2CaddressClick(Sender: TObject);
begin
  frmTftA_I2Caddress := TfrmTftA_I2Caddress.Create(self);
  frmTftA_I2Caddress.Initialise;
  frmTftA_I2Caddress.ShowModal;
  frmTftA_I2Caddress.Free;
end;

procedure TfrmMain.Menu_UsrowClick(Sender: TObject);
begin
  frmUsrow := TfrmUsrow.Create(self);
  frmUsrow.Initialise;
  frmUsrow.ShowModal;
  frmUsrow.Free;
end;

end.
