unit UfrmLoading;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UGlobals, RzButton, SyncObjs, StdCtrls, RzLabel, ExtCtrls;

type


  FilterFileInfo_type
     =  record
          ffiFileName: string;
          ffiComments: string;
          ffiAddress: word;
        end;


  TfrmLoading = class(TForm)
    RzBitBtn_Exit: TRzBitBtn;
    RzLabel_bytes1: TRzLabel;
    Timer_LoadingStart: TTimer;
    RzLabel_bytes2: TRzLabel;
    RzLabel_checksum: TRzLabel;
    RzLabel_Checksum_PC: TRzLabel;
    RzLabel_Checksum_AVR: TRzLabel;
    RzLabel_bytes3: TRzLabel;
    RzLabel_bytes4: TRzLabel;
    procedure FormShow(Sender: TObject);
    procedure Timer_LoadingStartTimer(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    DSPfilename: string;
    FilterFilename: string;
    TextFile: text;
    buf: array[0..40000] of byte;
    block: array[0..32000] of byte;
    pbuf: word;
    pblock: word;
    checksum: integer;
    cka, ckb, ckc: byte;
//    CalCurve: array[0..46] of byte;
    FilterFileInfo: array[1..7] of FilterFileInfo_type;
    nff: byte;
    s: string;
    ComDelayEvent: TEvent;
    DspAvr: Topt;
    DoCode: boolean;
    DoParams: boolean;
    DoDownload: boolean;
    SendChecksum: longint;
    RecCheckSum: word;
    procedure UpdateChecksum;
    function HexToBinary(s: string): byte;
    function SendParamsOnly: boolean;
    function SendCodeAndParams(tw: Topt): boolean;
    function  DoBlock: Topt;
    procedure ParseThree(s: string; var sa,sb,sc: string);
    procedure LoadCoeffs(ff: byte);
    procedure LoadChecksum;
    procedure TransmitRS232char(ch: char);
    procedure StringToRS232(s: string);
    procedure DSPcommandRS232(p,v: byte);
    procedure DownloadParams;
  public
    procedure Initialise(tw: Topt; wot: byte);
  end;

const
  RS232ToTestFile: boolean = false;


var
  frmLoading: TfrmLoading;

implementation

{$R *.dfm}

uses UIniData, UfrmMain, UUsb, UParams, UfrmDebug, D2XXUnit;

procedure TfrmLoading.Initialise(tw: Topt; wot: byte);
var
  path: string;
  nc: byte;
begin
  Application.ProcessMessages;
  Docode := ((wot AND $01) <> 0);
  DoParams := ((wot AND $02) <> 0);
  DoDownload := ((wot AND $04) <> 0);
  RzBitBtn_Exit.enabled := false;
  DspAvr := tw;
  if tw = ToAVR then
  begin
    if wot < 4
    then caption := 'Data to TrxAVR EEPROM via USB'
    else caption := 'Download params from TrxAVR to PC default';
  end
  else caption := 'Data to DSP via ' + g_RegIniData.IniComPort;
 try
  ReadXjpIniData;
 except hcerr(51,'','',0,0,0,0); end;
  path := g_RegIniData.IniStarFolder;
  nc := Length(path);
  if path[nc] <> '\' then path := Path + '\';
  DSPFilename := path + g_XJPIniData.IniDSPfile;
  FilterFilename := path + 'Filters\filters.xjp';
end;


// assumes two character hex number
function TfrmLoading.HexToBinary(s: string): byte;
var
  a,b: byte;
begin
  a := ord(s[1]);
  if a >64 then a := a-55 else a := a-48;
  b := ord(s[2]);
  if b >64 then b := b-55 else b := b-48;
  result := a*16 + b;
end;



procedure TfrmLoading.UpdateChecksum;
begin
  checksum := checksum + 256*cka;
  while checksum > 32767 do checksum := checksum - 32768;
  checksum := checksum + ckb;
  while checksum > 32767 do checksum := checksum - 32768;
  checksum := checksum + ckc;
  while checksum > 32767 do checksum := checksum - 32768;
end;


function  TfrmLoading.DoBlock: Topt;
var
  xa: word;  // QB:    x&
  ds: string;
  Lspa: boolean;
  divert: boolean;
  ad1, ad2: byte;
  y,z: integer;
  i: word;
begin
  pblock := 0;
  xa:= 0;
  try ReadLn(TextFile, s);  except hcerr(17,'','',0,0,0,0); end;
  if s[1] = #27 then
  begin
    result := esc;
    exit;
  end;
  Lspa := (s = '@PA');  // QB: L$ = "$DA"
  if Lspa then ds := '$DP' else ds := '$DD';
  try ReadLn(TextFile, s);  except hcerr(8,'','',0,0,0,0); end;
  ad1 := HexToBinary(Copy(s,1,2));
  ad2 := HexToBinary(Copy(s,3,2));
  divert :=  ((ds = '$DP') AND (ad1=0) AND (ad2=0));
  repeat
    ReadLn(TextFile, s);
    if s[1] <> '#' then
    begin
      cka := HexToBinary(Copy(s,1,2));
      block[pblock] := cka;
      inc(pblock);
      if not Lspa then
      begin         //  - only 2 bytes - dont think this happens
        ckc := HexToBinary(Copy(s,3,2));   // would screw up checksum as ckb undefined
        block[pblock] := ckc;
        inc(pblock);
      end
      else begin
        ckb := HexToBinary(Copy(s,3,2));
        block[pblock] := ckb;
        inc(pblock);
        ckc := HexToBinary(Copy(s,5,2));
        block[pblock] := ckc;
        inc(pblock);
      end;
      UpdateChecksum;
      inc(xa);
    end;
  until s[1] = '#';
  if divert then     //  QB:   send
  begin
    buf[pbuf] := ord('$'); inc(pbuf);
    buf[pbuf] := ord('D'); inc(pbuf);
    buf[pbuf] := ord('P'); inc(pbuf);
    buf[pbuf] := 63;  inc(pbuf);    // divert to adddress $3FCO (63 192)
    buf[pbuf] := 192; inc(pbuf);
    buf[pbuf] := 0;   inc(pbuf);    // force no of words to 48
    buf[pbuf] := 48;  inc(pbuf);
    for i := 0 to 48*3 - 1 do       // 48 words at 3 bytes per word
    begin
      buf[pbuf] := block[i];
      inc(pbuf);
    end;
    xa := xa - 48;
    buf[pbuf] := ord('$'); inc(pbuf);
    buf[pbuf] := ord('D'); inc(pbuf);
    buf[pbuf] := ord('P'); inc(pbuf);
    buf[pbuf] := 0;  inc(pbuf);
    buf[pbuf] := 48; inc(pbuf);
    y := xa DIV 256;    // QB: label : send2
    z := xa MOD 256;
    buf[pbuf] := y;
    inc(pbuf);
    buf[pbuf] := z;
    inc(pbuf);
    for i := 48*3 to pblock-1 do
    begin
      buf[pbuf] := block[i];
      inc(pbuf);
    end;
    inc(pbuf); ////////////////////////////
  end
  else begin
    for i := 1 to 3 do
    begin
      buf[pbuf] := ord(ds[i]);
      inc(pbuf);
    end;
    buf[pbuf] := ad1;
    inc(pbuf);
    buf[pbuf] := ad2;
    inc(pbuf);
    y := xa DIV 256;    // QB: label : send2
    z := xa MOD 256;
    buf[pbuf] := y;
    inc(pbuf);
    buf[pbuf] := z;
    inc(pbuf);
    for i := 0 to pblock-1 do
    begin
      buf[pbuf] := block[i];
      inc(pbuf);
    end;
  end;
  result := bok;
end;


procedure TfrmLoading.ParseThree(s: string; var sa,sb,sc: string);
var
  p: byte;
begin
 try
  p :=Pos(',',s);
  sa := Trim(Copy(s,1,p-1));
  s := Copy(s,p+1,255);
  p :=Pos(',',s);
  sb := Trim(Copy(s,1,p-1));
  sc := Trim(Copy(s,p+1,255));
 except hcerr(35,'','',0,0,0,0); end;
end;



procedure TfrmLoading.DownLoadParams;
begin
  RzLabel_bytes1.Caption := 'Uploading parameters from TrxAVR';
  RzLabel_bytes1.Show;
  Purge_USB_Device_In;
  Usb.usSendString('$$$DSP_S');
  if Params.paParamsFromAVR then
  begin
    Rzlabel_Checksum.Caption := 'DSP params received ok';
    RzLabel_bytes2.Caption := 'Params saved to: ' + Params.paUser2B2XjpFilename;
    RzLabel_bytes3.Caption := '        and : ' + Params.paXparamsXjpFilename;
    RzLabel_bytes4.Caption := '        and : ' + Params.paXparamsDatFilename;
    RzLabel_bytes2.Show;
    RzLabel_bytes3.Show;
  end
  else RzLabel_Checksum.Caption := 'DSP params reception failed';
  RzLabel_Checksum.Show;
  RzBitBtn_Exit.enabled := true;
end;


function TfrmLoading.SendParamsOnly: boolean;
begin
  RzLabel_bytes1.Caption := 'Sending default parameters to TrxAVR';
  RzLabel_bytes1.Show;
  Purge_USB_Device_In;
  Usb.usSendString('$$$DSP_P');
  if Params.paParamsToAVR
  then Rzlabel_bytes2.Caption := 'DSP params sent ok'
  else RzLabel_bytes2.Caption := 'DSP params transmission failed';
  RzLabel_bytes2.Show;
  RzBitBtn_Exit.enabled := true;
end;



function TfrmLoading.SendCodeAndParams(tw: Topt): boolean;
var
  i: word;
  ff: byte;
  b: byte;
  s,sa,sb,sc: string;
  HeaderFail: boolean;
  SendOk: boolean;
  bk, remaining, bksz: word;
  codedone: boolean;
begin
  result := true;
  ///////   DSP program code //////////////
  pbuf := 0;
  checksum := 0;
  case tw of
    ToAVR:
       begin
         for i := 0 to 12 do buf[i] := ord('#');
         buf[13] := ord('x');
         pbuf := 14;
       end;
    ToDSP:
       begin
         for i := 0 to 2 do buf[i] := ord('$');
         buf[3] := 13;
         pbuf := 4;
       end;
  end; {case }
  if not FileExists(DSPfilename) then
  begin
    s := 'Cannot find your DSP code file:  ' + DSPfilename;
    MessageDlg(s,mtWarning,[mbOk],0);
    result := false;
    exit;
  end;
  AssignFile(TextFile,DSPfilename);
  Reset(TextFile);
  ReadLn(TextFile, s); //   ignore first line
  repeat until DoBlock = esc;   //  *** DoBlock puts the DSP code in the buffer
  closeFile(TextFile);
  //////////////////////////////
  //// filters /////////
  if not FileExists(FilterFilename) then
  begin
    s := 'Cannot find your Filter code file:  ' + FilterFilename;
    MessageDlg(s,mtWarning,[mbOk],0);
    result := false;
    exit;
  end;
  AssignFile(TextFile,FilterFilename);
  Reset(TextFile);
  nff := 0;  // no of filter files
  while not Eof(TextFile) do
  begin
    inc(nff);
    Readln(Textfile, s);
    ParseThree(s,sa,sb,sc);
    if sa = 'decint.dat' then
    begin
      if Uppercase(Copy(DSPfilename,1,2)) = 'EZ' then sa := 'EZ' + sa;
    end;
    FilterFileInfo[nff].ffiFileName := sa;
    FilterFileInfo[nff].ffiComments := sb;
    FilterFileInfo[nff].ffiAddress := 256*HexToBinary(Copy(sc,1,2)) + HexToBinary(Copy(sc,3,2));
  end;
  CloseFile(TextFile);
  for ff := 1 to nff do LoadCoeffs(ff);   //  put the filters in the buffer
  LoadChecksum;     //  add $DP  .. checksum on end of code + filters
  for i := pbuf to pbuf+6 do buf[i] := ord('#');
  pbuf := pbuf + 7;

//////////////////////   TRANSMIt to TxrAVR //////////
  Rzlabel_bytes1.Caption := 'bytes:  ';
  case tw of
    ToAVR:
       begin
//         Usb.usbusy := true;
         RzLabel_bytes1.Show;
         ComDelayEvent := TEvent.Create(0, true, false, 'Hobcat RS232 DSP load delay event');
         HeaderFail := false;
         if DoCode then
         begin
           SendChecksum := 0;
           for i := 0 to pbuf-1 do SendChecksum := (SendChecksum + buf[i]) MOD $10000;
           SendChecksum := (SendChecksum + pbuf) MOD $10000;
           Purge_USB_Device_In;
           if Usb.usSendString('$$$DSP_C') = false
           then HeaderFail := true
           else begin
             block[0] := pbuf DIV 256;
             block[1] := pbuf MOD 256;
             if Usb.usSendBlock(@block,2) = false     //  sent byte count
             then HeaderFail := true
             else begin  // send byte count
               bk := 0;
               codedone := false;
               repeat
                 remaining := pbuf - bk;
                 if remaining >= 64 then
                 begin
                   for i := 0 to 63 do block[i] := buf[bk+i];
                   bk := bk + 64;
                   bksz := 64;
                   if remaining = 64 then codedone := true;
                 end
                 else begin
                   for i := 0 to remaining - 1 do block[i] := buf[bk+i];
                   for i := remaining to 63 do block[i]:= 0;
                   codedone := true;
                   bksz := remaining;
                 end;
                 Usb.usSendBlock(@block[0],bksz);
                 ComDelayEvent.ResetEvent;   // experimnetation for slower PCs / ? USB1
                 ComDelayEvent.WaitFor(10);
                 RzLabel_bytes1.Caption := 'bytes:  ' + IntToStr(bk);
                 Application.ProcessMessages;
               until codedone;
               if codedone
               then Rzlabel_bytes1.Caption := 'DSP code: ' + IntToStr(pbuf) + ' bytes sent'
               else RzLabel_bytes1.Caption := 'DSP code transmission by USB failed';
             end;
           end;
           ComDelayEvent.ResetEvent;
           ComDelayEvent.WaitFor(10);
           Usb.usReadWord(RecChecksum);
         end;
         if DoParams then
         begin
           Purge_USB_Device_In;
           Usb.usSendString('$$$DSP_P');
           if Params.paParamsToAVR
           then Rzlabel_bytes2.Caption := 'DSP params sent ok'
           else RzLabel_bytes2.Caption := 'DSP params transmission failed';
           RzLabel_bytes2.Show;
         end;
//         Usb.usbusy := false;
         if HeaderFail then RzLabel_bytes1.Caption := 'DSP header transmission by USB failed';
         RzLabel_bytes1.Show;
         if codedone then
         begin
           RzLabel_Checksum_PC.Caption :=  'Checksum on code bytes as sent from PC  =  '
                                               + IntToStr(SendChecksum);
           RzLabel_Checksum_AVR.Caption := 'Checksum on code bytes as received by TxrAVR  =  '
                                               + IntToStr(RecChecksum);
           RzLabel_Checksum.Show;
           RzLabel_Checksum_PC.Show;
           RzLabel_Checksum_AVR.Show;
         end;
         ComDelayEvent.Free;
       end;
    ToDSP:
       begin
         if DoCode then
         begin
           RzLabel_bytes1.Show;
           ComDelayEvent := TEvent.Create(0, true, false, 'Hobcat RS232 DSP load delay event');
           frmMain.StarComport.Open;
           DSPcommandRS232(111,0);  // reset
           for i := 0 to pbuf - 1 do
           begin
             b := buf[i];
             if b = ord('$') then
             begin
               ComDelayEvent.ResetEvent;
               ComDelayEvent.WaitFor(20);
             end;
             if i MOD 100 = 0 then  RzLabel_bytes1.Caption := 'bytes:  ' + IntToStr(i);
             Application.ProcessMessages;
             TransmitRS232char(Chr(b));
           end;
           RzLabel_bytes1.Caption := 'DSP codes: ' + IntToStr(pbuf) + ' bytes send to DSP.';
           ComDelayEvent.ResetEvent;
           ComDelayEvent.WaitFor(100);
           StringToRS232('$GO' + #0 + #0 + #13);
           ComDelayEvent.ResetEvent;
           ComDelayEvent.WaitFor(100);
           frmMain.StarComPort.Close;
           ComDelayEvent.Free;
         end;
         if DoParams then
         begin
           Params.paParamsToDSP;
           RzLabel_bytes2.Caption := 'Params sent to DSP';
           RzLabel_bytes2.Show;
         end;
       end;
  end; //case
  RzBitBtn_Exit.enabled := true;
end;



procedure TfrmLoading.TransmitRS232char(ch: char);
begin
 frmMain.StarComPort.WriteChar(ch);
end;


procedure TfrmLoading.StringToRS232(s: string);
var
  i: byte;
begin
  for i := 1 to Length(s) do TransmitRS232char(s[i]);
end;



procedure TfrmLoading.DSPcommandRS232(p,v: byte);
begin
  TransmitRS232char('~');
  TransmitRS232char(Chr(p));
  TransmitRS232char(Chr(v));
  ComDelayEvent.ResetEvent;
  ComDelayEvent.WaitFor(30);
end;


procedure TfrmLoading.LoadCoeffs(ff: byte);
var
  addr: word;
  coeffs: byte;
  i: word;
begin
  fillchar(block,sizeof(block),0);
  try addr := FilterFileInfo[ff].ffiAddress;  except hcerr(44,'','',0,0,0,0); end;
 try
  AssignFile(Textfile,g_RegIniData.IniStarFolder + '\Filters\' + FilterFileInfo[ff].ffiFileName);
  Reset(TextFile);
 except hcerr(45,FilterFileInfo[ff].ffiFileName,'',ff,0,0,0); end;
  buf[pbuf] := ord('$'); inc(pbuf);
  buf[pbuf] := ord('D'); inc(pbuf);
  buf[pbuf] := ord('P'); inc(pbuf);
  buf[pbuf] := addr DIV 256;  inc(pbuf);
  buf[pbuf] := addr MOD 256; inc(pbuf);
  pblock := 0;
  coeffs := 0;
  while not Eof(TextFile) do
  begin
    inc(coeffs);
    ReadLn(Textfile,s);
    if Length(s) < 6 then break;
    cka := HexToBinary(Copy(s,1,2));
    block[pblock] := cka;
    inc(pblock);
    ckb := HexToBinary(Copy(s,3,2));
    block[pblock] := ckb;
    inc(pblock);
    ckc := HexToBinary(Copy(s,5,2));
    block[pblock] := ckc;
    inc(pblock);
    UpdateChecksum;
  end;
  buf[pbuf] := 0;  inc(pbuf);
  buf[pbuf] := coeffs;  inc(pbuf);
  for i := 0 to pblock - 1 do
  begin
    buf[pbuf] := block[i];
    inc(pbuf);
  end;
  CloseFile(TextFile);
end;


procedure TfrmLoading.LoadChecksum;
begin
  // Load checksum at $37FE
  buf[pbuf] := ord('$'); inc(pbuf);
  buf[pbuf] := ord('D'); inc(pbuf);
  buf[pbuf] := ord('P'); inc(pbuf);
  buf[pbuf] := $37;   inc(pbuf);    // address
  buf[pbuf] := $FE;   inc(pbuf);
  buf[pbuf] := $00;   inc(pbuf);    // no off words = 1
  buf[pbuf] := $01;   inc(pbuf);
  buf[pbuf] := checksum DIV 256; inc(pbuf);    // checksum data
  buf[pbuf] := checksum MOD 256; inc(pbuf);
  buf[pbuf] := $00;              inc(pbuf);
  buf[pbuf] := $0D;              inc(pbuf);
end;



procedure TfrmLoading.FormShow(Sender: TObject);
begin
  Timer_LoadingStart.Enabled := true;
end;

procedure TfrmLoading.Timer_LoadingStartTimer(Sender: TObject);
begin
  Timer_LoadingStart.Enabled := false;
  Application.ProcessMessages;
  if DoCode then
  begin
    if not SendCodeAndParams(DspAvr) then ModalResult := mrAbort;
  end
  else begin
    if DoParams then SendParamsOnly
    else begin
      if DoDownload then DownLoadParams;
    end;
  end;
  Application.ProcessMessages;
end;

procedure TfrmLoading.RzBitBtn_ExitClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;


procedure TfrmLoading.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  //ComDelayEvent.Free;
end;

end.
