unit UfrmEEMEM;

interface
                                              
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RzLabel, RzButton, Syncobjs, D2XXUnit;

type
  TfrmEEMEM = class(TForm)
    RzBitBtn_Save: TRzBitBtn;
    RzBitBtn_Load: TRzBitBtn;
    RzLabel1: TRzLabel;
    RzLabel2: TRzLabel;
    RzLabel3: TRzLabel;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    RzLabel6: TRzLabel;
    RzLabel7: TRzLabel;
    RzBitBtn_Help: TRzBitBtn;
    RzBitBtn_Exit: TRzBitBtn;
    RzLabel8: TRzLabel;
    RzLabel9: TRzLabel;
    procedure RzBitBtn_SaveClick(Sender: TObject);
    procedure RzBitBtn_LoadClick(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure RzBitBtn_HelpClick(Sender: TObject);
  private
    block: array[0..128] of byte;
    EememDelayEvent: TEvent;
    procedure Set32Bit(n: longint; p: byte);
    function Get32Bit(p: byte): longint;
    procedure BandLastToIni;
    procedure BandSSBtoIni;
    procedure BandCWtoIni;
    procedure MemStack67ToIni;
    procedure MemStack68ToIni;
    procedure MemStack69ToIni;
    procedure MemStack60ToIni;
    procedure VFOStackToIni;
    procedure IniToBandLast;
    procedure IniToBandSSB;
    procedure IniToBandCW;
    procedure IniToMemStack67;
    procedure IniToMemStack68;
    procedure IniToMemStack69;
    procedure IniToMemStack60;
    procedure IniToVfoStack;
    procedure IniToIC2ButtonTaskData;
    procedure IniToIC2ButtonTaskLabels;
    procedure IniToIC2;
    procedure IC2ButtonTaskDataToIni;
    procedure IC2ButtonTaskLabelsToIni;
    procedure IC2ToIni;

  public
    procedure Initialise;
    procedure SaveEEMEM;
    procedure LoadEEMEM;
    function DoLoadEEMEM: boolean;
    function DoSaveEEMEM: boolean;
  end;

const LoadBlockDelay = 1000;
const SaveBlockDelay = 300;

var
  frmEEMEM: TfrmEEMEM;

implementation

uses UfrmMain, UIniData,UUsb;

{$R *.dfm}


procedure TfrmEEMEM.Initialise;
begin
  EememDelayEvent := TEvent.Create(0, true, false, 'Hobcat CFG delay event');
end;


procedure TfrmEEMEM.RzBitBtn_SaveClick(Sender: TObject);
begin
  frmMain.USBstate[eesave] := 'W';
end;

procedure TfrmEEMEM.RzBitBtn_LoadClick(Sender: TObject);
begin
  frmMain.USBstate[eeload] := 'W';
end;


function TfrmEEMEM.DoLoadEEMEM: boolean;
var
  i: byte;
begin
  result := false;
  LoadEememIniFile;

  with g_EememIniData do
  begin
     Set32Bit(IniDDSclock,0);
     Set32Bit(IniLSBoffset,4);
     Set32Bit(IniUSBoffset,8);
     for i := 0 to 9 do block[12+i] := IniEncodersPots[i];
     for i := 0 to 25 do block[22+i] := IniRxButton[chr(i+65)];
     for i := 0 to 25 do block[48+i] := IniTxButton[chr(i+65)];
     block[74] := Ini44CWmode;
     block[75] := IniSoftwareFlywheel;
     block[76] := IniAutoDim;
     block[77] := IniParamResetMode;
     block[78] := IniDisplayBright;
     block[79] := IniDisplayDimmed;
     block[80] := IniAutoDimSeconds;
     block[81] := IniDisplayKeyValue;
     block[82] := IniDSPDDSKeysDisplay;
     block[83] := IniMenuTimeout;
     block[84] := IniMoxTimeout MOD 256;
     block[85] := IniMoxTimeout DIV 256;
     block[86] := IniTouchCalLeft MOD 256;
     block[87] := IniTouchCalLeft DIV 256;
     block[88] := IniTouchCalRight MOD 256;
     block[89] := IniTouchCalRight DIV 256;
     block[90] := IniTouchCalTop MOD 256;
     block[91] := IniTouchCalTop DIV 256;
     block[92] := IniTouchCalBottom MOD 256;
     block[93] := IniTouchCalBottom DIV 256;
     for i := 0 to 14 do block[94+i] := IniRxTouchpad[i+1];
     for i := 0 to 14 do block[109+i] := IniTxTouchpad[i+1];
  end;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_I')
  then exit
  else begin
    if not Usb.usSendBlock(@block,124) then exit;
  end;
  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);

  with g_EememIniData do
  begin
    Set32Bit(IniCWoffset,0);
    block[4] := IniCWoffsetEnable;
  end;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_J')
  then exit
  else begin
    if not Usb.usSendBlock(@block,5) then exit;
  end;
  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);

  IniToBandLast;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_STK_L')
  then exit
  else begin
    if not Usb.usSendBlock(@block,80) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToBandSSB;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_STK_S')
  then exit
  else begin
    if not Usb.usSendBlock(@block,80) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToBandCW;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_STK_C')
  then exit
  else begin
    if not Usb.usSendBlock(@block,80) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToMemStack67;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_STK_7')
  then exit
  else begin
    if not Usb.usSendBlock(@block,48) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToMemStack68;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_STK_8')
  then exit
  else begin
    if not Usb.usSendBlock(@block,48) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToMemStack69;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_STK_9')
  then exit
  else begin
    if not Usb.usSendBlock(@block,48) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToMemStack60;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_STK_0')
  then exit
  else begin
    if not Usb.usSendBlock(@block,48) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToVfoStack;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_STK_V')
  then exit
  else begin
    if not Usb.usSendBlock(@block,64) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToIC2ButtonTaskData;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_I2C_D')
  then exit
  else begin
    if not Usb.usSendBlock(@block,40) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToIC2ButtonTaskLabels;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_I2C_L')
  then exit
  else begin
    if not Usb.usSendBlock(@block,96) then exit;
  end;

  EememDelayEvent.ResetEvent;
  EememDelayEvent.WaitFor(LoadBlockDelay);
  IniToIC2;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$L_I2C_I')
  then exit
  else begin
    if not Usb.usSendBlock(@block,24) then exit;
  end;

  result := true;
end;


procedure TfrmEEMEM.LoadEEMEM;
var
  s: string;
  LoadOk: boolean;
begin
  screen.Cursor := crHourGlass;
  LoadOk := DoLoadEEMEM;
  screen.Cursor := crDefault;
  if LoadOk then
  begin
    s := 'TrxAVR internal EEPROM data loaded from TrxAvrEemem.ini'
           + #13#10 + ' Please check on TrxAVR';
    MessageDlg(s,mtInformation,[mbOk],0);
  end
  else begin
    s := 'TrxAVR internal EEPROM data load FAILED';
    MessageDlg(s,mtWarning,[mbOk],0);
  end;
end;


function TfrmEEMEM.DoSaveEEMEM: boolean;
var
  i: byte;
begin
  result := false;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_S')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(50);
    if not Usb.usReceiveBlock(@block,124) then exit;
  end;
  with g_EememIniData do
  begin
    IniDDSclock := Get32Bit(0);
    IniLSBoffset := Get32Bit(4);
    IniUSBoffset := Get32Bit(8);
    for i := 0 to 9 do IniEncodersPots[i] := block[12+i];
    for i := 0 to 25 do IniRxButton[chr(i+65)] := block[22+i];
    for i := 0 to 25 do IniTxButton[chr(i+65)] := block[48+i];
    Ini44CWmode := block[74];
    IniSoftwareFlywheel := block[75];
    IniAutoDim := block[76];
    IniParamResetMode := block[77];
    IniDisplayBright := block[78];
    IniDisplayDimmed := block[79];
    IniAutoDimSeconds := block[80];
    IniDisplayKeyValue := block[81];
    IniDSPDDSKeysDisplay := block[82];
    IniMenuTimeout := block[83];
    IniMoxTimeout := block[84] + 256*block[85];
    IniTouchCalLeft := block[86] + 256*block[87];
    IniTouchCalRight := block[88] + 256*block[89];
    IniTouchCalTop := block[90] + 256*block[91];
    IniTouchCalBottom := block[92] + 256*block[93];
    for i := 0 to 14 do IniRxTouchpad[i+1] := block[94+i];
    for i := 0 to 14 do IniTxTouchpad[i+1] := block[109+i];
  end;


  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_T')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(50);
    if not Usb.usReceiveBlock(@block,5) then exit;
  end;
  with g_EememIniData do
  begin
    IniCWoffset := Get32Bit(0);
    IniCWoffsetEnable := block[4];
  end;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_STK_L')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,80) then exit;
  end;
  BandLastToIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_STK_S')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,80) then exit;
  end;
  BandSSBtoIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_STK_C')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,80) then exit;
  end;
  BandCWtoIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_STK_7')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,48) then exit;
  end;
  MemStack67ToIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_STK_8')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,48) then exit;
  end;
  MemStack68ToIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_STK_9')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,48) then exit;
  end;
  MemStack69ToIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_STK_0')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,48) then exit;
  end;
  MemStack60ToIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_STK_V')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,64) then exit;
  end;
  VFOStackToIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_I2C_D')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,40) then exit;
  end;
  Ic2ButtonTaskDataToIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_I2C_L')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,96) then exit;
  end;
  Ic2ButtonTaskLabelsToIni;

  Purge_USB_Device_In;
  if not Usb.usSendString('$$$S_I2C_I')
  then exit
  else begin
    EememDelayEvent.ResetEvent;
    EememDelayEvent.WaitFor(SaveBlockDelay);
    if not Usb.usReceiveBlock(@block,24) then exit;
  end;
  Ic2ToIni;

  SaveEememIniFile;
  result := true;
end;


procedure TfrmEEMEM.SaveEEMEM;
var
  s: string;
  SaveOk: boolean;
begin
  Screen.Cursor := crHourGlass;
  SaveOK := DoSaveEEMEM;
  Application.ProcessMessages;
  if SaveOk then
  begin
    SaveEememIniFile;
    Screen.Cursor := crDefault;
    s := 'TrxAVR internal EEPROM data saved to TrxAvrEemem.ini';
    MessageDlg(s,mtInformation,[mbOk],0);
  end
  else begin
    Screen.Cursor := crDefault;
    s := 'TrxAVR internal EEPROM data save FAILED';
    MessageDlg(s,mtWarning,[mbOk],0);
  end;
end;


function TfrmEEMEM.Get32Bit(p: byte): longint;
begin
 result := block[p]
         + $100*block[p+1]
         +$10000*block[p+2]
         +$1000000*block[p+3];
end;


procedure TfrmEEMEM.Set32Bit(n: longint; p: byte);
begin
  block[p] := n MOD 256;
  n := n DIV 256;
  block[p+1] := n MOD 256;
  n := n DIV 256;
  block[p+2] := n MOD 256;
  block[p+3] := n  DIV 256;
end;

procedure TfrmEEMEM.RzBitBtn_ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmEEMEM.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  EememDelayEvent.Free;
end;


procedure TfrmEEMEM.BandLastToIni;
begin
  with g_EememIniData do
  begin
    IniLast160mFreq := Get32Bit(0 + 0*8);
    IniLast160mMode := block[4 + 0*8];
    IniLast160mFilter := block[5 + 0*8];
    IniLast160mIP3 := block[6 + 0*8];
    IniLast160mColour := block[7 + 0*8];

    IniLast80mFreq :=  Get32Bit(0 + 1*8);
    IniLast80mMode := block[4 + 1*8];
    IniLast80mFilter := block[5 + 1*8];
    IniLast80mIP3 := block[6 + 1*8];
    IniLast80mColour := block[7 + 1*8];

    // no 60m slot

    IniLast40mFreq := Get32Bit(0 + 3*8);
    IniLast40mMode := block[4 + 3*8];
    IniLast40mFilter := block[5 + 3*8];
    IniLast40mIP3 := block[6 + 3*8];
    IniLast40mColour := block[7 + 3*8];

    IniLast30mFreq := Get32Bit(0 + 4*8);
    IniLast30mMode := block[4 + 4*8];
    IniLast30mFilter := block[5 + 4*8];
    IniLast30mIP3 := block[6 + 4*8];
    IniLast30mColour := block[7 + 4*8];

    IniLast20mFreq := Get32Bit(0 + 5*8);
    IniLast20mMode := block[4 + 5*8];
    IniLast20mFilter := block[5 + 5*8];
    IniLast20mIP3 := block[6 + 5*8];
    IniLast20mColour := block[7 + 5*8];

    IniLast17mFreq := Get32Bit(0 + 6*8);
    IniLast17mMode := block[4 + 6*8];
    IniLast17mFilter := block[5 + 6*8];
    IniLast17mIP3 := block[6 + 6*8];
    IniLast17mColour := block[7 + 6*8];

    IniLast15mFreq := Get32Bit(0 + 7*8);
    IniLast15mMode := block[4 + 7*8];
    IniLast15mFilter := block[5 + 7*8];
    IniLast15mIP3 := block[6 + 7*8];
    IniLast15mColour := block[7 + 7*8];

    IniLast12mFreq := Get32Bit(0 + 8*8);
    IniLast12mMode := block[4 + 8*8];
    IniLast12mFilter := block[5 + 8*8];
    IniLast12mIP3 := block[6 + 8*8];
    IniLast12mColour := block[7 + 8*8];

    IniLast10mFreq :=  Get32Bit(0 + 9*8);
    IniLast10mMode := block[4 + 9*8];
    IniLast10mFilter := block[5 + 9*8];
    IniLast10mIP3 := block[6 + 9*8];
    IniLast10mColour := block[7 + 9*8];
  end;
end;


procedure TfrmEEMEM.BandSSBtoIni;
begin
  with g_EememIniData do
  begin
    IniSSB160mFreq := Get32Bit(0 + 0*8);
    IniSSB160mMode := block[4 + 0*8];
    IniSSB160mFilter := block[5 + 0*8];
    IniSSB160mIP3 := block[6 + 0*8];
    IniSSB160mColour := block[7 + 0*8];

    IniSSB80mFreq :=  Get32Bit(0 + 1*8);
    IniSSB80mMode := block[4 + 1*8];
    IniSSB80mFilter := block[5 + 1*8];
    IniSSB80mIP3 := block[6 + 1*8];
    IniSSB80mColour := block[7 + 1*8];

    // no 60m slot

    IniSSB40mFreq := Get32Bit(0 + 3*8);
    IniSSB40mMode := block[4 + 3*8];
    IniSSB40mFilter := block[5 + 3*8];
    IniSSB40mIP3 := block[6 + 3*8];
    IniSSB40mColour := block[7 + 3*8];

    IniSSB30mFreq := Get32Bit(0 + 4*8);
    IniSSB30mMode := block[4 + 4*8];
    IniSSB30mFilter := block[5 + 4*8];
    IniSSB30mIP3 := block[6 + 4*8];
    IniSSB30mColour := block[7 + 4*8];

    IniSSB20mFreq := Get32Bit(0 + 5*8);
    IniSSB20mMode := block[4 + 5*8];
    IniSSB20mFilter := block[5 + 5*8];
    IniSSB20mIP3 := block[6 + 5*8];
    IniSSB20mColour := block[7 + 5*8];

    IniSSB17mFreq := Get32Bit(0 + 6*8);
    IniSSB17mMode := block[4 + 6*8];
    IniSSB17mFilter := block[5 + 6*8];
    IniSSB17mIP3 := block[6 + 6*8];
    IniSSB17mColour := block[7 + 6*8];

    IniSSB15mFreq := Get32Bit(0 + 7*8);
    IniSSB15mMode := block[4 + 7*8];
    IniSSB15mFilter := block[5 + 7*8];
    IniSSB15mIP3 := block[6 + 7*8];
    IniSSB15mColour := block[7 + 7*8];

    IniSSB12mFreq := Get32Bit(0 + 8*8);
    IniSSB12mMode := block[4 + 8*8];
    IniSSB12mFilter := block[5 + 8*8];
    IniSSB12mIP3 := block[6 + 8*8];
    IniSSB12mColour := block[7 + 8*8];

    IniSSB10mFreq :=  Get32Bit(0 + 9*8);
    IniSSB10mMode := block[4 + 9*8];
    IniSSB10mFilter := block[5 + 9*8];
    IniSSB10mIP3 := block[6 + 9*8];
    IniSSB10mColour := block[7 + 9*8];
  end;
end;

procedure TfrmEEMEM.BandCWtoIni;
begin
  with g_EememIniData do
  begin
    IniCW160mFreq := Get32Bit(0 + 0*8);
    IniCW160mMode := block[4 + 0*8];
    IniCW160mFilter := block[5 + 0*8];
    IniCW160mIP3 := block[6 + 0*8];
    IniCW160mColour := block[7 + 0*8];

    IniCW80mFreq :=  Get32Bit(0 + 1*8);
    IniCW80mMode := block[4 + 1*8];
    IniCW80mFilter := block[5 + 1*8];
    IniCW80mIP3 := block[6 + 1*8];
    IniCW80mColour := block[7 + 1*8];

    // no 60m slot

    IniCW40mFreq := Get32Bit(0 + 3*8);
    IniCW40mMode := block[4 + 3*8];
    IniCW40mFilter := block[5 + 3*8];
    IniCW40mIP3 := block[6 + 3*8];
    IniCW40mColour := block[7 + 3*8];

    IniCW30mFreq := Get32Bit(0 + 4*8);
    IniCW30mMode := block[4 + 4*8];
    IniCW30mFilter := block[5 + 4*8];
    IniCW30mIP3 := block[6 + 4*8];
    IniCW30mColour := block[7 + 4*8];

    IniCW20mFreq := Get32Bit(0 + 5*8);
    IniCW20mMode := block[4 + 5*8];
    IniCW20mFilter := block[5 + 5*8];
    IniCW20mIP3 := block[6 + 5*8];
    IniCW20mColour := block[7 + 5*8];

    IniCW17mFreq := Get32Bit(0 + 6*8);
    IniCW17mMode := block[4 + 6*8];
    IniCW17mFilter := block[5 + 6*8];
    IniCW17mIP3 := block[6 + 6*8];
    IniCW17mColour := block[7 + 6*8];

    IniCW15mFreq := Get32Bit(0 + 7*8);
    IniCW15mMode := block[4 + 7*8];
    IniCW15mFilter := block[5 + 7*8];
    IniCW15mIP3 := block[6 + 7*8];
    IniCW15mColour := block[7 + 7*8];

    IniCW12mFreq := Get32Bit(0 + 8*8);
    IniCW12mMode := block[4 + 8*8];
    IniCW12mFilter := block[5 + 8*8];
    IniCW12mIP3 := block[6 + 8*8];
    IniCW12mColour := block[7 + 8*8];

    IniCW10mFreq :=  Get32Bit(0 + 9*8);
    IniCW10mMode := block[4 + 9*8];
    IniCW10mFilter := block[5 + 9*8];
    IniCW10mIP3 := block[6 + 9*8];
    IniCW10mColour := block[7 + 9*8];
  end;
end;


procedure TfrmEEMEM.MemStack67ToIni;
begin
  with g_EememIniData do
  begin
    IniMem6761Freq   := Get32Bit(0 + 0*8);
    IniMem6761Mode   := block[4 + 0*8];
    IniMem6761Filter := block[5 + 0*8];
    IniMem6761IP3    := block[6 + 0*8];
    IniMem6761Colour := block[7 + 0*8];

    IniMem6762Freq   := Get32Bit(0 + 1*8);
    IniMem6762Mode   := block[4 + 1*8];
    IniMem6762Filter := block[5 + 1*8];
    IniMem6762IP3    := block[6 + 1*8];
    IniMem6762Colour := block[7 + 1*8];

    IniMem6763Freq   := Get32Bit(0 + 2*8);
    IniMem6763Mode   := block[4 + 2*8];
    IniMem6763Filter := block[5 + 2*8];
    IniMem6763IP3    := block[6 + 2*8];
    IniMem6763Colour := block[7 + 2*8];

    IniMem6764Freq   := Get32Bit(0 + 3*8);
    IniMem6764Mode   := block[4 + 3*8];
    IniMem6764Filter := block[5 + 3*8];
    IniMem6764IP3    := block[6 + 3*8];
    IniMem6764Colour := block[7 + 3*8];

    IniMem6765Freq   := Get32Bit(0 + 4*8);
    IniMem6765Mode   := block[4 + 4*8];
    IniMem6765Filter := block[5 + 4*8];
    IniMem6765IP3    := block[6 + 4*8];
    IniMem6765Colour := block[7 + 4*8];

    IniMem6766Freq   := Get32Bit(0 + 5*8);
    IniMem6766Mode   := block[4 + 5*8];
    IniMem6766Filter := block[5 + 5*8];
    IniMem6766IP3    := block[6 + 5*8];
    IniMem6766Colour := block[7 + 5*8];
  end;
end;


procedure TfrmEEMEM.MemStack68ToIni;
begin
  with g_EememIniData do
  begin
    IniMem6861Freq   := Get32Bit(0 + 0*8);
    IniMem6861Mode   := block[4 + 0*8];
    IniMem6861Filter := block[5 + 0*8];
    IniMem6861IP3    := block[6 + 0*8];
    IniMem6861Colour := block[7 + 0*8];

    IniMem6862Freq   := Get32Bit(0 + 1*8);
    IniMem6862Mode   := block[4 + 1*8];
    IniMem6862Filter := block[5 + 1*8];
    IniMem6862IP3    := block[6 + 1*8];
    IniMem6862Colour := block[7 + 1*8];

    IniMem6863Freq   := Get32Bit(0 + 2*8);
    IniMem6863Mode   := block[4 + 2*8];
    IniMem6863Filter := block[5 + 2*8];
    IniMem6863IP3    := block[6 + 2*8];
    IniMem6863Colour := block[7 + 2*8];

    IniMem6864Freq   := Get32Bit(0 + 3*8);
    IniMem6864Mode   := block[4 + 3*8];
    IniMem6864Filter := block[5 + 3*8];
    IniMem6864IP3    := block[6 + 3*8];
    IniMem6864Colour := block[7 + 3*8];

    IniMem6865Freq   := Get32Bit(0 + 4*8);
    IniMem6865Mode   := block[4 + 4*8];
    IniMem6865Filter := block[5 + 4*8];
    IniMem6865IP3    := block[6 + 4*8];
    IniMem6865Colour := block[7 + 4*8];

    IniMem6866Freq   := Get32Bit(0 + 5*8);
    IniMem6866Mode   := block[4 + 5*8];
    IniMem6866Filter := block[5 + 5*8];
    IniMem6866IP3    := block[6 + 5*8];
    IniMem6866Colour := block[7 + 5*8];
  end;
end;


procedure TfrmEEMEM.MemStack69ToIni;
begin
  with g_EememIniData do
  begin
    IniMem6961Freq   := Get32Bit(0 + 0*8);
    IniMem6961Mode   := block[4 + 0*8];
    IniMem6961Filter := block[5 + 0*8];
    IniMem6961IP3    := block[6 + 0*8];
    IniMem6961Colour := block[7 + 0*8];

    IniMem6962Freq   := Get32Bit(0 + 1*8);
    IniMem6962Mode   := block[4 + 1*8];
    IniMem6962Filter := block[5 + 1*8];
    IniMem6962IP3    := block[6 + 1*8];
    IniMem6962Colour := block[7 + 1*8];

    IniMem6963Freq   := Get32Bit(0 + 2*8);
    IniMem6963Mode   := block[4 + 2*8];
    IniMem6963Filter := block[5 + 2*8];
    IniMem6963IP3    := block[6 + 2*8];
    IniMem6963Colour := block[7 + 2*8];

    IniMem6964Freq   := Get32Bit(0 + 3*8);
    IniMem6964Mode   := block[4 + 3*8];
    IniMem6964Filter := block[5 + 3*8];
    IniMem6964IP3    := block[6 + 3*8];
    IniMem6964Colour := block[7 + 3*8];

    IniMem6965Freq   := Get32Bit(0 + 4*8);
    IniMem6965Mode   := block[4 + 4*8];
    IniMem6965Filter := block[5 + 4*8];
    IniMem6965IP3    := block[6 + 4*8];
    IniMem6965Colour := block[7 + 4*8];

    IniMem6966Freq   := Get32Bit(0 + 5*8);
    IniMem6966Mode   := block[4 + 5*8];
    IniMem6966Filter := block[5 + 5*8];
    IniMem6966IP3    := block[6 + 5*8];
    IniMem6966Colour := block[7 + 5*8];
  end;
end;


procedure TfrmEEMEM.MemStack60ToIni;
begin
  with g_EememIniData do
  begin
    IniMem6061Freq   := Get32Bit(0 + 0*8);
    IniMem6061Mode   := block[4 + 0*8];
    IniMem6061Filter := block[5 + 0*8];
    IniMem6061IP3    := block[6 + 0*8];
    IniMem6061Colour := block[7 + 0*8];

    IniMem6062Freq   := Get32Bit(0 + 1*8);
    IniMem6062Mode   := block[4 + 1*8];
    IniMem6062Filter := block[5 + 1*8];
    IniMem6062IP3    := block[6 + 1*8];
    IniMem6062Colour := block[7 + 1*8];

    IniMem6063Freq   := Get32Bit(0 + 2*8);
    IniMem6063Mode   := block[4 + 2*8];
    IniMem6063Filter := block[5 + 2*8];
    IniMem6063IP3    := block[6 + 2*8];
    IniMem6063Colour := block[7 + 2*8];

    IniMem6064Freq   := Get32Bit(0 + 3*8);
    IniMem6064Mode   := block[4 + 3*8];
    IniMem6064Filter := block[5 + 3*8];
    IniMem6064IP3    := block[6 + 3*8];
    IniMem6064Colour := block[7 + 3*8];

    IniMem6065Freq   := Get32Bit(0 + 4*8);
    IniMem6065Mode   := block[4 + 4*8];
    IniMem6065Filter := block[5 + 4*8];
    IniMem6065IP3    := block[6 + 4*8];
    IniMem6065Colour := block[7 + 4*8];

    IniMem6066Freq   := Get32Bit(0 + 5*8);
    IniMem6066Mode   := block[4 + 5*8];
    IniMem6066Filter := block[5 + 5*8];
    IniMem6066IP3    := block[6 + 5*8];
    IniMem6066Colour := block[7 + 5*8];
  end;
end;
        // VFO sticky stack
procedure TfrmEEMEM.VFOStackToIni;
begin
  with g_EememIniData do
  begin
    IniPowerOnFreq   := Get32Bit(0 + 0*8);
    IniPowerOnMode   := block[4 + 0*8];
    IniPowerOnFilter := block[5 + 0*8];
    IniPowerOnIP3    := block[6 + 0*8];
    IniPowerOnColour := block[7 + 0*8];

    IniVFO1Freq   := Get32Bit(0 + 1*8);
    IniVFO1Mode   := block[4 + 1*8];
    IniVFO1Filter := block[5 + 1*8];
    IniVFO1IP3    := block[6 + 1*8];
    IniVFO1Colour := block[7 + 1*8];

    IniVFO2Freq   := Get32Bit(0 + 2*8);
    IniVFO2Mode   := block[4 + 2*8];
    IniVFO2Filter := block[5 + 2*8];
    IniVFO2IP3    := block[6 + 2*8];
    IniVFO2Colour := block[7 + 2*8];

    IniVFO3Freq   := Get32Bit(0 + 3*8);
    IniVFO3Mode   := block[4 + 3*8];
    IniVFO3Filter := block[5 + 3*8];
    IniVFO3IP3    := block[6 + 3*8];
    IniVFO3Colour := block[7 + 3*8];

    IniVFO4Freq   := Get32Bit(0 + 4*8);
    IniVFO4Mode   := block[4 + 4*8];
    IniVFO4Filter := block[5 + 4*8];
    IniVFO4IP3    := block[6 + 4*8];
    IniVFO4Colour := block[7 + 4*8];

    IniVFO5Freq   := Get32Bit(0 + 5*8);
    IniVFO5Mode   := block[4 + 5*8];
    IniVFO5Filter := block[5 + 5*8];
    IniVFO5IP3    := block[6 + 5*8];
    IniVFO5Colour := block[7 + 5*8];

    IniVFO6Freq   := Get32Bit(0 + 6*8);
    IniVFO6Mode   := block[4 + 6*8];
    IniVFO6Filter := block[5 + 6*8];
    IniVFO6IP3    := block[6 + 6*8];
    IniVFO6Colour := block[7 + 6*8];

    IniVFO7Freq   := Get32Bit(0 + 7*8);
    IniVFO7Mode   := block[4 + 7*8];
    IniVFO7Filter := block[5 + 7*8];
    IniVFO7IP3    := block[6 + 7*8];
    IniVFO7Colour := block[7 + 7*8];

  end;
end;


procedure TfrmEEMEM.IniToBandLast;
begin
  with g_EememIniData do
  begin
    Set32Bit(IniLast160mFreq, 0 + 0*8);
    block[4 + 0*8] := IniLast160mMode;
    block[5 + 0*8] := IniLast160mFilter;
    block[6 + 0*8] := IniLast160mIP3;
    block[7 + 0*8] := IniLast160mColour;

    Set32Bit(IniLast80mFreq, 0 + 1*8);
    block[4 + 1*8] := IniLast80mMode;
    block[5 + 1*8] := IniLast80mFilter;
    block[6 + 1*8] := IniLast80mIP3;
    block[7 + 1*8] := IniLast80mColour;

    // no 60m slot

    Set32Bit(IniLast40mFreq, 0 + 3*8);
    block[4 + 3*8] := IniLast40mMode;
    block[5 + 3*8] := IniLast40mFilter;
    block[6 + 3*8] := IniLast40mIP3;
    block[7 + 3*8] := IniLast40mColour;

    Set32Bit(IniLast30mFreq, 0 + 4*8);
    block[4 + 4*8] := IniLast30mMode;
    block[5 + 4*8] := IniLast30mFilter;
    block[6 + 4*8] := IniLast30mIP3;
    block[7 + 4*8] := IniLast30mColour;

    Set32Bit(IniLast20mFreq, 0 + 5*8);
    block[4 + 5*8] := IniLast20mMode;
    block[5 + 5*8] := IniLast20mFilter;
    block[6 + 5*8] := IniLast20mIP3;
    block[7 + 5*8] := IniLast20mColour;

    Set32Bit(IniLast17mFreq, 0 + 6*8);
    block[4 + 6*8] := IniLast17mMode;
    block[5 + 6*8] := IniLast17mFilter;
    block[6 + 6*8] := IniLast17mIP3;
    block[7 + 6*8] := IniLast17mColour;

    Set32Bit(IniLast15mFreq, 0 + 7*8);
    block[4 + 7*8] := IniLast15mMode;
    block[5 + 7*8] := IniLast15mFilter;
    block[6 + 7*8] := IniLast15mIP3;
    block[7 + 7*8] := IniLast15mColour;

    Set32Bit(IniLast12mFreq, 0 + 8*8);
    block[4 + 8*8] := IniLast12mMode;
    block[5 + 8*8] := IniLast12mFilter;
    block[6 + 8*8] := IniLast12mIP3;
    block[7 + 8*8] := IniLast12mColour;

    Set32Bit(IniLast10mFreq, 0 + 9*8);
    block[4 + 9*8] := IniLast10mMode;
    block[5 + 9*8] := IniLast10mFilter;
    block[6 + 9*8] := IniLast10mIP3;
    block[7 + 9*8] := IniLast10mColour;
  end;
end;

procedure TfrmEEMEM.IniToBandSSB;
begin
  with g_EememIniData do
  begin
    Set32Bit(IniSSB160mFreq, 0 + 0*8);
    block[4 + 0*8] := IniSSB160mMode;
    block[5 + 0*8] := IniSSB160mFilter;
    block[6 + 0*8] := IniSSB160mIP3;
    block[7 + 0*8] := IniSSB160mColour;

    Set32Bit(IniSSB80mFreq, 0 + 1*8);
    block[4 + 1*8] := IniSSB80mMode;
    block[5 + 1*8] := IniSSB80mFilter;
    block[6 + 1*8] := IniSSB80mIP3;
    block[7 + 1*8] := IniSSB80mColour;

    // no 60m slot

    Set32Bit(IniSSB40mFreq, 0 + 3*8);
    block[4 + 3*8] := IniSSB40mMode;
    block[5 + 3*8] := IniSSB40mFilter;
    block[6 + 3*8] := IniSSB40mIP3;
    block[7 + 3*8] := IniSSB40mColour;

    Set32Bit(IniSSB30mFreq, 0 + 4*8);
    block[4 + 4*8] := IniSSB30mMode;
    block[5 + 4*8] := IniSSB30mFilter;
    block[6 + 4*8] := IniSSB30mIP3;
    block[7 + 4*8] := IniSSB30mColour;

    Set32Bit(IniSSB20mFreq, 0 + 5*8);
    block[4 + 5*8] := IniSSB20mMode;
    block[5 + 5*8] := IniSSB20mFilter;
    block[6 + 5*8] := IniSSB20mIP3;
    block[7 + 5*8] := IniSSB20mColour;

    Set32Bit(IniSSB17mFreq, 0 + 6*8);
    block[4 + 6*8] := IniSSB17mMode;
    block[5 + 6*8] := IniSSB17mFilter;
    block[6 + 6*8] := IniSSB17mIP3;
    block[7 + 6*8] := IniSSB17mColour;

    Set32Bit(IniSSB15mFreq, 0 + 7*8);
    block[4 + 7*8] := IniSSB15mMode;
    block[5 + 7*8] := IniSSB15mFilter;
    block[6 + 7*8] := IniSSB15mIP3;
    block[7 + 7*8] := IniSSB15mColour;

    Set32Bit(IniSSB12mFreq, 0 + 8*8);
    block[4 + 8*8] := IniSSB12mMode;
    block[5 + 8*8] := IniSSB12mFilter;
    block[6 + 8*8] := IniSSB12mIP3;
    block[7 + 8*8] := IniSSB12mColour;

    Set32Bit(IniSSB10mFreq, 0 + 9*8);
    block[4 + 9*8] := IniSSB10mMode;
    block[5 + 9*8] := IniSSB10mFilter;
    block[6 + 9*8] := IniSSB10mIP3;
    block[7 + 9*8] := IniSSB10mColour;
  end;
end;


procedure TfrmEEMEM.IniToBandCW;
begin
  with g_EememIniData do
  begin
    Set32Bit(IniCW160mFreq, 0 + 0*8);
    block[4 + 0*8] := IniCW160mMode;
    block[5 + 0*8] := IniCW160mFilter;
    block[6 + 0*8] := IniCW160mIP3;
    block[7 + 0*8] := IniCW160mColour;

    Set32Bit(IniCW80mFreq, 0 + 1*8);
    block[4 + 1*8] := IniCW80mMode;
    block[5 + 1*8] := IniCW80mFilter;
    block[6 + 1*8] := IniCW80mIP3;
    block[7 + 1*8] := IniCW80mColour;

    // no 60m slot

    Set32Bit(IniCW40mFreq, 0 + 3*8);
    block[4 + 3*8] := IniCW40mMode;
    block[5 + 3*8] := IniCW40mFilter;
    block[6 + 3*8] := IniCW40mIP3;
    block[7 + 3*8] := IniCW40mColour;

    Set32Bit(IniCW30mFreq, 0 + 4*8);
    block[4 + 4*8] := IniCW30mMode;
    block[5 + 4*8] := IniCW30mFilter;
    block[6 + 4*8] := IniCW30mIP3;
    block[7 + 4*8] := IniCW30mColour;

    Set32Bit(IniCW20mFreq, 0 + 5*8);
    block[4 + 5*8] := IniCW20mMode;
    block[5 + 5*8] := IniCW20mFilter;
    block[6 + 5*8] := IniCW20mIP3;
    block[7 + 5*8] := IniCW20mColour;

    Set32Bit(IniCW17mFreq, 0 + 6*8);
    block[4 + 6*8] := IniCW17mMode;
    block[5 + 6*8] := IniCW17mFilter;
    block[6 + 6*8] := IniCW17mIP3;
    block[7 + 6*8] := IniCW17mColour;

    Set32Bit(IniCW15mFreq, 0 + 7*8);
    block[4 + 7*8] := IniCW15mMode;
    block[5 + 7*8] := IniCW15mFilter;
    block[6 + 7*8] := IniCW15mIP3;
    block[7 + 7*8] := IniCW15mColour;

    Set32Bit(IniCW12mFreq, 0 + 8*8);
    block[4 + 8*8] := IniCW12mMode;
    block[5 + 8*8] := IniCW12mFilter;
    block[6 + 8*8] := IniCW12mIP3;
    block[7 + 8*8] := IniCW12mColour;

    Set32Bit(IniCW10mFreq, 0 + 9*8);
    block[4 + 9*8] := IniCW10mMode;
    block[5 + 9*8] := IniCW10mFilter;
    block[6 + 9*8] := IniCW10mIP3;
    block[7 + 9*8] := IniCW10mColour;
  end;
end;


procedure TfrmEEMEM.IniToMemStack67;
begin
  with g_EememIniData do
  begin
    Set32Bit(IniMem6761Freq, 0 + 0*8);
    block[4 + 0*8] := IniMem6761Mode;
    block[5 + 0*8] := IniMem6761Filter;
    block[6 + 0*8] := IniMem6761IP3;
    block[7 + 0*8] := IniMem6761Colour;

    Set32Bit(IniMem6762Freq, 0 + 1*8);
    block[4 + 1*8] := IniMem6762Mode;
    block[5 + 1*8] := IniMem6762Filter;
    block[6 + 1*8] := IniMem6762IP3;
    block[7 + 1*8] := IniMem6762Colour;

    Set32Bit(IniMem6763Freq, 0 + 2*8);
    block[4 + 2*8] := IniMem6763Mode;
    block[5 + 2*8] := IniMem6763Filter;
    block[6 + 2*8] := IniMem6763IP3;
    block[7 + 2*8] := IniMem6763Colour;

    Set32Bit(IniMem6764Freq, 0 + 3*8);
    block[4 + 3*8] := IniMem6764Mode;
    block[5 + 3*8] := IniMem6764Filter;
    block[6 + 3*8] := IniMem6764IP3;
    block[7 + 3*8] := IniMem6764Colour;

    Set32Bit(IniMem6765Freq, 0 + 4*8);
    block[4 + 4*8] := IniMem6765Mode;
    block[5 + 4*8] := IniMem6765Filter;
    block[6 + 4*8] := IniMem6765IP3;
    block[7 + 4*8] := IniMem6765Colour;

    Set32Bit(IniMem6766Freq, 0 + 5*8);
    block[4 + 5*8] := IniMem6766Mode;
    block[5 + 5*8] := IniMem6766Filter;
    block[6 + 5*8] := IniMem6766IP3;
    block[7 + 5*8] := IniMem6766Colour;
  end;
end;


procedure TfrmEEMEM.IniToMemStack68;
begin
  with g_EememIniData do
  begin
    Set32Bit(IniMem6861Freq, 0 + 0*8);
    block[4 + 0*8] := IniMem6861Mode;
    block[5 + 0*8] := IniMem6861Filter;
    block[6 + 0*8] := IniMem6861IP3;
    block[7 + 0*8] := IniMem6861Colour;

    Set32Bit(IniMem6862Freq, 0 + 1*8);
    block[4 + 1*8] := IniMem6862Mode;
    block[5 + 1*8] := IniMem6862Filter;
    block[6 + 1*8] := IniMem6862IP3;
    block[7 + 1*8] := IniMem6862Colour;

    Set32Bit(IniMem6863Freq, 0 + 2*8);
    block[4 + 2*8] := IniMem6863Mode;
    block[5 + 2*8] := IniMem6863Filter;
    block[6 + 2*8] := IniMem6863IP3;
    block[7 + 2*8] := IniMem6863Colour;

    Set32Bit(IniMem6864Freq, 0 + 3*8);
    block[4 + 3*8] := IniMem6864Mode;
    block[5 + 3*8] := IniMem6864Filter;
    block[6 + 3*8] := IniMem6864IP3;
    block[7 + 3*8] := IniMem6864Colour;

    Set32Bit(IniMem6865Freq, 0 + 4*8);
    block[4 + 4*8] := IniMem6865Mode;
    block[5 + 4*8] := IniMem6865Filter;
    block[6 + 4*8] := IniMem6865IP3;
    block[7 + 4*8] := IniMem6865Colour;

    Set32Bit(IniMem6866Freq, 0 + 5*8);
    block[4 + 5*8] := IniMem6866Mode;
    block[5 + 5*8] := IniMem6866Filter;
    block[6 + 5*8] := IniMem6866IP3;
    block[7 + 5*8] := IniMem6866Colour;
  end;
end;


procedure TfrmEEMEM.IniToMemStack69;
begin
  with g_EememIniData do
  begin
    Set32Bit(IniMem6961Freq, 0 + 0*8);
    block[4 + 0*8] := IniMem6961Mode;
    block[5 + 0*8] := IniMem6961Filter;
    block[6 + 0*8] := IniMem6961IP3;
    block[7 + 0*8] := IniMem6961Colour;

    Set32Bit(IniMem6962Freq, 0 + 1*8);
    block[4 + 1*8] := IniMem6962Mode;
    block[5 + 1*8] := IniMem6962Filter;
    block[6 + 1*8] := IniMem6962IP3;
    block[7 + 1*8] := IniMem6962Colour;

    Set32Bit(IniMem6963Freq, 0 + 2*8);
    block[4 + 2*8] := IniMem6963Mode;
    block[5 + 2*8] := IniMem6963Filter;
    block[6 + 2*8] := IniMem6963IP3;
    block[7 + 2*8] := IniMem6963Colour;

    Set32Bit(IniMem6964Freq, 0 + 3*8);
    block[4 + 3*8] := IniMem6964Mode;
    block[5 + 3*8] := IniMem6964Filter;
    block[6 + 3*8] := IniMem6964IP3;
    block[7 + 3*8] := IniMem6964Colour;

    Set32Bit(IniMem6965Freq, 0 + 4*8);
    block[4 + 4*8] := IniMem6965Mode;
    block[5 + 4*8] := IniMem6965Filter;
    block[6 + 4*8] := IniMem6965IP3;
    block[7 + 4*8] := IniMem6965Colour;

    Set32Bit(IniMem6966Freq, 0 + 5*8);
    block[4 + 5*8] := IniMem6966Mode;
    block[5 + 5*8] := IniMem6966Filter;
    block[6 + 5*8] := IniMem6966IP3;
    block[7 + 5*8] := IniMem6966Colour;
  end;
end;


procedure TfrmEEMEM.IniToMemStack60;
begin
  with g_EememIniData do
  begin
    Set32Bit(IniMem6061Freq, 0 + 0*8);
    block[4 + 0*8] := IniMem6061Mode;
    block[5 + 0*8] := IniMem6061Filter;
    block[6 + 0*8] := IniMem6061IP3;
    block[7 + 0*8] := IniMem6061Colour;

    Set32Bit(IniMem6062Freq, 0 + 1*8);
    block[4 + 1*8] := IniMem6062Mode;
    block[5 + 1*8] := IniMem6062Filter;
    block[6 + 1*8] := IniMem6062IP3;
    block[7 + 1*8] := IniMem6062Colour;

    Set32Bit(IniMem6063Freq, 0 + 2*8);
    block[4 + 2*8] := IniMem6063Mode;
    block[5 + 2*8] := IniMem6063Filter;
    block[6 + 2*8] := IniMem6063IP3;
    block[7 + 2*8] := IniMem6063Colour;

    Set32Bit(IniMem6064Freq, 0 + 3*8);
    block[4 + 3*8] := IniMem6064Mode;
    block[5 + 3*8] := IniMem6064Filter;
    block[6 + 3*8] := IniMem6064IP3;
    block[7 + 3*8] := IniMem6064Colour;

    Set32Bit(IniMem6065Freq, 0 + 4*8);
    block[4 + 4*8] := IniMem6065Mode;
    block[5 + 4*8] := IniMem6065Filter;
    block[6 + 4*8] := IniMem6065IP3;
    block[7 + 4*8] := IniMem6065Colour;

    Set32Bit(IniMem6066Freq, 0 + 5*8);
    block[4 + 5*8] := IniMem6066Mode;
    block[5 + 5*8] := IniMem6066Filter;
    block[6 + 5*8] := IniMem6066IP3;
    block[7 + 5*8] := IniMem6066Colour;
  end;
end;


procedure TfrmEEMEM.IniToVfoStack;
begin
  with g_EememIniData do
  begin
    Set32Bit(IniPowerOnFreq, 0 + 0*8);
    block[4 + 0*8] := IniPowerOnMode;
    block[5 + 0*8] := IniPowerOnFilter;
    block[6 + 0*8] := IniPowerOnIP3;
    block[7 + 0*8] := IniPowerOnColour;

    Set32Bit(IniVFO1Freq, 0 + 1*8);
    block[4 + 1*8] := IniVFO1Mode;
    block[5 + 1*8] := IniVFO1Filter;
    block[6 + 1*8] := IniVFO1IP3;
    block[7 + 1*8] := IniVFO1Colour;

    Set32Bit(IniVFO2Freq, 0 + 2*8);
    block[4 + 2*8] := IniVFO2Mode;
    block[5 + 2*8] := IniVFO2Filter;
    block[6 + 2*8] := IniVFO2IP3;
    block[7 + 2*8] := IniVFO2Colour;

    Set32Bit(IniVFO3Freq, 0 + 3*8);
    block[4 + 3*8] := IniVFO3Mode;
    block[5 + 3*8] := IniVFO3Filter;
    block[6 + 3*8] := IniVFO3IP3;
    block[7 + 3*8] := IniVFO3Colour;

    Set32Bit(IniVFO4Freq, 0 + 4*8);
    block[4 + 4*8] := IniVFO4Mode;
    block[5 + 4*8] := IniVFO4Filter;
    block[6 + 4*8] := IniVFO4IP3;
    block[7 + 4*8] := IniVFO4Colour;

    Set32Bit(IniVFO5Freq, 0 + 5*8);
    block[4 + 5*8] := IniVFO5Mode;
    block[5 + 5*8] := IniVFO5Filter;
    block[6 + 5*8] := IniVFO5IP3;
    block[7 + 5*8] := IniVFO5Colour;

    Set32Bit(IniVFO6Freq, 0 + 6*8);
    block[4 + 6*8] := IniVFO6Mode;
    block[5 + 6*8] := IniVFO6Filter;
    block[6 + 6*8] := IniVFO6IP3;
    block[7 + 6*8] := IniVFO6Colour;

    Set32Bit(IniVFO7Freq, 0 + 7*8);
    block[4 + 7*8] := IniVFO7Mode;
    block[5 + 7*8] := IniVFO7Filter;
    block[6 + 7*8] := IniVFO7IP3;
    block[7 + 7*8] := IniVFO7Colour;

  end;
end;

//////////////////////////////////////////////////////////////////////////
//// I2C code //////////////////////

procedure TfrmEEMEM.IniToIC2ButtonTaskData;
var
  i: byte;
begin
  for i := 1 to 8 do
  begin
    with g_EememIniData.IniPCAtasks[i] do
    begin
      block[0 + (i-1)] := IniPcaOpcode;
      block[8 + (i-1)] := IniPcaGroup;
      block[16 + (i-1)] := IniPcaAddress;
      block[24 + 2*(i-1)] := IniPcaDataword MOD $100;
      block[25 + 2*(i-1)] := IniPcaDataWord DIV $100;
    end;
  end;
end;


procedure TfrmEEMEM.IniToIC2ButtonTaskLabels;
var
  s: string[14];
  i,a,p: byte;
begin
  for i := 1 to 8 do
  begin
    with g_EememIniData.IniPCAtasks[i] do
    begin
      s := IniPcaLabel;
      a := Length(s);
      if a > 11 then s := Copy(s,1,11);
      if a = 0
      then block[12*(i-1)] := 0
      else begin
        for p := 1 to a do block[12*(i-1) + p - 1] := ord(s[p]);
        block[12*(i-1)+ a] := 0;
      end;
    end;
  end;
end;


procedure TfrmEEMEM.IniToIC2;
var
  i: byte;
begin
  with g_EememIniData do
  begin
    block[0] := IniPCA9555BpfType;
    block[1] := IniPCA9555BpfAddress;
    block[2] := IniPA3AKE_RooferAddress;
    block[3] := IniPA3AKE_SquarerAddress;
    block[4] := IniPA3AKE_MixerAddress;
    block[5] := IniPA3AKE_MixerEnable;
    block[6] := IniPA3AKE_RooferSwitchEnable;
    block[7] := IniPA3AKE_MixerDAC MOD $100;
    block[8] := IniPA3AKE_MixerDAC DIV $100;
    block[9] := IniPA3AKE_SquarerDAC MOD $100;
    block[10] := IniPA3AKE_SquarerDAC DIV $100;
    block[11] := IniEnablePCA9555;
    for i := 12 to 23 do block[i] := 0;  // spare
    block[23] := OffsetStringToByte(IniLocalTimeOffset);
  end;
end;


procedure TfrmEEMEM.IC2ButtonTaskDataToIni;
var
  s: string[14];
  i,a,p: byte;
begin
  for i := 1 to 8 do
  begin
    with g_EememIniData.IniPCAtasks[i] do
    begin
      IniPcaOpcode := block[0 + (i-1)];
      IniPcaGroup := block[8 + (i-1)];
      IniPcaAddress := block[16 + (i-1)];
      IniPcaDataword := block[24 + 2*(i-1)] +$100*block[25 + 2*(i-1)];
    end;
  end;
end;



procedure TfrmEEMEM.IC2ButtonTaskLabelsToIni;
var
  s: string[14];
  i,a,p: byte;
begin
  for i := 1 to 8 do
  begin
    with g_EememIniData.IniPCAtasks[i] do
    begin
      s := '';
      for p := 1 to 11 do
      begin
        a := block[12*(i-1) + p - 1] ;
        if a = 0 then break;
        s := s + char(a);
      end;
      IniPcaLabel := s;
    end;
  end;
end;


procedure TfrmEEMEM.IC2ToIni;
begin
  with g_EememIniData do
  begin
    IniPCA9555BpfType := block[0];
    IniPCA9555BpfAddress := block[1];
    IniPA3AKE_RooferAddress := block[2];
    IniPA3AKE_SquarerAddress := block[3];
    IniPA3AKE_MixerAddress := block[4];
    IniPA3AKE_MixerEnable := block[5];
    IniPA3AKE_RooferSwitchEnable := block[6];
    IniPA3AKE_MixerDAC := block[7] + $100*block[8];
    IniPA3AKE_SquarerDAC := block[9] + $100*block[10];
    IniEnablePCA9555 := block[11];
    IniLocalTimeOffset := ByteToOffsetString(block[23]);
  end;
end;



procedure TfrmEEMEM.RzBitBtn_HelpClick(Sender: TObject);
begin
  frmMain.WebBrowser('http://www.homebrew-radios.net/trxavr_picastar/TP_setup_4_USB_data.htm');
end;

end.





