unit UfrmDDSclock;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RzButton, StdCtrls, RzLabel, Mask, RzEdit, RzSpnEdt, ExtCtrls,
  RzPanel, RzRadGrp, RzRadChk, D2XXUnit;

type
  TfrmDDSclock = class(TForm)
    RzBitBtn_Save: TRzBitBtn;
    RzBitBtn_Exit: TRzBitBtn;
    RzBitBtn_Help: TRzBitBtn;
    RzLabel4: TRzLabel;
    RzLabel5: TRzLabel;
    RzLabel6: TRzLabel;
    RzRG_Step: TRzRadioGroup;
    RzGroupBox1: TRzGroupBox;
    RzSpinEdit_DDSclock: TRzSpinEdit;
    RzLabel1: TRzLabel;
    RzGroupBox2: TRzGroupBox;
    RzLabel2: TRzLabel;
    RzLabel3: TRzLabel;
    RzNumEdit_LSBoffset: TRzNumericEdit;
    RzNumEdit_USBoffset: TRzNumericEdit;
    RzSpinButtons_offsets: TRzSpinButtons;
    RzBitBtn_SendOffsets: TRzBitBtn;
    RzBitBtn_SendDDS: TRzBitBtn;
    RzLabel8: TRzLabel;
    RzGroupBox3: TRzGroupBox;
    RzLabel_CWoffset: TRzLabel;
    RzNumEdit_CWoffset: TRzNumericEdit;
    RzSpinButtons_CWoffset: TRzSpinButtons;
    RzBitBtn_SendCWoffset: TRzBitBtn;
    RzLabel9: TRzLabel;
    RzChBox_EnableCWoffset: TRzCheckBox;
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure RzBitBtn_SaveClick(Sender: TObject);
    procedure RzBitBtn_SendDDSClick(Sender: TObject);
    procedure RzBitBtn_SendOffsetsClick(Sender: TObject);
    procedure RzRG_StepClick(Sender: TObject);
    procedure RzSpinButtons_offsetsDownLeftClick(Sender: TObject);
    procedure RzSpinButtons_offsetsUpRightClick(Sender: TObject);
    procedure RzSpinButtons_CWoffsetDownLeftClick(Sender: TObject);
    procedure RzSpinButtons_CWoffsetUpRightClick(Sender: TObject);
    procedure RzBitBtn_SendCWoffsetClick(Sender: TObject);
    procedure RzChBox_EnableCWoffsetClick(Sender: TObject);
    procedure RzBitBtn_HelpClick(Sender: TObject);
  private
    SpinStep: word;
    block: array[0..4] of byte;
    procedure SetBlock(n: longint);
    procedure SetStep;
    procedure EnableControls;
  public
    procedure Initialise;
    function SendDDSclock: boolean;
    function SendUSBoffset: boolean;
    function SendLSBoffset: boolean;
    function SendCWoffset: boolean;
  end;

var
  frmDDSclock: TfrmDDSclock;

implementation

{$R *.dfm}

uses UIniData, UfrmMain, UUsb;

procedure TfrmDDSclock.Initialise;
begin
  RzRG_step.ItemIndex := 1;
  SetStep;
  with g_EememIniData do
  begin
    RzSpinEdit_DDSclock.Value := IniDDSclock;
    RzNumEdit_LSBoffset.Value := IniLSBoffset;
    RzNumEdit_USBoffset.Value := IniUSBoffset;
    RzNumEdit_CWoffset.Value := IniCWoffset;
    RzChBox_EnableCWoffset.Checked := (IniCWoffsetEnable = 1);
  end;
  EnableControls;
end;

procedure TfrmDDSclock.RzBitBtn_ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmDDSclock.EnableControls;
begin
  if RzChBox_EnableCWoffset.Checked then
  begin
    RzNumEdit_CWoffset.Enabled := true;
    RzSpinButtons_CWoffset.Enabled := true;
    RzLabel_CWoffset.Enabled := true;
  end
  else begin
    RzNumEdit_CWoffset.Enabled := false;
    RzSpinButtons_CWoffset.Enabled := false;
    RzLabel_CWoffset.Enabled := false;
  end;
end;




procedure TfrmDDSclock.RzBitBtn_SaveClick(Sender: TObject);
begin
  with g_EememIniData do
  begin
    IniDDSclock := trunc(RzSpinEdit_DDSclock.Value);
    IniLSBoffset := trunc(RzNumEdit_LSBoffset.Value);
    IniUSBoffset := trunc(RzNumEdit_USBoffset.Value);
    IniCWoffset := trunc(RzNumEdit_CWoffset.Value);
    if RzChBox_EnableCWoffset.Checked
    then IniCWoffsetEnable := 1
    else IniCWoffsetEnable := 0;
  end;
  SaveEememIniFile;
  Close;
end;

procedure TfrmDDSclock.RzBitBtn_SendDDSClick(Sender: TObject);
begin
  frmMain.USBstate[ddsclk] := 'W';
end;

procedure TfrmDDSclock.RzBitBtn_SendOffsetsClick(Sender: TObject);
begin
  frmMain.USBstate[lsboffs] := 'W';
  frmMain.USBstate[usboffs] := 'W';
end;

procedure TfrmDDSclock.RzBitBtn_SendCWoffsetClick(Sender: TObject);
begin
  frmMain.USBstate[cwoffs] := 'W';
end;


function TfrmDDSclock.SendDDSclock: boolean;
var
  n: longint;
begin
  result := false;
  n := trunc(RzSpinEdit_DDSclock.Value);
  SetBlock(n);
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_D') then exit;
  if not Usb.usSendBlock(@block,4) then exit;     //  sent byte count
  result := true;
end;


function TfrmDDSclock.SendUSBoffset: boolean;
var
  n: longint;
begin
  result := false;
  n := trunc(RzNumEdit_USBoffset.Value);
  SetBlock(n);
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_U') then exit;
  if not Usb.usSendBlock(@block,4) then exit;     //  sent byte count
  result := true;
end;


function TfrmDDSclock.SendLSBoffset: boolean;
var
  n: longint;
begin
  result := false;
  n := trunc(RzNumEdit_LSBoffset.Value);
  SetBlock(n);
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_L') then exit;
  if not Usb.usSendBlock(@block,4) then exit;     //  sent byte count
  result := true;
end;


function TfrmDDSclock.SendCWoffset: boolean;
var
  n: longint;
begin
  result := false;
  n := trunc(RzNumEdit_CWoffset.Value);
  SetBlock(n);
  if RzChBox_EnableCWoffset.Checked
  then block[4] := 1
  else block[4] := 0;
  Purge_USB_Device_In;
  if not Usb.usSendString('$$$CFG_C') then exit;
  if not Usb.usSendBlock(@block,5) then exit;     //  sent byte count
  result := true;
end;





procedure TfrmDDSclock.SetBlock(n: longint);
begin
  block[0] := n MOD 256;
  n := n DIV 256;
  block[1] := n MOD 256;
  n := n DIV 256;
  block[2] := n MOD 256;
  block[3] := n  DIV 256;
end;

procedure TfrmDDSclock.RzRG_StepClick(Sender: TObject);
begin
  SetStep;
end;

procedure TfrmDDSclock.SetStep;
var
  step: word;
begin
  step := 10;
  case RzRG_Step.ItemIndex of
    0:  step := 1;
    1:  step := 10;
    2:  step := 100;
    3:  step := 1000;
  end;
  RzSpinEdit_DDSclock.Increment := step;
  SpinStep := step;
end;

procedure TfrmDDSclock.RzSpinButtons_offsetsDownLeftClick(Sender: TObject);
begin
  RzNumEdit_LSBoffset.Value := RzNumEdit_LSBoffset.Value + SpinStep;
  RzNumEdit_USBoffset.Value := RzNumEdit_USBoffset.Value + SpinStep;
end;

procedure TfrmDDSclock.RzSpinButtons_offsetsUpRightClick(Sender: TObject);
begin
  RzNumEdit_LSBoffset.Value := RzNumEdit_LSBoffset.Value - SpinStep;
  RzNumEdit_USBoffset.Value := RzNumEdit_USBoffset.Value - SpinStep;
end;

procedure TfrmDDSclock.RzSpinButtons_CWoffsetDownLeftClick(
  Sender: TObject);
begin
  RzNumEdit_CWoffset.Value := RzNumEdit_CWoffset.Value + SpinStep;
end;

procedure TfrmDDSclock.RzSpinButtons_CWoffsetUpRightClick(Sender: TObject);
begin
  RzNumEdit_CWoffset.Value := RzNumEdit_CWoffset.Value - SpinStep;
end;


procedure TfrmDDSclock.RzChBox_EnableCWoffsetClick(Sender: TObject);
begin
  Application.ProcessMessages;
  EnableCOntrols;
end;

procedure TfrmDDSclock.RzBitBtn_HelpClick(Sender: TObject);
begin
  frmMain.WebBrowser('http://www.homebrew-radios.net/trxavr_picastar/TP_setup_4_USB_data.htm');
end;

end.


