unit UfrmDBRtf;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, RzEdit, ExtCtrls, RzPanel, UGlobals,
  RzButton, RzRadChk, RzLabel, IBDatabase, DB, IBCustomDataSet, IBQuery,
  Contnrs, UDBRichText, DateUtils, dxPSGlbl, dxPSUtl, dxPSEngn, dxPrnPg,
  dxBkgnd, dxWrap, dxPrnDev, dxPSCompsProvider, dxPSFillPatterns,
  dxPSEdgePatterns, Menus, dxPSCore, dxPSRELnk, ToolWin, ImgList, ClipBrd,
  RzStatus, RzLaunch;

type



  TfrmDBRtf = class(TForm)
    dxCP_DBrtf: TdxComponentPrinter;
    dxCPLink_DBrtf: TdxRichEditReportLink;
    MainMenu_Rtf: TMainMenu;
    Menu_Print: TMenuItem;
    Menu_PrintSetup: TMenuItem;
    RzPanel3: TRzPanel;
    Ruler: TPanel;
    FirstInd: TLabel;
    LeftInd: TLabel;
    RulerLine: TBevel;
    RightInd: TLabel;
    Editor: TRzRichEdit;
    ToolbarImages: TImageList;
    FontDialog1: TFontDialog;
    OpenDialog: TOpenDialog;
    ToolBar: TToolBar;
    OpenButton: TToolButton;
    SaveButton: TToolButton;
    ToolButton5: TToolButton;
    UndoButton: TToolButton;
    CutButton: TToolButton;
    CopyButton: TToolButton;
    PasteButton: TToolButton;
    ToolButton10: TToolButton;
    FontName: TComboBox;
    ToolButton11: TToolButton;
    FontSize: TEdit;
    UpDown1: TUpDown;
    BoldButton: TToolButton;
    ItalicButton: TToolButton;
    UnderlineButton: TToolButton;
    ToolButton16: TToolButton;
    LeftAlign: TToolButton;
    CenterAlign: TToolButton;
    RightAlign: TToolButton;
    ToolButton20: TToolButton;
    BulletsButton: TToolButton;
    SaveDialog: TSaveDialog;
    Menu_EditRtf: TMenuItem;
    Menu_Undo: TMenuItem;
    Menu_Paste: TMenuItem;
    Menu_FileRtf: TMenuItem;
    Menu_SaveAs: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Menu_Save: TMenuItem;
    Menu_New: TMenuItem;
    Menu_Open: TMenuItem;
    Menu_Exit: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    PopupMenu1: TPopupMenu;
    Copy2: TMenuItem;
    Paste1: TMenuItem;
    Undo1: TMenuItem;
    Selectall1: TMenuItem;
    Cut2: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    RzLauncher1: TRzLauncher;
    ToolButton_Print: TToolButton;
    ToolButton_PrintSetup: TToolButton;
    ToolButton3: TToolButton;
    ToolButton_Export: TToolButton;
    ToolButton_Help: TToolButton;
    RzStatusBar1: TRzStatusBar;
    RzStatusPane_Left: TRzStatusPane;
    RzStatusPane_Right: TRzStatusPane;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure EditorSelectionChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure RzBitBtn_PrintClick(Sender: TObject);
    procedure Menu_PrintClick(Sender: TObject);
    procedure Menu_PrintSetupClick(Sender: TObject);
    procedure Cut(Sender: TObject);
    procedure Copy(Sender: TObject);
    procedure Paste(Sender: TObject);
    procedure FileSave(Sender: TObject);
    procedure RulerResize(Sender: TObject);
    procedure RightIndMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RightIndMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure RightIndMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RightAlignClick(Sender: TObject);
    procedure BoldButtonClick(Sender: TObject);
    procedure BulletsButtonClick(Sender: TObject);
    procedure CenterAlignClick(Sender: TObject);
    procedure FirstIndMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FirstIndMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FirstIndMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FontNameChange(Sender: TObject);
    procedure FontSizeChange(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ItalicButtonClick(Sender: TObject);
    procedure LeftAlignClick(Sender: TObject);
    procedure LeftIndMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LeftIndMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure LeftIndMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FileOpen(Sender: TObject);
    procedure UnderlineButtonClick(Sender: TObject);
    procedure Undo(Sender: TObject);
    procedure EditorChange(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure FileSaveAs(Sender: TObject);
    procedure Menu_ExitClick(Sender: TObject);
    procedure FileNew(Sender: TObject);
    procedure SelectAll(Sender: TObject);
    procedure RzBitBtn_PagesPrintClick(Sender: TObject);
    procedure ToolButton_HelpClick(Sender: TObject);
    procedure ToolButton_ExportClick(Sender: TObject);
    procedure ToolButton_PrintSetupClick(Sender: TObject);
    procedure ToolButton_PrintClick(Sender: TObject);
  private
    zItemId: integer;
    zMaxCount: integer;
    zMaxMonths: integer;
    zUseReadCodes: integer;
    zDrugAdmin: integer;
    zDrugCompliance: integer;
    zNonDrugs: integer;
    zTitle: string;
    zItemIdent: string;
    zCaption: string;
    zRcList: TObjectList;
    SumSummaryId: integer;
    SumTitle: string;
    SumCaption: string;
    SumDescription: string;
    SumFontSize: integer;
    SumFontName: string;
    SumDateCreated: TDateTime;
    SumDateModified: TDateTime;
    SumHideHeaders: integer;
    ItemList: TObjectList;

    NewForm: boolean;
    RectSet: boolean;
    PrintHeader: string;
    PrintFooter: string;
    FFileName: string;
    FUpdating: Boolean;
    FDragOfs: Integer;
    FDragging: Boolean;
    FClipboardOwner: HWnd;
    DBRichText: TDBRichText;
    HasPageBreak: boolean;
    procedure ControlsEnable(Enabled: boolean);
    function HorizontalLine: string;
    function CurrText: TTextAttributes;
    procedure GetFontNames;
    procedure SetFileName(const FileName: String);
    procedure CheckFileSave;
    procedure SetupRuler;
    procedure SetEditRect;
    procedure UpdateCursorPos;
    procedure SetModified(Value: Boolean);
    procedure ClipboardChanged;
    procedure WMDropFiles(var Msg: TWMDropFiles); message WM_DROPFILES;
    procedure WMChangeCBChain(var Msg: TWMChangeCBChain); message WM_CHANGECBCHAIN;
    procedure WMDrawClipboard(var Msg: TWMDrawClipboard); message WM_DRAWCLIPBOARD;
    procedure PerformFileOpen(const AFileName: string);

    procedure BuildRtfDisplay;
    procedure PrintText(ShowDialog: boolean; Section: integer);
    procedure PrintInitialise(Section: integer);
    procedure PrinterSetup;
  public
    SumId: integer;
    Title: string;
    Description: string;
    function Initialise: boolean;
    procedure ClipBoardRemove;
  end;


var
  frmDBrtf: TfrmDBrtf;

implementation

uses UIniData, ShellAPI, RichEdit, UfrmMain, UOwdxPrintConfig, UfrmPreSetup,
  About, UfrmSummaryExport, UfrmCalswr, UfrmDatabase;

const
  RulerAdj = 4/3;
  GutterWid = 6;


{$R *.dfm}



/////////////  TfrmDBrtf ////////////////////////////





function TfrmDBrtf.HorizontalLine: string;
var
  i: integer;
begin
  result := '';
  for i := 1 to 15 do result := result + '_______________';
end;



procedure TfrmDBrtf.ClipBoardRemove;
begin
  // remove ourselves from the viewer chain
  ChangeClipboardChain(Handle, FClipboardOwner);
end;


function TfrmDBrtf.CurrText: TTextAttributes;
begin
  if Editor.SelLength > 0 then Result := Editor.SelAttributes
  else Result := Editor.DefAttributes;
end;


function EnumFontsProc(var LogFont: TLogFont; var TextMetric: TTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin
  TStrings(Data).Add(LogFont.lfFaceName);
  Result := 1;
end;

procedure TfrmDBrtf.ControlsEnable(Enabled: boolean);
begin
  Toolbar.Enabled := Enabled;
  Ruler.Enabled := Enabled;
  Menu_FileRtf.Enabled := Enabled;
  Menu_EditRtf.Enabled := Enabled;
end;


procedure TfrmDBrtf.GetFontNames;
var
  DC: HDC;
begin
  DC := GetDC(0);
  EnumFonts(DC, nil, @EnumFontsProc, Pointer(FontName.Items));
  ReleaseDC(0, DC);
  FontName.Sorted := True;
end;

procedure TfrmDBrtf.SetFileName(const FileName: String);
begin
  FFileName := FileName;
  Caption := concat(' HOBCAT - Database record printing: [ ',ExtractFileName(FileName), ' ]' );
  if Title <> '' then Caption := concat(Caption,'  -  ',Title);
end;

procedure TfrmDBrtf.CheckFileSave;
var
  SaveResp: Integer;
begin
  Exit; //////////////////////////////   Problem of this message when chnaging patient !!
  if not Editor.Modified then Exit;
  if FFileName = 'Untitled'
  then SaveResp := MessageDlg(Format('Save changes to summary:  %s?', [zTitle]),
                                            mtConfirmation, mbYesNoCancel, 0)
  else SaveResp := MessageDlg(Format('Save changes to %s?', [FFileName]),
    mtConfirmation, mbYesNoCancel, 0);
  case SaveResp of
    idYes: FileSave(Self);
    idNo: {Nothing};
    idCancel: Abort;
  end;
end;

procedure TfrmDBrtf.SetupRuler;
var
  I: Integer;
  S: String;
begin
  SetLength(S, 201);
  I := 1;
  while I < 200 do
  begin
    S[I] := #9;
    S[I+1] := '|';
    Inc(I, 2);
  end;
  Ruler.Caption := S;
end;

procedure TfrmDBrtf.SetEditRect;
var
  R: TRect;
begin
  with Editor do
  begin
    R := Rect(GutterWid, 0, ClientWidth-GutterWid, ClientHeight);
    SendMessage(Handle, EM_SETRECT, 0, Longint(@R));
  end;
end;

procedure TfrmDBrtf.FormCreate(Sender: TObject);
begin
  if frmCalswr = nil then
  begin
    frmCalswr := TfrmCalswr.Create(self);
    frmCalSwr.Timer_ADC.Enabled := false;
    frmCalswr.Initialise;
  end;
  DBRichText := TDBRichText.Create;
  ItemList := TObjectList.Create;
  zRcList := TObjectList.Create;
  NewForm := true;
  OpenDialog.InitialDir := ExtractFilePath(ParamStr(0));
  SaveDialog.InitialDir := OpenDialog.InitialDir;
  SetFileName('Untitled');
  GetFontNames;
  SetupRuler;
  EditorSelectionChange(Self);
  FClipboardOwner := SetClipboardViewer(Handle);
end;


function TfrmDBrtf.Initialise: boolean;
var
  ch: char;
begin
{
  with g_RegIniData do
  begin
    left := IniSummFormLeft;
    top := IniSummFormTop;
    width := IniSummFormwidth;
    height := IniSummFormHeight;
  end;
}
  ItemList.Clear;

  DBRichText.SummaryFontSize := 9;
  DBRichText.SummaryFontName := 'Ariel';

  ControlsEnable(false);
  BuildRtfDisplay;
  ControlsEnable(true);
end;




procedure TfrmDBrtf.BuildRtfDisplay;
var
  Loaded: boolean;
  Count: integer;
  id,n,i: integer;
  DateWidth: integer;
  Handle: integer;
begin
  SetModified(false);
  with Canvas do
  begin
    Font.Size := SumFontSize;
    Font.Name := SumFontName;
    FontName.Text := SumFontName;
    Font.Style := [];
    DBRichText.DateWidth := TextWidth('23/12/2004');
  end;
  RectSet := False;
  with DBRichText do
  begin
    try
 //     SetFormatStrings;
      SetRtfColours(g_RegIniData.IniPrintInColor);
      InitialiseTextFile(g_TextFilePath);
      WriteHeaderData('HOBCAT database - project printout');
      id := frmDatabase.GetFocusedId;
      WriteProjectRecord(id);
//      WriteHeading('ATmega2560 ADC level / forward & reflected watts calibration');
      FinaliseTextFile;
    except
      MessageDlg('Error creating RTF file',mtWarning,[mbOk],0);
      CloseExceptTextfile;
      Exit;
    end;
  end;
  if not RectSet then SetEditRect;
  RectSet := true;
  with Editor do
  begin
    Clear;
    Invalidate;
    PlainText := false;
    Count := 0;
    { terminal server - just in case temporary file deleted by another terminal }
    repeat
      inc(Count);
      Loaded := false;
      try
        DBRichText.CloseExceptTextFile;
        Lines.LoadFromFile(g_TextFilePath);
        Loaded := true;
      except
      end;
      Application.ProcessMessages;
      try
        assignfile(g_TextFile,g_TextFilePath);
        Erase(g_TextFile)
      except
      end;
    until Loaded OR (Count >= 4);
    if not Loaded
    then MessageDlg('Data display: Failed to load file ' + g_TextFilePath, mtWarning, [mbOk],0);
  end;
  Editor.Modified := false;
  SetModified(false);
end;




procedure TfrmDBrtf.FormResize(Sender: TObject);
begin
  EditorSelectionChange(Sender);
  SetEditRect;
end;

procedure TfrmDBrtf.FormActivate(Sender: TObject);
begin
  UpdateCursorPos;
end;



procedure TfrmDBrtf.UpdateCursorPos;
var
  CharPos: TPoint;
begin
  with Editor do
  begin
    CharPos.Y := SendMessage(Handle, EM_EXLINEFROMCHAR, 0, SelStart);
    CharPos.X := (SelStart - SendMessage(Handle, EM_LINEINDEX, CharPos.Y, 0));
    Inc(CharPos.Y);
    Inc(CharPos.X);
  end;
end;


procedure TfrmDBrtf.WMDropFiles(var Msg: TWMDropFiles);
var
  CFileName: array[0..MAX_PATH] of Char;
begin
  try
    if DragQueryFile(Msg.Drop, 0, CFileName, MAX_PATH) > 0 then
    begin
      CheckFileSave;
      PerformFileOpen(CFileName);
      Msg.Result := 0;
    end;
  finally
    DragFinish(Msg.Drop);
  end;
end;


procedure TfrmDBrtf.WMDrawClipboard(var Msg: TWMDrawClipboard);
begin
  SendMessage(FClipboardOwner, WM_DRAWCLIPBOARD, 0, 0);
  Msg.Result := 0;
  ClipboardChanged;
end;



procedure TfrmDBrtf.WMChangeCBChain(var Msg: TWMChangeCBChain);
begin
  if Msg.Remove = FClipboardOwner then FClipboardOwner := Msg.Next
  else SendMessage(FClipboardOwner, WM_CHANGECBCHAIN, Msg.Remove, Msg.Next);
  Msg.Result := 0;
end;



procedure TfrmDBrtf.ClipboardChanged;
var
  I: Integer;
  Format: Word;
  E: Boolean;
begin
  // check to see if we can paste what's on the clipboard
  E := False;
  for I := 0 to Clipboard.FormatCount - 1 do
  begin
    Format := Clipboard.Formats[I];
    if SendMessage(Editor.Handle, EM_CANPASTE, Format, 0) <> 0 then
    begin
      E := True;
      Break;
    end;
  end;
  PasteButton.Enabled := E;
  Menu_Paste.Enabled := E;
end;



procedure TfrmDBrtf.EditorSelectionChange(Sender: TObject);
begin
  with Editor.Paragraph do
  try
    FUpdating := True;
    FirstInd.Left := Trunc(FirstIndent*RulerAdj)-4+GutterWid;
    LeftInd.Left := Trunc((LeftIndent+FirstIndent)*RulerAdj)-4+GutterWid;
    RightInd.Left := Ruler.ClientWidth-6-Trunc((RightIndent+GutterWid)*RulerAdj);
    BoldButton.Down := fsBold in Editor.SelAttributes.Style;
    ItalicButton.Down := fsItalic in Editor.SelAttributes.Style;
    UnderlineButton.Down := fsUnderline in Editor.SelAttributes.Style;
    BulletsButton.Down := Boolean(Numbering);
    FontSize.Text := IntToStr(Editor.SelAttributes.Size);
    FontName.Text := Editor.SelAttributes.Name;
    case Ord(Alignment) of
      0: LeftAlign.Down := True;
      1: RightAlign.Down := True;
      2: CenterAlign.Down := True;
    end;
    UpdateCursorPos;
  finally
    FUpdating := False;
  end;
end;


procedure TfrmDBrtf.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  frmCalSwr.Free;
  frmCalSwr := nil;
  DBRichText.Free;
  zRcList.Free;
  ItemList.Free;
  Action := caFree;
  with g_RegIniData do
  begin
    IniSummFormLeft := left;
    IniSummFormTop := Top;
    IniSummFormwidth := width;
    IniSummFormHeight := height;
  end;
  SaveSwrCoordinates;
end;




procedure TfrmDBrtf.PrintInitialise(Section: integer);
begin
  LoadDxPrinterSettings('S');
  OwDxPrintConfig.ApplyDxPrinterSettings(dxCP_DBrtf);
  dxCPLink_DBrtf.OnlySelected := (Editor.SelLength > 0);
  with dxCPLink_DBrtf.PrinterPage do
  begin
    with PageHeader do
    begin
      LeftTitle.Clear;
      RightTitle.Clear;
    end;
    with PageFooter do
    begin
      LeftTitle.Clear;
      RightTitle.Clear;
      LeftTitle.Add(' Printed by Hobcat (c) 2008 homebrew-radioe.ntt, G3VPX');
      if Section = 0
      then RightTitle.Add('Page [Page #] of [Total Pages]')
      else RightTitle.Add('Page ' + IntToStr(Section) + ' -' + '[Page #]');
    end;
  end;
end;

procedure TfrmDBrtf.PerformFileOpen(const AFileName: string);
begin
  Title := '';
  Editor.Lines.LoadFromFile(AFileName);
  SetFileName(AFileName);
  Editor.SetFocus;
  Editor.Modified := False;
  SetModified(False);
end;


procedure TfrmDBrtf.PrinterSetup;
var
  Abort: boolean;
  s: string;
  WidthSave: integer;
begin
  frmPreSetup := TfrmPreSetup.Create(self);
  frmPreSetup.Caption := ' Summary builder SUMMARY printing setup';
  Abort := (frmPreSetup.ShowModal <> mrOk);
  frmPreSetup.Free;
  if Abort then exit;
  PrintInitialise(0);
  dxCP_DBrtf.Preview(true,nil);
  s := 'Do you want to save your changes as defaults for this workstation ?';
  if mrYes = MessageDlg(s,mtConfirmation,[mbYes,mbNo],0) then
  begin
    OwDxPrintConfig.ExtractDxPrinterSettings(dxCP_DBrtf);
    SaveDxPrinterSettings('S');
  end;
end;


procedure TfrmDBrtf.PrintText(ShowDialog: boolean; Section: integer);
var
  s: string;
begin
  PrintInitialise(Section);
  dxCP_DBrtf.Print(ShowDialog,nil,nil);
end;




procedure TfrmDBrtf.RzBitBtn_PrintClick(Sender: TObject);
begin
  PrintText(true,0);
end;

procedure TfrmDBrtf.Menu_PrintClick(Sender: TObject);
begin
  PrintText(true,0);
end;

procedure TfrmDBrtf.Menu_PrintSetupClick(Sender: TObject);
begin
  PrinterSetup;
end;

procedure TfrmDBrtf.Cut(Sender: TObject);
begin
  Editor.CutToClipboard;
end;

procedure TfrmDBrtf.Copy(Sender: TObject);
begin
  Editor.CopyToClipboard;
end;

procedure TfrmDBrtf.Paste(Sender: TObject);
begin
  Editor.PasteFromClipboard;
end;

procedure TfrmDBrtf.FileSave(Sender: TObject);
begin
  if FFileName = 'Untitled' then
    FileSaveAs(Sender)
  else
  begin
    Editor.Lines.SaveToFile(FFileName);
    Editor.Modified := False;
    SetModified(False);
  end;
end;

procedure TfrmDBrtf.SetModified(Value: Boolean);
begin
  if Value
  then RzStatusPane_Left.Caption := 'Modified'
  else RzStatusPane_Left.Caption := '';
end;




procedure TfrmDBrtf.RulerResize(Sender: TObject);
begin
  RulerLine.Width := Ruler.ClientWidth - (RulerLine.Left*2);
end;

procedure TfrmDBrtf.RightIndMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragOfs := (TLabel(Sender).Width div 2);
  TLabel(Sender).Left := TLabel(Sender).Left+X-FDragOfs;
  FDragging := True;
end;


procedure TfrmDBrtf.RightIndMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if FDragging then
    TLabel(Sender).Left :=  TLabel(Sender).Left+X-FDragOfs
end;

procedure TfrmDBrtf.RightIndMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  Editor.Paragraph.RightIndent := Trunc((Ruler.ClientWidth-RightInd.Left+FDragOfs-2) / RulerAdj)-2*GutterWid;
  EditorSelectionChange(Sender);
end;

procedure TfrmDBrtf.RightAlignClick(Sender: TObject);
begin
  if FUpdating then Exit;
  Editor.Paragraph.Alignment := TAlignment(TControl(Sender).Tag);
end;

procedure TfrmDBrtf.BoldButtonClick(Sender: TObject);
begin
  if FUpdating then Exit;
  if BoldButton.Down then
    CurrText.Style := CurrText.Style + [fsBold]
  else
    CurrText.Style := CurrText.Style - [fsBold];
end;

procedure TfrmDBrtf.BulletsButtonClick(Sender: TObject);
begin
  if FUpdating then Exit;
  Editor.Paragraph.Numbering := TNumberingStyle(BulletsButton.Down);
end;

procedure TfrmDBrtf.CenterAlignClick(Sender: TObject);
begin
  if FUpdating then Exit;
  Editor.Paragraph.Alignment := TAlignment(TControl(Sender).Tag);
end;

procedure TfrmDBrtf.FirstIndMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragOfs := (TLabel(Sender).Width div 2);
  TLabel(Sender).Left := TLabel(Sender).Left+X-FDragOfs;
  FDragging := True;
end;

procedure TfrmDBrtf.FirstIndMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if FDragging then
    TLabel(Sender).Left :=  TLabel(Sender).Left+X-FDragOfs
end;

procedure TfrmDBrtf.FirstIndMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  Editor.Paragraph.FirstIndent := Trunc((FirstInd.Left+FDragOfs-GutterWid) / RulerAdj);
  LeftIndMouseUp(Sender, Button, Shift, X, Y);
end;

procedure TfrmDBrtf.FontNameChange(Sender: TObject);
begin
  if FUpdating then Exit;
  CurrText.Name := FontName.Items[FontName.ItemIndex];
end;

procedure TfrmDBrtf.FontSizeChange(Sender: TObject);
begin
  if FUpdating then Exit;
  CurrText.Size := StrToInt(FontSize.Text);
end;

procedure TfrmDBrtf.FormPaint(Sender: TObject);
begin
  SetEditRect;
end;

procedure TfrmDBrtf.FormShow(Sender: TObject);
begin
  UpdateCursorPos;
  DragAcceptFiles(Handle, True);
  EditorChange(nil);
  Editor.SetFocus;
  ClipboardChanged;
end;

procedure TfrmDBrtf.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  try
    CheckFileSave;
  except
    CanClose := False;
  end;
end;

procedure TfrmDBrtf.ItalicButtonClick(Sender: TObject);
begin
  if FUpdating then Exit;
  if ItalicButton.Down then
    CurrText.Style := CurrText.Style + [fsItalic]
  else
    CurrText.Style := CurrText.Style - [fsItalic];
end;

procedure TfrmDBrtf.LeftAlignClick(Sender: TObject);
begin
  if FUpdating then Exit;
  Editor.Paragraph.Alignment := TAlignment(TControl(Sender).Tag);
end;

procedure TfrmDBrtf.LeftIndMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragOfs := (TLabel(Sender).Width div 2);
  TLabel(Sender).Left := TLabel(Sender).Left+X-FDragOfs;
  FDragging := True;
end;

procedure TfrmDBrtf.LeftIndMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if FDragging then
    TLabel(Sender).Left :=  TLabel(Sender).Left+X-FDragOfs
end;

procedure TfrmDBrtf.LeftIndMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  Editor.Paragraph.LeftIndent := Trunc((LeftInd.Left+FDragOfs-GutterWid) / RulerAdj)-Editor.Paragraph.FirstIndent;
  EditorSelectionChange(Sender);
end;

procedure TfrmDBrtf.FileOpen(Sender: TObject);
begin
  CheckFileSave;
  if OpenDialog.Execute then
  begin
    PerformFileOpen(OpenDialog.FileName);
    Editor.ReadOnly := ofReadOnly in OpenDialog.Options;
  end;
end;

procedure TfrmDBrtf.UnderlineButtonClick(Sender: TObject);
begin
  if FUpdating then Exit;
  if UnderlineButton.Down then
    CurrText.Style := CurrText.Style + [fsUnderline]
  else
    CurrText.Style := CurrText.Style - [fsUnderline];
end;

procedure TfrmDBrtf.Undo(Sender: TObject);
begin
  with Editor do
    if HandleAllocated then SendMessage(Handle, EM_UNDO, 0, 0);
end;

procedure TfrmDBrtf.FileSaveAs(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    if FileExists(SaveDialog.FileName) then
      if MessageDlg(Format('OK to overwrite %s', [SaveDialog.FileName]),
        mtConfirmation, mbYesNoCancel, 0) <> idYes then Exit;
    Editor.Lines.SaveToFile(SaveDialog.FileName);
    SetFileName(SaveDialog.FileName);
    Editor.Modified := False;
    SetModified(False);
  end;
end;

procedure TfrmDBrtf.EditorChange(Sender: TObject);
begin
  SetModified(Editor.Modified);
  UndoButton.Enabled := SendMessage(Editor.Handle, EM_CANUNDO, 0, 0) <> 0;
  Menu_Undo.Enabled := UndoButton.Enabled;
end;


procedure TfrmDBrtf.N2Click(Sender: TObject);
begin
  FontDialog1.Font.Assign(Editor.SelAttributes);
  if FontDialog1.Execute then
    CurrText.Assign(FontDialog1.Font);
  Editor.SetFocus;
end;

procedure TfrmDBrtf.Menu_ExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


procedure TfrmDBrtf.FileNew(Sender: TObject);
begin
  Title := '';
  SetFileName('Untitled');
  Editor.Lines.Clear;
  Editor.Modified := False;
  SetModified(False);
end;

procedure TfrmDBrtf.SelectAll(Sender: TObject);
begin
  Editor.SelectAll;
end;

procedure TfrmDBrtf.RzBitBtn_PagesPrintClick(Sender: TObject);
var
  p: integer;
  n: integer;
  CurPos: integer;
  PrevStart: integer;
  Section: integer;
  s: string;
begin
  s := 'This option prints the summary in numbered sections with each section starting on a page break item. '
           + #10#13 + 'Page break items are inserted when the summary is being defined.'
           + #10#13 + 'They appear in the text as  _-_-_-.'
           + #10#13 + 'Page numbering is: Section - Page-within-section'', eg:  2 - 3 .'
           + #10#13
           + #10#13 + '  Click OK to proceed:';
  if mrOK <> MessageDlg(s,mtConfirmation,[mbOk, mbCancel],0) then exit;
  with Editor do
  begin
    n := Lines.Count;
    PrevStart := 0;
    Line := 0;
    Section := 0;
    repeat
      inc(Section);
      repeat
        Line := Line + 1;
        p := Pos('_-_-_-',Lines[Line-1]);
      until (p > 0) or (Line >= n);
      if Line > n then Line := n;
      CurPos := SelStart;
      SelStart := PrevStart;
      PrevStart := Curpos + 8;
      SelLength := CurPos - SelStart;
      PrintText(false,Section);
      SelStart := PrevStart;
    until Line = n;
  end;
end;



procedure TfrmDBrtf.ToolButton_HelpClick(Sender: TObject);
begin
  frmMain.HtmlHelp.DisplayContext(2700);
end;

procedure TfrmDBrtf.ToolButton_ExportClick(Sender: TObject);
var
  FileName: string;
begin
  frmSummaryExport := TfrmSummaryExport.Create(self);
  with frmSummaryExport do
  begin
    Initialise;
    ShowModal;
    RzLauncher1.FileName := LaunchFileName;
    RzLauncher1.Parameters := LaunchParameters;
    FileName := SaveFileName;
    Free;
  end;
  if RzLauncher1.Filename = '' then exit;
  Editor.Lines.SaveToFile(Filename);
  with RzLauncher1 do
  begin
    if Filename <> '' then Launch;
  end;

end;

procedure TfrmDBrtf.ToolButton_PrintSetupClick(Sender: TObject);
begin
  PrinterSetup;
end;

procedure TfrmDBrtf.ToolButton_PrintClick(Sender: TObject);
begin
  PrintText(true,0);
end;

end.



