unit UfrmCalswr;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComPort, ComCtrls, Menus, RzButton, RzBorder, ExtCtrls,
  RzLabel, RzPanel, UIniData, HHComp, UGlobals, RzStatus, FileCtrl, syncobjs;

type

  TCalItem = record
               adc: integer;
               watts: integer;
             end;



  TCal = record
           caWattsPerLED: integer;  //    deciwatts
           caFsWatts: integer;   //    deciwatts
           caMismatchSeconds: integer;
           caMisMatchWatts: integer;
           caComment: string[255];
           caData: array[1..32] of TCalItem;
           caWatts32: array[1..32] of integer;
           caLedAdc: array[1..24] of integer;
           caLedAdcS: array[1..24] of integer;
         end;

  TfrmCalswr = class(TForm)
    Timer_ADC: TTimer;
    Timer_Startup: TTimer;
    procedure Timer_ADCTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    TimeoutErrorCount: integer;
    LessThanTenErrorCount: integer;
    CheckSumErrorCount: integer;
    NoDataCount: integer;
    LedsFwd: integer;
    LedsRef: integer;
    LedsRefS: integer;
    Swrx256: integer;
    CalFile: file of TCal;
    FwdWatts: single;
    RefWatts: single;
    Closing: boolean;
    btot: integer;
    CloseSwrCal: boolean;
    SwrAdcDelayEvent: TEvent;
    function ReadSwrData(var ADfwd, ADref: integer): char;
    function ParseAdcData(var s: string; var fwd,ref: integer): boolean;
  public
    CalFwd: TCal;
    CalRef: TCal;
    ADfwd: integer;
    ADref:  integer;
    NoAdcData: boolean;
    procedure Initialise;
    procedure GetADC;
    procedure LoadCalFiles;
  end;



var
  frmCalswr: TfrmCalswr;

implementation

uses About, UfrmRtf, UfrmUpdate, UfrmMain, DateUtils,
     UUsb, D2XXUnit, UfrmCal;

{$R *.dfm}



function TfrmCalswr.ParseAdcData(var s: string; var fwd,ref: integer): boolean;
var
  u: string;
  p: integer;
  valerr: integer;
begin
  result := false;
  p := pos(',',s);
  if p < 2 then exit;
  u := copy(s,1,p-1);
  val(u,fwd,valerr);
  if valerr > 0 then exit;
  s := copy(s,p+1,100);
  p := pos(#13,s);
  if p < 2 then exit;
  u := copy(s,1,p-1);
  val(u,ref,valerr);
  if valerr > 0 then exit;
  result := true;
end;



function TfrmCalswr.ReadSwrData(var ADfwd, ADref: integer): char;
var
  ss,u: string;
  p,i, fwd, ref: integer;
  valerr: integer;
  RxBytesInQueue: boolean;
  Start_ms: longword;
  noheader: boolean;
  ch: char;
begin
  Application.ProcessMessages;
  RxBytesInQueue := false;
  Start_ms := MilliSecondOfTheWeek(Time);
  TimeoutErrorCount := 0;
  repeat
    if Closing then exit;
    if (MilliSecondOfTheWeek(Time) - Start_ms > 4000) then
    begin
      Inc(TimeoutErrorCount);
      if TimeoutErrorCount > 5 then
      begin
        TimeoutErrorCount := 0;
        MessageDlg('SWR data requested from TrxAVR.'#13#10'Input queue remains empty after 4 seconds.',
                      mtWarning,[mbOK],0);
        result := 'T';
        exit;
      end;
    end;
    if Get_USB_Device_QueueStatus = FT_Ok
    then RxBytesInQueue := (FT_Q_bytes > 0);
  until RxBytesInQueue;
  btot := Read_USB_Device_Buffer(FT_In_Buffer_Size);
  if btot < 7 then
  begin
//    inc(LessThanTenErrorCount);
//    if LessThanTenErrorCount > 5 then
//    begin
//      LessThanTenErrorCount := 0;
      MessageDlg('SWR data requested from TrxAVR.'#13#10'Less than 10 chars received.',
                      mtWarning,[mbOK],0);
      result := 'N';
      exit;
//    end;
  end;
//  LessThanTenErrorCount := 0;
  noheader := false;
  i := 0;
  repeat
    ch := char(FT_In_Buffer[i]);
    inc(i);
  until (ch = 'S') OR (i > btot-8);
  if (ch <> 'S') OR (i > btot-8)
  then noheader := true
  else begin
    SetLength(ss,btot);
    for i := 0 to (btot - 1) do ss[i+1] := char(FT_In_Buffer[i]);
    if copy(ss,1,6) <> 'SWRADC' then noheader := true;
  end;
  if noheader then
  begin
    MessageDlg('SWR data requested from TrxAVR.'#13#10'SWRADC header characters not received.',
                      mtWarning,[mbOK],0);
    result := 'N';
    exit;
  end;
  ss := copy(ss,7,100);
  if not ParseAdcData(ss,AdFwd,ADref) then
  begin
    MessageDlg('SWR data requested from TrxAVR.'#13#10'Parsing error on received data',
                      mtWarning,[mbOK],0);
    result := 'D';
    exit;
  end;
  result := 'K';
end;

{$I-}
procedure TfrmCalswr.LoadCalFiles;  // now only used for summary display
var
  s: string;
begin
  with g_RegIniData do
  begin
    AssignFile(CalFile, IniFwdCalFile);
    Reset(CalFile);
    if IOresult = 0 then
    begin
      Read(CalFile,CalFwd);
      CloseFile(CalFile);
    end
    else begin
      s := 'Forward calibration file not found';
      MessageDlg(s,mtWarning,[mbOK],0);
    end;
    AssignFile(CalFile, IniRefCalFile);
    Reset(CalFile);
    if IOresult = 0 then
    begin
      Read(CalFile,CalRef);
      CloseFile(CalFile);
    end
    else begin
      s := 'Reflected calibration file not found';
      MessageDlg(s,mtWarning,[mbOK],0);
    end;
  end;
end;
{$I+}





procedure TfrmCalswr.Timer_ADCTimer(Sender: TObject);
begin
  frmMain.USBstate[adc] := 'W';
end;


procedure TfrmCalswr.GetADC;
var
  Swr: single;
  adcok: boolean;
  s: string;
  i, w, dw: integer;
  Rc, r: single;
  adcbuf: array[0..3] of byte;
begin
  with Usb do
  begin
    Purge_USB_Device_In;
    usSendString('$$$SWR_A');
    SwrAdcDelayEvent.ResetEvent;
    SwrAdcDelayEvent.WaitFor(50);
    Application.ProcessMessages;
    adcok := Usb.usReceiveBlock(@adcbuf[0],4);
  end;
  if not adcok then
  begin
    FwdWatts := 0;
    RefWatts := 0;
  end
  else begin
    ADfwd := adcbuf[0] + 256*adcbuf[1];
    ADref := adcbuf[2] + 256*adcbuf[3];
    // lookup Fwd watts with interpolation
    i := (ADfwd DIV 32) + 1;
    w := CalFwd.caWatts32[i];
    if i < 32
    then dw := CalFwd.caWatts32[i+1] - w
    else dw := w - CalFwd.caWatts32[i-1];
    r := w + ((AdFwd MOD 32)*dw)/32;
    FwdWatts := r / 100;
    // look up reflected watts with interpolationj
    i := (ADref DIV 32) + 1;
    w := CalRef.caWatts32[i];
    if i < 32
    then dw := CalRef.caWatts32[i+1] - w
    else dw := w - CalRef.caWatts32[i-1];
    r := w + ((AdRef MOD 32)*dw)/32;
    RefWatts := r / 100;
  end;
  if FwdWatts = 0
  then Swr := 0
  else begin
    Rc := Sqrt(RefWatts/FwdWatts);
    if Rc < 1
    then Swr := (1 + Rc) / (1 - Rc)
    else Swr := 99
  end;
  NoAdcData := false;
  ////////////////
end;


procedure TfrmCalswr.Initialise;
var
  TimeString: string;
begin
  CloseSwrCal := false;
  Closing := false;
  g_TempPath := ExtractFilePath(Application.ExeName) + 'Temp';
  if not DirectoryExists(g_TempPath) then CreateDir(g_TempPath);
  {File names are made unique to terminal by using application startup time hhmmsszzz
   where zzz is milliseconds.  }
  TimeString := FormatDateTime('hhmmsszzz',Now);
  g_TextFilePath := g_TempPath + '\' + 'DATA' + '_' + TimeString + '.RTF';
  NoAdcData := true;
  SwrAdcDelayEvent := TEvent.Create(0, true, false, 'Hobcat SwrAdc delay event');

// LoadCalFiles;
end;

procedure TfrmCalswr.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Closing := true;
  Timer_ADC.Enabled := false;
  ACtion := caFree;
  frmCalSwr := nil;
end;


end.
