unit UfrmCal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, dxExEdtr, DB, dxmdaset, dxCntner, dxTL, dxDBCtrl, dxDBGrid,
  ExtCtrls, StdCtrls, RzLabel, RzButton, Mask, RzEdit, RzSpnEdt, RzPanel,
  RzRadGrp, RzBorder, FileCtrl, Syncobjs, UfrmCalswr, HHComp;

type

  TCalKind = (fwd,ref);

//  STRUCT in AVR code and match record in Delphi
//  struct CalTrabsfertruct_type      88 bytes
//  {
//    uint16_t ctsCalLevel[32];    // 32 power levels for ADC output = 32, 64 ... 992
//    uint16_t ctsLedLevel[24];    // ADC output threshholds for a 24 LED bar
//    uint16_t ctsLowLedLevel[24]; // Reflected low power ADC output threshholds for a 24 LED bar
//    uint16_t ctsFsWatts;         // Forward analogue meter output full scale watts
//    uint16_t ctsMismatchWatts;
//    uint16_t ctsMismatchSeconds;
//    uint8_t  ctsFwdRef;
//    uint8_t  ctsSpare;
//  };


  CalTransferStruct_type
  = record
      ctsCalLevel:        array[1..32] of word;
//      ctsLedLevel:        array[1..24] of word;
//      ctsLowLEdLevel:     array[1..24] of word;
      ctsFsWatts:         word;
      ctsMismatchWatts:   word;
      ctsMismatchSeconds: word;
      ctsFwdRef:          char;
      ctsSpare:           byte;
    end;



  TLed = array[1..24] of word;

  TfrmCal = class(TForm)
    dxDBGridCal: TdxDBGrid;
    dxMemDataCal: TdxMemData;
    DataSourceCal: TDataSource;
    Col_ADC: TdxDBGridColumn;
    Col_Watts: TdxDBGridColumn;
    dxMemDataCalADC: TIntegerField;
    Col_Id: TdxDBGridColumn;
    dxMemDataCalid: TIntegerField;
    dxMemDataCalWatts: TFloatField;
    TimerAdc: TTimer;
    RzLabel1: TRzLabel;
    RzBitBtn_Open: TRzBitBtn;
    RzBitBtn_Save: TRzBitBtn;
    RzBitBtn_Cal: TRzBitBtn;
    RzBitBtn_Help: TRzBitBtn;
    RzBitBtn_Exit: TRzBitBtn;
    RzBitBtn_New: TRzBitBtn;
    RzLabel_Heading: TRzLabel;
    RzBitBtn_Star: TRzBitBtn;
    RzSpinEdit_FsWatts: TRzSpinEdit;
    RzLabel3: TRzLabel;
    RzSpinEdit_MismatchWatts: TRzSpinEdit;
    RzLabel_WattsLab: TRzLabel;
    SaveDlg: TSaveDialog;
    OpenDlg: TOpenDialog;
    RzRadioGroup_CalAB: TRzRadioGroup;
    RzLEDDisplay: TRzLEDDisplay;
    RzMemo_Comment: TRzMemo;
    RzLabel4: TRzLabel;
    HtmlHelp: TEmbeddedHtmlHelp;
    RzSpinEdit_MismatchSeconds: TRzSpinEdit;
    RzLabel_SecondsLab: TRzLabel;
    procedure FormShow(Sender: TObject);
    procedure Col_WattsCustomDrawCell(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; ANode: TdxTreeListNode; AColumn: TdxTreeListColumn;
      ASelected, AFocused, ANewItemRow: Boolean; var AText: String;
      var AColor: TColor; AFont: TFont; var AAlignment: TAlignment;
      var ADone: Boolean);
    procedure Col_ADCCustomDrawCell(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; ANode: TdxTreeListNode; AColumn: TdxTreeListColumn;
      ASelected, AFocused, ANewItemRow: Boolean; var AText: String;
      var AColor: TColor; AFont: TFont; var AAlignment: TAlignment;
      var ADone: Boolean);
    procedure Col_IdCustomDrawCell(Sender: TObject; ACanvas: TCanvas;
      ARect: TRect; ANode: TdxTreeListNode; AColumn: TdxTreeListColumn;
      ASelected, AFocused, ANewItemRow: Boolean; var AText: String;
      var AColor: TColor; AFont: TFont; var AAlignment: TAlignment;
      var ADone: Boolean);
    procedure TimerAdcTimer(Sender: TObject);
    procedure dxDBGridCalDblClick(Sender: TObject);
    procedure RzBitBtn_SaveClick(Sender: TObject);
    procedure RzBitBtn_NewClick(Sender: TObject);
    procedure RzBitBtn_ExitClick(Sender: TObject);
    procedure RzBitBtn_OpenClick(Sender: TObject);
    procedure RzBitBtn_CalClick(Sender: TObject);
    procedure RzRadioGroup_CalABClick(Sender: TObject);
    procedure RzBitBtn_StarClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure RzBitBtn_HelpClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    testbool: boolean;
    CalTransferStruct: CalTransferStruct_type;  // for transmission to AVR
    chk: integer;
    Led:  TLed;
    LedS: TLed; // for erflected only 5x sensitivity
    buffer: array[0..200] of byte;
    block: array[0..70] of byte;
    bufsize: integer;
    bksz: integer;
    CalFileName: string;
    CalFile: file of TCal;
    CheckAdc, CheckWatts: integer;
    CalA: TCal;
    CalB: TCal;
    ADval: integer;
    IdFieldIndex: integer;
    AdcFieldIndex: integer;
    WattsFieldIndex: integer;
    DelayEvent: TEvent;
    MemDataNormalised: boolean;
    procedure BuildLed(m: integer; var L: TLed);
    function Build32n(var sCal, dCal: TCal): boolean;
    procedure ZeroCal;
    procedure SetCaption;
    procedure GetMemData(var Cal: TCal);
    procedure SetMemData(var Cal: TCal);
    procedure AddRecord(Id, ADCval: integer; Watts: single);
    procedure BuildBuffer;
  public
    SelNodeId: integer;
    CalKind: TCalKind;
    CloseCal: boolean;
    procedure Initialise;
    procedure SendCal;
  end;

var
  frmCal: TfrmCal;

implementation

uses  UIniData, UfrmMain, UUsb, D2XXUnit;

{$R *.dfm}

procedure TfrmCal.BuildLed(m: integer; var L: TLed);
var
  i,j,w,dw: integer; // watts per LED in centiwatts
  adcU, adcL, adcD, wattsU, wattsL, wattsD: integer;
begin
  with CalB do
  begin
    dw := 10*CalB.caWattsPerLed div m;
    for i := 1 to 24 do
    begin
      w := i*dw;
      j := 1;
      repeat
        inc(j);
        wattsU := caData[j].watts;
      until (wattsU > w) OR (j = 32);
      if w >= wattsU then
      begin
        L[i] := caData[j].adc;
      end
      else begin
        wattsL := caData[j-1].watts;
        adcU := caData[j].adc;
        adcL := caData[j-1].adc;
        adcD := adcU - adcL;
        wattsD := wattsU - wattsL;
        L[i] := adcL + ((w - wattsL)*adcD) DIV wattsD;
      end;
    end;
  end;
end;



procedure TfrmCal.GetMemData(var Cal: TCal);
var
  sg: single;
  i: byte;
begin
  with dxMemDataCal, Cal do
  begin
    for i := 1 to 32 do
    begin
      locate('Id',i,[]);
      caData[i].adc := FieldValues['ADC'];
      CheckAdc := CheckAdc + caData[i].adc;
      sg := FieldValues['Watts'];
      caData[i].watts := trunc(100*sg);
    end;
  end;
  Cal.caFsWatts := trunc(RzSpinEdit_FsWatts.Value);
  Cal.caMismatchWatts := trunc(10*RzSpinEdit_MismatchWatts.Value);
  Cal.caMismatchSeconds := trunc(RzSpinEdit_MismatchSeconds.Value);
  Cal.caComment := RzMemo_Comment.Lines.Text;
end;

procedure TfrmCal.SetMemData(var Cal: TCal);
var
  i: byte;
begin
  with dxMemDataCal, Cal do
  begin
    Close;
    Open;
    for i := 1 to 32 do
    begin
      Append;
      FieldValues['Id'] := i;
      FieldValues['ADC'] := caData[i].adc;
      FieldValues['Watts'] := caData[i].watts/100;
      Post;
    end;
  end;
  RzSpinEdit_FsWatts.Value := Cal.caFsWatts;
  RzSpinEdit_MismatchWatts.Value := Cal.caMisMatchWatts/10;
  RzSpinEdit_MismatchSeconds.Value := Cal.caMisMatchSeconds;
  RzMemo_Comment.Lines.Text := Cal.caComment;
end;


procedure TfrmCal.AddRecord(Id, ADCval: integer; Watts: single);
begin
  with dxMemDataCal do
  begin
    Append;
    FieldValues['Id'] := Id;
    FieldValues['ADC'] := ADCval;
    FieldValues['Watts'] := Watts;
    Post;
  end;
end;


procedure TfrmCal.SetCaption;
begin
  Caption := 'TrxAVR SWR meter - calibration' + '  [ ' + MinimizeName(CalFileName, canvas, 180) + ' ]';
end;


procedure TfrmCal.Initialise;
begin
  if frmCalswr = nil then
  begin
    frmCalswr := TfrmCalswr.Create(self);
    frmCalswr.Initialise;
  end;
  with g_RegIniData do
  begin
    left := IniCalFormLeft;
    top := IniCalFormTop;
  end;
  MemDataNormalised := false;
  SaveDlg.Title := 'Save calibration to disc file';
  OpenDlg.Title := 'Load calibration from disc file';
  SetCaption;
  case CalKind of
    fwd: begin
           RzLabel_Heading.Caption := 'Forward power calibration';
           RzSpinEdit_MismatchWatts.Visible := false;
           RzLabel_WattsLab.Visible := false;
           RzLabel_SecondsLab.Visible := false;
           RzSpinEdit_MismatchSeconds.Visible := false;
           SaveDlg.Filter := 'Forward calibration files (*.fwd)|*.fwd';
           SaveDlg.DefaultExt := 'fwd';
           OpenDlg.Filter := 'Forward calibration files (*.fwd)|*.fwd';
           OpenDlg.DefaultExt := 'fwd';
         end;
    ref: begin
           RzLabel_Heading.Caption := 'Relfected power calibration';
           RzLabel_WattsLab.Visible := true;
           RzLabel_SecondsLab.Visible := true;
           RzSpinEdit_MismatchWatts.Visible := true;
           RzSpinEdit_MismatchSeconds.Visible := true;
           SaveDlg.Filter := 'Reflected calibration files (*.ref)|*.ref';
           SaveDlg.DefaultExt := 'ref';
           OpenDlg.Filter := 'Reflected calibration files (*.ref)|*.ref';
           OpenDlg.DefaultExt := 'ref';
         end;
  end;
  with dxDBGridCal do begin
    IdFieldIndex := ColumnByFieldName('Id').index;
    ADCFieldIndex := ColumnByFieldName('ADC').index;
    WattsFieldIndex := ColumnByFieldName('Watts').index;
  end;
  frmCalSWR.Timer_ADC.Enabled := true; 
end;


procedure TfrmCal.FormShow(Sender: TObject);
var
  i: integer;
begin
  dxMemDataCal.Open;
  ZeroCal;
  RzBitBtn_Cal.Enabled := true;
  CloseCal := false;
  TimerAdc.enabled := true;
end;


procedure TfrmCal.Col_WattsCustomDrawCell(Sender: TObject;
  ACanvas: TCanvas; ARect: TRect; ANode: TdxTreeListNode;
  AColumn: TdxTreeListColumn; ASelected, AFocused, ANewItemRow: Boolean;
  var AText: String; var AColor: TColor; AFont: TFont;
  var AAlignment: TAlignment; var ADone: Boolean);
begin
  if (ANode.Values[WattsFieldIndex] = 0)
  AND (ANode.Values[IdFieldIndex] <> 1)
  then begin
    AColor := clSilver;
    AText := 'no data';
  end;
end;

procedure TfrmCal.Col_ADCCustomDrawCell(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; ANode: TdxTreeListNode; AColumn: TdxTreeListColumn;
  ASelected, AFocused, ANewItemRow: Boolean; var AText: String;
  var AColor: TColor; AFont: TFont; var AAlignment: TAlignment;
  var ADone: Boolean);
begin
  AColor := clAqua;
  AFOnt.Color := clMaroon;
end;

procedure TfrmCal.Col_IdCustomDrawCell(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; ANode: TdxTreeListNode; AColumn: TdxTreeListColumn;
  ASelected, AFocused, ANewItemRow: Boolean; var AText: String;
  var AColor: TColor; AFont: TFont; var AAlignment: TAlignment;
  var ADone: Boolean);
begin
  AColor := clSkyBlue;
  AFOnt.Color := clMaroon;
end;

procedure TfrmCal.TimerAdcTimer(Sender: TObject);
begin
  if CalKind = fwd
  then ADval := frmCalswr.ADfwd
  else ADval := frmCalswr.ADref;
  if frmCalswr.NoAdcData
  then RzLEDDisplay.Caption := '----'
  else RzLEDDisplay.Caption := IntToStr(ADval);
end;

procedure TfrmCal.dxDBGridCalDblClick(Sender: TObject);
var
  n: integer;
begin
  n := Adval;
  SelNodeId := dxDbGridCal.FocusedNode.Values[IdFieldIndex];
  if SelNodeId = 1 then n := 0;
  with dxMemDataCal do
  begin
    locate('Id',0,[]);
    edit;
    FieldValues['ADC'] := n;
  end;
end;


procedure TfrmCal.ZeroCal;
var
  i: integer;
begin
  MemDataNormalised := false;
  CalFileName := 'untitled';
  SetCaption;
  dxMemdataCal.Close;
  dxMemDataCal.Open;
  AddRecord(1,0,0);
  for i := 2 to 32 do
  begin
    AddRecord(i,0,0);
  end;
  RzSpinEdit_FsWatts.Value := 150;
  RzSpinEdit_MismatchWatts.Value := 30;
  RzSpinEdit_MismatchSeconds.Value := 6;
  RzMemo_Comment.Lines.Text := '';
  GetMemData(CalA);
end;


procedure TfrmCal.RzBitBtn_NewClick(Sender: TObject);
begin
  ZeroCal;
  RzBitBtn_Cal.Enabled := true;
  RzRadioGroup_CalAB.ItemIndex := 0;
  MemDataNormalised := false;
end;

procedure TfrmCal.RzBitBtn_ExitClick(Sender: TObject);
begin
  ModalResult := mrAbort;
end;

procedure TfrmCal.RzBitBtn_SaveClick(Sender: TObject);
var
  i: integer;
begin
  if not MemDataNormalised then GetMemData(CalA);
  Build32n(CalA, CalB);
  case CalKind of
    fwd: SaveDlg.FileName := g_RegIniData.IniFwdCalFile;
    ref: SaveDlg.FileName := g_RegIniData.IniRefCalFile;
  end;
  if not SaveDlg.Execute then exit;
  case CalKind of
    fwd: g_RegIniData.IniFwdCalFile := SaveDlg.FileName;
    ref: g_RegIniData.IniRefCalFile := SaveDlg.FileName;
  end;
  SaveREgInifile;
  try
    AssignFile(CalFile, SaveDlg.FileName);
    ReWrite(CalFile);
    Write(CalFile,CalA);
    CloseFile(CalFile);
  except
    MessageDlg('Failed to save .. ? folder doesn''t exist ?',mtError,[mbOK],0);
    exit;
  end;
  CalFileName := SaveDlg.FileName;
  SetCaption;
end;


procedure TfrmCal.RzBitBtn_OpenClick(Sender: TObject);
begin
  case CalKind of
    fwd: OpenDlg.FileName := g_RegIniData.IniFwdCalFile;
    ref: OpenDlg.FileName := g_RegIniData.IniRefCalFile;
  end;
  if not OpenDlg.Execute then exit;
  case CalKind of
    fwd: g_RegIniData.IniFwdCalFile := OpenDlg.FileName;
    ref: g_RegIniData.IniRefCalFile := OpenDlg.FileName;
  end;
  SaveRegIniFile;
  try
    AssignFile(CalFile, OpenDlg.FileName);
    Reset(CalFile);
    Read(CalFile,CalA);
    CloseFile(CalFile);
  except
    MessageDlg('Faioed to save .. ? file doesn''t exist ?',mtError,[mbOK],0);
  end;
  SetMemData(CalA);
  MemDataNormalised := false;
  RzBitBtn_Cal.Enabled := true;
  CalFileName := OpenDlg.FileName;
  SetCaption;
end;

procedure TfrmCal.RzBitBtn_CalClick(Sender: TObject);
begin
  RzRadioGroup_CalAB.ItemIndex := 1;
end;

procedure TfrmCal.RzRadioGroup_CalABClick(Sender: TObject);
begin
  if not MemDataNormalised then GetMemData(CalA);
  with RzRadioGroup_CalAB do
  begin
    if ItemIndex = 1 then
    begin
      if not Build32n(CalA, CalB) then
      begin
        ItemIndex := 0;
        MemDataNormalised := false;
        exit;
      end;
      SetMemData(CalB);
      MemDataNormalised := true;
      RzBitBtn_Cal.Enabled := false;
    end
    else begin
      MemDataNormalised := false;
      SetMemData(CalA);
      RzBitBtn_Cal.Enabled := true;
    end;
  end;
end;

procedure TfrmCal.RzBitBtn_StarClick(Sender: TObject);
begin
  frmMain.USBstate[cal] := 'W';
end;


procedure TfrmCal.SendCal;
var
  msg: string;
  s: string;
  i,x,cs, valerr: integer;
  HeaderFail: boolean;
  SendOk: boolean;
  bk, remaining, bksz: integer;
  done: boolean;
  SendChecksum: word;
  RecChecksum: word;
begin
  RzRadioGroup_CalAB.ItemIndex := 1;
  Application.ProcessMessages;
  if not MemDataNormalised then
  begin
    RzRadioGroup_CalAB.ItemIndex := 0;
    exit;
  end;
  DelayEvent := TEvent.Create(0, true, false, 'Hobcat swr character delay event');
  Screen.Cursor := crHourglass;
  RzBitBtn_Star.enabled := false;
  BuildBuffer;
  SendChecksum := 0;
  for i := 0 to bufsize-1 do SendChecksum := (SendChecksum + buffer[i]) MOD $10000;
  SendChecksum := (SendChecksum + bufsize) MOD $10000;
  Purge_USB_Device_In;
  if Usb.usSendString('$$$SWR_C') = false
  then HeaderFail := true
  else begin
    DelayEvent.ResetEvent;
    DelayEvent.WaitFor(40);   // need > 20mS to allow for read and write of EEPROM in AVR
    block[0] := bufsize DIV 256;
    block[1] := bufsize MOD 256;
    if Usb.usSendBlock(@block,2) = false     //  sent byte count
    then HeaderFail := true
    else begin  // send byte count
      DelayEvent.ResetEvent;
      DelayEvent.WaitFor(40);   // need > 20mS to allow for read and write of EEPROM in AVR
      Purge_USB_Device_In;
      bk := 0;
      done := false;
      repeat
        remaining := bufsize - bk;
        if remaining >= 64 then
        begin
          for i := 0 to 63 do block[i] := buffer[bk+i];
          bk := bk + 64;
          bksz := 64;
          if remaining = 64 then done := true;
        end
        else begin
          for i := 0 to remaining - 1 do block[i] := buffer[bk+i];
          for i := remaining to 63 do block[i]:= 0;
          done := true;
          bksz := remaining;
        end;
        SendOk := Usb.usSendBlock(@block[0],bksz);
 //       Application.ProcessMessages;
        testbool := not SendOk;
      until done;
    end;
  end;
  if HeaderFail
  then msg := 'SWR calibation header transmission by USB failed'
  else begin
    if done then
    begin
      DelayEvent.ResetEvent;
      DelayEvent.WaitFor(200);   // need > 20mS to allow for read and write of EEPROM in AVR
      Usb.usReadWord(RecChecksum);
      msg := 'Calibration data sent to TrxAVR ... yes its fast!!' + #13#10#13#10
             +'Checksum on bytes sent from PC  =  ' + IntToStr(SendChecksum) + #13#10
             + 'Checksum on bytes as received by TxrAVR  =  ' + IntToStr(RecChecksum);
    end
    else msg := 'SWR calibration transmission failed'
  end;
  MessageDlg(msg,mtInformation,[mbOk],0);
  Screen.Cursor := crDefault;
  RZBitBtn_Star.enabled := true;
  DelayEvent.Free;
end;



procedure TfrmCal.BuildBuffer;
var
  i: integer;
  s: string;
  Kchar: char;
begin
  case CalKind of
    fwd: Kchar := 'F';
    ref: Kchar := 'R';
  end;
  with CalB, CalTransferStruct do
  begin
//    for i := 1 to 24 do ctsLedLevel[i] := Led[i];
//    for i := 1 to 24 do ctsLowLedLevel[i] := LedS[i];
    for i := 1 to 32 do ctsCalLevel[i] := caData[i].watts;
    ctsFsWatts := caFsWatts;
    ctsMismatchWatts := caMisMatchWatts;
    ctsMismatchSeconds := caMismatchSeconds;
    ctsFwdRef := Kchar;
    ctsSpare := 0;
  end;
  bufsize := Sizeof(CalTransferStruct_type);
  Move(CalTransferStruct,buffer,bufsize);
end;






procedure TfrmCal.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  TimerAdc.Enabled := false;
  frmCalSWR.Timer_ADC.Enabled := false;
  frmCalSWR.Free;
  frmCalSwr := nil;
  with g_RegIniData do
  begin
    IniCalFormLeft := left;
    IniCalFormTop := Top;
  end;
  SaveSwrCoordinates;
end;

procedure TfrmCal.RzBitBtn_HelpClick(Sender: TObject);
begin
  frmMain.WebBrowser('http://www.homebrew-radios.net/trxavr_picastar/calswr/CalswrCalibration.html');
//  HtmlHelp.ChmFile := ExtractFilePath(Application.EXEName) + 'Hobcat.chm';
//  HtmlHelp.DisplayContext(3060);
end;




function TfrmCal.Build32n(var sCal, dCal: TCal): boolean;
var
  i, j, n: integer;
  WattsExtrapolated, WattsMax: integer;
  amax, amaxwatts: integer;
  msg: string;
  done: boolean;
  adcX, adcU, adcL, adcD, wattsU, wattsL, wattsD: integer;
begin
  result := false;
//  if not norma then GetMemData(sCal);
  with sCal do
  begin
    i := 33;
    // Check for ANY data and count valid items
    repeat
      dec(i);
      if i = 1 then
      begin
        MessageDlg('No ADC data  - Press OK to continue', mtError,[mbOk],0);
        exit;
      end;
    until caData[i].adc <> 0;
    amax := i;
    amaxwatts := caData[i].watts;
    //check for at least 5 items   ie: row 1 = 0 plus data in rows 2 to
    if amax < 6 then
    begin
      msg := 'You have only ' + IntToStr(amax) + ' calibration points'
                     + #10#13 + '  - Press Abort :';
      MessageDlg(msg, mtError,[mbAbort],0);
      exit;
    end;
    for i := 3 to amax do
    begin
      if caData[i].adc < caData[i-1].adc then
      begin
        msg := 'ADC value ' + IntToStr(i) + ' is less than ADC value '
            + IntToStr(i-1) + #10#13 + 'Data cannot be processed.  Press Abort :';
        MessageDlg(msg, mtError,[mbAbort],0);
        exit;
      end;
      if caData[i].watts < caData[i-1].watts then
      begin
        msg := 'Watts value ' + IntToStr(i) + ' is less than Watts value '
            + IntToStr(i-1) + #10#13 + 'Data cannot be processed.  Press Abort :';
        MessageDlg(msg, mtError,[mbAbort],0);
        exit;
      end;
    end;
    //  data ok now build dCal
    dCal.caData[1].adc := 0;
    dCal.caData[1].watts := 0;
    j := 1;
    done := false;
    repeat
      inc(j);
      adcX := 32*(j-1);
//      if (adcX > caData[amax].adc)
      if (adcX > 1023)
      then done := true
      else begin
        i := 1;
        repeat
          inc(i);
          adcU := caData[i].adc;
        until (adcU > adcX) OR (adcU = 0);
        if adcU = 0 then
        begin
          done := true;
          dCal.caData[j].watts := WattsExtrapolated;
          dCal.caData[j].adc := adcX;
          WattsMax := WattsExtrapolated;
        end
        else begin
          adcL := caData[i-1].adc;
          wattsU := caData[i].watts;
          wattsL := caData[i-1].watts;
          adcD := adcU - adcL;
          wattsD := wattsU - wattsL;
          dCal.caData[j].watts := wattsL + ((adcX - adcL)*wattsD) DIV adcD;
          dCal.caData[j].adc := adcX;
          WattsMax := dCal.caData[j].watts;
        end;
        WattsExtrapolated := wattsU + wattsD;  // if end of list next item
      end;
    until done;
    if amaxwatts > WattsMax then WattsMAx := amaxwatts;
    if j < 32 then
    begin
      n := j + 1;
      for j := n to 32 do
      begin
        dCal.caData[j].adc := 32*(j-1);
        dCal.caData[j].watts := WattsMax;
      end;
    end;
    dCal.caWattsPerLED := caWattsPerLED;
    dCal.caFsWatts := caFsWatts;
    dCal.caMisMatchWatts := caMisMatchWatts;
    dCal.caMismatchSeconds := caMismatchSeconds;
    dCal.caComment := caComment;
  end;
  BuildLed(1,Led);
  BuildLed(10,LedS);
  for i := 1 to 32 do sCal.caWatts32[i] := dCal.caData[i].watts;
  for i := 1 to 24 do sCal.caLedAdc[i] := Led[i];
  for i := 1 to 24 do sCal.caLedAdcS[i] := LedS[i];
  result := true;
end;

procedure TfrmCal.FormCreate(Sender: TObject);
begin
  with g_RegIniData do
  begin
    left := IniCalformLeft;
    top := IniCalformTop;
  end;
end;

end.
