unit UIniData;

interface

uses Inifiles,SysUtils, graphics, forms,  Registry, Windows,
     Dialogs;
{
  inactive
Set bit(s) specified in data word
Clear bit(s) specified in data word
Toggle bit(s) specified in data word
Load data word
Load upper byte
Load lower byte
Group dataword step forward
Group dataword step reverse
Group upper byte step forward
Group upper byte step reverse
Group lower byte step forward
Group lower byte step reverse
}

const
   PcaTaskList: array[0..14] of string
   = ('no_action','set_bits','clear_bits','toggle_bits','load_dataword',
      'load_upper_byte','load_lower_byte','group_word_step',
      'group_upper_byte_step','group_lower_byte_step','load_dataword_at_startup',
      'set_bits_Tx_only', 'set_bits_Rx_only',
      'toggle_bits_Tx_only','toggle_bits_Rx_only');

   BpfKindList: array[0..2] of string
   = ('No_I2C_BPF','Picastar','PA3AKE');

type

    XjpIniData_type
    = record
        IniStarcDirectory: string;
        IniDSPFile: string;
        IniParams: string;
      end;


  IniPCAtask_type
  = record
     IniPcaOpcode: byte;
     IniPcaAddress: byte;
     IniPcaGroup: byte;
     IniPcaDataword: word;
     IniPcaLabel: string;
   end;


  EememIniData_type
    = record
        //  File base INIdata ... in Star2b
        //AVR internal EEPROM
        IniDDSclock: integer;
        IniLSBoffset: integer;
        IniUSBoffset: integer;
        IniCWoffset: integer;
        IniCWoffsetEnable: integer;

        // parameters assigned to Encoders 1-8 and pots A..D
        IniEncodersPots: array[0..9] of integer;

        // Rx button assignments
        IniRxButton: array ['A'..'Z'] of integer;

        // Tx  button assignments
        IniTxButton: array ['A'..'Z'] of integer;

        // Rx Touchpad assignments
        IniRxTouchpaD: array [1..15] of integer;

        // Tx touchpad assignments
        IniTxTouchpad: array [1..15] of integer;

        // DSP parameter settings
        Ini44CWmode: integer;
        IniSoftwareFlywheel: integer;
        IniAutoDim: integer;
        IniParamResetMode: integer;  // if 0  restore all backup params at startup
        IniDisplayBright: integer;
        IniDisplayDimmed: integer;
      	IniAutoDimSeconds: integer;
        IniDisplayKeyValue: integer;
        IniDSPDDSKeysDisplay: integer;
        IniMenuTimeout: integer;
        IniMoxTimeout: integer;
       // Touch panel
        IniTouchCalLeft: integer;
        IniTouchCalRight: integer;
        IniTouchCalTop: integer;
        IniTouchCalBottom: integer;

        //BandStacks

        //Band stack LAST visit to band

        IniLast160mFreq:   integer;
        IniLast160mMode:   integer;
        IniLast160mFilter: integer;
        IniLast160mIP3:    integer;
        IniLast160mColour: integer;

        IniLast80mFreq:   integer;
        IniLast80mMode:   integer;
        IniLast80mFilter: integer;
        IniLast80mIP3:    integer;
        IniLast80mColour: integer;

        IniLast40mFreq:   integer;
        IniLast40mMode:   integer;
        IniLast40mFilter: integer;
        IniLast40mIP3:    integer;
        IniLast40mColour: integer;

        IniLast30mFreq:   integer;
        IniLast30mMode:   integer;
        IniLast30mFilter: integer;
        IniLast30mIP3:    integer;
        IniLast30mColour: integer;

        IniLast20mFreq:   integer;
        IniLast20mMode:   integer;
        IniLast20mFilter: integer;
        IniLast20mIP3:    integer;
        IniLast20mColour: integer;

        IniLast17mFreq:   integer;
        IniLast17mMode:   integer;
        IniLast17mFilter: integer;
        IniLast17mIP3:    integer;
        IniLast17mColour: integer;

        IniLast15mFreq:   integer;
        IniLast15mMode:   integer;
        IniLast15mFilter: integer;
        IniLast15mIP3:    integer;
        IniLast15mColour: integer;

        IniLast12mFreq:   integer;
        IniLast12mMode:   integer;
        IniLast12mFilter: integer;
        IniLast12mIP3:    integer;
        IniLast12mColour: integer;

        IniLast10mFreq:   integer;
        IniLast10mMode:   integer;
        IniLast10mFilter: integer;
        IniLast10mIP3:    integer;
        IniLast10mColour:  integer;

        IniLast6mFreq:   integer;
        IniLast6mMode:   integer;
        IniLast6mFilter: integer;
        IniLast6mIP3:    integer;
        IniLast6mColour:  integer;

        // Band Stack SSB

        IniSSB160mFreq:   integer;
        IniSSB160mMode:   integer;
        IniSSB160mFilter: integer;
        IniSSB160mIP3:    integer;
        IniSSB160mColour: integer;

        IniSSB80mFreq:   integer;
        IniSSB80mMode:   integer;
        IniSSB80mFilter: integer;
        IniSSB80mIP3:    integer;
        IniSSB80mColour: integer;

        IniSSB40mFreq:   integer;
        IniSSB40mMode:   integer;
        IniSSB40mFilter: integer;
        IniSSB40mIP3:    integer;
        IniSSB40mColour: integer;

        IniSSB30mFreq:   integer;
        IniSSB30mMode:   integer;
        IniSSB30mFilter: integer;
        IniSSB30mIP3:    integer;
        IniSSB30mColour: integer;

        IniSSB20mFreq:   integer;
        IniSSB20mMode:   integer;
        IniSSB20mFilter: integer;
        IniSSB20mIP3:    integer;
        IniSSB20mColour: integer;

        IniSSB17mFreq:   integer;
        IniSSB17mMode:   integer;
        IniSSB17mFilter: integer;
        IniSSB17mIP3:    integer;
        IniSSB17mColour: integer;

        IniSSB15mFreq:   integer;
        IniSSB15mMode:   integer;
        IniSSB15mFilter: integer;
        IniSSB15mIP3:    integer;
        IniSSB15mColour: integer;

        IniSSB12mFreq:   integer;
        IniSSB12mMode:   integer;
        IniSSB12mFilter: integer;
        IniSSB12mIP3:    integer;
        IniSSB12mColour: integer;

        IniSSB10mFreq:   integer;
        IniSSB10mMode:   integer;
        IniSSB10mFilter: integer;
        IniSSB10mIP3:    integer;
        IniSSB10mColour:  integer;

        IniSSB6mFreq:   integer;
        IniSSB6mMode:   integer;
        IniSSB6mFilter: integer;
        IniSSB6mIP3:    integer;
        IniSSB6mColour:  integer;

        //Band stack CW

        IniCW160mFreq:   integer;
        IniCW160mMode:   integer;
        IniCW160mFilter: integer;
        IniCW160mIP3:    integer;
        IniCW160mColour: integer;

        IniCW80mFreq:   integer;
        IniCW80mMode:   integer;
        IniCW80mFilter: integer;
        IniCW80mIP3:    integer;
        IniCW80mColour: integer;

        IniCW40mFreq:   integer;
        IniCW40mMode:   integer;
        IniCW40mFilter: integer;
        IniCW40mIP3:    integer;
        IniCW40mColour: integer;

        IniCW30mFreq:   integer;
        IniCW30mMode:   integer;
        IniCW30mFilter: integer;
        IniCW30mIP3:    integer;
        IniCW30mColour: integer;

        IniCW20mFreq:   integer;
        IniCW20mMode:   integer;
        IniCW20mFilter: integer;
        IniCW20mIP3:    integer;
        IniCW20mColour: integer;

        IniCW17mFreq:   integer;
        IniCW17mMode:   integer;
        IniCW17mFilter: integer;
        IniCW17mIP3:    integer;
        IniCW17mColour: integer;

        IniCW15mFreq:   integer;
        IniCW15mMode:   integer;
        IniCW15mFilter: integer;
        IniCW15mIP3:    integer;
        IniCW15mColour: integer;

        IniCW12mFreq:   integer;
        IniCW12mMode:   integer;
        IniCW12mFilter: integer;
        IniCW12mIP3:    integer;
        IniCW12mColour: integer;

        IniCW10mFreq:   integer;
        IniCW10mMode:   integer;
        IniCW10mFilter: integer;
        IniCW10mIP3:    integer;
        IniCW10mColour:  integer;

        IniCW6mFreq:   integer;
        IniCW6mMode:   integer;
        IniCW6mFilter: integer;
        IniCW6mIP3:    integer;
        IniCW6mColour:  integer;

        // Memory Stack 67
        IniMem6761Freq:   integer;
        IniMem6761Mode:   integer;
        IniMem6761Filter: integer;
        IniMem6761IP3:    integer;
        IniMem6761Colour: integer;

        IniMem6762Freq:   integer;
        IniMem6762Mode:   integer;
        IniMem6762Filter: integer;
        IniMem6762IP3:    integer;
        IniMem6762Colour: integer;

        IniMem6763Freq:   integer;
        IniMem6763Mode:   integer;
        IniMem6763Filter: integer;
        IniMem6763IP3:    integer;
        IniMem6763Colour: integer;

        IniMem6764Freq:   integer;
        IniMem6764Mode:   integer;
        IniMem6764Filter: integer;
        IniMem6764IP3:    integer;
        IniMem6764Colour: integer;

        IniMem6765Freq:   integer;
        IniMem6765Mode:   integer;
        IniMem6765Filter: integer;
        IniMem6765IP3:    integer;
        IniMem6765Colour: integer;

        IniMem6766Freq:   integer;
        IniMem6766Mode:   integer;
        IniMem6766Filter: integer;
        IniMem6766IP3:    integer;
        IniMem6766Colour: integer;

        // Memory Stack 68
        IniMem6861Freq:   integer;
        IniMem6861Mode:   integer;
        IniMem6861Filter: integer;
        IniMem6861IP3:    integer;
        IniMem6861Colour: integer;

        IniMem6862Freq:   integer;
        IniMem6862Mode:   integer;
        IniMem6862Filter: integer;
        IniMem6862IP3:    integer;
        IniMem6862Colour: integer;

        IniMem6863Freq:   integer;
        IniMem6863Mode:   integer;
        IniMem6863Filter: integer;
        IniMem6863IP3:    integer;
        IniMem6863Colour: integer;

        IniMem6864Freq:   integer;
        IniMem6864Mode:   integer;
        IniMem6864Filter: integer;
        IniMem6864IP3:    integer;
        IniMem6864Colour: integer;

        IniMem6865Freq:   integer;
        IniMem6865Mode:   integer;
        IniMem6865Filter: integer;
        IniMem6865IP3:    integer;
        IniMem6865Colour: integer;

        IniMem6866Freq:   integer;
        IniMem6866Mode:   integer;
        IniMem6866Filter: integer;
        IniMem6866IP3:    integer;
        IniMem6866Colour: integer;

        // Memory Stack 69
        IniMem6961Freq:   integer;
        IniMem6961Mode:   integer;
        IniMem6961Filter: integer;
        IniMem6961IP3:    integer;
        IniMem6961Colour: integer;

        IniMem6962Freq:   integer;
        IniMem6962Mode:   integer;
        IniMem6962Filter: integer;
        IniMem6962IP3:    integer;
        IniMem6962Colour: integer;

        IniMem6963Freq:   integer;
        IniMem6963Mode:   integer;
        IniMem6963Filter: integer;
        IniMem6963IP3:    integer;
        IniMem6963Colour: integer;

        IniMem6964Freq:   integer;
        IniMem6964Mode:   integer;
        IniMem6964Filter: integer;
        IniMem6964IP3:    integer;
        IniMem6964Colour: integer;

        IniMem6965Freq:   integer;
        IniMem6965Mode:   integer;
        IniMem6965Filter: integer;
        IniMem6965IP3:    integer;
        IniMem6965Colour: integer;

        IniMem6966Freq:   integer;
        IniMem6966Mode:   integer;
        IniMem6966Filter: integer;
        IniMem6966IP3:    integer;
        IniMem6966Colour: integer;

        // Memory Stack 60
        IniMem6061Freq:   integer;
        IniMem6061Mode:   integer;
        IniMem6061Filter: integer;
        IniMem6061IP3:    integer;
        IniMem6061Colour: integer;

        IniMem6062Freq:   integer;
        IniMem6062Mode:   integer;
        IniMem6062Filter: integer;
        IniMem6062IP3:    integer;
        IniMem6062Colour: integer;

        IniMem6063Freq:   integer;
        IniMem6063Mode:   integer;
        IniMem6063Filter: integer;
        IniMem6063IP3:    integer;
        IniMem6063Colour: integer;

        IniMem6064Freq:   integer;
        IniMem6064Mode:   integer;
        IniMem6064Filter: integer;
        IniMem6064IP3:    integer;
        IniMem6064Colour: integer;

        IniMem6065Freq:   integer;
        IniMem6065Mode:   integer;
        IniMem6065Filter: integer;
        IniMem6065IP3:    integer;
        IniMem6065Colour: integer;

        IniMem6066Freq:   integer;
        IniMem6066Mode:   integer;
        IniMem6066Filter: integer;
        IniMem6066IP3:    integer;
        IniMem6066Colour: integer;

        // Power on slot  (stored in EEMEM as VFO 0)
        IniPowerOnFreq:   integer;
        IniPowerOnMode:   integer;
        IniPowerOnFilter: integer;
        IniPowerOnIP3:    integer;
        IniPowerOnColour: integer;


        // VFO sticky stack

        IniVFO1Freq:   integer;
        IniVFO1Mode:   integer;
        IniVFO1Filter: integer;
        IniVFO1IP3:    integer;
        IniVFO1Colour: integer;

        IniVFO2Freq:   integer;
        IniVFO2Mode:   integer;
        IniVFO2Filter: integer;
        IniVFO2IP3:    integer;
        IniVFO2Colour: integer;

        IniVFO3Freq:   integer;
        IniVFO3Mode:   integer;
        IniVFO3Filter: integer;
        IniVFO3IP3:    integer;
        IniVFO3Colour: integer;

        IniVFO4Freq:   integer;
        IniVFO4Mode:   integer;
        IniVFO4Filter: integer;
        IniVFO4IP3:    integer;
        IniVFO4Colour: integer;

        IniVFO5Freq:   integer;
        IniVFO5Mode:   integer;
        IniVFO5Filter: integer;
        IniVFO5IP3:    integer;
        IniVFO5Colour: integer;

        IniVFO6Freq:   integer;
        IniVFO6Mode:   integer;
        IniVFO6Filter: integer;
        IniVFO6IP3:    integer;
        IniVFO6Colour: integer;

        IniVFO7Freq:   integer;
        IniVFO7Mode:   integer;
        IniVFO7Filter: integer;
        IniVFO7IP3:    integer;
        IniVFO7Colour: integer;

        IniPcaTasks: array[1..8] of IniPcaTask_type;

        IniPCA9555BpfType: integer;
        IniPCA9555BpfAddress: integer;
        IniPA3AKE_RooferAddress: integer;
        IniPA3AKE_SquarerAddress: integer;
        IniPA3AKE_MixerAddress: integer;
        IniPA3AKE_MixerEnable: integer;
        IniPA3AKE_RooferSwitchEnable: integer;
        IniPA3AKE_MixerDAC: integer;
        IniPA3AKE_SquarerDAC: integer;
        IniEnablePCA9555: integer;

        IniLocalTimeOffset: string;
      end;


  RegIniData_type
    = record
        // Registry based INIdata
        IniStarFolder: string;

        IniDSPtelemetry: integer;
        IniComPort: string;
        IniFwdCalFile: string;
        IniRefCalFile: string;

        IniTFTflashFile: string;

        IniMainFormLeft: integer;
        IniMainFormTop: integer;
        IniMainFormWidth: integer;
        IniMainFormHeight: integer;

        IniWebFormLeft: integer;
        IniWebFormTop: integer;
        IniWebFormWidth: integer;
        IniWebFormHeight: integer;

        IniCalFormTop: integer;
        IniCalFormLeft: integer;

        IniSummFormTop: integer;
        IniSummFormLeft: integer;
        IniSummFormHeight: integer;
        IniSummFormWidth: integer;

        IniPrintInColor: boolean;

        IniSummaryExportFolder: string;
        IniSummaryExportFile: string;
        IniSummaryExportBefore: string;
        IniSummaryExportAfter: string;



        // dxPrinting Page setup   ... will need MULTIPLE !!

        IniCenterOnPageH: boolean;
        IniCenterOnPageV: boolean;
        IniDMPaper: integer;
        IniFitToPagesByTall: integer;
        IniFitToPagesByWide: integer;
        IniFooter: integer;
        IniGrayShading: boolean;
        IniHeader: integer;
        IniMarginsBottom: integer;
        IniMarginsLeft: integer;
        IniMarginsRight: integer;
        IniMarginsTop: integer;
        IniMeasurementUnits: string;

        IniPageFooterCenterTextAlignY: string;
        IniPageFooterLeftTextAlignY: string;
        IniPageFooterRightTextAlignY: string;
        IniPageFooterFontCharset: integer;
        IniPageFooterFontColor: integer;
        IniPageFooterFontHeight: integer;
        IniPageFooterFontName: string;
        IniPageFooterFontPitch: string;
        IniPageFooterFontSize: integer;
        IniPageFooterFontStyle: string;

        IniPageHeaderCenterTextAlignY: string;
        IniPageHeaderLeftTextAlignY: string;
        IniPageHeaderRightTextAlignY: string;
        IniPageHeaderFontCharset: integer;
        IniPageHeaderFontColor: integer;
        IniPageHeaderFontHeight: integer;
        IniPageHeaderFontName: string;
        IniPageHeaderFontPitch: string;
        IniPageHeaderFontSize: integer;
        IniPageHeaderFontStyle: string;

        IniPageOrder: string;
        IniPageSizeX: integer;
        IniPageSizeY: integer;
        IniReverseTitlesOnEvenPages: boolean;
        IniReportTitleMode: string;
        IniScaleFactor: integer;
        IniScaleMode: string;
        IniShowPageFooter: boolean;
        IniShowPageHeader: boolean;
        IniShrinkToPageWidth: boolean;
        IniOrientation: string;
        IniPageNumberFormat: string;

        IniDebugIdColWidthA: integer;
        IniDebugVarNameColWidthA: integer;
        IniDebugVarNameColWidthB: integer;
        IniDebugSplitterPosition: integer;


        IniDebugAutoVars: boolean;
        IniDebugAutoPorts: boolean;
        IniDebugRefresh: integer;
        IniDebugViewPorts: boolean;
        IniDebugViewVars: boolean;


      end;


var
  g_RegIniData: RegIniData_type;
  RegIniFile: TRegIniFile;

  g_XjpIniData: XjpIniData_type;
  XjpIniFile: TInifile;

  g_EememIniData: EememIniData_type;
  EememIniFile: TIniFile;

  function IniLookupPcaTask(s: string): byte;
  function IniLookupBpf(s: string): byte;
  function RegIniOpen: boolean;
  procedure ReadXjpIniData;
  procedure WriteXjpIniData;
  procedure EnsureIniFileIsRegistry;
  procedure LoadDebugCoordinates;
  procedure SaveDebugCoordinates;
  procedure SaveRegIniFile;
  procedure LoadRegInifile;
  procedure SaveDebugIniData;
  procedure LoadDebugIniData;
  procedure LoadMainCoordinates;
  procedure SaveMainCoordinates;
  procedure LoadWebBrowserCoordinates;
  procedure SaveWebBrowserCoordinates;
  procedure LoadSwrCoordinates;
  procedure SaveSwrCoordinates;
  procedure SaveDxPrinterSettings(Kind: char);
  procedure LoadDxPrinterSettings(Kind: char);

  procedure SaveEememIniFile;
  procedure LoadEememInifile;

  function ByteToOffsetString(b: byte): string;
  function OffsetStringToByte(s: string): byte;


implementation

uses UfrmMain;

const
 KeyName: string = 'Software\hbradios\Hobcat';



function IniLookupPcaTask(s: string): byte;
var
  i: byte;
begin
  result := 0;
  for i := 1 to 14 do
  begin
    if PcaTaskList[i] = s then
    begin
      result := i;
      break;
    end;
  end;
end;


function IniLookupBpf(s: string): byte;
var
  i: byte;
begin
  result := 0;
  for i := 1 to 2 do
  begin
    if BpfKindList[i] = s then
    begin
      result := i;
      break;
    end;
  end;
end;



procedure SaveEememIniFile;
begin
  EememIniFile := TIniFile.Create(g_RegIniData.IniStarFolder + '/TrxAvrEemem.ini');
  with EememIniFile, g_EememIniData do
  begin
    WriteInteger('rfconfig','ddsclock',IniDDSclock);
    WriteInteger('rfconfig','lsboffset',IniLSBoffset);
    WriteInteger('rfconfig','usboffset',IniUSBoffset);
    WriteInteger('rfconfig','cwoffset',IniCWoffset);
    WriteInteger('rfconfig','cwoffsetenable',IniCWoffsetEnable);

    WriteInteger('encoderparams','encoder1',IniEncodersPots[0]);
    WriteInteger('encoderparams','encoder2',IniEncodersPots[1]);
    WriteInteger('encoderparams','encoder3',IniEncodersPots[2]);
    WriteInteger('encoderparams','encoder4',IniEncodersPots[3]);
    WriteInteger('encoderparams','encoder5',IniEncodersPots[4]);
    WriteInteger('encoderparams','encoder6',IniEncodersPots[5]);
    WriteInteger('encoderparams','encoder7',IniEncodersPots[6]);
    WriteInteger('encoderparams','encoder8',IniEncodersPots[7]);
    WriteInteger('encoderparams','potA',IniEncodersPots[8]);
    WriteInteger('encoderparams','potB',IniEncodersPots[9]);

    WriteInteger('rxbuttonassign','rxbuttonA',IniRxButton['A']);
    WriteInteger('rxbuttonassign','rxbuttonB',IniRxButton['B']);
    WriteInteger('rxbuttonassign','rxbuttonC',IniRxButton['C']);
    WriteInteger('rxbuttonassign','rxbuttonD',IniRxButton['D']);
    WriteInteger('rxbuttonassign','rxbuttonE',IniRxButton['E']);
    WriteInteger('rxbuttonassign','rxbuttonF',IniRxButton['F']);
    WriteInteger('rxbuttonassign','rxbuttonG',IniRxButton['G']);
    WriteInteger('rxbuttonassign','rxbuttonH',IniRxButton['H']);
    WriteInteger('rxbuttonassign','rxbuttonI',IniRxButton['I']);
    WriteInteger('rxbuttonassign','rxbuttonJ',IniRxButton['J']);
    WriteInteger('rxbuttonassign','rxbuttonK',IniRxButton['K']);
    WriteInteger('rxbuttonassign','rxbuttonL',IniRxButton['L']);
    WriteInteger('rxbuttonassign','rxbuttonM',IniRxButton['M']);
    WriteInteger('rxbuttonassign','rxbuttonN',IniRxButton['N']);
    WriteInteger('rxbuttonassign','rxbuttonO',IniRxButton['O']);
    WriteInteger('rxbuttonassign','rxbuttonP',IniRxButton['P']);
    WriteInteger('rxbuttonassign','rxbuttonQ',IniRxButton['Q']);
    WriteInteger('rxbuttonassign','rxbuttonR',IniRxButton['R']);
    WriteInteger('rxbuttonassign','rxbuttonS',IniRxButton['S']);
    WriteInteger('rxbuttonassign','rxbuttonT',IniRxButton['T']);
    WriteInteger('rxbuttonassign','rxbuttonU',IniRxButton['U']);
    WriteInteger('rxbuttonassign','rxbuttonV',IniRxButton['V']);
    WriteInteger('rxbuttonassign','rxbuttonW',IniRxButton['W']);
    WriteInteger('rxbuttonassign','rxbuttonX',IniRxButton['X']);
    WriteInteger('rxbuttonassign','rxbuttonY',IniRxButton['Y']);
    WriteInteger('rxbuttonassign','rxbuttonZ',IniRxButton['Z']);

    WriteInteger('txbuttonassign','txbuttonA',IniTxButton['A']);
    WriteInteger('txbuttonassign','txbuttonB',IniTxButton['B']);
    WriteInteger('txbuttonassign','txbuttonC',IniTxButton['C']);
    WriteInteger('txbuttonassign','txbuttonD',IniTxButton['D']);
    WriteInteger('txbuttonassign','txbuttonE',IniTxButton['E']);
    WriteInteger('txbuttonassign','txbuttonF',IniTxButton['F']);
    WriteInteger('txbuttonassign','txbuttonG',IniTxButton['G']);
    WriteInteger('txbuttonassign','txbuttonH',IniTxButton['H']);
    WriteInteger('txbuttonassign','txbuttonI',IniTxButton['I']);
    WriteInteger('txbuttonassign','txbuttonJ',IniTxButton['J']);
    WriteInteger('txbuttonassign','txbuttonK',IniTxButton['K']);
    WriteInteger('txbuttonassign','txbuttonL',IniTxButton['L']);
    WriteInteger('txbuttonassign','txbuttonM',IniTxButton['M']);
    WriteInteger('txbuttonassign','txbuttonN',IniTxButton['N']);
    WriteInteger('txbuttonassign','txbuttonO',IniTxButton['O']);
    WriteInteger('txbuttonassign','txbuttonP',IniTxButton['P']);
    WriteInteger('txbuttonassign','txbuttonQ',IniTxButton['Q']);
    WriteInteger('txbuttonassign','txbuttonR',IniTxButton['R']);
    WriteInteger('txbuttonassign','txbuttonS',IniTxButton['S']);
    WriteInteger('txbuttonassign','txbuttonT',IniTxButton['T']);
    WriteInteger('txbuttonassign','txbuttonU',IniTxButton['U']);
    WriteInteger('txbuttonassign','txbuttonV',IniTxButton['V']);
    WriteInteger('txbuttonassign','txbuttonW',IniTxButton['W']);
    WriteInteger('txbuttonassign','txbuttonX',IniTxButton['X']);
    WriteInteger('txbuttonassign','txbuttonY',IniTxButton['Y']);
    WriteInteger('txbuttonassign','txbuttonZ',IniTxButton['Z']);

    WriteInteger('rxtouchpadassign','rxtouchpad1', IniRxTouchpad[1]);
    WriteInteger('rxtouchpadassign','rxtouchpad2', IniRxTouchpad[2]);
    WriteInteger('rxtouchpadassign','rxtouchpad3', IniRxTouchpad[3]);
    WriteInteger('rxtouchpadassign','rxtouchpad4', IniRxTouchpad[4]);
    WriteInteger('rxtouchpadassign','rxtouchpad5', IniRxTouchpad[5]);
    WriteInteger('rxtouchpadassign','rxtouchpad6', IniRxTouchpad[6]);
    WriteInteger('rxtouchpadassign','rxtouchpad7', IniRxTouchpad[7]);
    WriteInteger('rxtouchpadassign','rxtouchpad8', IniRxTouchpad[8]);
    WriteInteger('rxtouchpadassign','rxtouchpad9', IniRxTouchpad[9]);
    WriteInteger('rxtouchpadassign','rxtouchpad10',IniRxTouchpad[10]);
    WriteInteger('rxtouchpadassign','rxtouchpad11',IniRxTouchpad[11]);
    WriteInteger('rxtouchpadassign','rxtouchpad12',IniRxTouchpad[12]);
    WriteInteger('rxtouchpadassign','rxtouchpad13',IniRxTouchpad[13]);
    WriteInteger('rxtouchpadassign','rxtouchpad14',IniRxTouchpad[14]);
    WriteInteger('rxtouchpadassign','rxtouchpad15',IniRxTouchpad[15]);

    WriteInteger('txtouchpadassign','txtouchpad1', IniTxTouchpad[1]);
    WriteInteger('txtouchpadassign','txtouchpad2', IniTxTouchpad[2]);
    WriteInteger('txtouchpadassign','txtouchpad3', IniTxTouchpad[3]);
    WriteInteger('txtouchpadassign','txtouchpad4', IniTxTouchpad[4]);
    WriteInteger('txtouchpadassign','txtouchpad5', IniTxTouchpad[5]);
    WriteInteger('txtouchpadassign','txtouchpad6', IniTxTouchpad[6]);
    WriteInteger('txtouchpadassign','txtouchpad7', IniTxTouchpad[7]);
    WriteInteger('txtouchpadassign','txtouchpad8', IniTxTouchpad[8]);
    WriteInteger('txtouchpadassign','txtouchpad9', IniTxTouchpad[9]);
    WriteInteger('txtouchpadassign','txtouchpad10',IniTxTouchpad[10]);
    WriteInteger('txtouchpadassign','txtouchpad11',IniTxTouchpad[11]);
    WriteInteger('txtouchpadassign','txtouchpad12',IniTxTouchpad[12]);
    WriteInteger('txtouchpadassign','txtouchpad13',IniTxTouchpad[13]);
    WriteInteger('txtouchpadassign','txtouchpad14',IniTxTouchpad[14]);
    WriteInteger('txtouchpadassign','txtouchpad15',IniTxTouchpad[15]);

    WriteInteger('ddsparams','44CWmode',Ini44CWmode);
    WriteInteger('ddsparams','SoftwareFlywheel',IniSoftwareFlywheel);
    WriteInteger('ddsparams','Autodim',IniAutodim);
    WriteInteger('ddsparams','ParamResetMode',IniParamResetMode);
    WriteInteger('ddsparams','DisplayBright',IniDisplayBright);
    WriteInteger('ddsparams','DisplayDimmed',IniDisplayDimmed);
    WriteInteger('ddsparams','AutoDimSeconds',IniAutoDimSeconds);
    WriteInteger('ddsparams','DisplayKeyValue',IniDisplayKeyValue);
    WriteInteger('ddsparams','DSPDDSKeysDisplay', IniDSPDDSKeysDisplay);
    WriteInteger('ddsparams','MenuTimeout', IniMenuTimeout);
    WriteInteger('ddsparams','MoxTimeout', IniMoxTimeout);

    WriteInteger('touchpanel','TouchCalLeft',IniTouchCalLeft);
    WriteInteger('touchpanel','TouchCalRight',IniTouchCalRight);
    WriteInteger('touchpanel','TouchCalTop',IniTouchCalTop);
    WriteInteger('touchpanel','TouchCalBottom',IniTouchCalBottom);

    WriteInteger('bandlast','Last160mFreq',IniLast160mFreq);
    WriteInteger('bandlast','Last160mMode',IniLast160mMode);
    WriteInteger('bandlast','Last160mFilter',IniLast160mFilter);
    WriteInteger('bandlast','Last160mIP3',IniLast160mIP3);
    WriteInteger('bandlast','Last160mColour',IniLast160mColour);

    WriteInteger('bandlast','Last80mFreq',IniLast80mFreq);
    WriteInteger('bandlast','Last80mMode',IniLast80mMode);
    WriteInteger('bandlast','Last80mFilter',IniLast80mFilter);
    WriteInteger('bandlast','Last80mIP3',IniLast80mIP3);
    WriteInteger('bandlast','Last80mColour',IniLast80mColour);

    WriteInteger('bandlast','Last40mFreq',IniLast40mFreq);
    WriteInteger('bandlast','Last40mMode',IniLast40mMode);
    WriteInteger('bandlast','Last40mFilter',IniLast40mFilter);
    WriteInteger('bandlast','Last40mIP3',IniLast40mIP3);
    WriteInteger('bandlast','Last40mColour',IniLast40mColour);

    WriteInteger('bandlast','Last30mFreq',IniLast30mFreq);
    WriteInteger('bandlast','Last30mMode',IniLast30mMode);
    WriteInteger('bandlast','Last30mFilter',IniLast30mFilter);
    WriteInteger('bandlast','Last30mIP3',IniLast30mIP3);
    WriteInteger('bandlast','Last30mColour',IniLast30mColour);

    WriteInteger('bandlast','Last20mFreq',IniLast20mFreq);
    WriteInteger('bandlast','Last20mMode',IniLast20mMode);
    WriteInteger('bandlast','Last20mFilter',IniLast20mFilter);
    WriteInteger('bandlast','Last20mIP3',IniLast20mIP3);
    WriteInteger('bandlast','Last20mColour',IniLast20mColour);

    WriteInteger('bandlast','Last17mFreq',IniLast17mFreq);
    WriteInteger('bandlast','Last17mMode',IniLast17mMode);
    WriteInteger('bandlast','Last17mFilter',IniLast17mFilter);
    WriteInteger('bandlast','Last17mIP3',IniLast17mIP3);
    WriteInteger('bandlast','Last17mColour',IniLast17mColour);

    WriteInteger('bandlast','Last15mFreq',IniLast15mFreq);
    WriteInteger('bandlast','Last15mMode',IniLast15mMode);
    WriteInteger('bandlast','Last15mFilter',IniLast15mFilter);
    WriteInteger('bandlast','Last15mIP3',IniLast15mIP3);
    WriteInteger('bandlast','Last15mColour',IniLast15mColour);

    WriteInteger('bandlast','Last12mFreq',IniLast12mFreq);
    WriteInteger('bandlast','Last12mMode',IniLast12mMode);
    WriteInteger('bandlast','Last12mFilter',IniLast12mFilter);
    WriteInteger('bandlast','Last12mIP3',IniLast12mIP3);
    WriteInteger('bandlast','Last12mColour',IniLast12mColour);

    WriteInteger('bandlast','Last10mFreq',IniLast10mFreq);
    WriteInteger('bandlast','Last10mMode',IniLast10mMode);
    WriteInteger('bandlast','Last10mFilter',IniLast10mFilter);
    WriteInteger('bandlast','Last10mIP3',IniLast10mIP3);
    WriteInteger('bandlast','Last10mColour',IniLast10mColour);

{   WriteInteger('bandlast','Last6mFreq',IniLast6mFreq);
    WriteInteger('bandlast','Last6mMode',IniLast6mMode);
    WriteInteger('bandlast','Last6mFilter',IniLast6mFilter);
    WriteInteger('bandlast','Last6mIP3',IniLast6mIP3);
    WriteInteger('bandlast','Last6mColour',IniLast6mColour);
}

    WriteInteger('bandssb','SSB160mFreq',IniSSB160mFreq);
    WriteInteger('bandssb','SSB160mMode',IniSSB160mMode);
    WriteInteger('bandssb','SSB160mFilter',IniSSB160mFilter);
    WriteInteger('bandssb','SSB160mIP3',IniSSB160mIP3);
    WriteInteger('bandssb','SSB160mColour',IniSSB160mColour);

    WriteInteger('bandssb','SSB80mFreq',IniSSB80mFreq);
    WriteInteger('bandssb','SSB80mMode',IniSSB80mMode);
    WriteInteger('bandssb','SSB80mFilter',IniSSB80mFilter);
    WriteInteger('bandssb','SSB80mIP3',IniSSB80mIP3);
    WriteInteger('bandssb','SSB80mColour',IniSSB80mColour);

    WriteInteger('bandssb','SSB40mFreq',IniSSB40mFreq);
    WriteInteger('bandssb','SSB40mMode',IniSSB40mMode);
    WriteInteger('bandssb','SSB40mFilter',IniSSB40mFilter);
    WriteInteger('bandssb','SSB40mIP3',IniSSB40mIP3);
    WriteInteger('bandssb','SSB40mColour',IniSSB40mColour);

    WriteInteger('bandssb','SSB30mFreq',IniSSB30mFreq);
    WriteInteger('bandssb','SSB30mMode',IniSSB30mMode);
    WriteInteger('bandssb','SSB30mFilter',IniSSB30mFilter);
    WriteInteger('bandssb','SSB30mIP3',IniSSB30mIP3);
    WriteInteger('bandssb','SSB30mColour',IniSSB30mColour);

    WriteInteger('bandssb','SSB20mFreq',IniSSB20mFreq);
    WriteInteger('bandssb','SSB20mMode',IniSSB20mMode);
    WriteInteger('bandssb','SSB20mFilter',IniSSB20mFilter);
    WriteInteger('bandssb','SSB20mIP3',IniSSB20mIP3);
    WriteInteger('bandssb','SSB20mColour',IniSSB20mColour);

    WriteInteger('bandssb','SSB17mFreq',IniSSB17mFreq);
    WriteInteger('bandssb','SSB17mMode',IniSSB17mMode);
    WriteInteger('bandssb','SSB17mFilter',IniSSB17mFilter);
    WriteInteger('bandssb','SSB17mIP3',IniSSB17mIP3);
    WriteInteger('bandssb','SSB17mColour',IniSSB17mColour);

    WriteInteger('bandssb','SSB15mFreq',IniSSB15mFreq);
    WriteInteger('bandssb','SSB15mMode',IniSSB15mMode);
    WriteInteger('bandssb','SSB15mFilter',IniSSB15mFilter);
    WriteInteger('bandssb','SSB15mIP3',IniSSB15mIP3);
    WriteInteger('bandssb','SSB15mColour',IniSSB15mColour);

    WriteInteger('bandssb','SSB12mFreq',IniSSB12mFreq);
    WriteInteger('bandssb','SSB12mMode',IniSSB12mMode);
    WriteInteger('bandssb','SSB12mFilter',IniSSB12mFilter);
    WriteInteger('bandssb','SSB12mIP3',IniSSB12mIP3);
    WriteInteger('bandssb','SSB12mColour',IniSSB12mColour);

    WriteInteger('bandssb','SSB10mFreq',IniSSB10mFreq);
    WriteInteger('bandssb','SSB10mMode',IniSSB10mMode);
    WriteInteger('bandssb','SSB10mFilter',IniSSB10mFilter);
    WriteInteger('bandssb','SSB10mIP3',IniSSB10mIP3);
    WriteInteger('bandssb','SSB10mColour',IniSSB10mColour);

{   WriteInteger('bandssb','SSB6mFreq',IniSSB6mFreq);
    WriteInteger('bandssb','SSB6mMode',IniSSB6mMode);
    WriteInteger('bandssb','SSB6mFilter',IniSSB6mFilter);
    WriteInteger('bandssb','SSB6mIP3',IniSSB6mIP3);
    WriteInteger('bandssb','SSB6mColour',IniSSB6mColour);
}

    WriteInteger('bandcw','CW160mFreq',IniCW160mFreq);
    WriteInteger('bandcw','CW160mMode',IniCW160mMode);
    WriteInteger('bandcw','CW160mFilter',IniCW160mFilter);
    WriteInteger('bandcw','CW160mIP3',IniCW160mIP3);
    WriteInteger('bandcw','CW160mColour',IniCW160mColour);

    WriteInteger('bandcw','CW80mFreq',IniCW80mFreq);
    WriteInteger('bandcw','CW80mMode',IniCW80mMode);
    WriteInteger('bandcw','CW80mFilter',IniCW80mFilter);
    WriteInteger('bandcw','CW80mIP3',IniCW80mIP3);
    WriteInteger('bandcw','CW80mColour',IniCW80mColour);

    WriteInteger('bandcw','CW40mFreq',IniCW40mFreq);
    WriteInteger('bandcw','CW40mMode',IniCW40mMode);
    WriteInteger('bandcw','CW40mFilter',IniCW40mFilter);
    WriteInteger('bandcw','CW40mIP3',IniCW40mIP3);
    WriteInteger('bandcw','CW40mColour',IniCW40mColour);

    WriteInteger('bandcw','CW30mFreq',IniCW30mFreq);
    WriteInteger('bandcw','CW30mMode',IniCW30mMode);
    WriteInteger('bandcw','CW30mFilter',IniCW30mFilter);
    WriteInteger('bandcw','CW30mIP3',IniCW30mIP3);
    WriteInteger('bandcw','CW30mColour',IniCW30mColour);

    WriteInteger('bandcw','CW20mFreq',IniCW20mFreq);
    WriteInteger('bandcw','CW20mMode',IniCW20mMode);
    WriteInteger('bandcw','CW20mFilter',IniCW20mFilter);
    WriteInteger('bandcw','CW20mIP3',IniCW20mIP3);
    WriteInteger('bandcw','CW20mColour',IniCW20mColour);

    WriteInteger('bandcw','CW17mFreq',IniCW17mFreq);
    WriteInteger('bandcw','CW17mMode',IniCW17mMode);
    WriteInteger('bandcw','CW17mFilter',IniCW17mFilter);
    WriteInteger('bandcw','CW17mIP3',IniCW17mIP3);
    WriteInteger('bandcw','CW17mColour',IniCW17mColour);

    WriteInteger('bandcw','CW15mFreq',IniCW15mFreq);
    WriteInteger('bandcw','CW15mMode',IniCW15mMode);
    WriteInteger('bandcw','CW15mFilter',IniCW15mFilter);
    WriteInteger('bandcw','CW15mIP3',IniCW15mIP3);
    WriteInteger('bandcw','CW15mColour',IniCW15mColour);

    WriteInteger('bandcw','CW12mFreq',IniCW12mFreq);
    WriteInteger('bandcw','CW12mMode',IniCW12mMode);
    WriteInteger('bandcw','CW12mFilter',IniCW12mFilter);
    WriteInteger('bandcw','CW12mIP3',IniCW12mIP3);
    WriteInteger('bandcw','CW12mColour',IniCW12mColour);

    WriteInteger('bandcw','CW10mFreq',IniCW10mFreq);
    WriteInteger('bandcw','CW10mMode',IniCW10mMode);
    WriteInteger('bandcw','CW10mFilter',IniCW10mFilter);
    WriteInteger('bandcw','CW10mIP3',IniCW10mIP3);
    WriteInteger('bandcw','CW10mColour',IniCW10mColour);

{   WriteInteger('bandcw','CW6mFreq',IniCW6mFreq);
    WriteInteger('bandcw','CW6mMode',IniCW6mMode);
    WriteInteger('bandcw','CW6mFilter',IniCW6mFilter);
    WriteInteger('bandcw','CW6mIP3',IniCW6mIP3);
    WriteInteger('bandcw','CW6mColour',IniCW6mColour);
}

    WriteInteger('mem67','Mem6761Freq',IniMem6761Freq);
    WriteInteger('mem67','Mem6761Mode',IniMem6761Mode);
    WriteInteger('mem67','Mem6761Filter',IniMem6761Filter);
    WriteInteger('mem67','Mem6761IP3',IniMem6761IP3);
    WriteInteger('mem67','Mem6761Colour',IniMem6761Colour);

    WriteInteger('mem67','Mem6762Freq',IniMem6762Freq);
    WriteInteger('mem67','Mem6762Mode',IniMem6762Mode);
    WriteInteger('mem67','Mem6762Filter',IniMem6762Filter);
    WriteInteger('mem67','Mem6762IP3',IniMem6762IP3);
    WriteInteger('mem67','Mem6762Colour',IniMem6762Colour);

    WriteInteger('mem67','Mem6763Freq',IniMem6763Freq);
    WriteInteger('mem67','Mem6763Mode',IniMem6763Mode);
    WriteInteger('mem67','Mem6763Filter',IniMem6763Filter);
    WriteInteger('mem67','Mem6763IP3',IniMem6763IP3);
    WriteInteger('mem67','Mem6763Colour',IniMem6763Colour);

    WriteInteger('mem67','Mem6764Freq',IniMem6764Freq);
    WriteInteger('mem67','Mem6764Mode',IniMem6764Mode);
    WriteInteger('mem67','Mem6764Filter',IniMem6764Filter);
    WriteInteger('mem67','Mem6764IP3',IniMem6764IP3);
    WriteInteger('mem67','Mem6764Colour',IniMem6764Colour);

    WriteInteger('mem67','Mem6765Freq',IniMem6765Freq);
    WriteInteger('mem67','Mem6765Mode',IniMem6765Mode);
    WriteInteger('mem67','Mem6765Filter',IniMem6765Filter);
    WriteInteger('mem67','Mem6765IP3',IniMem6765IP3);
    WriteInteger('mem67','Mem6765Colour',IniMem6765Colour);

    WriteInteger('mem67','Mem6766Freq',IniMem6766Freq);
    WriteInteger('mem67','Mem6766Mode',IniMem6766Mode);
    WriteInteger('mem67','Mem6766Filter',IniMem6766Filter);
    WriteInteger('mem67','Mem6766IP3',IniMem6766IP3);
    WriteInteger('mem67','Mem6766Colour',IniMem6766Colour);


    WriteInteger('mem68','Mem6861Freq',IniMem6861Freq);
    WriteInteger('mem68','Mem6861Mode',IniMem6861Mode);
    WriteInteger('mem68','Mem6861Filter',IniMem6861Filter);
    WriteInteger('mem68','Mem6861IP3',IniMem6861IP3);
    WriteInteger('mem68','Mem6861Colour',IniMem6861Colour);

    WriteInteger('mem68','Mem6862Freq',IniMem6862Freq);
    WriteInteger('mem68','Mem6862Mode',IniMem6862Mode);
    WriteInteger('mem68','Mem6862Filter',IniMem6862Filter);
    WriteInteger('mem68','Mem6862IP3',IniMem6862IP3);
    WriteInteger('mem68','Mem6862Colour',IniMem6862Colour);

    WriteInteger('mem68','Mem6863Freq',IniMem6863Freq);
    WriteInteger('mem68','Mem6863Mode',IniMem6863Mode);
    WriteInteger('mem68','Mem6863Filter',IniMem6863Filter);
    WriteInteger('mem68','Mem6863IP3',IniMem6863IP3);
    WriteInteger('mem68','Mem6863Colour',IniMem6863Colour);

    WriteInteger('mem68','Mem6864Freq',IniMem6864Freq);
    WriteInteger('mem68','Mem6864Mode',IniMem6864Mode);
    WriteInteger('mem68','Mem6864Filter',IniMem6864Filter);
    WriteInteger('mem68','Mem6864IP3',IniMem6864IP3);
    WriteInteger('mem68','Mem6864Colour',IniMem6864Colour);

    WriteInteger('mem68','Mem6865Freq',IniMem6865Freq);
    WriteInteger('mem68','Mem6865Mode',IniMem6865Mode);
    WriteInteger('mem68','Mem6865Filter',IniMem6865Filter);
    WriteInteger('mem68','Mem6865IP3',IniMem6865IP3);
    WriteInteger('mem68','Mem6865Colour',IniMem6865Colour);

    WriteInteger('mem68','Mem6866Freq',IniMem6866Freq);
    WriteInteger('mem68','Mem6866Mode',IniMem6866Mode);
    WriteInteger('mem68','Mem6866Filter',IniMem6866Filter);
    WriteInteger('mem68','Mem6866IP3',IniMem6866IP3);
    WriteInteger('mem68','Mem6866Colour',IniMem6866Colour);


    WriteInteger('mem69','Mem6961Freq',IniMem6961Freq);
    WriteInteger('mem69','Mem6961Mode',IniMem6961Mode);
    WriteInteger('mem69','Mem6961Filter',IniMem6961Filter);
    WriteInteger('mem69','Mem6961IP3',IniMem6961IP3);
    WriteInteger('mem69','Mem6961Colour',IniMem6961Colour);

    WriteInteger('mem69','Mem6962Freq',IniMem6962Freq);
    WriteInteger('mem69','Mem6962Mode',IniMem6962Mode);
    WriteInteger('mem69','Mem6962Filter',IniMem6962Filter);
    WriteInteger('mem69','Mem6962IP3',IniMem6962IP3);
    WriteInteger('mem69','Mem6962Colour',IniMem6962Colour);

    WriteInteger('mem69','Mem6963Freq',IniMem6963Freq);
    WriteInteger('mem69','Mem6963Mode',IniMem6963Mode);
    WriteInteger('mem69','Mem6963Filter',IniMem6963Filter);
    WriteInteger('mem69','Mem6963IP3',IniMem6963IP3);
    WriteInteger('mem69','Mem6963Colour',IniMem6963Colour);

    WriteInteger('mem69','Mem6964Freq',IniMem6964Freq);
    WriteInteger('mem69','Mem6964Mode',IniMem6964Mode);
    WriteInteger('mem69','Mem6964Filter',IniMem6964Filter);
    WriteInteger('mem69','Mem6964IP3',IniMem6964IP3);
    WriteInteger('mem69','Mem6964Colour',IniMem6964Colour);

    WriteInteger('mem69','Mem6965Freq',IniMem6965Freq);
    WriteInteger('mem69','Mem6965Mode',IniMem6965Mode);
    WriteInteger('mem69','Mem6965Filter',IniMem6965Filter);
    WriteInteger('mem69','Mem6965IP3',IniMem6965IP3);
    WriteInteger('mem69','Mem6965Colour',IniMem6965Colour);

    WriteInteger('mem69','Mem6966Freq',IniMem6966Freq);
    WriteInteger('mem69','Mem6966Mode',IniMem6966Mode);
    WriteInteger('mem69','Mem6966Filter',IniMem6966Filter);
    WriteInteger('mem69','Mem6966IP3',IniMem6966IP3);
    WriteInteger('mem69','Mem6966Colour',IniMem6966Colour);


    WriteInteger('mem60','Mem6061Freq',IniMem6061Freq);
    WriteInteger('mem60','Mem6061Mode',IniMem6061Mode);
    WriteInteger('mem60','Mem6061Filter',IniMem6061Filter);
    WriteInteger('mem60','Mem6061IP3',IniMem6061IP3);
    WriteInteger('mem60','Mem6061Colour',IniMem6061Colour);

    WriteInteger('mem60','Mem6062Freq',IniMem6062Freq);
    WriteInteger('mem60','Mem6062Mode',IniMem6062Mode);
    WriteInteger('mem60','Mem6062Filter',IniMem6062Filter);
    WriteInteger('mem60','Mem6062IP3',IniMem6062IP3);
    WriteInteger('mem60','Mem6062Colour',IniMem6062Colour);

    WriteInteger('mem60','Mem6063Freq',IniMem6063Freq);
    WriteInteger('mem60','Mem6063Mode',IniMem6063Mode);
    WriteInteger('mem60','Mem6063Filter',IniMem6063Filter);
    WriteInteger('mem60','Mem6063IP3',IniMem6063IP3);
    WriteInteger('mem60','Mem6063Colour',IniMem6063Colour);

    WriteInteger('mem60','Mem6064Freq',IniMem6064Freq);
    WriteInteger('mem60','Mem6064Mode',IniMem6064Mode);
    WriteInteger('mem60','Mem6064Filter',IniMem6064Filter);
    WriteInteger('mem60','Mem6064IP3',IniMem6064IP3);
    WriteInteger('mem60','Mem6064Colour',IniMem6064Colour);

    WriteInteger('mem60','Mem6065Freq',IniMem6065Freq);
    WriteInteger('mem60','Mem6065Mode',IniMem6065Mode);
    WriteInteger('mem60','Mem6065Filter',IniMem6065Filter);
    WriteInteger('mem60','Mem6065IP3',IniMem6065IP3);
    WriteInteger('mem60','Mem6065Colour',IniMem6065Colour);

    WriteInteger('mem60','Mem6066Freq',IniMem6066Freq);
    WriteInteger('mem60','Mem6066Mode',IniMem6066Mode);
    WriteInteger('mem60','Mem6066Filter',IniMem6066Filter);
    WriteInteger('mem60','Mem6066IP3',IniMem6066IP3);
    WriteInteger('mem60','Mem6066Colour',IniMem6066Colour);


    WriteInteger('poweron','PowerOnFreq',IniPowerOnFreq);
    WriteInteger('poweron','PowerOnMode',IniPowerOnMode);
    WriteInteger('poweron','PowerOnFilter',IniPowerOnFilter);
    WriteInteger('poweron','PowerOnIP3',IniPowerOnIP3);
    WriteInteger('poweron','PowerOnColour',IniPowerOnColour);

    WriteInteger('vfo','VFO1Freq',IniVFO1Freq);
    WriteInteger('vfo','VFO1Mode',IniVFO1Mode);
    WriteInteger('vfo','VFO1Filter',IniVFO1Filter);
    WriteInteger('vfo','VFO1IP3',IniVFO1IP3);
    WriteInteger('vfo','VFO1Colour',IniVFO1Colour);

    WriteInteger('vfo','VFO2Freq',IniVFO2Freq);
    WriteInteger('vfo','VFO2Mode',IniVFO2Mode);
    WriteInteger('vfo','VFO2Filter',IniVFO2Filter);
    WriteInteger('vfo','VFO2IP3',IniVFO2IP3);
    WriteInteger('vfo','VFO2Colour',IniVFO2Colour);

    WriteInteger('vfo','VFO3Freq',IniVFO3Freq);
    WriteInteger('vfo','VFO3Mode',IniVFO3Mode);
    WriteInteger('vfo','VFO3Filter',IniVFO3Filter);
    WriteInteger('vfo','VFO3IP3',IniVFO3IP3);
    WriteInteger('vfo','VFO3Colour',IniVFO3Colour);

    WriteInteger('vfo','VFO4Freq',IniVFO4Freq);
    WriteInteger('vfo','VFO4Mode',IniVFO4Mode);
    WriteInteger('vfo','VFO4Filter',IniVFO4Filter);
    WriteInteger('vfo','VFO4IP3',IniVFO4IP3);
    WriteInteger('vfo','VFO4Colour',IniVFO4Colour);

    WriteInteger('vfo','VFO5Freq',IniVFO5Freq);
    WriteInteger('vfo','VFO5Mode',IniVFO5Mode);
    WriteInteger('vfo','VFO5Filter',IniVFO5Filter);
    WriteInteger('vfo','VFO5IP3',IniVFO5IP3);
    WriteInteger('vfo','VFO5Colour',IniVFO5Colour);

    WriteInteger('vfo','VFO6Freq',IniVFO6Freq);
    WriteInteger('vfo','VFO6Mode',IniVFO6Mode);
    WriteInteger('vfo','VFO6Filter',IniVFO6Filter);
    WriteInteger('vfo','VFO6IP3',IniVFO6IP3);
    WriteInteger('vfo','VFO6Colour',IniVFO6Colour);

    WriteInteger('vfo','VFO7Freq',IniVFO7Freq);
    WriteInteger('vfo','VFO7Mode',IniVFO7Mode);
    WriteInteger('vfo','VFO7Filter',IniVFO7Filter);
    WriteInteger('vfo','VFO7IP3',IniVFO7IP3);
    WriteInteger('vfo','VFO7Colour',IniVFO7Colour);

    WriteString( 'PCA9555tasks','PCA9555_Task1_Operation',PcaTaskList[IniPcaTasks[1].IniPcaOpcode]);
    WriteInteger('PCA9555tasks','PCA9555_Task1_Address',  IniPcaTasks[1].IniPcaAddress);
    WriteInteger('PCA9555tasks','PCA9555_Task1_Group',    IniPcaTasks[1].IniPcaGroup);
    WriteInteger('PCA9555tasks','PCA9555_Task1_Dataword', IniPcaTasks[1].IniPcaDataword);
    WriteString( 'PCA9555tasks','PCA9555_Task1_Label',    IniPcaTasks[1].IniPcaLabel);

    WriteString( 'PCA9555tasks','PCA9555_Task2_Operation',PcaTaskList[IniPcaTasks[2].IniPcaOpcode]);
    WriteInteger('PCA9555tasks','PCA9555_Task2_Address',  IniPcaTasks[2].IniPcaAddress);
    WriteInteger('PCA9555tasks','PCA9555_Task2_Group',    IniPcaTasks[2].IniPcaGroup);
    WriteInteger('PCA9555tasks','PCA9555_Task2_Dataword', IniPcaTasks[2].IniPcaDataword);
    WriteString( 'PCA9555tasks','PCA9555_Task2_Label',    IniPcaTasks[2].IniPcaLabel);

    WriteString( 'PCA9555tasks','PCA9555_Task3_Operation',PcaTaskList[IniPcaTasks[3].IniPcaOpcode]);
    WriteInteger('PCA9555tasks','PCA9555_Task3_Address',  IniPcaTasks[3].IniPcaAddress);
    WriteInteger('PCA9555tasks','PCA9555_Task3_Group',    IniPcaTasks[3].IniPcaGroup);
    WriteInteger('PCA9555tasks','PCA9555_Task3_Dataword', IniPcaTasks[3].IniPcaDataword);
    WriteString( 'PCA9555tasks','PCA9555_Task3_Label',    IniPcaTasks[3].IniPcaLabel);

    WriteString( 'PCA9555tasks','PCA9555_Task4_Operation',PcaTaskList[IniPcaTasks[4].IniPcaOpcode]);
    WriteInteger('PCA9555tasks','PCA9555_Task4_Address',  IniPcaTasks[4].IniPcaAddress);
    WriteInteger('PCA9555tasks','PCA9555_Task4_Group',    IniPcaTasks[4].IniPcaGroup);
    WriteInteger('PCA9555tasks','PCA9555_Task4_Dataword', IniPcaTasks[4].IniPcaDataword);
    WriteString( 'PCA9555tasks','PCA9555_Task4_Label',    IniPcaTasks[4].IniPcaLabel);

    WriteString( 'PCA9555tasks','PCA9555_Task5_Operation',PcaTaskList[IniPcaTasks[5].IniPcaOpcode]);
    WriteInteger('PCA9555tasks','PCA9555_Task5_Address',  IniPcaTasks[5].IniPcaAddress);
    WriteInteger('PCA9555tasks','PCA9555_Task5_Group',    IniPcaTasks[5].IniPcaGroup);
    WriteInteger('PCA9555tasks','PCA9555_Task5_Dataword', IniPcaTasks[5].IniPcaDataword);
    WriteString( 'PCA9555tasks','PCA9555_Task5_Label',    IniPcaTasks[5].IniPcaLabel);

    WriteString( 'PCA9555tasks','PCA9555_Task6_Operation',PcaTaskList[IniPcaTasks[6].IniPcaOpcode]);
    WriteInteger('PCA9555tasks','PCA9555_Task6_Address',  IniPcaTasks[6].IniPcaAddress);
    WriteInteger('PCA9555tasks','PCA9555_Task6_Group',    IniPcaTasks[6].IniPcaGroup);
    WriteInteger('PCA9555tasks','PCA9555_Task6_Dataword', IniPcaTasks[6].IniPcaDataword);
    WriteString( 'PCA9555tasks','PCA9555_Task6_Label',    IniPcaTasks[6].IniPcaLabel);

    WriteString( 'PCA9555tasks','PCA9555_Task7_Operation',PcaTaskList[IniPcaTasks[7].IniPcaOpcode]);
    WriteInteger('PCA9555tasks','PCA9555_Task7_Address',  IniPcaTasks[7].IniPcaAddress);
    WriteInteger('PCA9555tasks','PCA9555_Task7_Group',    IniPcaTasks[7].IniPcaGroup);
    WriteInteger('PCA9555tasks','PCA9555_Task7_Dataword', IniPcaTasks[7].IniPcaDataword);
    WriteString( 'PCA9555tasks','PCA9555_Task7_Label',    IniPcaTasks[7].IniPcaLabel);

    WriteString( 'PCA9555tasks','PCA9555_Task8_Operation',PcaTaskList[IniPcaTasks[8].IniPcaOpcode]);
    WriteInteger('PCA9555tasks','PCA9555_Task8_Address',  IniPcaTasks[8].IniPcaAddress);
    WriteInteger('PCA9555tasks','PCA9555_Task8_Group',    IniPcaTasks[8].IniPcaGroup);
    WriteInteger('PCA9555tasks','PCA9555_Task8_Dataword', IniPcaTasks[8].IniPcaDataword);
    WriteString( 'PCA9555tasks','PCA9555_Task8_Label',    IniPcaTasks[8].IniPcaLabel);

    WriteInteger('I2CBPF','PCA9555BpfType',IniPCA9555BpfType);
    WriteInteger('I2CBPF','PCA9555BpfAddress',IniPCA9555BpfAddress);
    WriteInteger('I2CBPF','EnablePCA9555',IniEnablePCA9555);
    WriteInteger('PA3AKE','IniPA3AKE_RooferAddress',IniPA3AKE_RooferAddress);
    WriteInteger('PA3AKE','IniPA3AKE_SquarerAddress',IniPA3AKE_SquarerAddress);
    WriteInteger('PA3AKE','IniPA3AKE_MixerAddress',IniPA3AKE_MixerAddress);
    WriteInteger('PA3AKE','IniPA3AKE_MixerEnable',IniPA3AKE_MixerEnable);
    WriteInteger('PA3AKE','IniPA3AKE_RooferSwitchEnable',IniPA3AKE_RooferSwitchEnable);
    WriteInteger('PA3AKE','IniPA3AKE_MixerDAC',IniPA3AKE_MixerDAC);
    WriteInteger('PA3AKE','IniPA3AKE_SquarerDAC',IniPA3AKE_SquarerDAC);

    WriteString('RTC','LocalTimeOffset',IniLocalTimeOffset);

    Free;
  end;
end;



procedure LoadEememInifile;
begin
  EememIniFile := TIniFile.Create(g_RegIniData.IniStarFolder + '/TrxAvrEemem.ini');
  with EememIniFile, g_EememIniData do
  begin
    IniDDSclock := ReadInteger('rfconfig','ddsclock',175000000);
    IniLSBoffset := ReadInteger('rfconfig','lsboffset',10751000);
    IniUSBoffset := ReadInteger('rfconfig','usboffset',10753700);
    IniCWoffset := ReadInteger('rfconfig','cwoffset',10752350);
    IniCWoffsetEnable := ReadInteger('rfconfig','cwoffsetenable',0);

    IniEncodersPots[0] := ReadInteger('encoderparams','encoder1',22);
    IniEncodersPots[1] := ReadInteger('encoderparams','encoder2',11);
    IniEncodersPots[2] := ReadInteger('encoderparams','encoder3',61);
    IniEncodersPots[3] := ReadInteger('encoderparams','encoder4',62);
    IniEncodersPots[4] := ReadInteger('encoderparams','encoder5',81);
    IniEncodersPots[5] := ReadInteger('encoderparams','encoder6',91);
    IniEncodersPots[6] := ReadInteger('encoderparams','encoder7',82);
    IniEncodersPots[7] := ReadInteger('encoderparams','encoder8',51);
    IniEncodersPots[8] := ReadInteger('encoderparams','potA',72);
    IniEncodersPots[9] := ReadInteger('encoderparams','potB',77);

    IniRxButton['A'] := ReadInteger('rxbuttonassign','rxbuttonA',0);
    IniRxButton['B'] := ReadInteger('rxbuttonassign','rxbuttonB',0);
    IniRxButton['C'] := ReadInteger('rxbuttonassign','rxbuttonC',0);
    IniRxButton['D'] := ReadInteger('rxbuttonassign','rxbuttonD',0);
    IniRxButton['E'] := ReadInteger('rxbuttonassign','rxbuttonE',0);
    IniRxButton['F'] := ReadInteger('rxbuttonassign','rxbuttonF',0);
    IniRxButton['G'] := ReadInteger('rxbuttonassign','rxbuttonG',0);
    IniRxButton['H'] := ReadInteger('rxbuttonassign','rxbuttonH',0);
    IniRxButton['I'] := ReadInteger('rxbuttonassign','rxbuttonI',0);
    IniRxButton['J'] := ReadInteger('rxbuttonassign','rxbuttonJ',0);
    IniRxButton['K'] := ReadInteger('rxbuttonassign','rxbuttonK',0);
    IniRxButton['L'] := ReadInteger('rxbuttonassign','rxbuttonL',0);
    IniRxButton['M'] := ReadInteger('rxbuttonassign','rxbuttonM',0);
    IniRxButton['N'] := ReadInteger('rxbuttonassign','rxbuttonN',0);
    IniRxButton['O'] := ReadInteger('rxbuttonassign','rxbuttonO',0);
    IniRxButton['P'] := ReadInteger('rxbuttonassign','rxbuttonP',0);
    IniRxButton['Q'] := ReadInteger('rxbuttonassign','rxbuttonQ',0);
    IniRxButton['R'] := ReadInteger('rxbuttonassign','rxbuttonR',0);
    IniRxButton['S'] := ReadInteger('rxbuttonassign','rxbuttonS',0);
    IniRxButton['T'] := ReadInteger('rxbuttonassign','rxbuttonT',0);
    IniRxButton['U'] := ReadInteger('rxbuttonassign','rxbuttonU',0);
    IniRxButton['V'] := ReadInteger('rxbuttonassign','rxbuttonV',0);
    IniRxButton['W'] := ReadInteger('rxbuttonassign','rxbuttonW',0);
    IniRxButton['X'] := ReadInteger('rxbuttonassign','rxbuttonX',0);
    IniRxButton['Y'] := ReadInteger('rxbuttonassign','rxbuttonY',0);
    IniRxButton['Z'] := ReadInteger('rxbuttonassign','rxbuttonZ',0);

    IniTxButton['A'] := ReadInteger('txbuttonassign','txbuttonA',0);
    IniTxButton['B'] := ReadInteger('txbuttonassign','txbuttonB',0);
    IniTxButton['C'] := ReadInteger('txbuttonassign','txbuttonC',0);
    IniTxButton['D'] := ReadInteger('txbuttonassign','txbuttonD',0);
    IniTxButton['E'] := ReadInteger('txbuttonassign','txbuttonE',0);
    IniTxButton['F'] := ReadInteger('txbuttonassign','txbuttonF',0);
    IniTxButton['G'] := ReadInteger('txbuttonassign','txbuttonG',0);
    IniTxButton['H'] := ReadInteger('txbuttonassign','txbuttonH',0);
    IniTxButton['I'] := ReadInteger('txbuttonassign','txbuttonI',0);
    IniTxButton['J'] := ReadInteger('txbuttonassign','txbuttonJ',0);
    IniTxButton['K'] := ReadInteger('txbuttonassign','txbuttonK',0);
    IniTxButton['L'] := ReadInteger('txbuttonassign','txbuttonL',0);
    IniTxButton['M'] := ReadInteger('txbuttonassign','txbuttonM',0);
    IniTxButton['N'] := ReadInteger('txbuttonassign','txbuttonN',0);
    IniTxButton['O'] := ReadInteger('txbuttonassign','txbuttonO',0);
    IniTxButton['P'] := ReadInteger('txbuttonassign','txbuttonP',0);
    IniTxButton['Q'] := ReadInteger('txbuttonassign','txbuttonQ',0);
    IniTxButton['R'] := ReadInteger('txbuttonassign','txbuttonR',0);
    IniTxButton['S'] := ReadInteger('txbuttonassign','txbuttonS',0);
    IniTxButton['T'] := ReadInteger('txbuttonassign','txbuttonT',0);
    IniTxButton['U'] := ReadInteger('txbuttonassign','txbuttonU',0);
    IniTxButton['V'] := ReadInteger('txbuttonassign','txbuttonV',0);
    IniTxButton['W'] := ReadInteger('txbuttonassign','txbuttonW',0);
    IniTxButton['X'] := ReadInteger('txbuttonassign','txbuttonX',0);
    IniTxButton['Y'] := ReadInteger('txbuttonassign','txbuttonY',0);
    IniTxButton['Z'] := ReadInteger('txbuttonassign','txbuttonZ',0);

    IniRxTouchpad[1]  := ReadInteger('rxtouchpadassign','rxtouchpad1' ,0);
    IniRxTouchpad[2]  := ReadInteger('rxtouchpadassign','rxtouchpad2' ,0);
    IniRxTouchpad[3]  := ReadInteger('rxtouchpadassign','rxtouchpad3' ,0);
    IniRxTouchpad[4]  := ReadInteger('rxtouchpadassign','rxtouchpad4' ,0);
    IniRxTouchpad[5]  := ReadInteger('rxtouchpadassign','rxtouchpad5' ,0);
    IniRxTouchpad[6]  := ReadInteger('rxtouchpadassign','rxtouchpad6' ,0);
    IniRxTouchpad[7]  := ReadInteger('rxtouchpadassign','rxtouchpad7' ,0);
    IniRxTouchpad[8]  := ReadInteger('rxtouchpadassign','rxtouchpad8' ,0);
    IniRxTouchpad[9]  := ReadInteger('rxtouchpadassign','rxtouchpad9' ,0);
    IniRxTouchpad[10] := ReadInteger('rxtouchpadassign','rxtouchpad10',0);
    IniRxTouchpad[11] := ReadInteger('rxtouchpadassign','rxtouchpad11',0);
    IniRxTouchpad[12] := ReadInteger('rxtouchpadassign','rxtouchpad12',0);
    IniRxTouchpad[13] := ReadInteger('rxtouchpadassign','rxtouchpad13',0);
    IniRxTouchpad[14] := ReadInteger('rxtouchpadassign','rxtouchpad14',0);
    IniRxTouchpad[15] := ReadInteger('rxtouchpadassign','rxtouchpad15',0);

    IniTxTouchpad[1]  := ReadInteger('txtouchpadassign','txtouchpad1' ,0);
    IniTxTouchpad[2]  := ReadInteger('txtouchpadassign','txtouchpad2' ,0);
    IniTxTouchpad[3]  := ReadInteger('txtouchpadassign','txtouchpad3' ,0);
    IniTxTouchpad[4]  := ReadInteger('txtouchpadassign','txtouchpad4' ,0);
    IniTxTouchpad[5]  := ReadInteger('txtouchpadassign','txtouchpad5' ,0);
    IniTxTouchpad[6]  := ReadInteger('txtouchpadassign','txtouchpad6' ,0);
    IniTxTouchpad[7]  := ReadInteger('txtouchpadassign','txtouchpad7' ,0);
    IniTxTouchpad[8]  := ReadInteger('txtouchpadassign','txtouchpad8' ,0);
    IniTxTouchpad[9]  := ReadInteger('txtouchpadassign','txtouchpad9' ,0);
    IniTxTouchpad[10] := ReadInteger('txtouchpadassign','txtouchpad10',0);
    IniTxTouchpad[11] := ReadInteger('txtouchpadassign','txtouchpad11',0);
    IniTxTouchpad[12] := ReadInteger('txtouchpadassign','txtouchpad12',0);
    IniTxTouchpad[13] := ReadInteger('txtouchpadassign','txtouchpad13',0);
    IniTxTouchpad[14] := ReadInteger('txtouchpadassign','txtouchpad14',0);
    IniTxTouchpad[15] := ReadInteger('txtouchpadassign','txtouchpad15',0);

    Ini44CWmode := ReadInteger('ddsparams','44CWmode',2);
    IniSoftwareFlywheel := ReadInteger('ddsparams','SoftwareFlywheel',0);
    IniAutoDIm := ReadInteger('ddsparams','Autodim',1);
    IniParamResetMode := ReadInteger('ddsparams','ParamResetMode',1);
    IniDisplayBright := ReadInteger('ddsparams','DisplayBright',255);
    IniDisplayDimmed := ReadInteger('ddsparams','DisplayDimmed',80);
    IniAutoDimSeconds := ReadInteger('ddsparams','AutoDimSeconds',30);
    IniDisplayKeyValue := ReadInteger('ddsparams','DisplayKeyValue',0);
    IniDSPDDSKeysDisplay := ReadInteger('ddsparams','DSPDDSKeysDisplay',0);
    IniMenuTimeout := ReadInteger('ddsparams','MenuTimeout',0);
    IniMoxTimeout := ReadInteger('ddsparams','MoxTimeout',5);

    IniTouchCalLeft := ReadInteger('touchpanel','TouchCalLeft',200);
    IniTouchCalRight := ReadInteger('touchpanel','TouchCalRight',840);
    IniTouchCalTop := ReadInteger('touchpanel','TouchCalTop',168);
    IniTouchCalBottom := ReadInteger('touchpanel','TouchCalBottom',915);

    IniLast160mFreq   := ReadInteger('bandlast','Last160mFreq',1850000);
    IniLast160mMode   := ReadInteger('bandlast','Last160mMode',0);
    IniLast160mFilter := ReadInteger('bandlast','Last160mFilter',0);
    IniLast160mIP3    := ReadInteger('bandlast','Last160mIP3',1);
    IniLast160mColour := ReadInteger('bandlast','Last160mColour',1);

    IniLast80mFreq   := ReadInteger('bandlast','Last80mFreq',3727000);
    IniLast80mMode   := ReadInteger('bandlast','Last80mMode',0);
    IniLast80mFilter := ReadInteger('bandlast','Last80mFilter',0);
    IniLast80mIP3    := ReadInteger('bandlast','Last80mIP3',1);
    IniLast80mColour := ReadInteger('bandlast','Last80mColour',1);

    IniLast40mFreq   := ReadInteger('bandlast','Last40mFreq',7040000);
    IniLast40mMode   := ReadInteger('bandlast','Last40mMode',0);
    IniLast40mFilter := ReadInteger('bandlast','Last40mFilter',0);
    IniLast40mIP3    := ReadInteger('bandlast','Last40mIP3',1);
    IniLast40mColour := ReadInteger('bandlast','Last40mColour',1);

    IniLast30mFreq   := ReadInteger('bandlast','Last30mFreq',10100000);
    IniLast30mMode   := ReadInteger('bandlast','Last30mMode',2);
    IniLast30mFilter := ReadInteger('bandlast','Last30mFilter',0);
    IniLast30mIP3    := ReadInteger('bandlast','Last30mIP3',1);
    IniLast30mColour := ReadInteger('bandlast','Last30mColour',1);

    IniLast20mFreq   := ReadInteger('bandlast','Last20mFreq',14307000);
    IniLast20mMode   := ReadInteger('bandlast','Last20mMode',1);
    IniLast20mFilter := ReadInteger('bandlast','Last20mFilter',0);
    IniLast20mIP3    := ReadInteger('bandlast','Last20mIP3',0);
    IniLast20mColour := ReadInteger('bandlast','Last20mColour',1);

    IniLast17mFreq   := ReadInteger('bandlast','Last17mFreq',18110000);
    IniLast17mMode   := ReadInteger('bandlast','Last17mMode',1);
    IniLast17mFilter := ReadInteger('bandlast','Last17mFilter',0);
    IniLast17mIP3    := ReadInteger('bandlast','Last17mIP3',0);
    IniLast17mColour := ReadInteger('bandlast','Last17mColour',1);

    IniLast15mFreq   := ReadInteger('bandlast','Last15mFreq',21150000);
    IniLast15mMode   := ReadInteger('bandlast','Last15mMode',1);
    IniLast15mFilter := ReadInteger('bandlast','Last15mFilter',0);
    IniLast15mIP3    := ReadInteger('bandlast','Last15mIP3',0);
    IniLast15mColour := ReadInteger('bandlast','Last15mColour',1);

    IniLast12mFreq   := ReadInteger('bandlast','Last12mFreq',24930000);
    IniLast12mMode   := ReadInteger('bandlast','Last12mMode',2);
    IniLast12mFilter := ReadInteger('bandlast','Last12mFilter',0);
    IniLast12mIP3    := ReadInteger('bandlast','Last12mIP3',0);
    IniLast12mColour := ReadInteger('bandlast','Last12mColour',1);

    IniLast10mFreq   := ReadInteger('bandlast','Last10mFreq',28500000);
    IniLast10mMode   := ReadInteger('bandlast','Last10mMode',1);
    IniLast10mFilter := ReadInteger('bandlast','Last10mFilter',0);
    IniLast10mIP3    := ReadInteger('bandlast','Last10mIP3',0);
    IniLast10mColour := ReadInteger('bandlast','Last10mColour',1);

    IniLast6mFreq   := ReadInteger('bandlast','Last6mFreq',50150000);
    IniLast6mMode   := ReadInteger('bandlast','Last6mMode',1);
    IniLast6mFilter := ReadInteger('bandlast','Last6mFilter',0);
    IniLast6mIP3    := ReadInteger('bandlast','Last6mIP3',0);
    IniLast6mColour := ReadInteger('bandlast','Last6mColour',1);


    IniSSB160mFreq   := ReadInteger('bandssb','SSB160mFreq',1949000);
    IniSSB160mMode   := ReadInteger('bandssb','SSB160mMode',0);
    IniSSB160mFilter := ReadInteger('bandssb','SSB160mFilter',0);
    IniSSB160mIP3    := ReadInteger('bandssb','SSB160mIP3',1);
    IniSSB160mColour := ReadInteger('bandssb','SSB160mColour',1);

    IniSSB80mFreq   := ReadInteger('bandssb','SSB80mFreq',3727000);
    IniSSB80mMode   := ReadInteger('bandssb','SSB80mMode',0);
    IniSSB80mFilter := ReadInteger('bandssb','SSB80mFilter',0);
    IniSSB80mIP3    := ReadInteger('bandssb','SSB80mIP3',1);
    IniSSB80mColour := ReadInteger('bandssb','SSB80mColour',1);

    IniSSB40mFreq   := ReadInteger('bandssb','SSB40mFreq',7155000);
    IniSSB40mMode   := ReadInteger('bandssb','SSB40mMode',0);
    IniSSB40mFilter := ReadInteger('bandssb','SSB40mFilter',0);
    IniSSB40mIP3    := ReadInteger('bandssb','SSB40mIP3',1);
    IniSSB40mColour := ReadInteger('bandssb','SSB40mColour',1);

    IniSSB30mFreq   := ReadInteger('bandssb','SSB30mFreq',10100000);
    IniSSB30mMode   := ReadInteger('bandssb','SSB30mMode',2);
    IniSSB30mFilter := ReadInteger('bandssb','SSB30mFilter',0);
    IniSSB30mIP3    := ReadInteger('bandssb','SSB30mIP3',1);
    IniSSB30mColour := ReadInteger('bandssb','SSB30mColour',1);

    IniSSB20mFreq   := ReadInteger('bandssb','SSB20mFreq',14276000);
    IniSSB20mMode   := ReadInteger('bandssb','SSB20mMode',1);
    IniSSB20mFilter := ReadInteger('bandssb','SSB20mFilter',0);
    IniSSB20mIP3    := ReadInteger('bandssb','SSB20mIP3',0);
    IniSSB20mColour := ReadInteger('bandssb','SSB20mColour',1);

    IniSSB17mFreq   := ReadInteger('bandssb','SSB17mFreq',18110000);
    IniSSB17mMode   := ReadInteger('bandssb','SSB17mMode',1);
    IniSSB17mFilter := ReadInteger('bandssb','SSB17mFilter',0);
    IniSSB17mIP3    := ReadInteger('bandssb','SSB17mIP3',0);
    IniSSB17mColour := ReadInteger('bandssb','SSB17mColour',1);

    IniSSB15mFreq   := ReadInteger('bandssb','SSB15mFreq',21295000);
    IniSSB15mMode   := ReadInteger('bandssb','SSB15mMode',1);
    IniSSB15mFilter := ReadInteger('bandssb','SSB15mFilter',0);
    IniSSB15mIP3    := ReadInteger('bandssb','SSB15mIP3',0);
    IniSSB15mColour := ReadInteger('bandssb','SSB15mColour',1);

    IniSSB12mFreq   := ReadInteger('bandssb','SSB12mFreq',24930000);
    IniSSB12mMode   := ReadInteger('bandssb','SSB12mMode',2);
    IniSSB12mFilter := ReadInteger('bandssb','SSB12mFilter',0);
    IniSSB12mIP3    := ReadInteger('bandssb','SSB12mIP3',0);
    IniSSB12mColour := ReadInteger('bandssb','SSB12mColour',1);

    IniSSB10mFreq   := ReadInteger('bandssb','SSB10mFreq',28495000);
    IniSSB10mMode   := ReadInteger('bandssb','SSB10mMode',1);
    IniSSB10mFilter := ReadInteger('bandssb','SSB10mFilter',0);
    IniSSB10mIP3    := ReadInteger('bandssb','SSB10mIP3',0);
    IniSSB10mColour := ReadInteger('bandssb','SSB10mColour',1);

    IniSSB6mFreq   := ReadInteger('bandssb','SSB6mFreq',50150000);
    IniSSB6mMode   := ReadInteger('bandssb','SSB6mMode',1);
    IniSSB6mFilter := ReadInteger('bandssb','SSB6mFilter',0);
    IniSSB6mIP3    := ReadInteger('bandssb','SSB6mIP3',0);
    IniSSB6mColour := ReadInteger('bandssb','SSB6mColour',1);


    IniCW160mFreq   := ReadInteger('bandcw','CW160mFreq',1820000);
    IniCW160mMode   := ReadInteger('bandcw','CW160mMode',2);
    IniCW160mFilter := ReadInteger('bandcw','CW160mFilter',0);
    IniCW160mIP3    := ReadInteger('bandcw','CW160mIP3',1);
    IniCW160mColour := ReadInteger('bandcw','CW160mColour',1);

    IniCW80mFreq   := ReadInteger('bandcw','CW80mFreq',3520000);
    IniCW80mMode   := ReadInteger('bandcw','CW80mMode',2);
    IniCW80mFilter := ReadInteger('bandcw','CW80mFilter',0);
    IniCW80mIP3    := ReadInteger('bandcw','CW80mIP3',1);
    IniCW80mColour := ReadInteger('bandcw','CW80mColour',1);

    IniCW40mFreq   := ReadInteger('bandcw','CW40mFreq',7020000);
    IniCW40mMode   := ReadInteger('bandcw','CW40mMode',2);
    IniCW40mFilter := ReadInteger('bandcw','CW40mFilter',0);
    IniCW40mIP3    := ReadInteger('bandcw','CW40mIP3',1);
    IniCW40mColour := ReadInteger('bandcw','CW40mColour',1);

    IniCW30mFreq   := ReadInteger('bandcw','CW30mFreq',10100000);
    IniCW30mMode   := ReadInteger('bandcw','CW30mMode',2);
    IniCW30mFilter := ReadInteger('bandcw','CW30mFilter',0);
    IniCW30mIP3    := ReadInteger('bandcw','CW30mIP3',1);
    IniCW30mColour := ReadInteger('bandcw','CW30mColour',1);

    IniCW20mFreq   := ReadInteger('bandcw','CW20mFreq',14020000);
    IniCW20mMode   := ReadInteger('bandcw','CW20mMode',2);
    IniCW20mFilter := ReadInteger('bandcw','CW20mFilter',0);
    IniCW20mIP3    := ReadInteger('bandcw','CW20mIP3',0);
    IniCW20mColour := ReadInteger('bandcw','CW20mColour',1);

    IniCW17mFreq   := ReadInteger('bandcw','CW17mFreq',18070000);
    IniCW17mMode   := ReadInteger('bandcw','CW17mMode',2);
    IniCW17mFilter := ReadInteger('bandcw','CW17mFilter',0);
    IniCW17mIP3    := ReadInteger('bandcw','CW17mIP3',0);
    IniCW17mColour := ReadInteger('bandcw','CW17mColour',1);

    IniCW15mFreq   := ReadInteger('bandcw','CW15mFreq',21020000);
    IniCW15mMode   := ReadInteger('bandcw','CW15mMode',2);
    IniCW15mFilter := ReadInteger('bandcw','CW15mFilter',0);
    IniCW15mIP3    := ReadInteger('bandcw','CW15mIP3',0);
    IniCW15mColour := ReadInteger('bandcw','CW15mColour',1);

    IniCW12mFreq   := ReadInteger('bandcw','CW12mFreq',24920000);
    IniCW12mMode   := ReadInteger('bandcw','CW12mMode',2);
    IniCW12mFilter := ReadInteger('bandcw','CW12mFilter',0);
    IniCW12mIP3    := ReadInteger('bandcw','CW12mIP3',0);
    IniCW12mColour := ReadInteger('bandcw','CW12mColour',1);

    IniCW10mFreq   := ReadInteger('bandcw','CW10mFreq',28020000);
    IniCW10mMode   := ReadInteger('bandcw','CW10mMode',2);
    IniCW10mFilter := ReadInteger('bandcw','CW10mFilter',0);
    IniCW10mIP3    := ReadInteger('bandcw','CW10mIP3',0);
    IniCW10mColour := ReadInteger('bandcw','CW10mColour',1);

    IniCW6mFreq   := ReadInteger('bandcw','CW6mFreq',50090000);
    IniCW6mMode   := ReadInteger('bandcw','CW6mMode',2);
    IniCW6mFilter := ReadInteger('bandcw','CW6mFilter',0);
    IniCW6mIP3    := ReadInteger('bandcw','CW6mIP3',0);
    IniCW6mColour := ReadInteger('bandcw','CW6mColour',1);


    IniMem6761Freq   := ReadInteger('mem67','Mem6761Freq',5000000);
    IniMem6761Mode   := ReadInteger('mem67','Mem6761Mode',1);
    IniMem6761Filter := ReadInteger('mem67','Mem6761Filter',0);
    IniMem6761IP3    := ReadInteger('mem67','Mem6761IP3',1);
    IniMem6761Colour := ReadInteger('mem67','Mem6761Colour',1);

    IniMem6762Freq   := ReadInteger('mem67','Mem6762Freq',9996000);
    IniMem6762Mode   := ReadInteger('mem67','Mem6762Mode',1);
    IniMem6762Filter := ReadInteger('mem67','Mem6762Filter',0);
    IniMem6762IP3    := ReadInteger('mem67','Mem6762IP3',1);
    IniMem6762Colour := ReadInteger('mem67','Mem6762Colour',1);

    IniMem6763Freq   := ReadInteger('mem67','Mem6763Freq',10000000);
    IniMem6763Mode   := ReadInteger('mem67','Mem6763Mode',1);
    IniMem6763Filter := ReadInteger('mem67','Mem6763Filter',0);
    IniMem6763IP3    := ReadInteger('mem67','Mem6763IP3',1);
    IniMem6763Colour := ReadInteger('mem67','Mem6763Colour',1);

    IniMem6764Freq   := ReadInteger('mem67','Mem6764Freq',14996000);
    IniMem6764Mode   := ReadInteger('mem67','Mem6764Mode',1);
    IniMem6764Filter := ReadInteger('mem67','Mem6764Filter',0);
    IniMem6764IP3    := ReadInteger('mem67','Mem6764IP3',0);
    IniMem6764Colour := ReadInteger('mem67','Mem6764Colour',1);

    IniMem6765Freq   := ReadInteger('mem67','Mem6765Freq',15000000);
    IniMem6765Mode   := ReadInteger('mem67','Mem6765Mode',1);
    IniMem6765Filter := ReadInteger('mem67','Mem6765Filter',0);
    IniMem6765IP3    := ReadInteger('mem67','Mem6765IP3',0);
    IniMem6765Colour := ReadInteger('mem67','Mem6765Colour',1);

    IniMem6766Freq   := ReadInteger('mem67','Mem6766Freq',20000000);
    IniMem6766Mode   := ReadInteger('mem67','Mem6766Mode',1);
    IniMem6766Filter := ReadInteger('mem67','Mem6766Filter',0);
    IniMem6766IP3    := ReadInteger('mem67','Mem6766IP3',0);
    IniMem6766Colour := ReadInteger('mem67','Mem6766Colour',1);


    IniMem6861Freq   := ReadInteger('mem68','Mem6861Freq',1836000);
    IniMem6861Mode   := ReadInteger('mem68','Mem6861Mode',2);
    IniMem6861Filter := ReadInteger('mem68','Mem6861Filter',0);
    IniMem6861IP3    := ReadInteger('mem68','Mem6861IP3',0);
    IniMem6861Colour := ReadInteger('mem68','Mem6861Colour',1);

    IniMem6862Freq   := ReadInteger('mem68','Mem6862Freq',3560000);
    IniMem6862Mode   := ReadInteger('mem68','Mem6862Mode',2);
    IniMem6862Filter := ReadInteger('mem68','Mem6862Filter',0);
    IniMem6862IP3    := ReadInteger('mem68','Mem6862IP3',0);
    IniMem6862Colour := ReadInteger('mem68','Mem6862Colour',1);

    IniMem6863Freq   := ReadInteger('mem68','Mem6863Freq',7030000);
    IniMem6863Mode   := ReadInteger('mem68','Mem6863Mode',2);
    IniMem6863Filter := ReadInteger('mem68','Mem6863Filter',0);
    IniMem6863IP3    := ReadInteger('mem68','Mem6863IP3',0);
    IniMem6863Colour := ReadInteger('mem68','Mem6863Colour',1);

    IniMem6864Freq   := ReadInteger('mem68','Mem6864Freq',10116000);
    IniMem6864Mode   := ReadInteger('mem68','Mem6864Mode',2);
    IniMem6864Filter := ReadInteger('mem68','Mem6864Filter',0);
    IniMem6864IP3    := ReadInteger('mem68','Mem6864IP3',0);
    IniMem6864Colour := ReadInteger('mem68','Mem6864Colour',1);

    IniMem6865Freq   := ReadInteger('mem68','Mem6865Freq',14060000);
    IniMem6865Mode   := ReadInteger('mem68','Mem6865Mode',2);
    IniMem6865Filter := ReadInteger('mem68','Mem6865Filter',0);
    IniMem6865IP3    := ReadInteger('mem68','Mem6865IP3',1);
    IniMem6865Colour := ReadInteger('mem68','Mem6865Colour',1);

    IniMem6866Freq   := ReadInteger('mem68','Mem6866Freq',18096000);
    IniMem6866Mode   := ReadInteger('mem68','Mem6866Mode',2);
    IniMem6866Filter := ReadInteger('mem68','Mem6866Filter',0);
    IniMem6866IP3    := ReadInteger('mem68','Mem6866IP3',1);
    IniMem6866Colour := ReadInteger('mem68','Mem6866Colour',1);


    IniMem6961Freq   := ReadInteger('mem69','Mem6961Freq',3215000);
    IniMem6961Mode   := ReadInteger('mem69','Mem6961Mode',1);
    IniMem6961Filter := ReadInteger('mem69','Mem6961Filter',0);
    IniMem6961IP3    := ReadInteger('mem69','Mem6961IP3',0);
    IniMem6961Colour := ReadInteger('mem69','Mem6961Colour',1);

    IniMem6962Freq   := ReadInteger('mem69','Mem6962Freq',4319000);
    IniMem6962Mode   := ReadInteger('mem69','Mem6962Mode',1);
    IniMem6962Filter := ReadInteger('mem69','Mem6962Filter',0);
    IniMem6962IP3    := ReadInteger('mem69','Mem6962IP3',0);
    IniMem6962Colour := ReadInteger('mem69','Mem6962Colour',1);

    IniMem6963Freq   := ReadInteger('mem69','Mem6963Freq',5070000);
    IniMem6963Mode   := ReadInteger('mem69','Mem6963Mode',1);
    IniMem6963Filter := ReadInteger('mem69','Mem6963Filter',0);
    IniMem6963IP3    := ReadInteger('mem69','Mem6963IP3',0);
    IniMem6963Colour := ReadInteger('mem69','Mem6963Colour',1);

    IniMem6964Freq   := ReadInteger('mem69','Mem6964Freq',6150000);
    IniMem6964Mode   := ReadInteger('mem69','Mem6964Mode',1);
    IniMem6964Filter := ReadInteger('mem69','Mem6964Filter',0);
    IniMem6964IP3    := ReadInteger('mem69','Mem6964IP3',0);
    IniMem6964Colour := ReadInteger('mem69','Mem6964Colour',1);

    IniMem6965Freq   := ReadInteger('mem69','Mem6965Freq',6195000);
    IniMem6965Mode   := ReadInteger('mem69','Mem6965Mode',1);
    IniMem6965Filter := ReadInteger('mem69','Mem6965Filter',0);
    IniMem6965IP3    := ReadInteger('mem69','Mem6965IP3',0);
    IniMem6965Colour := ReadInteger('mem69','Mem6965Colour',1);

    IniMem6966Freq   := ReadInteger('mem69','Mem6966Freq',17550000);
    IniMem6966Mode   := ReadInteger('mem69','Mem6966Mode',1);
    IniMem6966Filter := ReadInteger('mem69','Mem6966Filter',0);
    IniMem6966IP3    := ReadInteger('mem69','Mem6966IP3',1);
    IniMem6966Colour := ReadInteger('mem69','Mem6966Colour',1);


    IniMem6061Freq   := ReadInteger('mem60','Mem6061Freq',5258500);
    IniMem6061Mode   := ReadInteger('mem60','Mem6061Mode',2);
    IniMem6061Filter := ReadInteger('mem60','Mem6061Filter',0);
    IniMem6061IP3    := ReadInteger('mem60','Mem6061IP3',1);
    IniMem6061Colour := ReadInteger('mem60','Mem6061Colour',1);

    IniMem6062Freq   := ReadInteger('mem60','Mem6062Freq',5278500);
    IniMem6062Mode   := ReadInteger('mem60','Mem6062Mode',2);
    IniMem6062Filter := ReadInteger('mem60','Mem6062Filter',0);
    IniMem6062IP3    := ReadInteger('mem60','Mem6062IP3',1);
    IniMem6062Colour := ReadInteger('mem60','Mem6062Colour',1);

    IniMem6063Freq   := ReadInteger('mem60','Mem6063Freq',5288500);
    IniMem6063Mode   := ReadInteger('mem60','Mem6063Mode',2);
    IniMem6063Filter := ReadInteger('mem60','Mem6063Filter',0);
    IniMem6063IP3    := ReadInteger('mem60','Mem6063IP3',1);
    IniMem6063Colour := ReadInteger('mem60','Mem6063Colour',1);

    IniMem6064Freq   := ReadInteger('mem60','Mem6064Freq',5298500);
    IniMem6064Mode   := ReadInteger('mem60','Mem6064Mode',2);
    IniMem6064Filter := ReadInteger('mem60','Mem6064Filter',0);
    IniMem6064IP3    := ReadInteger('mem60','Mem6064IP3',1);
    IniMem6064Colour := ReadInteger('mem60','Mem6064Colour',1);

    IniMem6065Freq   := ReadInteger('mem60','Mem6065Freq',5403500);
    IniMem6065Mode   := ReadInteger('mem60','Mem6065Mode',2);
    IniMem6065Filter := ReadInteger('mem60','Mem6065Filter',0);
    IniMem6065IP3    := ReadInteger('mem60','Mem6065IP3',1);
    IniMem6065Colour := ReadInteger('mem60','Mem6065Colour',1);

    IniMem6066Freq   := ReadInteger('mem60','Mem6066Freq',5288500);
    IniMem6066Mode   := ReadInteger('mem60','Mem6066Mode',2);
    IniMem6066Filter := ReadInteger('mem60','Mem6066Filter',0);
    IniMem6066IP3    := ReadInteger('mem60','Mem6066IP3',1);
    IniMem6066Colour := ReadInteger('mem60','Mem6066Colour',1);


    IniPowerOnFreq   := ReadInteger('poweron','PowerOnFreq',3272700);
    IniPowerOnMode   := ReadInteger('poweron','PowerOnMode',0);
    IniPowerOnFilter := ReadInteger('poweron','PowerOnFilter',0);
    IniPowerOnIP3    := ReadInteger('poweron','PowerOnIP3',1);
    IniPowerOnColour := ReadInteger('poweron','PowerOnColour',1);

    IniVFO1Freq   := ReadInteger('vfo','VFO1Freq',3272000);
    IniVFO1Mode   := ReadInteger('vfo','VFO1Mode',0);
    IniVFO1Filter := ReadInteger('vfo','VFO1Filter',0);
    IniVFO1IP3    := ReadInteger('vfo','VFO1IP3',1);
    IniVFO1Colour := ReadInteger('vfo','VFO1Colour',1);

    IniVFO2Freq   := ReadInteger('vfo','VFO2Freq',3272000);
    IniVFO2Mode   := ReadInteger('vfo','VFO2Mode',0);
    IniVFO2Filter := ReadInteger('vfo','VFO2Filter',0);
    IniVFO2IP3    := ReadInteger('vfo','VFO2IP3',1);
    IniVFO2Colour := ReadInteger('vfo','VFO2Colour',1);

    IniVFO3Freq   := ReadInteger('vfo','VFO3Freq',3272000);
    IniVFO3Mode   := ReadInteger('vfo','VFO3Mode',0);
    IniVFO3Filter := ReadInteger('vfo','VFO3Filter',0);
    IniVFO3IP3    := ReadInteger('vfo','VFO3IP3',1);
    IniVFO3Colour := ReadInteger('vfo','VFO3Colour',1);

    IniVFO4Freq   := ReadInteger('vfo','VFO4Freq',3272000);
    IniVFO4Mode   := ReadInteger('vfo','VFO4Mode',0);
    IniVFO4Filter := ReadInteger('vfo','VFO4Filter',0);
    IniVFO4IP3    := ReadInteger('vfo','VFO4IP3',1);
    IniVFO4Colour := ReadInteger('vfo','VFO4Colour',1);

    IniVFO5Freq   := ReadInteger('vfo','VFO5Freq',3272000);
    IniVFO5Mode   := ReadInteger('vfo','VFO5Mode',0);
    IniVFO5Filter := ReadInteger('vfo','VFO5Filter',0);
    IniVFO5IP3    := ReadInteger('vfo','VFO5IP3',1);
    IniVFO5Colour := ReadInteger('vfo','VFO5Colour',1);

    IniVFO6Freq   := ReadInteger('vfo','VFO6Freq',3272000);
    IniVFO6Mode   := ReadInteger('vfo','VFO6Mode',0);
    IniVFO6Filter := ReadInteger('vfo','VFO6Filter',0);
    IniVFO6IP3    := ReadInteger('vfo','VFO6IP3',1);
    IniVFO6Colour := ReadInteger('vfo','VFO6Colour',1);

    IniVFO7Freq   := ReadInteger('vfo','VFO7Freq',3272000);
    IniVFO7Mode   := ReadInteger('vfo','VFO7Mode',0);
    IniVFO7Filter := ReadInteger('vfo','VFO7Filter',0);
    IniVFO7IP3    := ReadInteger('vfo','VFO7IP3',1);
    IniVFO7Colour := ReadInteger('vfo','VFO7Colour',1);


    IniPcaTasks[1].IniPcaOpcode :=  IniLookupPcaTask(ReadString('PCA9555tasks','PCA9555_Task1_Operation','no_action'));
    IniPcaTasks[1].IniPcaAddress := ReadInteger('PCA9555tasks','PCA9555_Task1_Address',1);
    IniPcaTasks[1].IniPcaGroup := ReadInteger('PCA9555tasks','PCA9555_Task1_Group',0);
    IniPcaTasks[1].IniPcaDataword := ReadInteger('PCA9555tasks','PCA9555_Task1_Dataword',0);
    IniPcaTasks[1].IniPcaLabel := ReadString('PCA9555tasks','PCA9555_Task1_Label','PCA-9555' );

    IniPcaTasks[2].IniPcaOpcode := IniLookupPcaTask(ReadString('PCA9555tasks','PCA9555_Task2_Operation','no_action'));
    IniPcaTasks[2].IniPcaAddress := ReadInteger('PCA9555tasks','PCA9555_Task2_Address',1);
    IniPcaTasks[2].IniPcaGroup := ReadInteger('PCA9555tasks','PCA9555_Task2_Group',0);
    IniPcaTasks[2].IniPcaDataword := ReadInteger('PCA9555tasks','PCA9555_Task2_Dataword',0);
    IniPcaTasks[2].IniPcaLabel := ReadString('PCA9555tasks','PCA9555_Task2_Label','PCA-9555' );

    IniPcaTasks[3].IniPcaOpcode := IniLookupPcaTask(ReadString('PCA9555tasks','PCA9555_Task3_Operation','no_action'));
    IniPcaTasks[3].IniPcaAddress := ReadInteger('PCA9555tasks','PCA9555_Task3_Address',1);
    IniPcaTasks[3].IniPcaGroup := ReadInteger('PCA9555tasks','PCA9555_Task3_Group',0);
    IniPcaTasks[3].IniPcaDataword := ReadInteger('PCA9555tasks','PCA9555_Task3_Dataword',0);
    IniPcaTasks[3].IniPcaLabel := ReadString('PCA9555tasks','PCA9555_Task3_Label','PCA-9555' );

    IniPcaTasks[4].IniPcaOpcode := IniLookupPcaTask(ReadString('PCA9555tasks','PCA9555_Task4_Operation','no_action'));
    IniPcaTasks[4].IniPcaAddress := ReadInteger('PCA9555tasks','PCA9555_Task4_Address',1);
    IniPcaTasks[4].IniPcaGroup := ReadInteger('PCA9555tasks','PCA9555_Task4_Group',0);
    IniPcaTasks[4].IniPcaDataword := ReadInteger('PCA9555tasks','PCA9555_Task4_Dataword',0);
    IniPcaTasks[4].IniPcaLabel := ReadString('PCA9555tasks','PCA9555_Task4_Label','PCA-9555' );

    IniPcaTasks[5].IniPcaOpcode := IniLookupPcaTask(ReadString('PCA9555tasks','PCA9555_Task5_Operation','no_action'));
    IniPcaTasks[5].IniPcaAddress := ReadInteger('PCA9555tasks','PCA9555_Task5_Address',1);
    IniPcaTasks[5].IniPcaGroup := ReadInteger('PCA9555tasks','PCA9555_Task5_Group',0);
    IniPcaTasks[5].IniPcaDataword := ReadInteger('PCA9555tasks','PCA9555_Task5_Dataword',0);
    IniPcaTasks[5].IniPcaLabel := ReadString('PCA9555tasks','PCA9555_Task5_Label','PCA-9555' );

    IniPcaTasks[6].IniPcaOpcode := IniLookupPcaTask(ReadString('PCA9555tasks','PCA9555_Task6_Operation','no_action'));
    IniPcaTasks[6].IniPcaAddress := ReadInteger('PCA9555tasks','PCA9555_Task6_Address',1);
    IniPcaTasks[6].IniPcaGroup := ReadInteger('PCA9555tasks','PCA9555_Task6_Group',0);
    IniPcaTasks[6].IniPcaDataword := ReadInteger('PCA9555tasks','PCA9555_Task6_Dataword',0);
    IniPcaTasks[6].IniPcaLabel := ReadString('PCA9555tasks','PCA9555_Task6_Label','PCA-9555' );

    IniPcaTasks[7].IniPcaOpcode := IniLookupPcaTask(ReadString('PCA9555tasks','PCA9555_Task7_Operation','no_action'));
    IniPcaTasks[7].IniPcaAddress := ReadInteger('PCA9555tasks','PCA9555_Task7_Address',1);
    IniPcaTasks[7].IniPcaGroup := ReadInteger('PCA9555tasks','PCA9555_Task7_Group',0);
    IniPcaTasks[7].IniPcaDataword := ReadInteger('PCA9555tasks','PCA9555_Task7_Dataword',0);
    IniPcaTasks[7].IniPcaLabel := ReadString('PCA9555tasks','PCA9555_Task7_Label','PCA-9555' );

    IniPcaTasks[8].IniPcaOpcode := IniLookupPcaTask(ReadString('PCA9555tasks','PCA9555_Task8_Operation','no_action'));
    IniPcaTasks[8].IniPcaAddress := ReadInteger('PCA9555tasks','PCA9555_Task8_Address',1);
    IniPcaTasks[8].IniPcaGroup := ReadInteger('PCA9555tasks','PCA9555_Task8_Group',0);
    IniPcaTasks[8].IniPcaDataword := ReadInteger('PCA9555tasks','PCA9555_Task8_Dataword',0);
    IniPcaTasks[8].IniPcaLabel := ReadString('PCA9555tasks','PCA9555_Task8_Label','PCA-9555' );

    IniPCA9555BpfType := ReadInteger('I2CBPF','PCA9555BpfType',0);
    IniPCA9555BpfAddress := ReadInteger('I2CBPF','PCA9555BpfAddress',1);
    IniEnablePCA9555 := ReadInteger('I2CBPF','EnablePCA9555',1);
    IniPA3AKE_RooferAddress := ReadInteger('PA3AKE','IniPA3AKE_RooferAddress',1);
    IniPA3AKE_SquarerAddress := ReadInteger('PA3AKE','IniPA3AKE_SquarerAddress',1);
    IniPA3AKE_MixerAddress := ReadInteger('PA3AKE','IniPA3AKE_MixerAddress',1);
    IniPA3AKE_MixerEnable := ReadInteger('PA3AKE','IniPA3AKE_MixerEnable',0);
    IniPA3AKE_RooferSwitchEnable := ReadInteger('PA3AKE','IniPA3AKE_RooferSwitchEnable',0);
    IniPA3AKE_SquarerDAC := ReadInteger('PA3AKE','IniPA3AKE_SquarerDAC',0);
    IniPA3AKE_MixerDAC := ReadInteger('PA3AKE','IniPA3AKE_MixerDAC',0);

    IniLocalTimeOffset := ReadString('RTC','LocalTimeOffset','0');
    Free;
  end;
end;



procedure ReadXjpIniData;
var
  path: string;
  nc: byte;
begin
  path := g_RegIniData.IniStarFolder;
  nc := Length(path);
  if path[nc] <> '\' then path := Path + '\';
  XjpIniFile := TIniFile.Create(path + 'xjp.ini');
  with XjpIniFile, g_XjpIniData do
  begin
    IniDSPfile := ReadString('DSP file','file','STAR2b1x.xjp');
    IniParams := ReadString('Params','file','User2B2.XJP');
    Free;
  end;
end;



procedure WriteXjpIniData;
begin
  XjpIniFile := TIniFile.Create(g_RegIniData.IniStarFolder + '/xjp.ini');
  with XjpIniFile, g_XjpIniData do
  begin
    WriteString('Directory','path',g_RegIniData.IniStarFolder);
    WriteString('DSP file','file',IniDSPfile);
    WriteString('Params','file',IniParams);
    Free;
  end;
end;



procedure EnsureIniFileIsRegistry;
begin
  try
    RegIniFile := TRegIniFile.Create;
    RegIniFile.RootKey := HKEY_CURRENT_USER; // Section to look for within the registry
    if not RegIniFile.OpenKey(KeyName,False) then
    begin
      RegIniFile.CreateKey(KeyName);
      RegIniFile.Free;
      Exit;
    end;
  except
    MessageDlg('Failed to create HKEY_CURRENT_USER Registry Key. INI settings will not be saved.',mtWarning,[mbOk],0);
  end;
  RegIniFile.Free;
end;


function RegIniOpen: boolean;
begin
  result := true;
  try
    RegIniFile := TRegIniFile.Create;
    RegIniFile.RootKey := HKEY_CURRENT_USER; // Section to look for within the registry
    RegIniFile.OpenKey(KeyName,true);
  except
    result := false;
    RegIniFile.Free;
  end;
end;




function BoolToInt(b: boolean): integer;
begin
  if b then result := 1 else result := 0;
end;


function IntToBool(i: integer): boolean;
begin
  if i=0 then result := FALSE else result := TRUE;
end;




procedure LoadDebugCoordinates;
var
  s: string;
  a: integer;
begin
  s := ExtractFilePath(Application.ExeName);
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    IniDebugIdColWidthA := ReadInteger('DebugForm','DebugIdColWidthA',25);
    IniDebugVarNameColWidthA := ReadInteger('DebugForm','DebugVarNameColWidthA',95);
    IniDebugVarNameColWidthB := ReadInteger('DebugForm','DebugVarNameColWidthB',56);
    IniDebugSplitterPosition := ReadInteger('DebugForm','DebugSplitterPosition',360);
//    IniDebugFormWidth := ReadInteger('DebugForm','DebugFormWidth',627);
//    IniDebugFormHeight := ReadInteger('DebugForm','DebugFormHeight',400);
//    IniDebugFormTop := ReadInteger('DebugForm','DebugFormTop',20);
//    IniDebugFormLeft := ReadInteger('DebugForm','DebugFormLeft',20);
//    IniDebugFormMaximized := ReadInteger('DebugForm','DebugFormMaximized',0);
  end;
  RegIniFile.Free;
  a := frmMain.Top + frmMain.RzToolbar1.top + frmMain.RzToolbar1.height;
//  with g_RegIniData do
//  begin
//    if IniDebugFormLeft < frmMain.Left
//    then begin
//      IniDebugFormLeft := frmMain.left + 8;
//      SaveDebugCoordinates;
//    end;
//    if IniDebugFormTop < a
//    then begin
//      IniDebugFormTop := a + 6;
//      SaveDebugCoordinates;
//    end;
//    if IniDebugFormWidth > frmMain.width
//    then begin
//      IniDebugFormWidth := frmMain.width - 10;
//      SaveDebugCoordinates;
//    end;
//    if IniDebugFormHeight < a
//    then begin
//      IniDebugFormTop := a + 6;
//      SaveDebugCoordinates;
//    end;
//  end;
end;

procedure SaveDebugCoordinates;
begin
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    WriteInteger('DebugForm','DebugIdColWidthA',IniDebugIdColWidthA);
    WriteInteger('DebugForm','DebugVarNameColWidthA',IniDebugVarNameColWidthA);
    WriteInteger('DebugForm','DebugVarNameColWidthB',IniDebugVarNameColWidthB);
    WriteInteger('DebugForm','DebugSplitterPosition',IniDebugSplitterPosition);
//    WriteInteger('DebugForm','DebugFormWidth',IniDebugFormWidth);
//    WriteInteger('DebugForm','DebugFormHeight',IniDebugFormHeight);
//    WriteInteger('DebugForm','DebugFormTop',IniDebugFormTop);
//    WriteInteger('DebugForm','DebugFormLeft',IniDebugFormLeft);
//    WriteInteger('DebugForm','DebugFormMaximized',IniDebugFormMaximized);
  end;
  RegIniFile.Free;
end;


procedure SaveRegIniFile;
begin
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    WriteInteger('DSP','dsptelemetry',IniDspTelemetry);
    WriteString('Star','StarFolder',IniStarFolder);
    WriteString('Files','TFTFlashFile',IniTFTflashFile);
    WriteString('RS232','comport',IniComPort);
    WriteString('Files','fwdcalfile',IniFwdCalFile);
    WriteString('Files','refcalfile',IniRefCalFile);
//    WriteInteger('Display','PrintInColor',BoolToInt(IniPrintInColor));

    WriteString('Summaries','SummaryExportFolder',IniSummaryExportFolder);
    WriteString('Summaries','SummaryExportFile',IniSummaryExportFile);
    WriteString('Summaries','SummaryExportBefore',IniSummaryExportBefore);
    WriteString('Summaries','SummaryExportAfter',IniSummaryExportAfter);
  end;
  RegIniFile.Free;
end;


procedure LoadDebugIniData;
var
  s: string;
begin
  s := ExtractFilePath(Application.ExeName);
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    IniDebugAutoPorts := IntToBool(ReadInteger('DebugForm','DebugAutoPorts',0));
    IniDebugAutoVars := IntToBool(ReadInteger('DebugForm','DebugAutoVars',0));
    IniDebugRefresh := ReadInteger('DebugForm','DebugRefresh',20);
    IniDebugViewVars := IntToBool(ReadInteger('DebugForm','DebugViewVars',1));
    IniDebugViewPorts := IntToBool(ReadInteger('DebugForm','DebugViewPorts',1));
  end;
  RegIniFile.Free;
end;


procedure SaveDebugIniData;
begin
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    WriteInteger('DebugForm','DebugAutoPorts',BoolToInt(IniDebugAutoPorts));
    WriteInteger('DebugForm','DebugAutoVars',BoolToInt(IniDebugAutoVars));
    WriteInteger('DebugForm','DebugRefresh',IniDebugRefresh);
    WriteInteger('DebugForm','DebugViewPorts',BoolToInt(IniDebugViewPorts));
    WriteInteger('DebugForm','DebugViewVars',BoolToInt(IniDebugViewVars));
  end;
  RegIniFile.Free;
end;


procedure LoadRegIniFile;
var
  s: string;
begin
  s := ExtractFilePath(Application.ExeName);
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    IniDspTelemetry := ReadInteger('DSP','dsptelemetry',0);
    IniStarFolder := ReadString('Star','StarFolder','C:\TrxAVR');
    IniTFTflashFile := ReadString('Files','TFTflashFile','');
    IniComport := ReadString('RS232','Comport','COM1');
    IniFwdCalFile := ReadString('Files','fwdcalfile',s + 'Caldata\G3VPX_default.fwd');
    IniRefCalFile := ReadString('Files','refcalfile',s + 'Caldata\G3VPX_default.ref');
    IniPrintInColor := IntToBool(ReadInteger('Display','PrintInColor',1));

    IniSummaryExportFolder := ReadString('Summaries','SummaryExportFolder','C:\');
    IniSummaryExportFile   := ReadString('Summaries','SummaryExportFile','TempSummary.rtf');
    IniSummaryExportBefore := ReadString('Summaries','SummaryExportBefore','');
    IniSummaryExportAfter  := ReadString('Summaries','SummaryExportAfter','');
  end;
  RegIniFile.Free;
end;


procedure LoadMainCoordinates;
begin
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    IniMainFormTop := ReadInteger('coordinates','mainformtop',30);
    IniMainFormLeft := ReadInteger('coordinates','mainformleft',30);
    IniMainFormWidth := ReadInteger('coordinates','mainformwidth',400);
    IniMainFormHeight := ReadInteger('coordinates','mainformheight',300);
  end;
  RegIniFile.Free;

  with g_RegIniData do begin
    if IniMainFormLeft > Screen.Width-100
    then begin
      IniMainFormLeft := Screen.Width - 100;
      SaveMainCoordinates;
    end;
    if IniMainFormTop > Screen.Height-100
    then begin
      IniMainFormTop := Screen.Height - 100;
      SaveMainCoordinates;
    end;
    if IniMainFormHeight > Screen.Height
    then begin
      IniMainFormLeft := Screen.Height - 60;
      SaveMainCoordinates;
    end;
    if IniMainFormTop > Screen.Width
    then begin
      IniMainFormLeft := Screen.Width - 60;
      SaveMainCoordinates;
    end;
  end;
end;


procedure SaveMainCoordinates;
begin
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    WriteInteger('coordinates','mainformtop',IniMainFormTop);
    WriteInteger('coordinates','mainformleft',IniMainFormLeft);
    WriteInteger('coordinates','mainformheight',IniMainFormHeight);
    WriteInteger('coordinates','mainformwidth',IniMainFormWidth);
  end;
  RegIniFile.Free;
end;

procedure LoadWebBrowserCoordinates;
begin
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    IniWebFormTop := ReadInteger('coordinates','webformtop',40);
    IniWebFormLeft := ReadInteger('coordinates','webformleft',60);
    IniWebFormWidth := ReadInteger('coordinates','webformwidth',795);
    IniWebFormHeight := ReadInteger('coordinates','webformheight',550);
  end;
  RegIniFile.Free;

  with g_RegIniData do begin
    if IniWebFormLeft > Screen.Width-100
    then begin
      IniWebFormLeft := Screen.Width - 100;
      SaveWebBrowserCoordinates;
    end;
    if IniWebFormTop > Screen.Height-100
    then begin
      IniWebFormTop := Screen.Height - 100;
      SaveWebBrowserCoordinates;
    end;
    if IniWebFormHeight > Screen.Height
    then begin
      IniWebFormHeight := Screen.Height - 60;
      SaveWebBrowserCoordinates;
    end;
    if IniWebFormWidth > Screen.Width
    then begin
      IniWebFormWidth := Screen.Width - 60;
      SaveWebBrowserCoordinates;
    end;
  end;

end;


procedure SaveWebBrowserCoordinates;
begin
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    WriteInteger('coordinates','webformtop',IniWebFormTop);
    WriteInteger('coordinates','webformleft',IniWebFormLeft);
    WriteInteger('coordinates','webformheight',IniWebFormHeight);
    WriteInteger('coordinates','webformwidth',IniWebFormWidth);
  end;
  RegIniFile.Free;
end;



procedure LoadSwrCoordinates;
begin
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    IniCalFormTop := ReadInteger('coordinates','calformtop',70);
    IniCalFormLeft := ReadInteger('coordinates','calformleft',70);
    IniSummFormTop := ReadInteger('coordinates','summformtop',80);
    IniSummFormLeft := ReadInteger('coordinates','summformleft',80);
    IniSummFormWidth := ReadInteger('coordinates','summformwidth',702);
    IniSummFormHeight := ReadInteger('coordinates','summformheight',939);
  end;
  RegIniFile.Free;

  with g_RegIniData do begin
    if IniCalFormLeft > Screen.Width-100
    then begin
      IniCalFormLeft := Screen.Width - 100;
      SaveSwrCoordinates;
    end;
    if IniCalFormTop > Screen.Height-100
    then begin
      IniCalFormLeft := Screen.Height - 100;
      SaveSwrCoordinates;
    end;
    if IniSummFormLeft > Screen.Width-100
    then begin
      IniSummFormLeft := Screen.Width - 100;
      SaveSwrCoordinates;
    end;
    if IniSummFormTop > Screen.Height-100
    then begin
      IniSummFormLeft := Screen.Height - 100;
      SaveSwrCoordinates;
    end;
    if IniSummFormWidth > Screen.Width
    then begin
      IniMainFormLeft := Screen.Width;
      SaveSwrCoordinates;
    end;
    if IniSummFormHeight > Screen.Height
    then begin
      IniSummFormHeight := Screen.Height;
      SaveSwrCoordinates;
    end;
  end;
end;





procedure SaveSwrCoordinates;
begin
  if not RegIniOpen then exit;
  with g_RegIniData, RegIniFile do begin
    WriteInteger('coordinates','calformtop',IniCalFormTop);
    WriteInteger('coordinates','calformleft',IniCalFormLeft);
    WriteInteger('coordinates','summformtop',IniSummFormTop);
    WriteInteger('coordinates','summformleft',IniSummFormLeft);
    WriteInteger('coordinates','summformwidth',IniSummFormWidth);
    WriteInteger('coordinates','summformheight',IniSummFormHeight);
  end;
  RegIniFile.Free;
end;


procedure LoadDxPrinterSettings(Kind: char);
var
  s: string;
  bold, italic: boolean;
  Section: string;
begin
  if not RegIniOpen then exit;
  case Kind of
    'N': Section := 'DxNotesPrinting';
    'S': Section := 'DxSummaryPrinting';
    'R': Section := 'DxResultsPrinting';
  else exit;
  end;
  with g_RegIniData, RegIniFile do begin
    //DYJ change default temp path
    IniCenterOnPageH := IntToBool(ReadInteger(Section,'CenterOnPageH',0));
    IniCenterOnPageV := IntToBool(ReadInteger(Section,'CenterOnPageV',0));
    IniDMPaper := ReadInteger(Section,'DMPaper',9);
    IniFitToPagesByTall := ReadInteger(Section,'FitToPagesByTall',1);
    IniFitToPagesByWide := ReadInteger(Section,'FitToPagesByWide',1);
    IniFooter := ReadInteger(Section,'Footer',6350);
    IniGrayShading := IntToBool(ReadInteger(Section,'GrayShading',0));
    IniHeader := ReadInteger(Section,'Header',6100);
    IniMarginsBottom := ReadInteger(Section,'MarginsBottom',12700);
    IniMarginsLeft := ReadInteger(Section,'MarginsLeft',21400);
    IniMarginsRight := ReadInteger(Section,'MarginsRight',12700);
    IniMarginsTop := ReadInteger(Section,'MarginsTop',18300);
    IniMeasurementUnits := ReadString(Section,'MeasurementUnits','muDefault');

    IniPageFooterCenterTextAlignY := ReadString(Section,'PageFooterCenterTextAlignY','taBottom');
    IniPageFooterLeftTextAlignY := ReadString(Section,'PageFooterLeftTextAlignY','taBottom');
    IniPageFooterRightTextAlignY := ReadString(Section,'PageFooterRightTextAlignY','taBottom');
    IniPageFooterFontCharset := ReadInteger(Section,'PageFooterFontCharset',1);
    IniPageFooterFontColor := ReadInteger(Section,'PageFooterFontColor',0);
    IniPageFooterFontHeight := ReadInteger(Section,'PageFooterFontHeight',-11);
    IniPageFooterFontName := ReadString(Section,'PageFooterFontName','Times New Roman');
    IniPageFooterFontPitch := ReadString(Section,'PageFooterPitch','fpDefault');
    IniPageFooterFontSize := ReadInteger(Section,'PageFooterFontSize',8);

    IniPageHeaderCenterTextAlignY := ReadString(Section,'PageHeaderCenterTextAlignY','taTop');
    IniPageHeaderLeftTextAlignY := ReadString(Section,'PageHeaderLeftTextAlignY','taTop');
    IniPageHeaderRightTextAlignY := ReadString(Section,'PageHeaderRightTextAlignY','taTop');
    IniPageHeaderFontCharset := ReadInteger(Section,'PageHeaderFontCharset',1);
    IniPageHeaderFontColor := ReadInteger(Section,'PageHeaderFontColor',0);
    IniPageHeaderFontHeight := ReadInteger(Section,'PageHeaderFontHeight',-11);
    IniPageHeaderFontName := ReadString(Section,'PageHeaderFontName','Arial');
    IniPageHeaderFontPitch := ReadString(Section,'PageHeaderPitch','fpDefault');
    IniPageHeaderFontSize := ReadInteger(Section,'PageHeaderFontSize',8);
    IniPageHeaderFontStyle := ReadString(Section,'PageHeaderFontStyle','B');

    IniPageOrder := ReadString(Section,'PageOrder','poOverThenDown');
    IniPageSizeX := ReadInteger(Section,'PageSizeX',210000);
    IniPageSizeY := ReadInteger(Section,'PageSizeY',297000);
    IniReverseTitlesOnEvenPages := IntToBool(ReadInteger(Section,'ReverseTitlesOnEvenPages',0));
    IniReportTitleMode := ReadString(Section,'ReportTitleMode','tmOnFirstPage');
    IniScaleFactor := ReadInteger(Section,'ScaleFactor',100);
    IniScaleMode := ReadString(Section,'ScaleMode','smFit');
    IniShowPageFooter := IntToBool(ReadInteger(Section,'ShowPageFooter',1));
    IniShowPageHeader := IntToBool(ReadInteger(Section,'ShowPageHeader',0));
    IniShrinkToPageWidth := IntToBool(ReadInteger(Section,'ShrinkToPageWidth',1));
    IniPageNumberFormat := ReadString(Section,'PageNumberFormat','poNumeral');
    IniOrientation := ReadString(Section,'Orientation','poPortrait');
   end;
  RegIniFile.Free;
end;




procedure SaveDxPrinterSettings(Kind: char);
var
  s: string;
  Section: string;
begin
  if not RegIniOpen then exit;
  case Kind of
    'N': Section := 'DxNotesPrinting';
    'S': Section := 'DxSummaryPrinting';
    'R': Section := 'DxResultsPrinting';
  else exit;
  end;
  with g_RegIniData, RegIniFile do begin
    WriteInteger(Section,'CenterOnPageH',BoolToInt(IniCenterOnPageH));
    WriteInteger(Section,'CenterOnPageV',BoolToInt(IniCenterOnPageV));
    WriteInteger(Section,'DMPaper',IniDMPaper);
    WriteInteger(Section,'FitToPagesByTall',IniFitToPagesByTall);
    WriteInteger(Section,'FitToPagesByWide',IniFitToPagesByWide);
    WriteInteger(Section,'Footer',IniFooter);
    WriteInteger(Section,'GrayShading',BoolToInt(IniGrayShading));
    WriteInteger(Section,'Header',IniHeader);
    WriteInteger(Section,'MarginsBottom',IniMarginsBottom);
    WriteInteger(Section,'MarginsLeft',IniMarginsLeft);
    WriteInteger(Section,'MarginsRight',IniMarginsRight);
    WriteInteger(Section,'MarginsTop',IniMarginsTop);
    WriteString(Section,'MeasurementUnits',IniMeasurementUnits);

    WriteString(Section,'PageFooterCenterTextAlignY',IniPageFooterCenterTextAlignY);
    WriteString(Section,'PageFooterLeftTextAlignY',IniPageFooterLeftTextAlignY);
    WriteString(Section,'PageFooterRightTextAlignY',IniPageFooterRightTextAlignY);
    WriteInteger(Section,'PageFooterFontCharset',IniPageFooterFontCharset);
    WriteInteger(Section,'PageFooterFontColor',IniPageFooterFontColor);
    WriteInteger(Section,'PageFooterFontHeight',IniPageFooterFontHeight);
    WriteString(Section,'PageFooterFontName',IniPageFooterFontName);
    WriteString(Section,'PageFooterPitch',IniPageFooterFontPitch);
    WriteInteger(Section,'PageFooterFontSize',IniPageFooterFontSize);
    WriteString(Section,'PageFooterFontStyle',IniPageFooterFontStyle);

    WriteString(Section,'PageHeaderCenterTextAlignY',IniPageHeaderCenterTextAlignY);
    WriteString(Section,'PageHeaderLeftTextAlignY',IniPageHeaderLeftTextAlignY);
    WriteString(Section,'PageHeaderRightTextAlignY',IniPageHeaderRightTextAlignY);
    WriteInteger(Section,'PageHeaderFontCharset',IniPageHeaderFontCharset);
    WriteInteger(Section,'PageHeaderFontColor',IniPageHeaderFontColor);
    WriteInteger(Section,'PageHeaderFontHeight',IniPageHeaderFontHeight);
    WriteString(Section,'PageHeaderFontName',IniPageHeaderFontName);
    WriteString(Section,'PageHeaderPitch',IniPageHeaderFontPitch);
    WriteInteger(Section,'PageHeaderFontSize',IniPageHeaderFontSize);
    WriteString(Section,'PageHeaderFontStyle',IniPageHeaderFontStyle);

    WriteString(Section,'PageOrder',IniPageOrder);
    WriteInteger(Section,'PageSizeX',InipageSizeX);
    WriteInteger(Section,'PageSizeY',IniPageSizeY);
    WriteInteger(Section,'ReverseTitlesOnEvenPages',BoolToInt(IniReverseTitlesOnEvenPages));
    WriteString(Section,'ReportTitleMode',IniReportTitleMode);
    WriteInteger(Section,'ScaleFactor',IniScaleFactor);
    WriteString(Section,'ScaleMode',IniScaleMode);
    WriteInteger(Section,'ShowPageFooter',BoolToInt(IniShowPageFooter));
    WriteInteger(Section,'ShowPageHeader',BoolToInt(IniShowPageHeader));
    WriteInteger(Section,'ShrinkToPageWidth',BoolToInt(IniShrinkToPageWidth));
    WriteString(Section,'Orientation',IniOrientation);
    WriteString(Section,'PageNumberFormat',IniPageNumberFormat);
  end;
  RegIniFile.Free;
end;

/////////////////////////////

function OffsetStringToByte(s: string): byte;
var
  Offs: shortint;
  OffsReal: real;
begin
  OffsReal := 2*StrToFloat(s);
  Offs := trunc(OffsReal);
  result := byte(Offs);
end;


function ByteToOffsetString(b: byte): string;
var
  Offs: shortint;  // use to force 2s compliment interpretation of data byte (ie -128 to +127)
  OffsReal: real;
begin
  Offs := shortint(b);
  OffsReal := Offs;
  result :=  FloatToStr(OffsReal/2);
end;



end.


