unit UFileInidata;

interface

uses Inifiles,SysUtils, graphics, forms,  Registry, Windows,
     Dialogs;

type

  TDaliDescriptors =
  record
    ddBallasts: array[0..63] of string[80];
    ddGroups: array[0..15] of string[80];
    ddScenes: array[0..15] of string[80];
  end;

var

  DaliIniFile: TIniFile;
  DaliDescriptors: TDaliDescriptors;

procedure LoadDaliDescriptors(NodeAddress: word; FilePath: string);
procedure SaveDaliDescriptors(NodeAddress: word; FilePath: string);



implementation

Uses UIniData;
// + IntToHex(g_NodeConfigX.nuNodeAddress,4)

function DaliDescriptorFilePathName: string;
begin
  with g_RegInidata do
  begin
    result := IniDaliDescriptorFolder + '\' + IniSiteCode + '.dad';
  end;
end;



procedure LoadDaliDescriptors(NodeAddress: word; FilePath: string);
var
  node: string;
begin
  node := 'Rayzig_node_' +  IntToHex(NodeAddress,4);
  DaliIniFile := TIniFile.Create(FilePath);
  with DaliIniFile, DaliDescriptors do
  begin
    ddBallasts[0]  := ReadString(node,'Luminaire00','Luminaire 00');
    ddBallasts[1]  := ReadString(node,'Luminaire01','Luminaire 01');
    ddBallasts[2]  := ReadString(node,'Luminaire02','Luminaire 02');
    ddBallasts[3]  := ReadString(node,'Luminaire03','Luminaire 03');
    ddBallasts[4]  := ReadString(node,'Luminaire04','Luminaire 04');
    ddBallasts[5]  := ReadString(node,'Luminaire05','Luminaire 05');
    ddBallasts[6]  := ReadString(node,'Luminaire06','Luminaire 06');
    ddBallasts[7]  := ReadString(node,'Luminaire07','Luminaire 07');
    ddBallasts[8]  := ReadString(node,'Luminaire08','Luminaire 08');
    ddBallasts[9]  := ReadString(node,'Luminaire09','Luminaire 09');
    ddBallasts[10] := ReadString(node,'Luminaire10','Luminaire 10');
    ddBallasts[11] := ReadString(node,'Luminaire11','Luminaire 11');
    ddBallasts[12] := ReadString(node,'Luminaire12','Luminaire 12');
    ddBallasts[13] := ReadString(node,'Luminaire13','Luminaire 13');
    ddBallasts[14] := ReadString(node,'Luminaire14','Luminaire 14');
    ddBallasts[15] := ReadString(node,'Luminaire15','Luminaire 15');
    ddBallasts[16] := ReadString(node,'Luminaire16','Luminaire 16');
    ddBallasts[17] := ReadString(node,'Luminaire17','Luminaire 17');
    ddBallasts[18] := ReadString(node,'Luminaire18','Luminaire 18');
    ddBallasts[19] := ReadString(node,'Luminaire19','Luminaire 19');
    ddBallasts[20] := ReadString(node,'Luminaire20','Luminaire 20');
    ddBallasts[21] := ReadString(node,'Luminaire21','Luminaire 21');
    ddBallasts[22] := ReadString(node,'Luminaire22','Luminaire 22');
    ddBallasts[23] := ReadString(node,'Luminaire23','Luminaire 23');
    ddBallasts[24] := ReadString(node,'Luminaire24','Luminaire 24');
    ddBallasts[25] := ReadString(node,'Luminaire25','Luminaire 25');
    ddBallasts[26] := ReadString(node,'Luminaire26','Luminaire 26');
    ddBallasts[27] := ReadString(node,'Luminaire27','Luminaire 27');
    ddBallasts[28] := ReadString(node,'Luminaire28','Luminaire 28');
    ddBallasts[29] := ReadString(node,'Luminaire29','Luminaire 29');
    ddBallasts[30] := ReadString(node,'Luminaire30','Luminaire 30');
    ddBallasts[31] := ReadString(node,'Luminaire31','Luminaire 31');
    ddBallasts[32] := ReadString(node,'Luminaire32','Luminaire 32');
    ddBallasts[33] := ReadString(node,'Luminaire33','Luminaire 33');
    ddBallasts[34] := ReadString(node,'Luminaire34','Luminaire 34');
    ddBallasts[35] := ReadString(node,'Luminaire35','Luminaire 35');
    ddBallasts[36] := ReadString(node,'Luminaire36','Luminaire 36');
    ddBallasts[37] := ReadString(node,'Luminaire37','Luminaire 37');
    ddBallasts[38] := ReadString(node,'Luminaire38','Luminaire 38');
    ddBallasts[39] := ReadString(node,'Luminaire39','Luminaire 39');
    ddBallasts[40] := ReadString(node,'Luminaire40','Luminaire 40');
    ddBallasts[41] := ReadString(node,'Luminaire41','Luminaire 41');
    ddBallasts[42] := ReadString(node,'Luminaire42','Luminaire 42');
    ddBallasts[43] := ReadString(node,'Luminaire43','Luminaire 43');
    ddBallasts[44] := ReadString(node,'Luminaire44','Luminaire 44');
    ddBallasts[45] := ReadString(node,'Luminaire45','Luminaire 45');
    ddBallasts[46] := ReadString(node,'Luminaire46','Luminaire 46');
    ddBallasts[47] := ReadString(node,'Luminaire47','Luminaire 47');
    ddBallasts[48] := ReadString(node,'Luminaire48','Luminaire 48');
    ddBallasts[49] := ReadString(node,'Luminaire49','Luminaire 49');
    ddBallasts[50] := ReadString(node,'Luminaire50','Luminaire 50');
    ddBallasts[51] := ReadString(node,'Luminaire51','Luminaire 51');
    ddBallasts[52] := ReadString(node,'Luminaire52','Luminaire 52');
    ddBallasts[53] := ReadString(node,'Luminaire53','Luminaire 53');
    ddBallasts[54] := ReadString(node,'Luminaire54','Luminaire 54');
    ddBallasts[55] := ReadString(node,'Luminaire55','Luminaire 55');
    ddBallasts[56] := ReadString(node,'Luminaire56','Luminaire 56');
    ddBallasts[57] := ReadString(node,'Luminaire57','Luminaire 57');
    ddBallasts[58] := ReadString(node,'Luminaire58','Luminaire 58');
    ddBallasts[59] := ReadString(node,'Luminaire59','Luminaire 59');
    ddBallasts[60] := ReadString(node,'Luminaire60','Luminaire 60');
    ddBallasts[61] := ReadString(node,'Luminaire61','Luminaire 61');
    ddBallasts[62] := ReadString(node,'Luminaire62','Luminaire 62');
    ddBallasts[63] := ReadString(node,'Luminaire63','Luminaire 63');

    ddGroups[0]  := ReadString(node,'Group00','Group 00');
    ddGroups[1]  := ReadString(node,'Group01','Group 01');
    ddGroups[2]  := ReadString(node,'Group02','Group 02');
    ddGroups[3]  := ReadString(node,'Group03','Group 03');
    ddGroups[4]  := ReadString(node,'Group04','Group 04');
    ddGroups[5]  := ReadString(node,'Group05','Group 05');
    ddGroups[6]  := ReadString(node,'Group06','Group 06');
    ddGroups[7]  := ReadString(node,'Group07','Group 07');
    ddGroups[8]  := ReadString(node,'Group08','Group 08');
    ddGroups[9]  := ReadString(node,'Group09','Group 09');
    ddGroups[10] := ReadString(node,'Group10','Group 10');
    ddGroups[11] := ReadString(node,'Group11','Group 11');
    ddGroups[12] := ReadString(node,'Group12','Group 12');
    ddGroups[13] := ReadString(node,'Group13','Group 13');
    ddGroups[14] := ReadString(node,'Group14','Group 14');
    ddGroups[15] := ReadString(node,'Group15','Group 15');

    ddScenes[0]  := ReadString(node,'Scene00','Scene 00');
    ddScenes[1]  := ReadString(node,'Scene01','Scene 01');
    ddScenes[2]  := ReadString(node,'Scene02','Scene 02');
    ddScenes[3]  := ReadString(node,'Scene03','Scene 03');
    ddScenes[4]  := ReadString(node,'Scene04','Scene 04');
    ddScenes[5]  := ReadString(node,'Scene05','Scene 05');
    ddScenes[6]  := ReadString(node,'Scene06','Scene 06');
    ddScenes[7]  := ReadString(node,'Scene07','Scene 07');
    ddScenes[8]  := ReadString(node,'Scene08','Scene 08');
    ddScenes[9]  := ReadString(node,'Scene09','Scene 09');
    ddScenes[10] := ReadString(node,'Scene10','Scene 10');
    ddScenes[11] := ReadString(node,'Scene11','Scene 11');
    ddScenes[12] := ReadString(node,'Scene12','Scene 12');
    ddScenes[13] := ReadString(node,'Scene13','Scene 13');
    ddScenes[14] := ReadString(node,'Scene14','Scene 14');
    ddScenes[15] := ReadString(node,'Scene15','Scene 15');

  end;
end;




procedure SaveDaliDescriptors(NodeAddress: word; FilePath: string);
var
  node: string;
begin
  node := 'Rayzig_node_' +  IntToHex(NodeAddress,4);
  DaliIniFile := TIniFile.Create(FilePath);
  with DaliIniFile, DaliDescriptors do
  begin
    WriteString(node,'Luminaire00',ddBallasts[0]);
    WriteString(node,'Luminaire01',ddBallasts[1]);
    WriteString(node,'Luminaire02',ddBallasts[2]);
    WriteString(node,'Luminaire03',ddBallasts[3]);
    WriteString(node,'Luminaire04',ddBallasts[4]);
    WriteString(node,'Luminaire05',ddBallasts[5]);
    WriteString(node,'Luminaire06',ddBallasts[6]);
    WriteString(node,'Luminaire07',ddBallasts[7]);
    WriteString(node,'Luminaire08',ddBallasts[8]);
    WriteString(node,'Luminaire09',ddBallasts[9]);
    WriteString(node,'Luminaire10',ddBallasts[10]);
    WriteString(node,'Luminaire11',ddBallasts[11]);
    WriteString(node,'Luminaire12',ddBallasts[12]);
    WriteString(node,'Luminaire13',ddBallasts[13]);
    WriteString(node,'Luminaire14',ddBallasts[14]);
    WriteString(node,'Luminaire15',ddBallasts[15]);
    WriteString(node,'Luminaire16',ddBallasts[16]);
    WriteString(node,'Luminaire17',ddBallasts[17]);
    WriteString(node,'Luminaire18',ddBallasts[18]);
    WriteString(node,'Luminaire19',ddBallasts[19]);
    WriteString(node,'Luminaire20',ddBallasts[20]);
    WriteString(node,'Luminaire21',ddBallasts[21]);
    WriteString(node,'Luminaire22',ddBallasts[22]);
    WriteString(node,'Luminaire23',ddBallasts[23]);
    WriteString(node,'Luminaire24',ddBallasts[24]);
    WriteString(node,'Luminaire25',ddBallasts[25]);
    WriteString(node,'Luminaire26',ddBallasts[26]);
    WriteString(node,'Luminaire27',ddBallasts[27]);
    WriteString(node,'Luminaire28',ddBallasts[28]);
    WriteString(node,'Luminaire29',ddBallasts[29]);
    WriteString(node,'Luminaire30',ddBallasts[30]);
    WriteString(node,'Luminaire31',ddBallasts[31]);
    WriteString(node,'Luminaire32',ddBallasts[32]);
    WriteString(node,'Luminaire33',ddBallasts[33]);
    WriteString(node,'Luminaire34',ddBallasts[34]);
    WriteString(node,'Luminaire35',ddBallasts[35]);
    WriteString(node,'Luminaire36',ddBallasts[36]);
    WriteString(node,'Luminaire37',ddBallasts[37]);
    WriteString(node,'Luminaire38',ddBallasts[38]);
    WriteString(node,'Luminaire39',ddBallasts[39]);
    WriteString(node,'Luminaire40',ddBallasts[40]);
    WriteString(node,'Luminaire41',ddBallasts[41]);
    WriteString(node,'Luminaire42',ddBallasts[42]);
    WriteString(node,'Luminaire43',ddBallasts[43]);
    WriteString(node,'Luminaire44',ddBallasts[44]);
    WriteString(node,'Luminaire45',ddBallasts[45]);
    WriteString(node,'Luminaire46',ddBallasts[46]);
    WriteString(node,'Luminaire47',ddBallasts[47]);
    WriteString(node,'Luminaire48',ddBallasts[48]);
    WriteString(node,'Luminaire49',ddBallasts[49]);
    WriteString(node,'Luminaire50',ddBallasts[50]);
    WriteString(node,'Luminaire51',ddBallasts[51]);
    WriteString(node,'Luminaire52',ddBallasts[52]);
    WriteString(node,'Luminaire53',ddBallasts[53]);
    WriteString(node,'Luminaire54',ddBallasts[54]);
    WriteString(node,'Luminaire55',ddBallasts[55]);
    WriteString(node,'Luminaire56',ddBallasts[56]);
    WriteString(node,'Luminaire57',ddBallasts[57]);
    WriteString(node,'Luminaire58',ddBallasts[58]);
    WriteString(node,'Luminaire59',ddBallasts[59]);
    WriteString(node,'Luminaire60',ddBallasts[60]);
    WriteString(node,'Luminaire61',ddBallasts[61]);
    WriteString(node,'Luminaire62',ddBallasts[62]);
    WriteString(node,'Luminaire63',ddBallasts[63]);

    WriteString(node,'Group00',ddGroups[0]);
    WriteString(node,'Group01',ddGroups[1]);
    WriteString(node,'Group02',ddGroups[2]);
    WriteString(node,'Group03',ddGroups[3]);
    WriteString(node,'Group04',ddGroups[4]);
    WriteString(node,'Group05',ddGroups[5]);
    WriteString(node,'Group06',ddGroups[6]);
    WriteString(node,'Group07',ddGroups[7]);
    WriteString(node,'Group08',ddGroups[8]);
    WriteString(node,'Group09',ddGroups[9]);
    WriteString(node,'Group10',ddGroups[10]);
    WriteString(node,'Group11',ddGroups[11]);
    WriteString(node,'Group12',ddGroups[12]);
    WriteString(node,'Group13',ddGroups[13]);
    WriteString(node,'Group14',ddGroups[14]);
    WriteString(node,'Group15',ddGroups[15]);

    WriteString(node,'Scene00',ddScenes[0]);
    WriteString(node,'Scene01',ddScenes[1]);
    WriteString(node,'Scene02',ddScenes[2]);
    WriteString(node,'Scene03',ddScenes[3]);
    WriteString(node,'Scene04',ddScenes[4]);
    WriteString(node,'Scene05',ddScenes[5]);
    WriteString(node,'Scene06',ddScenes[6]);
    WriteString(node,'Scene07',ddScenes[7]);
    WriteString(node,'Scene08',ddScenes[8]);
    WriteString(node,'Scene09',ddScenes[9]);
    WriteString(node,'Scene10',ddScenes[10]);
    WriteString(node,'Scene11',ddScenes[11]);
    WriteString(node,'Scene12',ddScenes[12]);
    WriteString(node,'Scene13',ddScenes[13]);
    WriteString(node,'Scene14',ddScenes[14]);
    WriteString(node,'Scene15',ddScenes[15]);

  end;
end;





end.
