unit UDBRichText;

interface


uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
        StdCtrls, UIniData, UGlobals, Contnrs;

type
  str11 = string[11];




  TDBRichText = class
                FormatString: string;
                FormatStringNotes: string;
                FormatStringBP: string;
                FormatStringQAOF: string;
                ItemIdent: string;
                ItemTitle: string;
                CrFilters: string;
                ItemMaxCount: integer;
                SummaryFontName: string;
                SummaryFontSize: integer;       {default font size = IniFontSize}
                SummaryHideHeaders: integer;
                //PersonSeenId: integer;
                ReportTitle: string;
                DummyString: string;
                ClinRecProbList: TObjectList;
                DateWidth: integer;
                function CrZap(s: string): string;
           //     Procedure SetFormatStrings;
                procedure WriteColourDefs;
                procedure SetRtfColours(UseColour: boolean);
                function Sz(SizeChar: char): str11;
                procedure InitialiseTextFile(FilePath: string);
                function TodayNow: TDateTime;
                procedure FinaliseTextFile;
                procedure CloseExceptTextFile;
                procedure WriteHeading(Title: string);
                procedure WriteHeaderData(ReportTitle: string);
                function WriteProjectRecord(id: integer): integer;
                function FormatMemo(ms: string; var lines: integer): string;
              end;


implementation

uses UfrmDatabase, UfrmDBrtf;

const
  {minimum rich text header}
  RtfHeader1: string = '{\rtf1\ansi\ansicpg1252\deff0\deflang2057{\fonttbl{\f0\fnil\fcharset0 ';
  RtfHeader2: string = ';}{\f1\fnil\fcharset0 Courier New;}}';
  RtfHeader3: string = '\viewkind4\uc1\f0';





///////////  TDBRichText ////////////////////////////////


procedure TDBRichText.CloseExceptTextfile;
begin
  try
    //CloseFile(g_TextFile);
  except
  end;
end;





procedure TDBRichText.WriteColourDefs;
var
  i: byte;
  s: string[27];
  m: integer;
begin
  m := 3;
  writeln(g_TextFile,'{\colortbl ;');
  for i := 1 to 9 do begin
    s := concat('\red',IntToStr((m*g_ColourDefs[i,cr]) DIV 2));
    s := concat(s,'\green',IntToStr((m*g_ColourDefs[i,cg]) DIV 2));
    s := concat(s,'\blue',IntToStr((m*g_ColourDefs[i,cb]) DIV 2),';');
    writeln(g_TextFile,s);
  end;
  writeln(g_TextFile,'}');
end;







procedure TDBRichText.SetRtfColours(UseColour: boolean);
begin
  if UseColour then begin
   cHeader        := cBlack;
   cHeading1      := cNavy;
   cHeading2      := cTeal;
   cAdc           := cMagenta;
   cWatts         := cBlue;
   cLedNo         := cGreen;
  end
  else begin
   cHeader        := cBlack;
   cHeading1      := cBlack;
   cHeading2      := cBlack;
   cAdc           := cBlack;
   cWatts         := cBlack;
   cLedNo         := cBlack;
  end;
end;

function TDBRichText.Sz(SizeChar: char): str11;
var
  d: integer;
begin
  case SizeChar of
    'S': d := -1;
    'N': d := 0;
    'L': d := 2;
    'E': d := 4;
  else d := 0;
  end;
  result := concat('\fs',IntToStr(2*(SummaryFontSize + d)),' ');
end;


procedure TDBRichText.InitialiseTextFile(FilePath: string);
begin
  CloseExceptTextFile;
  assignfile(g_TextFile,FilePath);
  Rewrite(g_TextFile);
  writeln(g_TextFile,RtfHeader1,SummaryFontName, RtfHeader2);
  WriteColourDefs;
  writeln(g_TextFile,RtfHeader3);
end;




function TDBRichText.TodayNow: TDateTime;
var
  SystemTime: TSystemTime;
begin
  GetLocalTime(SystemTime);
  Result := SystemTimeToDateTime(SystemTime);
end;


function TDBRichText.CrZap(s: string): string;
begin
  result := StringReplace(s,' <-| ','\par \tab ',[rfReplaceAll]);
end;


procedure TDBRichText.FinaliseTextFile;
begin
  writeln(g_TextFile, '\par }');
  CloseFile(g_TextFile);
end;


procedure TDBRichText.WriteHeading(Title: string);
begin
  writeln(g_TextFile,cHeading1,Sz('L'),'\b ',Title,Sz('N'),'\b0 \par \par ');
end;



procedure TDBRichText.WriteHeaderData(ReportTitle: string);
begin
  writeln(g_TextFile,cHeader,Sz('L'),'\b ',ReportTitle,'\b0');
  writeln(g_TextFile,Sz('N'),'     ', DateToStr(TodayNow),Sz('N'),'\par \par');
end;



function TDBRichText.FormatMemo(ms: string; var lines: integer): string;
var
  a,p: integer;
  s: string;
  ch: char;
begin
  a := Length(ms);
  p := 0;
  lines := 3;
  s := '';
  repeat
    inc(p);
    ch := ms[p];
    case ch of
      #10: ;
      #13: begin
             s := s + '\par ';
             inc(lines);
           end;  
    else s := s + ch;
    end; {case}
  until p >= a;
  if s[a] <> #10 then s := s + '\par ';
  result := s;
end;

//returns no of lines used
function TDBRichText.WriteProjectRecord(id: integer): integer;
var
  username, xname, callsign, title: string;
  starpcbs, display, controller: string;
  encoder, encoders8, bpf: string;
  description, comments: string;
  url: string;
  roofer, mixer: string;
  starno: integer;
  startdate, qsodate: string;
  a: integer;
  memolines,lines: integer;
begin
 with frmDatabase.Query_DbRtf do
 begin
    Close;
    SQL.Clear;
    SQL.Add('select * from projects,users where projects.username = users.username'
                  + ' and projects.id = ''' + IntToStr(id) + '''');
    Open;
    if EOF then
    begin
      Close;
      exit;
    end;
    username := FieldByName('username').AsString;
    xname := FieldByName('name').AsString;
    callsign := FieldByName('callsign').AsString;
    starno := FieldByName('starno').Asinteger;
    title := FieldByName('title').AsString;
    startdate := FieldByName('startdate').AsString;
    qsodate := FieldByName('qsodate').AsString;
    description := FieldByName('description').AsString;
    comments := FieldByName('comments').AsString;
    roofer := FieldByName('roofer').AsString;
    mixer := FieldByName('mixer').AsString;
    url := FieldByName('url').AsString;
    a := FieldByName('starpcbs').AsInteger;
    if a >= 0 then starpcbs := starpcbs_array[a];
    a := FieldByName('display').AsInteger;
    if a >= 0 then display := display_array[a];
    a := FieldByName('encoder').AsInteger;
    if a >= 0 then encoder := encoder_array[a];
    a := FieldByName('encoders8').AsInteger;
    if a >= 0 then encoders8 := encoders8_array[a];
    a := FieldByName('bpf').AsInteger;
    if a >= 0 then bpf := bpf_array[a];
    a := FieldByName('controller').AsInteger;
    if a >= 0 then controller := controller_array[a];
    close; {the query}
  end;
////////////////////////////////////////////////
  lines := 10;
  writeln(g_TextFile, 'Project title:  \b ' + title + '\b0');
  writeln(g_TextFile, '\par \par');
  writeln(g_textFile, '\pard\tx2000 \tx5200 \tx9200');
  write(g_TextFile,'Username:  \b ' + username + '\b0 \tab Name:  \b '+ xname + '\b0');
  writeln(g_TextFile,'\tab Callsign:  \b ' + callsign + '\b0 ');
  writeln(g_TextFile, '\par \par');
  writeln(g_textFile, '\pard\tx200\tx2800 \tx5600');
  writeln(g_textFile,'\tab Build start date:  \b ' + startdate + '\b0 ');
  writeln(g_textFile,'\tab First qso date:  \b ' + qsodate + '\b0 ');
  writeln(g_TextFile, '\par \par ');
  writeln(g_textFile, '\pard\tx200\tx3200 \tx6200 \tx9200');
  writeln(g_textFile,'\tab Controller:  \b ' + controller + '\b0 ');
  writeln(g_textFile,'\tab Star PCBs:  \b ' + starpcbs + '\b0 ');
  writeln(g_textFile,'\tab Display:  \b ' + display + '\b0 ');
  writeln(g_TextFile, '\par ');
  writeln(g_textFile,'\tab BPF:  \b ' + bpf + '\b0 ');
  writeln(g_textFile,'\tab Encoder:  \b ' + encoder + '\b0 ');
  writeln(g_textFile,'\tab Encoders8:  \b ' + encoders8 + '\b0 ');
  writeln(g_TextFile, '\par ');
  writeln(g_textFile,'\tab Roofer:  \b ' + roofer + '\b0 ');
  writeln(g_textFile,'\tab Mixer:  \b ' + mixer + '\b0 ');
  writeln(g_TextFile, '\par \par \pard ');
  if Length(description) > 0 then
  begin
    writeln(g_TextFile, 'Description \par ');
    writeln(g_textFile, '\pard \fi280 \b ');
    writeln(g_TextFile, FormatMemo(description,memolines));
    writeln(g_TextFile, '\par \pard \b0 ');
    lines := lines + memolines;
  end;
  if Length(comments) > 0 then
  begin
    writeln(g_TextFile, 'Comments \par ');
    writeln(g_textFile, '\pard \fi280 \b ');
    writeln(g_TextFile, FormatMemo(comments,memolines));
    writeln(g_TextFile, '\par \pard \b0 ');
    lines := lines + memolines;
  end;
  if Length(url) > 0 then
  begin
    writeln(g_textFile, '\par URL:  \b ' + url + '\b0 \par ');
    lines := lines + 2;
  end;
  result := lines;
end;





end.




